/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.MemorySystem;
import jp.asamomiji.emulator.UnmappedMemory;
import jp.asamomiji.emulator.device.Beep;
import jp.asamomiji.emulator.device.MB8861;
import jp.asamomiji.emulator.device.gamepad.Gamepad;
import jp.asamomiji.emulator.jr100.BasicRom;
import jp.asamomiji.emulator.jr100.ExtendedIOPort;
import jp.asamomiji.emulator.jr100.JR100Display;
import jp.asamomiji.emulator.jr100.JR100Keyboard;
import jp.asamomiji.emulator.jr100.JR100R6522;
import jp.asamomiji.emulator.jr100.MainRam;
import jp.asamomiji.emulator.jr100.UserDefinedCharacterRam;
import jp.asamomiji.emulator.jr100.VideoRam;

public final class JR100
extends Computer {
    public static final String PROPERTY_EXTENDED_RAM = "jr100.extended_ram";
    public static final String PROPERTY_CPU_CLOCK_FREQUENCY = "jr100.cpu_clock_frequency";
    public static final int ADDRESS_START_OF_BASIC_PROGRAM = 582;
    public static final int WORKAREA_END_OF_BASIC_PROGRAM = 6;
    public static final int DEFAULT_CPU_CLOCK = 894000;
    private static final int MEMORY_CAPACITY = 65536;
    private static final double REFRESH_RATE = 0.02;
    private static int clockFrequency = 894000;

    public JR100(Application application, String fname) {
        super(application, 0.02);
        MemorySystem m = this.getHardware().getMemory();
        m.allocateSpace(65536);
        if (JR100.getPropertyOfUseExtendedRam()) {
            m.registMemory(new MainRam(0, 32768));
        } else {
            m.registMemory(new MainRam(0, 16384));
        }
        m.registMemory(new UserDefinedCharacterRam(49152, 256));
        m.registMemory(new VideoRam(49408, 768));
        m.registMemory(new ExtendedIOPort(this, 52224));
        m.registMemory(new BasicRom(fname, 57344, 8192));
        this.setCPU(new MB8861(this));
        JR100R6522 via = new JR100R6522(this, 51200);
        m.registMemory(via);
        this.getHardware().setSoundProcessor(new Beep(this, 44100.0));
        this.getHardware().setKeyboard(new JR100Keyboard(this));
        this.getHardware().setGamepad(new Gamepad(this));
        JR100Display display = new JR100Display(this);
        this.getHardware().setDisplay(display);
        UserDefinedCharacterRam um = (UserDefinedCharacterRam)m.getMemory(UserDefinedCharacterRam.class);
        um.setDisplay(display);
        VideoRam vm = (VideoRam)m.getMemory(VideoRam.class);
        vm.setDisplay(display);
        this.getDevices().add(via);
        this.getDevices().add(this.getHardware().getKeyboard());
        this.getDevices().add(display);
        this.getDevices().add(this.getHardware().getSoundProcessor());
    }

    public static boolean getPropertyOfUseExtendedRam() {
        String m = Application.getProperties().getProperty(PROPERTY_EXTENDED_RAM);
        if (m == null) {
            return false;
        }
        return Boolean.parseBoolean(m);
    }

    public static void setPropertyOfUseExtendedRam(boolean value) {
        Application.getProperties().setProperty(PROPERTY_EXTENDED_RAM, Boolean.toString(value));
    }

    public static int getPropertyOfCpuClockFrequency() {
        String m = Application.getProperties().getProperty(PROPERTY_CPU_CLOCK_FREQUENCY);
        if (m == null) {
            return 894000;
        }
        return Integer.parseInt(m);
    }

    public static void setPropertyOfCpuClockFrequency(int value) {
        Application.getProperties().setProperty(PROPERTY_CPU_CLOCK_FREQUENCY, Integer.toString(value));
    }

    @Override
    public int getClockFrequency() {
        return clockFrequency;
    }

    @Override
    public void setClockFrequency(int f) {
        clockFrequency = f;
    }

    @Override
    public void powerOn() {
        this.setClockFrequency(JR100.getPropertyOfCpuClockFrequency());
        if (JR100.getPropertyOfUseExtendedRam()) {
            this.getHardware().getMemory().registMemory(new MainRam(0, 32768));
        } else {
            this.getHardware().getMemory().registMemory(new MainRam(0, 16384));
            this.getHardware().getMemory().registMemory(new UnmappedMemory(16384, 16384));
        }
        super.powerOn();
    }
}

