/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import jp.asamomiji.emulator.AbstractSoundProcessor;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.device.R6522;
import jp.asamomiji.emulator.jr100.JR100;
import jp.asamomiji.emulator.jr100.JR100Display;
import jp.asamomiji.emulator.jr100.JR100Keyboard;

public final class JR100R6522
extends R6522 {
    private double prevFrequency = 0.0;

    public JR100R6522(Computer computer, int start) {
        super(computer, start);
    }

    private void jumperPB7andPB6() {
        this.setPortB(6, this.inputPortB(7));
    }

    @Override
    protected void storeORB_option() {
        JR100Display d = (JR100Display)this.computer.getHardware().getDisplay();
        if ((this.inputPortB() & 0x20) == 32) {
            d.setCurrentFont(1);
        } else {
            d.setCurrentFont(0);
        }
        this.jumperPB7andPB6();
    }

    @Override
    protected void storeIORA_option() {
        int[] m = ((JR100Keyboard)this.computer.getHardware().getKeyboard()).getKeyMatrix();
        byte value = this.inputPortB();
        value = (byte)(value & 0xE0);
        value = (byte)(value | ~m[this.ORA & 0xF] & 0x1F);
        this.setPortB(value);
    }

    @Override
    protected void storeT1CH_option() {
        AbstractSoundProcessor sp = this.computer.getHardware().getSoundProcessor();
        if ((this.ACR & 0xC0) == 192) {
            double frequency = 894886.25 / (double)(this.timer1 + 2) / 2.0;
            if (frequency == this.prevFrequency) {
                sp.setLineOn();
                return;
            }
            this.prevFrequency = frequency;
            sp.setFrequency(this.currentClock * 1000000000L / (long)JR100.getPropertyOfCpuClockFrequency() + this.computer.getBaseTime(), frequency);
            sp.setLineOn();
        } else {
            sp.setLineOff();
        }
    }

    @Override
    protected void timer1TimeoutMode0_option() {
        this.computer.getHardware().getSoundProcessor().setLineOff();
    }

    @Override
    protected void timer1TimeoutMode2_option() {
        this.jumperPB7andPB6();
    }

    @Override
    protected void timer1TimeoutMode3_option() {
        this.jumperPB7andPB6();
    }
}

