/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import jp.asamomiji.emulator.RAM;
import jp.asamomiji.emulator.StateSavable;
import jp.asamomiji.emulator.StateSet;
import jp.asamomiji.emulator.jr100.JR100Display;

public final class VideoRam
extends RAM
implements StateSavable {
    private JR100Display display;

    public VideoRam(int start, int length) {
        super(start, length);
    }

    public void setDisplay(JR100Display display) {
        this.display = display;
    }

    @Override
    public void store8(int address, byte value) {
        this.data[address - this.start] = value;
        this.display.updateFont((address - (this.start - 256)) / 8, (address - (this.start - 256)) % 8, value);
    }

    @Override
    public void store16(int address, short value) {
        this.data[address - this.start] = (byte)(value >> 8);
        this.display.updateFont((address - this.start) / 8, (address - this.start) % 8, value >> 8);
        this.data[address - this.getStartAddress() + 1] = (byte)(value & 0xFF);
        this.display.updateFont((address - (this.start - 256)) / 8, (address - (this.start - 256)) % 8, value & 0xFF);
    }

    @Override
    public void saveState(StateSet ss) {
        ss.set("VideoRam.start_addr", this.start);
        ss.set("VideoRam.length", this.length);
        ss.set("VideoRam.data", this.data);
    }

    @Override
    public void loadState(StateSet ss) {
        this.start = (Integer)ss.get("VideoRam.start_addr");
        this.length = (Integer)ss.get("VideoRam.length");
        this.data = (byte[])ss.get("VideoRam.data");
    }
}

