
HARD_DISC_TOO EQU -1

; Macro um aus der Z80 Emulation Biosroutinen aufzurufen, => V20

calln  macro  nr
       db 0edh,0edh
       db nr
endm

; Macros fuer Z80 Sprunganweisungen, die TASM nicht kennt

z80jp  macro  labl
       db 0c3h
       dw offset labl
endm

z80ret macro
       db 0c9h
endm

; naechste Zeilen orginal aus DR's CBIOS.ASM

;
MSIZE  equ    20     ;cp/m version memory size in kilobytes
;
;  "BIAS" is address offset from 3400h for memory systems
;  than 16k (referred to as "b" throughout the text).
;
BIAS   equ    (MSIZE-20)*1024


IOBYTE equ 3  ;intel i/o byte
CDISK  equ 4  ;current disk number 0=a,...,15=p


;       org    bios   ;origin of this program

zbiosbeg equ this byte                 ; start of z80 bios

;  jump vector fuer einzelne Ups
       z80jp    zboot+ZBIOSDISPL   ;cold start
wboote equ this byte
       z80jp    zwboot+ZBIOSDISPL  ;warm start
       z80jp    zconst+ZBIOSDISPL  ;console status
       z80jp    zconin+ZBIOSDISPL  ;console character in
       z80jp    zconout+ZBIOSDISPL ;console character out
       z80jp    zlist+ZBIOSDISPL   ;list character out
       z80jp    zpunch+ZBIOSDISPL  ;punch character out
       z80jp    zreader+ZBIOSDISPL ;reader character out
       z80jp    zhome+ZBIOSDISPL   ;move head to home position
       z80jp    zseldsk+ZBIOSDISPL ;select disk
       z80jp    zsettrk+ZBIOSDISPL ;set track number
       z80jp    zsetsec+ZBIOSDISPL ;set sector number
       z80jp    zsetdma+ZBIOSDISPL ;set dma address
       z80jp    zread+ZBIOSDISPL   ;read disk
       z80jp    zwrite+ZBIOSDISPL  ;write disk
       z80jp    zlistst+ZBIOSDISPL ;return list status
       z80jp    zsectran+ZBIOSDISPL       ;sector translate
       rept 25-16-1
         z80jp    zwboot+ZBIOSDISPL
       endm
       z80jp    zmove+ZBIOSDISPL
       z80jp    ztime+ZBIOSDISPL
       rept 30-26-1
         z80jp    zwboot+ZBIOSDISPL
       endm
       z80jp    zuser+ZBIOSDISPL
zvecend equ this byte

zboot  equ this byte
       calln 0
       z80ret
zwboot equ this byte
        calln 1
       db 31h,80h,00h    ; ld sp,80h
       z80ret
zconst equ this byte
       calln 2
       z80ret
zconin equ this byte
       calln 3
       z80ret
zconout equ this byte
       calln 4
       z80ret
zlist  equ this byte
       calln 5
       z80ret
zpunch equ this byte
       calln 6
       z80ret
zreader equ this byte
       calln 7
       z80ret
zhome   equ this byte
       calln 8
       z80ret
zseldsk equ this byte
       calln 9
       z80ret
zsettrk equ this byte
       calln 10
       z80ret
zsetsec equ this byte
       calln 11
       z80ret
zsetdma equ this byte
       calln 12
       z80ret
zread   equ this byte
       calln 13
       z80ret
zwrite  equ this byte
       calln 14
       z80ret
zlistst equ this byte
       calln 15
       z80ret
zsectran equ this byte
       calln 16
       z80ret
zmove equ this byte     ; number as in cp/m plus
       calln 25
       z80ret
ztime equ this byte     ; number as in cp/m plus
       calln 26
       z80ret
zuser equ this byte     ; number as in cp/m plus
       calln 30
       z80ret

LAST_TRCK0 equ 39  ; track = 0..39
LAST_SEC0  equ 35  ; sektor = 0..35

LAST_SEC1  equ 31

XLT0       equ 0
XLT1       equ 0
XLT2       equ 0

; datas cpc system format

                    ; blocksize bls=1024
       SPTC equ 24h ;
       BSHC equ 3   ; log2(bls/128)=3
       BLMC equ 7   ; bls/128-1
       EXMC equ 0   ; (bls/1024)-1
       DSMC equ 168 ; disksize-1
       DRMC equ 63  ; direntrys-1
       AL0C equ 11000000b
       AL1C equ 00000000b
       CKSC equ 16
       OFFC equ 2


; datas cpc data format

                    ; blocksize bls=1024
       SPTD equ 24h ;
       BSHD equ 3   ; log2(bls/128)=3
       BLMD equ 7   ; bls/128-1
       EXMD equ 0   ; (bls/1024)-1
       DSMD equ 177 ; disksize-1
       DRMD equ 63  ; direntrys-1
       AL0D equ 11000000b
       AL1D equ 00000000b
       CKSD equ 16
       OFFD equ 0


; datas fuer CP/M 86 SS

                    ; blocksize bls=1024
       SPT0 equ 32  ;
       BSH0 equ 3   ; log2(bls/128)=3
       BLM0 equ 7   ; bls/128-1
       EXM0 equ 0   ; (bls/1024)-1
       DSM0 equ 152 ; disksize-1
       DRM0 equ 63  ; direntrys-1
       AL00 equ 11000000b
       AL10 equ 00000000b
       CKS0 equ 16
       OFF0 equ 1

; datas fuer CP/M 86 DS

                    ; blocksize bls=1024
       SPT1 equ 32  ;
       BSH1 equ 4   ; log2(bls/128)=3
       BLM1 equ 15  ; bls/128-1
       EXM1 equ 1   ; (bls/1024)-1
       DSM1 equ 157 ; disksize-1
       DRM1 equ 63  ; direntrys-1
       AL01 equ 10000000b
       AL11 equ 00000000b
       CKS1 equ 16
       OFF1 equ 1

;
; disc parameter data Ramdisk
;

                    ; blocksize bls=2048
       SPTR equ 32   ; 4K
       BSHR equ 4   ; log2(bls/128)
       BLMR equ 15  ; bls/128-1
       EXMR equ 1   ; (bls/1024)-1
       DSMR equ 255  ; disksize-1
                     ; note: take max size for dsm to reserve space for alv
       DRMR equ 127 ; direntrys-1 -> 128*32 Bytes = 2 Blocks = 2 Bits in  AL0
       AL0R equ 11000000b
       AL1R equ 00000000b
       CKSR equ 0
       OFFR equ 0

if HARD_DISC_TOO
;
; disc parameter data Harddisc
;

                    ; blocksize bls=4096
       SPTH equ 128
       BSHH equ 5   ; log2(bls/128)
       BLMH equ 31  ; bls/128-1
       EXMH equ 1   ; (bls/2048)-1
       DSMH equ (HARD_DISC_SIZE SHR 2)-1
       DRMH equ 1023; direntrys+1
       AL0H equ 11111111b
       AL1H equ 00000000b
       CKSH equ 0
       OFFH equ 0

endif
;
; structure fuer disc parameter headers
;
dph struc
    dw 0                            ; xlt
    dw 0                            ; scratch pads
    dw 0
    dw 0
    dw ?                            ; dirbuf
    dw ?                            ; dpb
    dw ?                            ; csv
    dw ?                            ; alv
dph ends

;
; structure fuer disc parameter blocks
;

dpb   struc
    spt dw ?
    bsh db ?
    blm db ?
    exm db ?
    dsm dw ?
    drm dw ?
    al0 db ?
    al1 db ?
    cks dw ?
    off dw ?
dpb  ends

; drive a:

dph_base equ this byte  ; disk parameter base

dph0  dph <XLT0,0,0,0,offset dirbuf+ZBIOSDISPL,offset dpb0+ZBIOSDISPL,offset csv0+ZBIOSDISPL,offset alv0+ZBIOSDISPL>
dph1  dph <XLT1,0,0,0,offset dirbuf+ZBIOSDISPL,offset dpb1+ZBIOSDISPL,0,offset alv1+ZBIOSDISPL>
if HARD_DISC_TOO
dph2  dph <XLT2,0,0,0,offset dirbuf+ZBIOSDISPL,offset dpb2+ZBIOSDISPL,0,offset alv2+ZBIOSDISPL>
endif

dpb0  dpb <SPTC,BSHC,BLMC,EXMC,DSMC,DRMC,AL0C,AL1C,CKSC,OFFC>

dpb1  dpb <SPTR,BSHR,BLMR,EXMR,DSMR,DRMR,AL0R,AL1R,CKSR,OFFR>
if HARD_DISC_TOO
dpb2  dpb <SPTH,BSHH,BLMH,EXMH,DSMH,DRMH,AL0H,AL1H,CKSH,OFFH>
endif
dirbuf db 128 dup (?)   ; fuer alle Laufwerke gemeinsam

csv0   db (DRMC+1)/4 dup (?)
alv0   db (DSMC/8)+1 dup (?)

; csv unnecessary for non removable media


alv1   db (DSMR/8)+1 dup (?) ; !! take max size of DSM of ramdisc !!

if HARD_DISC_TOO
; csv unnecessary for non removable media
alv2   db (DSMH/8)+1 dup (?)
endif

@date dw (?)
@hour db (?)
@min  db (?)
@sec  db (?)

zbiosend equ this byte

