;
;
; HAUPTMODUL DES Z80EMULATORS
;
;
; Copyright (C) 1990,1991,1994 by Juergen Weber
;
;             Juergen Weber
;             Wiesentalstr. 1
;             D-74523 Schwaebisch Hall
;
;             Federal Republik of Germany
;
;             email: weberjn@yahoo.com
;
;
; usage within any other program than zsim
; requires consent of the author
; any program that incorporates this module must display
; the following:
;
;   "Z80 simulator (c) 1990,1994 by Juergen Weber"
;
; NON-PRIVATE USAGE NOT WITHOUT CONSENT OF THE AUTHOR
;
;
; to assemble:
;
; DEVICE=C:\DOS\emm386.exe noems i=E000-EFFF i=A000-B7FF
; dos=high,umb
; tasm -mx ...
;
; to understand:
;
; start reading at label bios88ret
;

; ************
    .286
; ************



_CPCEMU EQU 0           ;specials for CPCEMU
_CPC_CO EQU 0 		;for CO-Z80-mode

if _CPCEMU
_BANKING EQU -1
else
_BANKING EQU 0	; _BANKING for RAM below ROM on  Homecomputers

endif


comment @



KNOWN BUGS:

 accessing a word at 0FFFFH generates an INT 0D, that is not caught

NEW HISTORY:

16.3.93  seperated mloop from op0
	 when an intreq occured before a jump to mloop the inc si was
	 undone without a previous code fetch and inc si
         implemented a new way of doing int reqs
	 until now there were problems, if an intreq happened if
         the emulation had just finished a one byte code:

         OPXX:
	       one_byte_8086_code
                                 <- int req happens here, writes
                                    code for int 85 ( = CD 85)

				    now main code continued with
				    executing code 85H -> nonsense

         I solved the problem by making int_reqest inserting a
	 _one_ byte jump code. There are only two: int 3 and RET
         So I used RET. Now before executing OPxx (x=0..FF) there
         must be the offset of int_ack at the top of stack.
         At every entering the emulation it is put there,
         namely at
	 bios88ret,halt_cont
	 at every leaving the emulation it is taken away, namely at
	 halt_cont,EDOP0ED

         also at every entry emu_active_flg is set to TRUE
         and set to FALSE at every exit

         inserted code, so that block out goes to (C-1)

IF _BANKING

Banking is to simulate some home computers that have ram and rom
at the same address. So read is from Rom and write is to Ram.
The following example is for the Amstrad CPC that has
64K Ram and a 16K Rom at 0-3fff and a second one at c000-ffff

0 Ram 0000-3fff
1 Ram 4000-7fff
2 Ram 8000-bfff
4 Ram c000-ffff
L Rom 0000-3fff
U Rom c000-ffff


 state 1        both  Roms on -->    state 2
                <--   only UROM on

  U      |                                       U |
| 0 |    |   <-					 L | |
| 4 |  | |     |			       | 4 | | |
| 8 |  | |     | swap at                       | 8 | | |
| C |  |       | state change                  | C   | |
  L    |     <-				       | 0     |

^ write to      es, offs = 0                   ^ write to es, offs = c000

read from ds:adr+offs                              ^ both  Roms on, offs = 4000

    ^  both Roms off, offs=0                         ^ LROM enable, offs = 0000

       ^ LROM enable, offs = C000                      ^ RAM-RAM, offs=c000

         ^ UROM enable, offs = 4000

SI alway has offs added on,
all other registers are added the offs not
until memory access

ENDIF
@

_32BIT EQU -1  ; VERSION for 32 BIT machines (runs on 286 too)

_Z80 EQU  -1   ; 0 for only 8080

_UNDOC_FLG_TOO EQU  -1 ; sets  undef. Flagresults

_R_REG_TOO EQU  0   ; emulates R register correctly

_WAITCALL EQU 0   ; calls wait loop

COMMENT @
BENCHMARKS(#4 FROM ZSIM.DOC) : 386/40 seconds (_BANKING=0)

_R_REG_TOO  7.75
_WAITCALL  10.44
both       12.40
none        6.00

@



MAXNOPS equ 48  ; for waiting

masm51 ; cause INSTR
locals

; CS: EMULATOR CODE
; DS,ES: Z80 CODE
;
;
; Z80EMU as a seperat module:
;
; FAR Module, needs FAR Modul PORTIO
;
; entry at PUBLIC FAR bios88ret with JMP FAR (no CALLS)
; ! push int_ack
;
;  SS:SP   Stack, >= 16 Words
;  DS      64K Segment for Read for Z80
;  ES      64K Segment for Write for Z80

;  SI      points to memory Z80 will execute
;  AL      A Register
;  BX      HL
;  CX      BC
;  DX      DE

;

; Exit    at  Code 76 HALT   : CALL FAR prg_exit
;         at  Code ED ED xx  : JMP  FAR bios88, AL = xx
; ! pop int_ack
; at both NO registers are saved on the stack


EXTRN prg_exit:far ; emulation stop
EXTRN bios88:far

PUBLIC z80ini,bios88ret,ctrl_break_req,interrupt_request,nmi_irq
IF _BANKING
   PUBLIC set_read_dist,set_write_dist
ENDIF

IF _CPCEMU
	public force_interrupt_request
	extrn emexit:far
	extrn ext_int_ack:far

_DATA SEGMENT WORD PUBLIC 'DATA'

z80regs	struc
	zAF	DW ?
	zBC	DW ?
	zDE	DW ?
	zHL	DW ?
	zIR     DW ?
	zIF	DW ?
	zIX	DW ?
	zIY	DW ?
	zSP	DW ?
	zPC	DW ?
	zIMD	DW ?
	zAF2	DW ?
	zBC2	DW ?
	zDE2	DW ?
	zHL2	DW ?
z80regs	ends

extrn _z: z80regs

_DATA ENDS

ENDIF	;_cpcemu


; REGISTERS:
; Z80    8088
A  EQU   AL
BC EQU   CX
DE EQU   DX
HL EQU   BX
B  EQU   CH
C  EQU   CL
D  EQU   DH
E  EQU   DL
H  EQU   BH
L  EQU   BL
PC EQU   SI
SP_Z EQU   BP


; BEGIN

EXTRN port_in:far,port_out:far,get_rand:far   ; FAR Routinen

TRUE                    EQU 0FFH
FALSE                   EQU 0H

TSTNCLR MACRO FLAG    ; Z-> was not set
	CMP FLAG,FALSE
	MOV FLAG,FALSE
ENDM

PUSHR MACRO REGS
LOCAL REG
;; EXAPL: PUSHR <BX,AX,CX>
   IRP REG,<REGS>
     PUSH REG
   ENDM
ENDM

POPR  MACRO REGS
LOCAL REG
;; EXAMPL: POPR  <BX,AX,CX>
   IRP REG,<REGS>
     POP  REG
   ENDM
ENDM


COMMENT *

   ZUM BANKING:
     ALLE LESEZUGRIFFE MIT DS: +READ_OFFS
     ALLE WRITEZUGRIFFE MIT ES: +WRITE_OFFS
*

AWO MACRO REG  ; ADD WRITE OFFSET
if _BANKING
    ADD REG,CS:WRITE_OFFS
endif
ENDM
SWO MACRO REG  ; SUB WRITE OFFSET
if _BANKING
    SUB REG,CS:WRITE_OFFS
endif
ENDM

ARO MACRO REG  ; ADD READ OFFSET
if _BANKING
    ADD REG,CS:READ_OFFS
endif
ENDM

SRO MACRO REG  ; SUB READ OFFSET
if _BANKING
    SUB REG,CS:READ_OFFS
endif
ENDM


IF _R_REG_TOO
; xxIR-Commands increment R-register several times (new op-fetch)!
;(if (z_BC != 1) rcount += ( (byte)((z_BC-1)*2) ) )
R_REG_ADD MACRO
LOCAL NO_ADD
	cmp BC,1
	jz short NO_ADD
	push BC
	dec BC
	add BC,BC
	add cs:RR,C
	pop BC
NO_ADD:
ENDM
ENDIF
;
; FLAGS IN Z80
;
S_FLAG EQU 10000000B
Z_FLAG EQU 01000000B
H_FLAG EQU 00010000B
V_FLAG EQU 00000100B
N_FLAG EQU 00000010B
C_FLAG EQU 00000001B

; Flags werden beim Z80 normalerweise entsprechend dem Ergebnis
; einer Operation gesetzt. Die alte Stellung hat keinen Einfluss,
; ausser N und H, die fuer DAA benutzt werden.
; Auch wird die alte Stellung von Carry fuer
; rotate/shift und add/sub mit Carry benutzt.

;
; macro, um das O-flag des 8086 in das V-Flag des Z80 zu kopieren
; muss SOFORT nach Flagaenderung aufgerufen werden
; eine andere Moeglichkeit waere, einen INTO einzusetzen,
; der aber viele Takte braucht
;
SET_V_FLAG MACRO
LOCAL RES_PV
if _Z80
      MOV DI,((NOT V_FLAG) SHL 8) OR 0FFH
      JNO SHORT RES_PV
      MOV DI,0FFFFH
endif
RES_PV:
if _Z80
;; als Default setze V, wenn kein Overflow, resetiere
      OR AH,V_FLAG
      AND AX,DI
endif
ENDM

RES_C_FLAG MACRO
      AND AH,NOT C_FLAG
ENDM

SET_N_FLAG MACRO
      OR AH,N_FLAG  ;; loesche N_FLAG
ENDM

RES_N_FLAG MACRO
      AND AH,NOT N_FLAG  ;; loesche N_FLAG
ENDM

; ********************************
; *
; * The 8-Bit Load Group
; *
; ********************************

;
; LD r,r'
; macro fuer 8 Bit Ladebefehle
; kein Flag veraendert
;

LD8  MACRO TAR8,SRC8
     IF _BANKING
	IFIDNI <SRC8>,<[BX]>
           MOV DI,BX
           ARO DI
           MOV TAR8,[DI]
	ELSEIFIDNI <TAR8>,<[BX]>
           MOV DI,BX
           AWO DI
           MOV ES:[DI],SRC8
	ELSE
           MOV TAR8,SRC8
        ENDIF
     ELSE
        MOV TAR8,SRC8
     ENDIF
ENDM


;
; move immediate reg8,data8  LD r,n
; kein Flag veraendert
;
MVI8   MACRO R8
      IFIDNI <R8>,<AL>
         LODSB
      ELSEIFIDNI <R8>,<[HL]>               ;; LD (HL),n
          MOV DI,BX
	  AWO DI     ;; SWO unnoetig
          MOVSB      ;; ES:DI := DS:SI
      ELSE
         MOV   R8,[SI]
	 INC   SI
      ENDIF
ENDM

;
; lade A mit *extended register  LD A,(R16)
; R16={BC,DE,HL}
; kein Flag veraendert
;
LDAX  MACRO R16
      IF _BANKING
          MOV DI,R16
          ARO DI
	  MOV AL,[DI]
      ELSE
         IFIDN <R16>,<HL>
            MOV AL,[HL]
	 ELSE
            MOV DI,R16
            MOV AL,[DI]
         ENDIF
      ENDIF
ENDM
;
; lade A aus dem Speicher  LD A,(nn)
;
LDA   MACRO
      MOV DI,[SI]
      ADD SI,2
      ARO DI
      MOV AL,[DI]
ENDM
;
; speichere A nach *extended register  LD (R16),A
; R16={BC,DE,HL}
;

STAX MACRO R16
      IF _BANKING
	 MOV DI,R16
         AWO DI
         MOV ES:[DI],AL
      ELSE
         IFIDN <R16>,<HL>
            MOV [HL],AL
         ELSE
            MOV DI,R16
            MOV [DI],AL
	 ENDIF
      ENDIF
ENDM
;
; speichere A in Speicher  LD (nn),A
; R16={BC,DE,HL}
;
STA  MACRO
      MOV DI,[SI]
      ADD SI,2
      AWO DI
      IF _BANKING
         MOV ES:[DI],AL
      ELSE
         MOV [DI],AL
      ENDIF
ENDM

; 8 Bit Ladebefehle mit (ix,iy) in Modul DDOPS
;

; ********************************
; *
; * The 16-Bit Load Group
; *
; ********************************

;
; lade extended register immediate  LD R16,nn
; reg16={HL,BC,DE,SP}
; kein Flag veraendert
;
LXI_R16   MACRO R16
      MOV  R16,[SI]
      ADD  SI,2
ENDM


;
; lade extended register aus Speicher LD R16,(nn)
; reg16={HL,BC,DE,SP}
; kein Flag veraendert
;
LXD_R16   MACRO R16
         MOV DI,[SI]
         ADD SI,2
         ARO DI
         MOV R16,[DI]                     ;; r16:=(nn)
ENDM


;
; speichere extendended register nach Speicher  LD (nn),R16
; reg16={HL,BC,DE,SP}
; kein Flag veraendert
;
SXD_R16   MACRO R16
      MOV DI,[SI]
      ADD SI,2
      IF _BANKING
         AWO DI
         MOV  ES:[DI],R16
      ELSE
         MOV  [DI],R16                    ;; AX:=(nn)
      ENDIF
ENDM

; LD SP,HL  bei OPF9

FLAGS_LD_A_R_I MACRO
      MOV DI,AX
      AND DI,C_FLAG SHL 8        ; KEEP CY
      OR  AL,AL
      LAHF                       ; GET RESULTFLAGS
      AND AH,(Z_FLAG OR S_FLAG)  ; KEEP Z AND S, CLEAR REST
      OR  AH,byte ptr IFF0       ; GET IFF
      OR  AX,DI                  ; GET CY
ENDM

MOV_A_I MACRO
       MOV AL,CS:[RI]                  ; LD A,I
       FLAGS_LD_A_R_I
ENDM

MOV_R_A MACRO
      MOV  CS:RR,AL
IF _R_REG_TOO
      MOV  DI,AX
      AND  AL,80H
      MOV  CS:OLD_R,AL            ; KEEP BIT 7 FOR LATER LOAD
      MOV  AX,DI
ENDIF
ENDM

MOV_A_R MACRO                          ; LD A,R
IF _R_REG_TOO
      MOV  AL,CS:RR
      AND  AL,7FH         ; KEEP ONLY LOWER 7 BIT
      OR   AL,CS:OLD_R   ; GET UNCHANGED BIT 7
ELSE
      CALL get_rand
      MOV  DI,AX
      AND  DI,7FH  ; BEHALTE NUR UNTERE 7 BIT
      MOV  AL,BYTE PTR CS:RR
      AND  AL,80H
      OR   AX,DI
ENDIF
      FLAGS_LD_A_R_I
ENDM


;
; push r16 mit BP als Stackpointer
; kein Flag veraendert
;
ZPUSH MACRO R16
      SUB BP,2
      IF _BANKING
         AWO BP
         MOV ES:[BP],R16
         SWO BP
      ELSE
         MOV DS:[BP],R16
      ENDIF
;; der Z80 macht eigentlich [SP-2]:=R16;DEC(SP,2)
;; aber ein MOV [BP-2] braucht auf einem 8086 4 Taktzyklen mehr als MOV[BP]
ENDM
;
; pop r16 mit BP als Stackpointer
;
ZPOP  MACRO R16
      IF _BANKING
         MOV DI,BP
         ARO DI
         MOV R16,[DI]
      ELSE
         MOV R16,DS:[BP]
      ENDIF
      ADD BP,2
ENDM
;
; push af
; kein Flag veraendert
;
PUSH_AF MACRO                    ; PUSH AF
      XCHG AH,AL                 ;; da A Highbyte im PSW (AF) ist
      ZPUSH AX
      XCHG AH,AL
ENDM
;
; pop af
;
POP_AF MACRO
      ZPOP AX                    ; POP AF
      XCHG AH,AL                 ;; da A Highbyte im PSW (AF) ist
ENDM

; ********************************
; *
; * The 8-Bit Arithmetic und Logical Group
; *
; ********************************

;
; macro fuer Befehle add,adc,sub,sbc,and,or,xor,cp
; alle Flags werden gemaess der Tabelle geaendert:
; ACHTUNG: fuer adc und sbc ist der AUSGANGSwert von Carry wichtig
;
; OP     C   Z   P/V S   N   H
;
; ADD    |   |   V   |   0   |
; ADC    |   |   V   |   0   |
; SUB    |   |   V   |   1   |
; SBC    |   |   V   |   1   |
; AND    0   |   P   |   0   |
; OR     0   |   P   |   0   |
; XOR    0   |   P   |   0   |
; CP     |   |   V   |   1   |
; INC        |   V   |   0   |
; DEC        |   V   |   1   |
;
; ACHTUNG: 8086 setzt H flag bei AND,OR,XOR zufaellig
;          z80 setzt IMMMER H flag bei AND
;              resetiert IMMER H flag bei OR und XOR
;              also muessen AND,OR,XOR speziell behandelt werden
;   dabei ist das Setzen bei AND unlogisch, da ja kein Uebertrag von
;   Bit 3 nach 4 auftreten kann.
;
ALU_R8  MACRO CMD,R8,IN_AH_FLAG
      IFB <IN_AH_FLAG> ;; IF NON BLANK SAHF schon von ALU8IMM
         IFIDN <CMD>,<ADC>
           SAHF
         ELSEIFIDN <CMD>,<SBB>
           SAHF
         ENDIF
      ENDIF
      &CMD AL,R8
      LAHF
;; setze immer V_Flag, aber nicht mit AND,OR,XOR
      IFDIF <CMD>,<AND>
        IFDIF <CMD>,<OR>
          IFDIF <CMD>,<XOR>
            SET_V_FLAG
          ENDIF
        ENDIF
      ENDIF
;; jedoch mit AND setze H flag und resetiere es bei OR und XOR
;; if SUB,SBB oder CMP setze N_Flag, sonst resetiere
      IFIDN <CMD>,<ADD>
        RES_N_FLAG
      ELSEIFIDN <CMD>,<ADC>
        RES_N_FLAG
      ELSEIFIDN <CMD>,<SUB>
        SET_N_FLAG
      ELSEIFIDN <CMD>,<SBB>
        SET_N_FLAG
      ELSEIFIDN <CMD>,<AND>
        RES_N_FLAG
        OR AH,H_FLAG
      ELSEIFIDN <CMD>,<OR>
        AND AH,NOT (H_FLAG OR N_FLAG)
      ELSEIFIDN <CMD>,<XOR>
        AND AH,NOT (H_FLAG OR N_FLAG)
      ELSEIFIDN <CMD>,<CMP>
        SET_N_FLAG
      ELSE
        %OUT UNKNOWN COMMAND IN ALU_R8
      ENDIF
ENDM
;
; macro fuer arithmetic/logic 8 bit mit direkt angegebenem Databyte
; ruft macro ALU_R8 auf
;
ALU_IMM8  MACRO CMD                        ;; 8 BIT ARITHMETIK IMMEDIATE
      IFIDN <CMD>,<ADC>
         SAHF
      ELSEIFIDN <CMD>,<SBB>
         SAHF
      ENDIF
      MOV AH,[SI]
      INC SI
      ALU_R8 &CMD,AH,IN_BL_FLAG
; evtl verbesserung:
; ALU_R8 &CMD,[SI],IN_BL_FLAG
; INC SI
ENDM

;
; macros fuer 8 bit increment/decrement
; lassen Carry unberuehrt  (wie auch der 8086), setzen aber  V
;


INC_R8 MACRO R8
   INCDEC8 INC,R8
   RES_N_FLAG
ENDM

DEC_R8 MACRO R8
   INCDEC8 DEC,R8
   SET_N_FLAG
ENDM

INCDEC8 MACRO CMD,R8
      SAHF
      IFIDN <R8>,<[HL]>
	IF _BANKING
	   MOV DI,HL
	   AWO DI
	   SAHF ; nochmal
	   &CMD BYTE PTR ES:[DI]
	ELSE
	   &CMD BYTE PTR [HL]
	ENDIF
      ELSEIFIDN <R8>,<[HL+DI]>
	IF _BANKING
           AWO DI
           SAHF
           &CMD BYTE PTR ES:[HL+DI]
        ELSE
           &CMD BYTE PTR [HL+DI]
        ENDIF
      ELSE
        &CMD R8
      ENDIF
      LAHF
      SET_V_FLAG
ENDM


; **************************************************
; *
; * General Purpose Arithmetic and CPU Control Group
; *
; **************************************************

;
; alle Flags werden auf folgende Weise veraendert:
;
; OP     C   Z   P/V S   N   H
;
; DAA    |   |   P   |       |
; CPL                    1   1
; NEG    |   |   V   |   1   |
; CCF    |               0   CY old
; SCF    1               0   0
;
; macro fuer z80 Befehl daa
; erhaelt N_Flag
; wenn das n-Flag gesetzt war, war die letzte Operation eine
; Subtraktion und daa muss durch ein DAS ausgefuehrt werden,
; sonst durch DAA
; das alte Carry wird benoetigt
; Problem nach Subtraktion (N=1) :
;      wenn das LowNibble > 9 setzt 8086 nach DAS korrekter-
;      weise H_FLAG, jedoch nicht der Z80, in diesem Fall muss
;      also das H_Flag geloescht werden
;

Z80_DAA MACRO
LOCAL SUBTRACT,NO_H
      MOV DI,AX
      AND DI,N_FLAG SHL 8 ;; behalte nur N DI
      ; dies setzt auch das ZeroFlag fuer den JNZ
      JNZ SHORT SUBTRACT
      SAHF
      DAA
      LAHF
      RES_N_FLAG
      OR AX,DI    ; setze N alt
      DO_MLOOP
SUBTRACT:
      PUSH CX
      MOV CL,AL
      SAHF
      DAS
      LAHF
      AND CL,0FH
      CMP CL,9
      POP CX
      JNA short NO_H
      AND AH,NOT H_FLAG
NO_H:
      RES_N_FLAG
      OR AX,DI    ; setze N alt
ENDM


;
; macro fuer z80 command cpl
; setzt N und H Flags, die anderen sind nicht veraendert
;
Z80_CPL MACRO
      XOR AL,0FFH        ; Einerkomplement
      OR  AH,(N_FLAG OR H_FLAG)        ; setze N und H
ENDM
;
; macro fuer z80 command NEG
; aendert alle Flags,setzt V Flag, N=1
;
Z80_NEG MACRO
       NEG AL                          ; NEG
       LAHF
       SET_V_FLAG
       SET_N_FLAG
ENDM
;
; macro fuer z80 command CCF
; complementiert carry, N=0, H zufaellig
;
Z80_CCF MACRO
   AND AH,NOT (N_FLAG OR H_FLAG)
IF _UNDOC_FLG_TOO
   ;;  H-flag = old C-flag
   MOV DI,AX
   SHL AH,4    ; CY OLD TO H
   AND AH,H_FLAG
   OR AX,DI
ENDIF
   XOR AH,C_FLAG
ENDM
;
; macro fuer z80 command SCF
; C=1, N=0, H=0
;
Z80_SCF MACRO
       OR AH,C_FLAG
       AND AH,NOT (N_FLAG OR H_FLAG)
ENDM

; ********************************
; *
; * The 16-Bit Arithmetic Group
; *
; ********************************

;
; ADD HL,ss
; 8086 aendert alle Flags, aber
; der Z80 aendert carry und resetiert N und behaelt die anderen
;
ADD_HL  MACRO R16
     AND AH,NOT (C_FLAG OR N_FLAG) ;; C_FLAG wegen folgendem adc ,0
     ADD HL,R16
     ADC AH,0   ;; hole CY nach AH
ENDM
;
; ADC AH,0 kopiert das 8086 C_FLAG ins Z80 C_FLAG
; dieser Trick klappt, weil das Carry in Bit 0 ist
; jedoch muss zuvor Bit 0 in AH geloescht werden,
; da wenn schon vorher C gesetzt war, es einen
; Ueberlauf nach Bit 1 gibt
;
;

;
; ADC HL,ss
; alle flags veraendert, setze V, N=0, H=?
;
ADC_HL  MACRO R16
      SAHF         ; CY nach FLAGREG
      ADC HL,R16
      LAHF
      SET_V_FLAG
      RES_N_FLAG
IF _CPC_CO
	OR AH,H_FLAG
ENDIF
ENDM

;
; SBC HL,ss
; alle flags veraendert, setze V, N=1, H=?
;
SBC_HL  MACRO R16
      SAHF         ; CY nach FLAGREG
      SBB HL,R16
      LAHF
      SET_V_FLAG
      SET_N_FLAG
IF _CPC_CO
	OR AH,H_FLAG
ENDIF
ENDM

;
; Decrement und Increment eines 16 bit
; Registerpaares aendert auf einem Z80 keine Flags
;
INC_R16   MACRO R16
      INC R16
ENDM
DEC_R16   MACRO R16
      DEC R16
ENDM

XTHL MACRO ; EXCHANGE STACK TOP AND HL
  IF _BANKING ; KANN DANN UNSINN BEWIRKEN
     PUSH CX
     MOV  CX,BX
     ZPOP BX
     ZPUSH CX
     POP CX
  ELSE
     XCHG DS:[BP],HL
  ENDIF
ENDM

; ********************************
; *
; * The Rotate and Shift Group
; *
; ********************************

;
; macro fuer 8080 Rotate Operationen
;
ROTA MACRO CMD

;; RLA ,RRA benutzen CY alt

     IFIDN <CMD>,<RLA>
	SAHF
     ELSEIFIDN <CMD>,<RRA>
        SAHF
     ENDIF
     MOV DI,AX
     IFIDN <CMD>,<RLCA>
       ROL AL,1
     ELSEIFIDN <CMD>,<RLA>
       RCL AL,1
     ELSEIFIDN <CMD>,<RRCA>
       ROR AL,1
     ELSEIFIDN <CMD>,<RRA>
       RCR AL,1
     ELSE
       %OUT ILLEGAL CMD IN ROTA
       ERR
     ENDIF
     LAHF
     ;; behalte nur neues Cy
     AND AH,C_FLAG
     ;; loesche alte C,N,H & A
     AND DI,(NOT (C_FLAG OR N_FLAG OR H_FLAG))SHL 8
     OR AX,DI
ENDM


RRD MACRO
       PUSH AX   ; CY OLD
       MOV DI,CX
       MOV  CL,4  ; fuer SHIFT
       MOV CH,AL
       AND CH,0FH
       SHL CH,CL   ; muss nach [BX].high nib

       AND AL,0F0H
       MOV AH,AL
       ARO BX
       MOV AL,[BX]
       AND AL,0FH
       OR  AL,AH

       MOV AH,[BX]
       SRO BX
       SHR AH,CL
       AND AH,0FH
       OR  AH,CH
       IF _BANKING
          AWO BX
	  MOV ES:[BX],AH
          SWO BX
       ELSE
          MOV [BX],AH
       ENDIF

       OR AL,AL
       LAHF
       POP CX ; CY OLD
       AND CH,C_FLAG
       AND AH,(Z_FLAG OR V_FLAG OR S_FLAG)
       OR  AH,CH
       MOV CX,DI
ENDM

RLD MACRO
       PUSH AX
       MOV DI,CX
       MOV  CL,4
       MOV CH,AL
       AND CH,0FH

       AND AL,0F0H
       MOV AH,AL
       ARO BX
       MOV AL,[BX]
       AND AL,0F0H
       SHR AL,CL
       AND AL,0FH
       OR  AL,AH

       MOV AH,[BX]
       SRO BX
       SHL AH,CL
       AND AH,0F0H
       OR  AH,CH
       IF _BANKING
          AWO BX
          MOV ES:[BX],AH
	  SWO BX
       ELSE
          MOV [BX],AH
       ENDIF

       OR AL,AL
       LAHF
       POP CX ; CY OLD
       AND CH,C_FLAG
       AND AH,(Z_FLAG OR V_FLAG OR S_FLAG)
       OR  AH,CH
       MOV CX,DI
ENDM


;
; Es folgen  macros fuer JUMP und CALL Operationen
;

;
; branch JP,CALL,RET with condition cc
; cc={NZ,Z,NC,C,P,M,PE,PO}
; dies ist ein Untermacro fuer die Macros jpcc,callcc,retcc
;
BRNCC MACRO CC,KIND
LOCAL EXIT
      IFDIF <KIND>,<RET>
	;; hole Adresse fuer JP und CALL
        MOV DI,[SI]
        ADD SI,2
      ENDIF
      IFNB <CC>
          SAHF  ;; Flags nach F zur Sprungauswertung
		;; if CC true THEN jp else jmp to exit
          IFIDNI <CC>,<NZ>
	    JZ SHORT EXIT
          ELSEIFIDNI <CC>,<Z>
            JNZ SHORT EXIT
          ELSEIFIDNI <CC>,<NC>
	    JC SHORT EXIT
          ELSEIFIDNI <CC>,<C>
            JNC SHORT EXIT
          ELSEIFIDNI <CC>,<P>
            ;; P <=> SF=0
            ;; EXIT if SF=1
            JS SHORT EXIT
	  ELSEIFIDNI <CC>,<M>
            ;; M <=> SF=1
            ;; EXIT if SF=0
            JNS SHORT EXIT
          ELSEIFIDNI <CC>,<PE>
            ;; PE <=> PF=1
	    ;; EXIT if PF=0
            JPO SHORT EXIT
          ELSEIFIDNI <CC>,<PO>
            ;; PO <=> PF=0
            ;; EXIT if PF=1
            JPE SHORT EXIT
          ENDIF
      ENDIF                   ;; NON BLANK
      IFIDNI <KIND>,<JP>
        MOV SI,DI
      ELSEIFIDNI <KIND>,<CALL>
        SRO SI    ;; CALL muss richtige Adresse pushen
        ZPUSH SI
	MOV SI,DI
      ELSEIFIDNI <KIND>,<RET>
        ZPOP SI
      ELSE
	%OUT - ILLEGAL FUNCTION IN BRNCC
	ERR
      ENDIF
      ARO SI
EXIT:
ENDM

; ********************************
; *
; * Jump Group
; *
; ********************************

; keine flags veraendert

JPCC   MACRO CC
      BRNCC CC,JP
ENDM

;
; macro fuer z80 jr with condition
; cc={NZ,Z,NC,C}
;
JRCC MACRO CC                ;; BRANCH WITH CONDITION JP,CALL,RET
LOCAL EXIT
                            ;; SEE ALSO OP10: DJNZ
;; contrary to DJNZ a nojump is
;; as probable as a jump, so shun
;; overhead with nojump

      INC SI
      IFNB <CC>
         SAHF    ;; GET FLAGS FOR EVALUATION
         IFIDNI <CC>,<NZ>
           JZ SHORT EXIT
	 ELSEIFIDNI <CC>,<Z>
           JNZ SHORT EXIT
         ELSEIFIDNI <CC>,<NC>
           JC SHORT EXIT
         ELSEIFIDNI <CC>,<C>
           JNC SHORT EXIT
         ELSE
	   %OUT - ILLEGAL FUNCTION IN JR
	   ERR
         ENDIF
      ENDIF                   ;; NON BLANK
      MOV DI,AX
      MOV AL,[SI-1]        ;; GET DISTANCE
      CBW                  ;; EXPAND DISTANCE TO 16 BIT
      XCHG AX,DI
      ADD SI,DI
EXIT:
ENDM
;
; macro fuer z80 djnz
;
DJNZ  MACRO
LOCAL NOJUMP
;; if b=1 there is overhead but this is only once
      MOV DI,AX
      LODSB                ;; GET DISTANCE
      CBW
      XCHG DI,AX
      DEC B
      JZ  SHORT NOJUMP           ;; B IS ZERO, DON'T LOOP
      ADD SI,DI
NOJUMP:
ENDM


JP_HL MACRO
      MOV SI,HL
      ARO SI
ENDM


; ********************************
; *
; * Call and Return Group
; *
; ********************************

;
; the following macros fuer CALL,RET simply call
; macro BRNCC
;
CALLCC MACRO CC
      BRNCC CC,CALL
ENDM

RETCC MACRO CC
      BRNCC CC,RET
ENDM

Z80_RETI  MACRO
    RETCC
ENDM

Z80_RETN MACRO
    mov  di,IFF1
    mov  IFF0,di             ; iff0:=iff1
    RETCC
ENDM
;
; macro fuer restart operations
; NR=8*k; k=0..7
;
RST   MACRO NR
      SRO SI
      ZPUSH SI                          ;; CALL NR
      MOV SI,NR
      ARO SI
ENDM

LDILDD MACRO CMD    ; ES:DI:=DS:SI
LOCAL BC_N_NULL
       MOV  DI,DE
       XCHG SI,HL
       IFIDN <CMD>,<LDD>
         STD
       ENDIF

       ARO SI
       AWO DI

       MOVSB  ; Segmente stimmen auch bei banking

       SRO SI
       SWO DI
       IFIDN <CMD>,<LDD>
         CLD
       ENDIF
       XCHG DI,DE
       XCHG SI,HL
       AND  AH,NOT (V_FLAG OR N_FLAG OR H_FLAG)
       MOV  DI,AX
       DEC  BC
       MOV  AL,V_FLAG
       JNZ  SHORT BC_N_NULL
       XOR  AL,AL
BC_N_NULL:
       OR  AH,AL
       XOR AL,AL
       OR  AX,DI
ENDM


LDIRLDDR MACRO CMD    ; ES:DI:=DS:SI
IF _R_REG_TOO
       R_REG_ADD
ENDIF
       MOV  DI,DE
       XCHG SI,HL
       IFIDN <CMD>,<LDDR>
	 STD
       ENDIF
       ARO SI
       AWO DI

       REP MOVSB ; Segmente stimmen auch bei banking

       SRO SI
       SWO DI

       IFIDN <CMD>,<LDDR>
         CLD
       ENDIF
       MOV  DE,DI
       XCHG SI,HL
       AND  AH,NOT (V_FLAG OR N_FLAG OR H_FLAG)
ENDM



;; FLAGS: C_FLAG NOT AFFECTED
;;        Z,S,H ACCORDING TO CP(HL)
;;        P IF BC<>0

CMPBLOCK MACRO CMD
LOCAL BC_N_NULL

REPOP  INSTR <CMD>,<R> ; cpiR cpdR
CPDOP  INSTR <CMD>,<CPD> ; CPI CPIr

       MOV DI,HL
       IF REPOP EQ 0
	  PUSH CX
	  MOV  CX,1
       else
IF _R_REG_TOO
       R_REG_ADD
ENDIF
       ENDIF
       IF CPDOP
	 STD
       ENDIF
       IF _BANKING
	  ARO DI
	  PUSH ES
	  PUSH DS       ; Vergleiche sind Readzugriffe
	  POP ES
	  REPNE SCASB   ; CMP AL,ES:DI
	  POP ES
       ELSE
	  REPNE SCASB   ; CMP AL,ES:DI
       ENDIF
       IF REPOP EQ 0
	  POP CX
	  DEC CX
       ENDIF
       MOV HL,DI
       MOV DI,AX  ; SAVE OLD C_FLAG
       AND DI,(C_FLAG SHL 8)
;;ARO BX --- ERROR - already done for DI
       IF CPDOP
	 CLD
	 CMP AL,[HL+1]
       ELSE
	 CMP AL,[HL-1]
       ENDIF


       LAHF
       AND AH,NOT (C_FLAG OR V_FLAG)
       OR  DI,AX
       OR  CX,CX
       MOV  AH,V_FLAG
       JNZ  SHORT BC_N_NULL
       XOR  AH,AH
BC_N_NULL:
       OR AX,DI
       SRO BX
ENDM

; Die tatsaechliche I/O Operation wird im Modul portio unternommen,
; sie kann auch durch eine Dummy Operation ersetzt werden
;
; port_in:  AL:=port(DX)
; port_out: port(DX):=AL



; ****** MACRO fuer IN A,(n) ******

INP_A_N MACRO
      MOV DI,DX                        ; IN A,(n)
      MOV DH,AL                        ; A8..A15=A
      LODSB                            ; A0..A7=n
      MOV DL,AL
      CALL port_in  ; AL:=INPUT BYTE
      MOV DX,DI
ENDM

; ****** MACRO fuer IN R,(C) ******

; illegal ED70 TSTI(C) setzt nur Flags

INP    MACRO REG8  ; REG8:=PORT(BX);
       MOV  DI,AX  ; CY merken
       MOV  AH,AL  ; A merken
       XCHG BC,DE
       CALL port_in ; AL:=INPUT BYTE
       XCHG BC,DE
       OR   AL,AL ; Flags setzen
       IFDIF <REG8>,<A>
	 IFDIF <REG8>,<TST>
           MOV  REG8,AL
         ENDIF
         MOV  AL,AH ; A auf jeden Fall restaurieren
       ENDIF
       LAHF
       AND AH,(S_FLAG OR Z_FLAG OR H_FLAG OR V_FLAG) ; N:=0
       AND DI,C_FLAG SHL 8
       OR  AX,DI
ENDM

; ****** MACRO fuer Blockeingabebefehle INI,INIR,IND,INDR ******

BLOCK_INP MACRO CMD
LOCAL LOOP


REP_OP INSTR <CMD>,<R>   ; iniR indR
INC_OP INSTR <CMD>,<INI> ; INI INIr

LOOP:
       MOV  DI,AX    ; merke CY und A
       XCHG BC,DX
       CALL port_in
       XCHG BC,DX
       IF _BANKING
	  AWO HL
	  MOV  ES:[HL],AL
	  SWO HL
       ELSE
	  MOV  [HL],AL
       ENDIF
       IF INC_OP
	 INC  HL
       ELSE
	 DEC  HL
       ENDIF
       MOV  AX,DI
       SAHF ; CY nach F
       DEC  B   ; CY unberuehrt, Z gesetzt
       IF REPOP
	 JNZ  SHORT LOOP
       ENDIF
       LAHF
       OR AH,N_FLAG ; andere Flags bei z80 undef.
IF _CPC_CO
       AND AH,(C_FLAG OR Z_FLAG OR N_FLAG) ;;for CoZ80
ENDIF
ENDM


; ****** MACRO fuer Blockausgabebefehle OUTI,OTIR,OUTD,OTDR ******

BLOCK_OUTP MACRO CMD
LOCAL LOOP

REP_OP INSTR <CMD>,<R>   ; otiR otdR
INC_OP INSTR <CMD>,<I> ; outI otIr

       MOV  DI,AX    ; merke CY und A
LOOP:
       XCHG BC,DX
       ARO HL
       MOV  AL,[HL]
       SRO HL
       dec  dh       ; as z80 _first_ decs B
       CALL local_port_out
       inc  dh
       XCHG BC,DX
       IF INC_OP
	 INC  HL
       ELSE
	 DEC  HL
       ENDIF
       MOV  AX,DI
       SAHF ; CY nach F
       DEC  B   ; CY unberuehrt, Z gesetzt
       IF REPOP
	 JNZ  SHORT LOOP
       ENDIF
       LAHF
       OR AH,N_FLAG ; andere Flags bei z80 undef.
IF _CPC_CO
       AND AH,(C_FLAG OR Z_FLAG OR N_FLAG)	;;for CoZ80
ENDIF
ENDM


; ****** MACRO fuer OUT (n),A ******

; keine Flags veraendert

OUTP_A_N MACRO                         ; OUT (n),A
      MOV DI,DX
      MOV DH,AL                        ; A8..A15=A
      LODSB                            ; A0..A7=n
      MOV DL,AL
      MOV AL,DH  ; A wiederherstellen
      CALL local_port_out ; PORT(DX):=AL
      MOV DX,DI
ENDM

; ****** MACRO fuer OUT (C),R ******

; keine Flags veraendert

OUTP   MACRO REG8
       MOV  DI,AX  ; merke AF
       IFDIF <REG8>,<A>
         MOV  AL,REG8                  ; BYTE nach AL
       ENDIF
       XCHG BC,DE                      ; STORE DX
       CALL local_port_out                   ; PORT(DX):=AL
       XCHG BC,DE                      ; RESTORE DX
       MOV  AX,DI
ENDM

SET_IM MACRO NR     ; SET INTERRUPT MODE
IF _CPCEMU
      mov cs:byte ptr RIM,NR	;memorize interrupt-mode
ENDIF
IFIDN <NR>,<0>
      mov CS:int_rout_poi,offset im0_rout
ELSEIFIDN <NR>,<1>
      mov CS:int_rout_poi,offset im1_rout
ELSEIFIDN <NR>,<2>
      mov CS:int_rout_poi,offset im2_rout
ELSE
    %OUT ILLEGAL INTERRUPT MODE &NR
    ERR
ENDIF
ENDM

DISABLE_INTS MACRO
      MOV byte ptr CS:IFF0,0
      MOV byte ptr CS:IFF1,0
ENDM

ENABLE_INTS MACRO
      MOV byte ptr CS:IFF0,V_FLAG
      MOV byte ptr CS:IFF1,V_FLAG
ENDM


; Macro fuer Interpreterhauptschleife

GET_CODE MACRO
IF _32BIT
      mov di,[si]     ; 4
      inc si          ; 2
      and di,0ffh     ; 2
      add di,di       ; 2
ELSE
      MOV DI,AX       ; 2              ; AF merken
      LODSB           ; 5              ; OP CODE von [SI] holen, SI++
      XOR AH,AH       ; 2
      ADD AX,AX       ; 2              ; OP CODE*=2,
      XCHG AX,DI      ; 3              ; DI dient als Index in JPTAB
ENDIF
ENDM

IF _R_REG_TOO OR _WAITCALL
   LEFT_SHIFT EQU 6
ELSE
   IF _BANKING     ; mehr Platz pro Code noetig
      LEFT_SHIFT EQU 6
   ELSE
      LEFT_SHIFT EQU 5
   ENDIF
ENDIF
BYTES_PER_CODE EQU (1 SHL LEFT_SHIFT)

SET_OPCNTR MACRO
inst_cntr = OFFSET $
ENDM

SET_OP_DIST MACRO
if ($-inst_cntr) gt BYTES_PER_CODE
  %out ACHTUNG: Instruktion zu gross
  DW ($-inst_cntr)
  db 'DIST_ERR'
endif

ALIGN BYTES_PER_CODE
SET_OPCNTR

ENDM


; anstelle eines Jumpes nach MLOOP wird dieses Macro verwendet,
; was zu einer wesentlichen Geschwindigkeitserhoehung fuehrt


IF _CPC_CO

DO_MLOOP MACRO
jmp next_instr
ENDM

ELSE

DO_MLOOP MACRO

IF _R_REG_TOO
	inc cs:RR  ; this is an 8 bit inc, but only 7 bits
		   ; are stored/loaded to/from R
ENDIF
IF _WAITCALL
   call waiting
ENDIF

IF _USE386
.386
        movzx di,byte ptr [si]        ; 6
.286
else
	mov di,[si]                   ; 4
	and di,0ffh                   ; 2
endif
	shl di,LEFT_SHIFT             ; 3
        inc si                        ; 2
	jmp di                        ; 7

ENDM

ENDIF	;if _cpc_co

; ********
; VORSICHT: Speicheraddressierung mit BP braucht DS:OVERRIDE
; ********

; beim Eintritt in den Emulator muessen DS,ES auf das
; z80 Segment zeigen und SS:SP auf einen Stack (>=128 Words)

Z80EmulatorSeg segment PAGE 'CODE'

assume  cs:Z80EmulatorSeg,ds:nothing,es:nothing,ss:nothing

SET_OPCNTR

; hier muss unbedingt OFFSET 0 sein

OP0:                                  ; NOP
      DO_MLOOP
SET_OP_DIST

OP1:
                                       ; LD BC,nn
      LXI_R16  BC
      DO_MLOOP
SET_OP_DIST

OP2:
      STAX BC                          ; LD (BC),A
      DO_MLOOP
SET_OP_DIST
OP3:
      INC_R16 BC                       ; INC BC
      DO_MLOOP
SET_OP_DIST
OP4:
      INC_R8 B                           ; INC B
      DO_MLOOP
SET_OP_DIST
OP5:
      DEC_R8 B                           ; DEC B
      DO_MLOOP
SET_OP_DIST
OP6:
      MVI8 B                          ; LD B,n
      DO_MLOOP
SET_OP_DIST
OP7:
      ROTA RLCA                        ; RLCA
      DO_MLOOP
SET_OP_DIST

OP8:
if _Z80
      XCHG AX,CS:WORD PTR RAF          ; EX AF,AF'
endif
      DO_MLOOP
SET_OP_DIST
OP9:
      ADD_HL BC                        ; ADD HL,BC
      DO_MLOOP
SET_OP_DIST
OP0A:
      LDAX BC                          ; LD A,(BC)
      DO_MLOOP
SET_OP_DIST
OP0B:
      DEC_R16 BC                       ; DEC BC
      DO_MLOOP
SET_OP_DIST
OP0C:
      INC_R8 C                           ; INC C
      DO_MLOOP
SET_OP_DIST
OP0D:
      DEC_R8 C                           ; DEC C
      DO_MLOOP
SET_OP_DIST
OP0E:
      MVI8 C                           ; LD C,n
      DO_MLOOP
SET_OP_DIST
OP0F:
      ROTA RRCA                        ; RRCA
      DO_MLOOP
SET_OP_DIST
OP10:
if _Z80
      DJNZ                             ; DJNZ
endif
      DO_MLOOP
SET_OP_DIST
OP11:                                  ; LD DE,nn
      LXI_R16 DE
      DO_MLOOP
SET_OP_DIST
OP12:
      STAX DE                         ; LD (DE),A
      DO_MLOOP
SET_OP_DIST
OP13:
      INC_R16 DE                       ; INC DE
      DO_MLOOP
SET_OP_DIST
OP14:
      INC_R8 D                           ; INC D
      DO_MLOOP
SET_OP_DIST
OP15:
      DEC_R8 D                           ; DEC D
      DO_MLOOP
SET_OP_DIST
OP16:
      MVI8 D                           ; LD D,n
      DO_MLOOP
SET_OP_DIST
OP17:
      ROTA RLA                         ; RLA
      DO_MLOOP
SET_OP_DIST
OP18:
if _Z80
      JRCC                               ; JR
endif
      DO_MLOOP
SET_OP_DIST
OP19:
      ADD_HL DE                         ; ADD HL,DE
      DO_MLOOP
SET_OP_DIST
OP1A:
      LDAX DE                         ; LD A,(DE)
      DO_MLOOP
SET_OP_DIST
OP1B:
      DEC_R16 DE                           ; DEC DE
      DO_MLOOP
SET_OP_DIST
OP1C:
      INC_R8 E                           ; INC E
      DO_MLOOP
SET_OP_DIST
OP1D:
      DEC_R8 E                           ; DEC E
      DO_MLOOP
SET_OP_DIST
OP1E:
      MVI8 E                           ; LD E,n
      DO_MLOOP
SET_OP_DIST
OP1F:
      ROTA RRA                         ; RRA
      DO_MLOOP
SET_OP_DIST
OP20:
if _Z80
      JRCC NZ                            ; JR NZ,
endif
      DO_MLOOP
SET_OP_DIST
OP21:
				       ; LD HL,nn
      LXI_R16  HL
      DO_MLOOP
SET_OP_DIST
OP22:
				       ; LD (nn),HL
      SXD_R16 HL
      DO_MLOOP
SET_OP_DIST
OP23:
      INC_R16 HL                           ; INC HL
      DO_MLOOP
SET_OP_DIST
OP24:
      INC_R8 H                           ; INC H
      DO_MLOOP
SET_OP_DIST
OP25:
      DEC_R8 H                           ; DEC H
      DO_MLOOP
SET_OP_DIST
OP26:
      MVI8 H                           ; LD H,n
      DO_MLOOP

SET_OP_DIST

OP27:                                  ; DAA
       jmp EXEC_DAA
SET_OP_DIST
OP28:
if _Z80
      JRCC Z                             ; JR Z,
endif
      DO_MLOOP
SET_OP_DIST
OP29:
      ADD_HL HL                         ; ADD HL,HL
      DO_MLOOP
SET_OP_DIST
OP2A:
                                       ; LD HL,(nn)
      LXD_R16 HL
      DO_MLOOP
SET_OP_DIST
OP2B:
      DEC_R16 HL                           ; DEC HL
      DO_MLOOP
SET_OP_DIST

OP2C:
      INC_R8 L                           ; INC L
      DO_MLOOP
SET_OP_DIST
OP2D:
      DEC_R8 L                           ; DEC L
      DO_MLOOP
SET_OP_DIST
OP2E:
      MVI8 L                           ; LD L,n
      DO_MLOOP
SET_OP_DIST

OP2F: Z80_CPL                          ; CPL
      DO_MLOOP
SET_OP_DIST
OP30:
      JRCC NC                            ; JR NC,
      DO_MLOOP
SET_OP_DIST
OP31:
                                         ; LD SP,nn
      LXI_R16  SP_Z
      DO_MLOOP
SET_OP_DIST

OP32:                                    ; LD (nn),A
      STA
      DO_MLOOP
SET_OP_DIST
OP33:
      INC_R16 SP_Z                           ; INC SP
      DO_MLOOP
SET_OP_DIST

OP34:
      INC_R8 [HL]               ; INC (HL)
      DO_MLOOP
SET_OP_DIST

OP35:
      DEC_R8 [HL]                ; DEC (HL)
      DO_MLOOP
SET_OP_DIST

OP36:
      MVI8 [HL]                         ; LD (HL),n
      DO_MLOOP
SET_OP_DIST

OP37:
      Z80_SCF                          ; SCF
      DO_MLOOP
SET_OP_DIST
OP38:
if _Z80
      JRCC C                             ; JR C,
endif
      DO_MLOOP
SET_OP_DIST
OP39:
      ADD_HL SP_Z                         ; ADD HL,SP
      DO_MLOOP
SET_OP_DIST
OP3A:                                  ; LD A,(nn)
      LDA
      DO_MLOOP
SET_OP_DIST
OP3B:
      DEC_R16 SP_Z                           ; DEC SP
      DO_MLOOP
SET_OP_DIST
OP3C:
      INC_R8 AL                           ; INC A
      DO_MLOOP
SET_OP_DIST
OP3D:
      DEC_R8 AL                           ; DEC A
      DO_MLOOP
SET_OP_DIST
OP3E:
      MVI8 AL                           ; LD A,n
      DO_MLOOP
SET_OP_DIST
OP3F:
      Z80_CCF                          ; CCF
      DO_MLOOP
SET_OP_DIST


; Labels sind nur dazu da, sich mit dem
; debugger besser zurechtzufinden

ldmakelabel macro x
OP&x:
endm

; the 8 bit load group


CN = 40H

; im folgenden wird immer DI statt HL genommen,
; dies wird in LD8 korrigiert

IRP TARG8, <CH,CL,DH,DL,BH,BL,[BX],AL>
    IRP SRC8, <CH,CL,DH,DL,BH,BL,[BX],AL>


    .RADIX 16
    ldmakelabel %CN
    .RADIX 10

    IF CN NE 76H
       LD8 <TARG8>,<SRC8>
       DO_MLOOP
    ELSE                     ; HALT
       MOV DI,76H                       ;  HALT
jmp halt_cont

    ENDIF

    CN = CN + 1                      ;; INC CODE #

    SET_OP_DIST

    ENDM  ;; IRP SRC8

ENDM  ;; IRP TARG8


; the 8 bit arithmetic and logical group

IRP CMD, <ADD,ADC,SUB,SBB,AND,XOR,OR,CMP>
    IRP REG8, <CH,CL,DH,DL,BH,BL,[BX],AL>

       align 4

      .RADIX 16
      ldmakelabel %CN
      .RADIX 10

     IF _BANKING
	IFIDNI <REG8>,<[BX]>
           MOV DI,BX
           ARO DI
           ALU_R8 <CMD>,<[DI]>
        ELSE
	   ALU_R8 <CMD>,<REG8>
        ENDIF
     ELSE
        ALU_R8 <CMD>,<REG8>
     ENDIF

      DO_MLOOP

    CN = CN + 1                      ;; INC CODE #

    SET_OP_DIST


    ENDM  ;; IRP REG8

ENDM  ;; IRP CMD


OP0C0:
                                       ; RET NZ
      RETCC NZ
      DO_MLOOP
SET_OP_DIST
OP0C1:
      ZPOP BC                          ; POP BC
      DO_MLOOP
SET_OP_DIST
OP0C2:
                                        ; JP NZ,nn
      JPCC NZ
      DO_MLOOP
SET_OP_DIST
OP0C3:
                                        ; JP nn
      JPCC
      DO_MLOOP
SET_OP_DIST
OP0C4:
                                        ; CALL NZ,nn
      CALLCC NZ
      DO_MLOOP
SET_OP_DIST
OP0C5:
      ZPUSH BC                          ; PUSH BC
      DO_MLOOP
SET_OP_DIST
OP0C6:
      ALU_IMM8 ADD                         ; ADD A,n
      JMP MLOOP
SET_OP_DIST

OP0C7:
      RST 0                            ; RST 0
      DO_MLOOP
SET_OP_DIST
OP0C8:
                                       ; RET Z
      RETCC Z
      DO_MLOOP
SET_OP_DIST
OP0C9:
      RETCC                            ; RET
      DO_MLOOP
SET_OP_DIST
OP0CA:
					; JP Z,nn
      JPCC Z
      DO_MLOOP

SET_OP_DIST

; ************ INTERPRETER SCHLEIFE *************

OP0CB:
if _Z80
IF _R_REG_TOO
	inc cs:RR
ENDIF
      GET_CODE ; Folgebyte nach CB
      JMP WORD PTR CS:CBOPTAB[DI]
else
      DO_MLOOP
endif

SET_OP_DIST

OP0CC:
                                        ; CALL Z,nn
      CALLCC Z
      DO_MLOOP
SET_OP_DIST
OP0CD:
                                        ; CALL nn
      CALLCC
      DO_MLOOP
SET_OP_DIST
OP0CE:
      ALU_IMM8 ADC                         ; ADC A,n
      JMP MLOOP
SET_OP_DIST

OP0CF:
      RST 8H                           ; RST 8
      DO_MLOOP
SET_OP_DIST
OP0D0:
      RETCC NC                         ; RET NC
      DO_MLOOP
SET_OP_DIST
OP0D1:
      ZPOP DE                          ; POP DE
      DO_MLOOP
SET_OP_DIST
OP0D2:
                                        ; JP NC,nn
      JPCC NC
      DO_MLOOP
SET_OP_DIST
OP0D3:                                   ; OUT (n),A
      OUTP_A_N
      DO_MLOOP
SET_OP_DIST
OP0D4:
                                        ; CALL NC,nn
      CALLCC NC
      DO_MLOOP
SET_OP_DIST
OP0D5:
      ZPUSH DE                          ; PUSH DE
      DO_MLOOP
SET_OP_DIST

OP0D6:
      ALU_IMM8 SUB                         ; SUB n
      JMP MLOOP
SET_OP_DIST

OP0D7:
      RST 10H                          ; RST 10
      DO_MLOOP
SET_OP_DIST
OP0D8:
                                       ; RET C
      RETCC C
      DO_MLOOP
SET_OP_DIST
OP0D9:
if _Z80
      XCHG HL,CS:WORD PTR RHL          ; EXX
      XCHG BC,CS:WORD PTR RBC
      XCHG DE,CS:WORD PTR RDE
endif
      DO_MLOOP
SET_OP_DIST
OP0DA:
                                        ; JP C,nn
      JPCC C
      DO_MLOOP
SET_OP_DIST
OP0DB:
      INP_A_N                          ; IN A,(n)
      DO_MLOOP
SET_OP_DIST
OP0DC:
                                        ; CALL C,nn
      CALLCC C
      DO_MLOOP

SET_OP_DIST

; ************ INTERPRETER SCHLEIFE *************

OP0DD:

if _Z80
IF _R_REG_TOO
        inc cs:RR
ENDIF
      MOV  CS:HL_R.HWORD,BX
      MOV  BX,CS:RIX
      MOV  CS:REGPOI,OFFSET RIX
      GET_CODE
      JMP WORD PTR CS:DDOPTAB[DI]         ; EXEC
else
      DO_MLOOP
endif

SET_OP_DIST

OP0DE:
      ALU_IMM8 SBB                         ; SBC A,n
      JMP MLOOP
SET_OP_DIST

OP0DF:
      RST 18H                          ; RST 18
      DO_MLOOP
SET_OP_DIST
OP0E0:
      RETCC PO                         ; RET PO
      DO_MLOOP
SET_OP_DIST
OP0E1:
      ZPOP HL                          ; POP HL
      DO_MLOOP
SET_OP_DIST
OP0E2:
                                       ; JP PO,nn
      JPCC PO
      DO_MLOOP
SET_OP_DIST
OP0E3:                                  ; EX (SP),HL
      XTHL
      DO_MLOOP
SET_OP_DIST
OP0E4:
      CALLCC PO                        ; CALL PO,nn
      DO_MLOOP
SET_OP_DIST
OP0E5:
      ZPUSH HL                         ; PUSH HL
      DO_MLOOP
SET_OP_DIST
OP0E6:
      ALU_IMM8 AND                         ; AND n
      DO_MLOOP
SET_OP_DIST
OP0E7:
      RST 20H                          ; RST 20
      DO_MLOOP
SET_OP_DIST
OP0E8:
                                       ; RET PE
      RETCC PE
      DO_MLOOP
SET_OP_DIST
OP0E9: JP_HL                            ; JP (HL)

      DO_MLOOP
SET_OP_DIST
OP0EA:
				       ; JP PE,nn
      JPCC PE
      DO_MLOOP
SET_OP_DIST
OP0EB:
      XCHG DE,HL                       ; EX DE,HL
      DO_MLOOP
SET_OP_DIST
OP0EC:
                                       ; CALL PE,nn
      CALLCC PE
      DO_MLOOP

SET_OP_DIST

; *********** Sekundaere InterpreterSchleife fuer EDops **********

OP0ED:
if _Z80
IF _R_REG_TOO
	inc cs:RR
ENDIF
      GET_CODE  ;  hole Folgebyte nach ED
      JMP WORD PTR CS:EDOPTAB[DI]
else
      mov di,[si]
      inc si
      and di,0ffh
      cmp di,0edh
      jnz short EDED1
      jmp EDOP0ED
EDED1:
      DO_MLOOP

endif

SET_OP_DIST

OP0EE:
      ALU_IMM8 XOR                         ; XOR n

      DO_MLOOP
SET_OP_DIST
OP0EF:
      RST 28H                          ; RST 28
      DO_MLOOP
SET_OP_DIST
OP0F0:
				       ; RET P
      RETCC P
      DO_MLOOP
SET_OP_DIST
OP0F1:
      POP_AF                           ; POP AF
      DO_MLOOP
SET_OP_DIST
OP0F2:
				       ; JP P,nn
      JPCC P
      DO_MLOOP
SET_OP_DIST
OP0F3:
                                       ; DI
      DISABLE_INTS
      DO_MLOOP
SET_OP_DIST
OP0F4:
                                       ; CALL P,nn
      CALLCC P
      DO_MLOOP
SET_OP_DIST
OP0F5:
      PUSH_AF                          ; PUSH AF
      DO_MLOOP
SET_OP_DIST
OP0F6:
      ALU_IMM8 OR                          ; OR n
      DO_MLOOP
SET_OP_DIST
OP0F7:
      RST 30H                          ; RST 30
      DO_MLOOP
SET_OP_DIST
OP0F8:
                                       ; RET M
      RETCC M
      DO_MLOOP
SET_OP_DIST
OP0F9:
      MOV SP_Z,HL                        ; LD SP,HL
      DO_MLOOP
SET_OP_DIST
OP0FA:
				       ; JP M,nn
      JPCC M
      DO_MLOOP
SET_OP_DIST
OP0FB:
      ENABLE_INTS                       ; EI
      DO_MLOOP
SET_OP_DIST

OP0FC:
                                       ; CALL M,nn
      CALLCC M
      DO_MLOOP
SET_OP_DIST

OP0FD:

if _Z80
IF _R_REG_TOO
        inc cs:RR
ENDIF
      MOV  CS:HL_R.HWORD,HL
      MOV  BX,CS:RIY
      MOV  CS:REGPOI,OFFSET RIY
      GET_CODE
      JMP WORD PTR CS:DDOPTAB[DI]         ; EXEC
else
      DO_MLOOP
endif

SET_OP_DIST

OP0FE:
      ALU_IMM8 CMP                         ; CP n
      JMP MLOOP

SET_OP_DIST


OP0FF:
      RST 38H                          ; RST 38
      DO_MLOOP

; nicht genug Platz fuer DAA am richtigen Platz
EXEC_DAA:
      Z80_DAA
      DO_MLOOP

halt_cont:
       SRO SI                          ;sub (old) offset from PC
       mov cs:emu_active_flg,FALSE
       add sp,2
       CALL prg_exit
       push offset int_ack
       ARO SI                          ;add (new) offset to PC
       mov cs:emu_active_flg,TRUE
IF _CPC_CO
	mov word ptr cs:inscount,1	;return at once
ENDIF
       DO_MLOOP


MLOOP:               ; special entry point that intreq does not overwrite
      DO_MLOOP


if _CPCEMU
;see below

else	;not cpcemu

EDOP0ED:                                ; CALLN
	LODSB                          ; hole Bios Nr
	SRO SI                          ;sub offset from PC
	mov cs:emu_active_flg,FALSE
	add sp,2           ; throw away ptr to int_ack
	JMP bios88

endif	;not cpcemu

if _Z80
align 4
RAF   DW 0
RHL   DW 0
RBC   DW 0
RDE   DW 0
RIX   DW 0
RIY   DW 0
      DB 0      ; damit i in im2_rout nach high(di) geladen werden kann
RI    DB 0
RR    DB 0
IF _CPCEMU
RIM   DW 0	;interrupt-mode
ENDIF
endif
IFF0  DW 0
IFF1  DW 0

OLD_R db 0

if _Z80

EDOP_ILLEGAL:
; unbekannte illegals werden wie NOPs behandelt
      JMP MLOOP

edmakelabel macro x
EDOP&x:
endm

CN = 0H

rept 3eh+1
    .RADIX 16
    edmakelabel %CN
    .RADIX 10

    CN = CN + 1                      ;; INC CODE #
endm

EDOP3F:
       JMP EDOP_ILLEGAL

ALIGN 4
EDOP40:                                ; IN B,(C)
       INP B
       JMP MLOOP
ALIGN 4
EDOP41:                                ; OUT (C),B
       OUTP B
       JMP MLOOP
ALIGN 4
EDOP42:
       SBC_HL BC                       ; SBC HL,BC
       DO_MLOOP
ALIGN 4
EDOP43:
       SXD_R16 BC                          ; LD (nn),BC
       DO_MLOOP
ALIGN 4
EDOP44:
       Z80_NEG                         ; NEG

       DO_MLOOP
ALIGN 4
EDOP45:
       Z80_RETN                         ; RETN
       JMP MLOOP
ALIGN 4
EDOP46:
       SET_IM 0
       JMP MLOOP                       ; IM 0
ALIGN 4
EDOP47:
       MOV CS:[RI],AL                  ; LD I,A
       JMP MLOOP
ALIGN 4

EDOP48:                                ; IN C,(C)
       INP C
       JMP MLOOP
ALIGN 4
EDOP49:                                ; OUT (C),C
       OUTP C
       JMP MLOOP
ALIGN 4
EDOP4A:
       ADC_HL BC                       ; ADC HL,BC
       DO_MLOOP
ALIGN 4
EDOP4B:
       LXD_R16 BC                          ; LD BC,(nn)
       DO_MLOOP
ALIGN 4
EDOP4C:
       JMP MLOOP
ALIGN 4
EDOP4D:
       Z80_RETI                        ; RETI
       JMP MLOOP
ALIGN 4
EDOP4E:
       JMP MLOOP
ALIGN 4
EDOP4F:
       MOV_R_A
                                       ; LD R,A
       JMP MLOOP
ALIGN 4
EDOP50:
       INP D                          ; IN D,(C)
       JMP MLOOP
ALIGN 4
EDOP51:                                ; OUT (C),D
       OUTP D
       JMP MLOOP
ALIGN 4
EDOP52:
       SBC_HL DE                       ; SBC HL,DE
       DO_MLOOP
ALIGN 4
EDOP53:
       SXD_R16 DE                      ; LD (nn),DE
       JMP MLOOP
EDOP54:
EDOP55:
       JMP EDOP_ILLEGAL
EDOP56:
       SET_IM 1                        ; IM 1
       JMP MLOOP
ALIGN 4
EDOP57:
       MOV_A_I
                                       ; LD A,I
       JMP MLOOP
ALIGN 4
EDOP58:                                ; IN E,(C)
       INP E
       JMP MLOOP
ALIGN 4
EDOP59:                                ; OUT (C),E
       OUTP E
       JMP MLOOP
ALIGN 4
EDOP5A:
       ADC_HL DE                       ; ADC HL,DE
       DO_MLOOP
ALIGN 4
EDOP5B:
       LXD_R16 DE                      ; LD DE,(nn)
       JMP MLOOP
EDOP5C:
EDOP5D:
       JMP EDOP_ILLEGAL
EDOP5E:
       SET_IM 2                        ; IM 2
       JMP MLOOP
ALIGN 4
EDOP5F:                                ; LD A,R
       MOV_A_R
       JMP MLOOP
ALIGN 4
EDOP60:                                ; IN H,(C)
       INP H
       JMP MLOOP
ALIGN 4
EDOP61:                                ; OUT (C),H
       OUTP H
       JMP MLOOP
ALIGN 4
EDOP62:
       SBC_HL HL                       ; SBC HL,HL
       DO_MLOOP
ALIGN 4
EDOP63:
       SXD_R16 HL                          ; LD (nn),HL
       JMP MLOOP
EDOP64:
EDOP65:
EDOP66:JMP EDOP_ILLEGAL

ALIGN 4
EDOP67:                                ; RRD
       RRD
       DO_MLOOP
ALIGN 4
EDOP68:                                ; IN L,(C)
       INP L
       JMP MLOOP
ALIGN 4
EDOP69:                                ; OUT (C),L
       OUTP L
       JMP MLOOP
ALIGN 4
EDOP6A:
       ADC_HL HL                       ; ADC HL,HL
       DO_MLOOP
ALIGN 4
EDOP6B:
       LXD_R16 HL                          ; LD HL,(nn)
       JMP MLOOP
EDOP6C:
EDOP6D:
EDOP6E:
       JMP EDOP_ILLEGAL
ALIGN 4
EDOP6F:                              ; RLD
       RLD
       DO_MLOOP
ALIGN 4
EDOP70:INP TST                         ; TSTI (C) (undok. Op.)
       JMP MLOOP
EDOP71:
       JMP EDOP_ILLEGAL
ALIGN 4
EDOP72:
       SBC_HL SP_Z                       ; SBC HL,SP
       DO_MLOOP
ALIGN 4
EDOP73:
       SXD_R16 SP_Z                          ; LD (nn),SP
       DO_MLOOP

EDOP74:
EDOP75:
EDOP76:
       JMP EDOP_ILLEGAL
EDOP77:
       MOV AL,6AH                      ; TSTW
       JMP MLOOP
ALIGN 4
EDOP78:                                ; IN A,(C)
       INP A
       JMP MLOOP
ALIGN 4
EDOP79:                                ; OUT (C),A
       OUTP A
       JMP MLOOP
ALIGN 4
EDOP7A:
       ADC_HL SP_Z                      ; ADC HL,SP
       DO_MLOOP
ALIGN 4
EDOP7B:
       LXD_R16 SP_Z                     ; LD SP,(nn)
       DO_MLOOP


CN = 7CH

rept (9Eh-7CH+1)
    .RADIX 16
    edmakelabel %CN
    .RADIX 10

    CN = CN + 1                      ;; INC CODE #
endm

EDOP9F:
       JMP EDOP_ILLEGAL

ALIGN 4
EDOP0A0:                        ; LDI
       LDILDD LDI
       DO_MLOOP
ALIGN 4
EDOP0A1:                                ; CPI
       CMPBLOCK CPI
       DO_MLOOP
ALIGN 4
EDOP0A2:                                ; INI
       BLOCK_INP INI
       DO_MLOOP
ALIGN 4
EDOP0A3:                                ; OUTI
       BLOCK_OUTP OUTI
       DO_MLOOP
EDOP0A4:
EDOP0A5:
EDOP0A6:
EDOP0A7:
       JMP EDOP_ILLEGAL
ALIGN 4
EDOP0A8:                         ; LDD
       LDILDD LDD
       DO_MLOOP
ALIGN 4
EDOP0A9:                                ; CPD
       CMPBLOCK CPD
       DO_MLOOP
ALIGN 4

EDOP0AA:                                ; IND
       BLOCK_INP IND
       DO_MLOOP
ALIGN 4
EDOP0AB:                                ; OUTD
       BLOCK_OUTP OUTD
       DO_MLOOP
EDOP0AC:
EDOP0AD:
EDOP0AE:
EDOP0AF:
       JMP EDOP_ILLEGAL

ALIGN 4
EDOP0B0:                                ; LDIR
       LDIRLDDR LDIR
       DO_MLOOP
ALIGN 4

EDOP0B1:                                ; CPIR
       CMPBLOCK CPIR
       DO_MLOOP
ALIGN 4
EDOP0B2:                                ; INIR
       BLOCK_INP INIR
       DO_MLOOP

ALIGN 4
EDOP0B3:                                ; OTIR
       BLOCK_OUTP OTIR
       DO_MLOOP
EDOP0B4:
EDOP0B5:
EDOP0B6:
EDOP0B7:
       JMP EDOP_ILLEGAL
ALIGN 4
EDOP0B8:                       ; LDDR
       LDIRLDDR LDDR
       DO_MLOOP
ALIGN 4

EDOP0B9:                                ; CPDR
       CMPBLOCK CPDR
       DO_MLOOP
ALIGN 4
EDOP0BA:                                ; INDR
       BLOCK_INP INDR
       DO_MLOOP
ALIGN 4
EDOP0BB:                                ; OTDR
       BLOCK_OUTP OTDR
       DO_MLOOP


CN = 0BCH


IF _CPCEMU

rept (0F8h-0BCH)
    IF (CN NE 0FDH)
	  .RADIX 16
	  edmakelabel %CN
	  .RADIX 10
    ENDIF
    CN = CN + 1                      ;; INC CODE #
endm
EDOP0F8: JMP EDOP_ILLEGAL

;system-calls  ED [F9..FF] xx (don't modify AX !)
EDOP0F9:
EDOP0FA:
EDOP0FB:
EDOP0FC:
EDOP0FD:
EDOP0FE:
EDOP0FF:
	mov di,[si-1]	;dil = [f9..ff], dih = xx (number)
	inc si		;PC+=1
	SRO SI				;sub offset from PC
	mov cs:emu_active_flg,FALSE
	add sp,2           ; throw away ptr to int_ack
	call save_z80regs	;copy regs to dseg
	JMP bios88

ELSE	;not cpcemu

rept (0FFh-0BCH)
    IF (CN NE 0EDH)  ; EDED BIOSCALL
    .RADIX 16
    edmakelabel %CN
    .RADIX 10
    ENDIF

    CN = CN + 1                      ;; INC CODE #
endm

EDOP0FF: JMP EDOP_ILLEGAL
ENDIF	;if _cpcemu

endif ; if _z80



; *************************************************+
;
; TEILMODUL DES Z80EMULATORS FUER CB-CODES
;
;
; (C) 1990 by Juergen Weber
;


;
; IN DIESEM MODUL DARF DER TRICK MIT DEM MACRO DO_MLOOP
; NICHT VERWENDET WERDEN, DA OPCB REKURSIV VON OPDD AUFGERUFEN
; WIRD UND BEI MLOOP EIN RET EINGESETZT WIRD
;

;
; FLAGS IM Z80
;
S_FLAG EQU 10000000B
Z_FLAG EQU 01000000B
H_FLAG EQU 00010000B
V_FLAG EQU 00000100B
N_FLAG EQU 00000010B
C_FLAG EQU 00000001B


; Macros zur automatischen Generierung von Labeln und Tabellen
; mit Zeigern auf Labels

if _Z80
makelabel macro x
CBOP&x:
endm

makepoint macro x
   dw offset CBOP&x
endm

endif

align 4



if _Z80

CN = 0                                 ; Z80 OP CODE

; ************* ROTATE/SHIFT COMMANDS *****************

; entsprechende Befehle:

;;  Z80   8088
;;  RLC   ROL
;;  RRC   RCR
;;  RL    RCL
;;  RR    ROR
;;  SLA   SAL
;;  SRA   SAR
;;  SLI   SHL+OR
;;  SRL   SHR


; Geschachtelte Schleifen ueber die Register B,C,D,E,H,L,(HL),A

IRP CMD, <RLC,RRC,RL,RR,SLA,SRA,SLI,SRL>

   IRP REG8, <CH,CL,DH,DL,BH,BL,BYTE PTR [es:BX],AL>
	 .RADIX 16
	 makelabel %CN
	 .RADIX 10

; Seperate Behandlung der einzelnen Rotate/Shift Befehle

IF _BANKING
    HL_WR INSTR <REG8>,<BX>
    IF HL_WR
       AWO BX
    ENDIF
ENDIF

	  IFIDNI <CMD>,<RLC>
	     ROL REG8,1
	  ELSEIFIDNI <CMD>,<RRC>
	     ROR REG8,1
	  ELSEIFIDNI <CMD>,<RL>
	     SAHF
	     RCL REG8,1
	  ELSEIFIDNI <CMD>,<RR>
             SAHF
             RCR REG8,1
          ELSEIFIDNI <CMD>,<SLA>
	     SAL REG8,1
	  ELSEIFIDNI <CMD>,<SRA>
             SAR REG8,1
          ELSEIFIDNI <CMD>,<SLI>
          ;; Z80 ILLEGAL nach links Schieben und Bit 0 auf 1 setzen
             SHL REG8,1
	     LAHF
             MOV DI,AX
             AND DI,C_FLAG SHL 8
             OR  REG8,1
	     LAHF
             AND AH,NOT C_FLAG
             OR  AX,DI
             SAHF
          ELSEIFIDNI <CMD>,<SRL>
	     SHR REG8,1
	  ENDIF
          LAHF

	  SHIFTOP INSTR <CMD>,<S>
	  IF SHIFTOP EQ 0
	     MOV DI,AX
             AND DI,C_FLAG SHL 8
             MOV AH,REG8
             OR  AH,AH
             LAHF
             AND AH,NOT C_FLAG
             OR  AX,DI
          ENDIF
          AND AH,NOT (N_FLAG OR H_FLAG)

IF _BANKING
    HL_WR INSTR <REG8>,<BX>
    IF HL_WR
       SWO BX
    ENDIF
ENDIF

          JMP MLOOP

      CN = CN + 1                      ;; INC CODE #

    ENDM  ;; IRP REG8

ENDM  ;; IRP CMD



; ************* BIT,RES,SET  ************

Z_TO_P MACRO  ;; nur wegen des localen labels
LOCAL not_z
IF _UNDOC_FLG_TOO
      JNZ short not_z
      OR  DI,V_FLAG SHL 8  ;; COPY Z_FLAG TO V_FLAG
not_z:
ENDIF
ENDM

IRP CMD,<BIT,RES,SET>

   BITNR = 1

   REPT 8                              ;; Schleife ueber 8 Bits


;; Schleife ueber die Register B,C,D,E,H,L,(HL),A

      IRP REG8, <CH,CL,DH,DL,BH,BL,BYTE PTR [BX],AL>


	 .RADIX 16
         makelabel %CN                   ;; LABEL CBOP40-CBOP7F
         .RADIX 10

IF _BANKING
    HL_RD INSTR <REG8>,<BX>
    IF HL_RD
         IFIDNI <CMD>,<BIT>
           ARO BX
         ELSE
	   AWO BX
           PUSH DS
           PUSH ES
	   POP  DS
         ENDIF
    ENDIF
ENDIF

         IFIDNI <CMD>,<BIT>
	    MOV  DI,AX
            AND  DI,C_FLAG SHL 8         ;; Carry unchanged
            TEST REG8,BITNR
            LAHF
if _UNDOC_FLG_TOO
	    Z_TO_P
endif
	    AND  AH,Z_FLAG               ;; get new Zero-flag
            OR   AH,H_FLAG               ;; H:=1
            OR   AX,DI

	 ELSEIFIDNI <CMD>,<RES>
            AND REG8,NOT BITNR
         ELSE
            OR  REG8,BITNR
         ENDIF

IF _BANKING
    HL_RD INSTR <REG8>,<BX>
    IF HL_RD
	 IFIDNI <CMD>,<BIT>
           SRO BX
         ELSE
           SWO BX
           POP  DS
	 ENDIF
    ENDIF
ENDIF


	 JMP MLOOP

         CN = CN + 1                   ;; INC CODE NUMBER

      ENDM   ;; IRP REG8

      BITNR = BITNR SHL 1     ;; gehe zum naechsten Bit

   ENDM       ;; REPT 8

ENDM ;; IRP CMD


; ********* Baue Sprungtabelle fuer CB - OPS *****

CBOPTAB LABEL WORD

CN = 0
REPT 256

     .RADIX 16
     makepoint %CN
     .RADIX 10

     CN = CN + 1
ENDM



; ****************************************
;
; TEILMODUL DES Z80EMULATORS FUER DD-CODES
;
;
; (C) 1990 by Juergen Weber
;

GETDIST MACRO                          ; Hole offset zu IX nach DI
      MOV DI,AX
      LODSB
      CBW                              ;; Expandiere Offset auf 16 Bits
      XCHG AX,DI
ENDM

LDIXR8 MACRO REG8                      ;; LD (IX+d),R8
      GETDIST
      IFDIF <REG8>,<H>
        IFDIF <REG8>,<L>
	   IF _BANKING
             AWO DI
	     MOV ES:[HL+DI],REG8              ;; LD (IX+d),R8
           ELSE
             MOV [HL+DI],REG8              ;; LD (IX+d),R8
           ENDIF
        ENDIF
      ENDIF
      IFIDN <REG8>,<H>
        PUSH AX
          MOV AL,CS:HL_R.HBYTE+1
	  IF _BANKING
             AWO DI
             MOV ES:[HL+DI],AL
          ELSE
             MOV [HL+DI],AL
          ENDIF
        POP  AX
      ELSEIFIDN <REG8>,<L>
        PUSH AX
	  MOV AL,CS:HL_R.HBYTE
	  IF _BANKING
	     AWO DI
	     MOV ES:[HL+DI],AL
	  ELSE
             MOV [HL+DI],AL
          ENDIF
	POP  AX
      ENDIF
ENDM

LDR8IX MACRO REG8                      ;; LD R8,(IX+d)
      GETDIST
      IFDIF <REG8>,<H>
        IFDIF <REG8>,<L>
           ARO DI
           MOV REG8,[HL+DI]
        ENDIF
      ENDIF
      IFIDN <REG8>,<H>
        PUSH AX
          ARO DI
	  MOV AL,[HL+DI]
          MOV CS:HL_R.HBYTE+1,AL
        POP  AX
      ELSEIFIDN <REG8>,<L>
	PUSH AX
	  ARO DI
          MOV AL,[HL+DI]
          MOV CS:HL_R.HBYTE,AL
        POP  AX
      ENDIF
ENDM


REGPOI DW (?) ;; zeigt auf richtiges Register (IX oder IY)


HL_REG UNION                 ; damit Word und Byteweise ansprechbar
       HWORD DW (?)
       HBYTE DB 2 DUP (?)
HL_REG ENDS

HL_R   HL_REG <?,?>

endif ; _z80

if _Z80
DO_MEDLOOP MACRO
      MOV  DI,CS:REGPOI
      MOV  CS:[DI],BX
      MOV  BX,CS:HL_R.HWORD
      DO_MLOOP
ENDM
MEDLOOP:
      DO_MEDLOOP

DDOP_ILLEGAL:
; unbekannte illegals werden wie NOPs behandelt (only the prefix)
;repeat last code (ignore dd,fd-prefix)
  dec si		;repeat last code again
IF _R_REG_TOO
  dec cs:RR		;resore R-reg
ENDIF

if _Z80
  DO_MEDLOOP	;restore hl !
else
JMP MLOOP
endif

DDOP0:
DDOP1:
DDOP2:
DDOP3:
DDOP4:
DDOP5:
DDOP6:
DDOP7:
DDOP8:
       JMP DDOP_ILLEGAL
ALIGN 4
DDOP9:                                ; ADD IX,BC
       ADD_HL BC
       DO_MEDLOOP
DDOP0A:
DDOP0B:
DDOP0C:
DDOP0D:
DDOP0E:
DDOP0F:
DDOP10:
DDOP11:
DDOP12:
DDOP13:
DDOP14:
DDOP15:
DDOP16:
DDOP17:
DDOP18:JMP DDOP_ILLEGAL
ALIGN 4
DDOP19:                                ; ADD IX,DE
       ADD_HL DE
       DO_MEDLOOP
DDOP1A:
DDOP1B:
DDOP1C:
DDOP1D:
DDOP1E:
DDOP1F:
DDOP20:JMP DDOP_ILLEGAL
ALIGN 4
DDOP21:                                ; LD IX,nn
       LXI_R16 HL
       DO_MEDLOOP
ALIGN 4
DDOP22:                                ; LD (nn),IX
       SXD_R16 HL
       DO_MEDLOOP
ALIGN 4
DDOP23:                                ; INC IX
       INC_R16 HL
       DO_MEDLOOP
DDOP24:INC_R8 H                          ; INC HX
       DO_MEDLOOP
DDOP25:DEC_R8 H                          ; DEC HX
       DO_MEDLOOP
DDOP26:MVI8 H                          ; LD HX,n
       DO_MEDLOOP
DDOP27:
DDOP28:JMP DDOP_ILLEGAL
ALIGN 4
DDOP29:                                ; ADD IX,IX
       ADD_HL HL
       DO_MEDLOOP
ALIGN 4
DDOP2A:                                ; LD IX,(nn)
       LXD_R16 HL
       DO_MEDLOOP
ALIGN 4
DDOP2B:                                ; DEC IX
       DEC_R16 HL
       DO_MEDLOOP
DDOP2C:INC_R8 L                          ; INC LX
       DO_MEDLOOP
DDOP2D:DEC_R8 L                          ; DEC LX
       DO_MEDLOOP
DDOP2E:MVI8 L                          ; LD LX,n
       DO_MEDLOOP
DDOP2F:
DDOP30:
DDOP31:
DDOP32:
DDOP33:JMP DDOP_ILLEGAL
ALIGN 4
DDOP34:
       GETDIST                         ; INC (IX+d)
       INC_R8 [HL+DI]
       DO_MEDLOOP
ALIGN 4
DDOP35:GETDIST                         ; DEC (IX+d)
       DEC_R8 [HL+DI]
       DO_MEDLOOP
ALIGN 4
DDOP36:GETDIST                         ; LD (IX+d),n
       PUSH AX
       LODSB
       IF _BANKING
	  AWO DI
	  MOV  ES:[HL+DI],AL
       ELSE
          MOV  [HL+DI],AL
       ENDIF
       POP AX
       DO_MEDLOOP
DDOP37:
DDOP38:JMP DDOP_ILLEGAL
ALIGN 4
DDOP39:                                ; ADD IX,SP
       ADD_HL SP_Z
       DO_MEDLOOP
DDOP3A:
DDOP3B:
DDOP3C:
DDOP3D:
DDOP3E:
DDOP3F:
DDOP40:
DDOP41:
DDOP42:
DDOP43:JMP DDOP_ILLEGAL
DDOP44:MOV B,H                       ; LD B,HX
       DO_MEDLOOP
DDOP45:MOV B,L                       ; LD B,LX
       DO_MEDLOOP
ALIGN 4
DDOP46:LDR8IX B                       ; LD B,(IX+d)
       DO_MEDLOOP
DDOP47:
DDOP48:
DDOP49:
DDOP4A:
DDOP4B:JMP DDOP_ILLEGAL
DDOP4C:MOV C,H                       ; LD C,HX
       DO_MEDLOOP
DDOP4D:MOV C,L                       ; LD C,LX
       DO_MEDLOOP
ALIGN 4
DDOP4E:LDR8IX C                       ; LD C,(IX+d)
       DO_MEDLOOP
DDOP4F:
DDOP50:
DDOP51:
DDOP52:
DDOP53:
DDOP54:JMP DDOP_ILLEGAL
DDOP55:MOV D,L                       ; LD D,LX
       DO_MEDLOOP
ALIGN 4
DDOP56:LDR8IX D                       ; LD D,(IX+d)
       DO_MEDLOOP
DDOP57:
DDOP58:
DDOP59:
DDOP5A:
DDOP5B:JMP DDOP_ILLEGAL
DDOP5C:MOV E,H                       ; LD E,HX
       DO_MEDLOOP
DDOP5D:MOV E,L                       ; LD E,LX
       DO_MEDLOOP
ALIGN 4
DDOP5E:LDR8IX E                       ; LD E,(IX+d)
       DO_MEDLOOP
DDOP5F:JMP DDOP_ILLEGAL
DDOP60:MOV H,B                       ; LD HX,B
       DO_MEDLOOP
DDOP61:MOV H,C                       ; LD HX,C
       DO_MEDLOOP
DDOP62:MOV H,D                       ; LD HX,D
       DO_MEDLOOP
DDOP63:MOV H,E                       ; LD HX,E
       DO_MEDLOOP
DDOP64:
DDOP65:JMP DDOP_ILLEGAL
ALIGN 4
DDOP66:LDR8IX H                      ; LD H,(IX+d)
       DO_MEDLOOP
DDOP67:MOV H,A                       ; LD HX,A
       DO_MEDLOOP
DDOP68:MOV L,B                       ; LD LX,B
       DO_MEDLOOP
DDOP69:MOV L,C                       ; LD LX,C
       DO_MEDLOOP
DDOP6A:MOV L,D                       ; LD LX,D
       DO_MEDLOOP
DDOP6B:MOV L,E                       ; LD LX,E
       DO_MEDLOOP
DDOP6C:
DDOP6D:JMP DDOP_ILLEGAL
ALIGN 4
DDOP6E:LDR8IX L                       ; LD L,(IX+d)
       DO_MEDLOOP
DDOP6F:MOV L,A                       ; LD LX,A
       DO_MEDLOOP
ALIGN 4
DDOP70:
       LDIXR8 B                       ; LD (IX+d),B
       DO_MEDLOOP
ALIGN 4
DDOP71:LDIXR8 C                       ; LD (IX+d),C
       DO_MEDLOOP
ALIGN 4
DDOP72:LDIXR8 D                       ; LD (IX+d),D
       DO_MEDLOOP
ALIGN 4
DDOP73:LDIXR8 E                       ; LD (IX+d),E
       DO_MEDLOOP
ALIGN 4
DDOP74:LDIXR8 H                       ; LD (IX+d),H
       DO_MEDLOOP
ALIGN 4
DDOP75:LDIXR8 L                       ; LD (IX+d),L
       DO_MEDLOOP
DDOP76:JMP DDOP_ILLEGAL
ALIGN 4
DDOP77:LDIXR8 AL                       ; LD (IX+d),A
       DO_MEDLOOP
DDOP78:
DDOP79:
DDOP7A:
DDOP7B:JMP DDOP_ILLEGAL
DDOP7C:MOV AL,H                       ; LD A,HX
       DO_MEDLOOP
DDOP7D:MOV AL,L                       ; LD A,LX
       DO_MEDLOOP
ALIGN 4
DDOP7E:LDR8IX AL                       ; LD A,(IX+d)
       DO_MEDLOOP
DDOP7F:
DDOP80:
DDOP81:
DDOP82:
DDOP83:JMP DDOP_ILLEGAL
DDOP84:ALU_R8 ADD,H                       ; ADD A,HX
       DO_MEDLOOP
DDOP85:ALU_R8 ADD,L                       ; ADD A,LX
       DO_MEDLOOP
ALIGN 4
DDOP86:GETDIST                         ; ADD A,(IX+d)
       ARO DI
       ALU_R8 ADD,[HL+DI]
       DO_MEDLOOP
DDOP87:
DDOP88:
DDOP89:
DDOP8A:
DDOP8B:JMP DDOP_ILLEGAL
DDOP8C:ALU_R8 ADC,H                       ; ADC A,HX
       DO_MEDLOOP
DDOP8D:ALU_R8 ADC,L                       ; ADC A,LX
       DO_MEDLOOP
ALIGN 4
DDOP8E:GETDIST                         ; ADC A,(IX+d)
       ARO DI
       ALU_R8 ADC,[HL+DI]
       DO_MEDLOOP
DDOP8F:
DDOP90:
DDOP91:
DDOP92:
DDOP93:JMP DDOP_ILLEGAL
DDOP94:ALU_R8 SUB,H                       ; SUB HX
       DO_MEDLOOP
DDOP95:ALU_R8 SUB,L                       ; SUB LX
       DO_MEDLOOP
ALIGN 4
DDOP96:GETDIST                         ; SUB (IX+d)
       ARO DI
       ALU_R8 SUB,[HL+DI]
       DO_MEDLOOP
DDOP97:
DDOP98:
DDOP99:
DDOP9A:
DDOP9B:JMP DDOP_ILLEGAL
DDOP9C:ALU_R8 SBB,H                       ; SBC A,HX
       DO_MEDLOOP
DDOP9D:ALU_R8 SBB,L                       ; SBC A,LX
       DO_MEDLOOP
ALIGN 4
DDOP9E:GETDIST                         ; SBC (IX+d)
       ARO DI
       ALU_R8 SBB,[HL+DI]
       DO_MEDLOOP
DDOP9F:
DDOP0A0:
DDOP0A1:
DDOP0A2:
DDOP0A3:JMP DDOP_ILLEGAL
DDOP0A4:ALU_R8 AND,H                       ; AND HX
       DO_MEDLOOP
DDOP0A5:ALU_R8 AND,L                       ; AND LX
       DO_MEDLOOP
ALIGN 4
DDOP0A6:GETDIST                         ; AND (IX+d)
       ARO DI
       ALU_R8 AND,[HL+DI]
       DO_MEDLOOP
DDOP0A7:
DDOP0A8:
DDOP0A9:
DDOP0AA:
DDOP0AB:JMP DDOP_ILLEGAL
DDOP0AC:ALU_R8 XOR,H                       ; XOR HX
       DO_MEDLOOP
DDOP0AD:ALU_R8 XOR,L                       ; XOR LX
       DO_MEDLOOP
ALIGN 4
DDOP0AE:GETDIST                         ; XOR (IX+d)
       ARO DI
       ALU_R8 XOR,[HL+DI]
       DO_MEDLOOP
DDOP0AF:
DDOP0B0:
DDOP0B1:
DDOP0B2:
DDOP0B3:JMP DDOP_ILLEGAL
DDOP0B4:ALU_R8 OR,H                       ; OR HX
       DO_MEDLOOP
DDOP0B5:ALU_R8 OR,L                       ; OR LX
       DO_MEDLOOP
ALIGN 4
DDOP0B6:GETDIST                         ; OR (IX+d)
       ARO DI
       ALU_R8 OR,[HL+DI]
       DO_MEDLOOP
DDOP0B7:
DDOP0B8:
DDOP0B9:
DDOP0BA:
DDOP0BB:JMP DDOP_ILLEGAL
DDOP0BC:ALU_R8 CMP,H                       ; CP HX
       DO_MEDLOOP
DDOP0BD:ALU_R8 CMP,L                       ; CP LX
       DO_MEDLOOP
ALIGN 4
DDOP0BE:GETDIST                         ; CP (IX+d)
       ARO DI
       ALU_R8 CMP,[HL+DI]
       DO_MEDLOOP
DDOP0BF:
DDOP0C0:
DDOP0C1:
DDOP0C2:
DDOP0C3:
DDOP0C4:
DDOP0C5:
DDOP0C6:
DDOP0C7:
DDOP0C8:
DDOP0C9:
DDOP0CA:JMP DDOP_ILLEGAL


EXECOP0CB:
IF _R_REG_TOO
	inc cs:RR
ENDIF
      GET_CODE ; Folgebyte nach CB
      JMP WORD PTR CS:CBOPTAB[DI]


DDOP0CB:
 ;
 ; hier wird es ein wenig TRICKY:
 ; bei MLOOP wird der Code in ein RET geaendert
 ; und die CB Operation durch CALL aufgerufen, nachdem HL:=IX+dist
 ;
       PUSH WORD PTR CS:MLOOP
       PUSH BX
       MOV BYTE PTR CS:MLOOP,0C3H ; RET NEAR

       GETDIST                         ; GET OFFSET
       ADD BX,DI
       CALL EXECOP0CB   ; don't call OP0CB !! (may be interrupt-byte !)
       POP BX
       POP WORD PTR CS:MLOOP
       DO_MEDLOOP
DDOP0CC:
DDOP0CD:
DDOP0CE:
DDOP0CF:
DDOP0D0:
DDOP0D1:
DDOP0D2:
DDOP0D3:
DDOP0D4:
DDOP0D5:
DDOP0D6:
DDOP0D7:
DDOP0D8:
DDOP0D9:
DDOP0DA:
DDOP0DB:
DDOP0DC:
DDOP0DD:
DDOP0DE:
DDOP0DF:
DDOP0E0:JMP DDOP_ILLEGAL
ALIGN 4
DDOP0E1:ZPOP HL                          ; POP IX
       DO_MEDLOOP
DDOP0E2:JMP DDOP_ILLEGAL
ALIGN 4
DDOP0E3:XTHL                           ; EX (SP),IX
       DO_MEDLOOP
DDOP0E4:JMP DDOP_ILLEGAL
ALIGN 4
DDOP0E5:ZPUSH HL                         ; PUSH IX
       DO_MEDLOOP
DDOP0E6:
DDOP0E7:
DDOP0E8:JMP DDOP_ILLEGAL
ALIGN 4
DDOP0E9:                                ; JP (IX)
       JP_HL
       DO_MEDLOOP
DDOP0EA:
DDOP0EB:
DDOP0EC:
DDOP0ED:
DDOP0EE:
DDOP0EF:
DDOP0F0:
DDOP0F1:
DDOP0F2:
DDOP0F3:
DDOP0F4:
DDOP0F5:
DDOP0F6:
DDOP0F7:
DDOP0F8:JMP DDOP_ILLEGAL
DDOP0F9:MOV SP_Z,HL                       ; LD SP,IX
       DO_MEDLOOP
DDOP0FA:
DDOP0FB:
DDOP0FC:
DDOP0FD:
DDOP0FE:
DDOP0FF:JMP DDOP_ILLEGAL

endif ; _Z80




; ********* BUILD JUMBTABLE FOR OPS *****

if _Z80
EDOPTAB LABEL WORD

edmakepoint macro x
   dw offset EDOP&x
endm

             CN = 0H
	     REPT 100H

              .RADIX 16
	      edmakepoint %CN
              .RADIX 10

	      CN = CN + 1
             ENDM

DDOPTAB LABEL WORD

ddmakepoint macro x
   dw offset DDOP&x
endm

	     CN = 0H
	     REPT 100H

              .RADIX 16
	      ddmakepoint %CN
	      .RADIX 10

              CN = CN + 1
             ENDM

endif ; _Z80

int_rout_poi dw offset im0_rout   ; nach reset im 0
old_int_rout_poi dw 0
int_byte db 0,0

; im 0: das bei irq gelieferte byte ausfuehren

im0_rout proc
      mov di,word ptr cs:int_byte ; cast
      and di,0ffh
      shl di,LEFT_SHIFT
      jmp di
im0_rout endp

if _Z80        ; 8080 hat default im0

im1_rout proc
RST 38H
DO_MLOOP
im1_rout endp

im2_rout proc
        mov di,word ptr cs:int_byte
	and di,7fh           ; behalte nur bit 0..6
        add di,di           ; bit0:=0
	or di,word ptr cs:[RI-1]     ; damit I nach high kommt
	SRO SI                          ; sub offset from PC
	ARO DI                          ; int adr
	ZPUSH SI
        MOV SI,[DI]
	ARO SI				;add offset to PC
	DO_MLOOP
im2_rout endp

endif ; _Z80


nmi_rout proc   ; ich vermute nmi beim 8080 genauso ?
    push ax
    mov ax,cs:old_int_rout_poi
    mov cs:int_rout_poi,ax
    xor al,al
    xchg al,byte ptr cs:IFF0  ; IFF0:=0
    mov byte ptr cs:IFF1,al   ; IFF1:=IFF0
    pop ax
    SRO SI				;sub offset from PC
    ZPUSH SI
    mov si,0066h  ; CALL 66H
    ARO SI				;+offset
    DO_MLOOP
nmi_rout endp

IF _CPCEMU
z80ini proc far	;no z80ini
z80ini endp

ELSE

z80ini PROC FAR


; alle Register ausser PC loeschen


MOV   AX,0       ; AF
MOV   HL,0       ; HL
MOV   DE,0       ; DE
MOV   BC,0       ; BC


DISABLE_INTS

if _Z80
MOV   CS:RAF,AX  ; AF'
MOV   CS:RHL,AX  ; HL'
MOV   CS:RDE,AX  ; DE'
MOV   CS:RBC,AX  ; BC'
MOV   CS:RIX,AX  ; IX
MOV   CS:RIY,AX  ; IY
MOV   CS:RI,AL   ; I
MOV   CS:RR,AL   ; R
endif
MOV   SP_Z,0       ; SP = BP
RET

z80ini ENDP

ENDIF	;not _cpcemu

brk_req_flg db FALSE
ir_req_flg db FALSE
nmi_req_flg db FALSE

emu_active_flg db FALSE


nmi_irq proc far
    mov cs:nmi_req_flg,TRUE
    push ax
    mov ax,cs:int_rout_poi
    mov cs:old_int_rout_poi,ax
    pop ax
    mov cs:int_rout_poi,offset nmi_rout
    jmp short interrupt_request
nmi_irq endp

ctrl_break_req proc far
	mov cs:brk_req_flg,TRUE
	; and run into interrupt_request
ctrl_break_req endp

interrupt_request proc far
	cmp cs:emu_active_flg,TRUE
        jnz  short @@ir_exit

IF _CPCEMU
force_interrupt_request:	;from outside emulation
ENDIF

	cmp cs:ir_req_flg,TRUE
        je  short @@ir_exit     ; already pending

	mov cs:ir_req_flg,TRUE  ; ! Wettlaufbedingungen

IF _CPCEMU
;nmi ,interr. moved to int ack.
ELSE	;not _cpcemu
; nmi ?

	TSTNCLR nmi_req_flg
	jnz  short @@no_test

; control break request ?

	cmp cs:brk_req_flg,TRUE
	je  short @@no_test

; interrupts enabled ?

	cmp byte ptr cs:IFF0,0

	mov cs:ir_req_flg,FALSE
        je  short @@ir_exit     ; ints are disabled

@@no_test:
ENDIF	;not _cpcemu
	mov cs:ir_req_flg,TRUE

	mov cs:int_byte,al

	PUSHR <ES,DS,AX,CX,DI,SI>

	MOV  AX,CS
	MOV  ES,AX
	MOV  DS,AX

; insert Ret-near at every non-ext. z80-code's code
; ints are acknowledged at the start of OP0..OP0FF
; so while executing MLOOP's code offset int_ack
; MUST BE AT THE TOP OF STACK

	MOV  AL,0C3H         ; RET
	MOV  SI,OFFSET OP0
	MOV  CX,256
	MOV  DI,OFFSET op_store
        CLD
@@intloop:
        MOVSB                 ; es:di := ds:si
	MOV DS:[SI-1],AL
	ADD SI,BYTES_PER_CODE-1 ; 1 does movsb
        LOOP @@intloop
	POPR <SI,DI,CX,AX,DS,ES>
@@ir_exit:
	ret
interrupt_request endp


int_ack proc

	push offset int_ack  ; it was just used up
	dec si     ; do last op again

IF _R_REG_TOO
	dec cs:RR	;Korrektur, da gleich DO_MLOOP
ENDIF

; code restaurieren
	PUSHR <ES,DS,AX,CX,SI,DI>
	MOV  AX,CS
	MOV  ES,AX
	MOV  DS,AX

	MOV  CX,256
	MOV  SI,OFFSET op_store
	MOV  DI,OFFSET OP0
	CLD
@@restloop:
	MOVSB
	ADD DI,BYTES_PER_CODE-1
        LOOP @@restloop
	POPR <DI,SI,CX,AX,DS,ES>


	TSTNCLR brk_req_flg
	MOV ir_req_flg,FALSE ; jetzt duerfen sie wieder
	jnz short @@exit
; interrupt Behandlung

IF _CPCEMU
	TSTNCLR nmi_req_flg	;nmi ?
	jnz  short @@no_test

	call ext_int_ack

; interrupts enabled ?

	cmp byte ptr cs:IFF0,0

	jne short @@no_test	;ints are enabled - ok
	jmp MLOOP		;oh, disabled.
@@no_test:
ENDIF	;_cpcemu

       DISABLE_INTS                  ; ints verbieten


       jmp word ptr CS:int_rout_poi  ; je nach gesetzter Intmode

@@exit:
	mov di,0
if _CPC_CO
  inc word ptr cs:inscount	;last code was cbreak
  exit_emu:
endif

IF _CPCEMU
  SRO SI				;sub offset from PC
  mov cs:emu_active_flg,FALSE
if _CPC_CO
  mov di,word ptr cs:inscount	;get remaining
endif
  add sp,2
  call save_z80regs	;copy regs in dseg
  jmp emexit
ELSE
	jmp halt_cont
ENDIF	;if _cpcemu
int_ack endp


IF _BANKING

; IN: BX: Lese Segment
;     AX: Lese Offset
set_read_dist proc far
	mov CS:READ_OFFS,ax
	mov CS:READ_SEG,bx
	ret
set_read_dist endp

; IN: BX: Schreib Segment
;     AX: Schreib Offset
set_write_dist proc far
    mov CS:WRITE_OFFS,ax
    mov CS:WRITE_SEG,bx
    ret
set_write_dist endp

   WRITE_OFFS dw 0
   WRITE_SEG dw 0
   READ_OFFS  dw 0
   READ_SEG  dw 0

ENDIF

; Banking wird normalerweise durch Outbefehle erledigt
; daher hat das Modul PORTIO die Moeglichkeit, eine neue
; Speicherkonfiguragtion zu setzen

local_port_out proc
;IF _BANKING
;PUSH AX
;MOV AX,ES
;MOV CS:WRITE_SEG,AX
;MOV AX,DS
;MOV CS:READ_SEG,AX
;POP AX
;ENDIF
	SRO SI
	call port_out
IF _BANKING
	ARO SI
	PUSH AX
	MOV AX,CS:WRITE_SEG
	MOV ES,AX
	MOV AX,CS:READ_SEG
	MOV DS,AX
	POP AX
ENDIF
	RET
local_port_out endp

bios88ret:
if _CPC_CO
	mov word ptr cs:inscount,di		;set number of instructions
endif
IF _CPCEMU
	call load_z80regs
	PUSH AX
	MOV AX,CS:WRITE_SEG
	MOV ES,AX
	MOV AX,CS:READ_SEG
	MOV DS,AX
	POP AX
ENDIF	;if _cpcemu
   ARO SI
   push offset int_ack
   mov cs:emu_active_flg,TRUE
   jmp MLOOP


; on entry: ax=number of nops to execute at every mloop
set_wait proc
	cmp ax,MAXNOPS
        ja short @@sw_exit
	mov bx,offset waiting
	mov cx,ax
	mov al,byte ptr cs:[@@nop]
@@lp:
	mov cs:[bx],al
	inc bx
	loop @@lp
	mov al,byte ptr cs:[@@ret]
	mov cs:[bx],al
@@sw_exit:
@@ret:  ret
@@nop:  nop
set_wait endp

waiting proc
	ret
	db   MAXNOPS dup (?)
waiting endp


IF _CPCEMU

dseg_save dw ?

assume ds:_DATA
;load register from data-segment
load_z80regs proc near
	mov cs:dseg_save,ds	;save dseg

	;load alternate registers
	mov ax,_z.zAF2
	xchg ah,al
	mov cs:RAF,ax	;AF'
	mov ax,_z.zBC2
	mov cs:RBC,ax
	mov ax,_z.zDE2
	mov cs:RDE,ax	;DE'
	mov ax,_z.zHL2
	mov cs:RHL,ax

	mov ax,_z.zIX
	mov cs:RIX,ax
	mov ax,_z.zIY
	mov cs:RIY,ax

	;load states
	mov ax,_z.zIF	;al=iff1, ah=iff2
	mov byte ptr cs:IFF0,al
	mov byte ptr cs:IFF1,ah
	mov ax,_z.zIR	;al=R,ah=I

	mov cs:RI,ah
IF _R_REG_TOO
      MOV  CS:RR,AL
      AND  AL,80H
      MOV  CS:OLD_R,AL            ; KEEP BIT 7 FOR LATER LOAD
ELSE
	mov cs:RR,al
ENDIF

	mov ax,_z.zIMD
	cmp al,byte ptr cs:RIM	;compare with old im-mode
	je short @@_cont1	;fine,equal
	mov byte ptr cs:RIM,al	;save new
	and al,03h		;only im-mode
	;set new im-mode
	cmp al,1
	jz short @@_setim1
	jb short @@_setim0
	SET_IM 2
	jmp short @@_cont1
@@_setim1:
	SET_IM 1
	jmp short @@_cont1
@@_setim0:
	SET_IM 0
@@_cont1:

	;load normal register
	mov ax,_z.zAF
	xchg ah,al	;flags in ah
	mov bx,_z.zHL
	mov cx,_z.zBC
	mov dx,_z.zDE
	mov si,_z.zPC
	mov bp,_z.zSP
	ret
load_z80regs endp


;save regs in dseg
save_z80regs proc near
	push di	;save
	mov ds,word ptr cs:dseg_save
	assume ds:_DATA
	;save normal register
	xchg ah,al	;flags in al, A in ah
	mov _z.zAF,ax
	mov _z.zHL,bx
	mov _z.zBC,cx
	mov _z.zDE,dx
	mov _z.zPC,si
	mov _z.zSP,bp

	;save alternate register
	mov ax,cs:RAF
	xchg ah,al
	mov _z.zAF2,ax
	mov ax,cs:RHL
	mov _z.zHL2,ax
	mov ax,cs:RBC
	mov _z.zBC2,ax
	mov ax,cs:RDE
	mov _z.zDE2,ax
	mov ax,cs:RIX
	mov _z.zIX,ax
	mov ax,cs:RIY
	mov _z.zIY,ax

	;save states
	mov al,cs:RR
IF _R_REG_TOO
      AND  AL,7FH         ; KEEP ONLY LOWER 7 BIT
      OR   AL,CS:OLD_R   ; GET UNCHANGED BIT 7
ENDIF
	mov ah,cs:RI
	mov _z.zIR,ax		;al=R,ah=I

	mov ax,word ptr cs:RIM
	mov _z.zIMD,ax

	mov al,byte ptr cs:IFF0
	mov ah,byte ptr cs:IFF1
	mov _z.zIF,ax

	pop di
	ret
save_z80regs endp

endif	;cpcemu

if _CPC_CO

inscount dw 0

next_instr:
	dec word ptr cs:inscount
	jnz short @@_w1
	jmp exit_emu
@@_w1:
IF _R_REG_TOO
	inc cs:RR
ENDIF
IF _WAITCALL
   call waiting
ENDIF

	mov di,[si]                   ; 4
	inc si                        ; 2
	and di,0ffh                   ; 2
	shl di,LEFT_SHIFT             ; 3
	jmp di                        ; 7

ENDIF	;if _cpc_co


op_store db 256 dup (?)

Z80EmulatorSeg ENDS

END

