
/*
  example c program to use the Z80 simulator without cpmbios

  (c) 1992 Jrgen Weber
           Wiesentalstrae 1
           7170 Schwbisch Hall
           Germany

  tcc -ml z80exmpl.c z80iface.obj Z80EMU.OBJ

  Z80EMU.OBJ contains the machine code of the Z80 simulation
  z80iface.asm is an assembler interface between the emulation
  and a c program that uses Z80EMU

  usage of Z80EMU.OBJ within your code is allowed
  only for private purposes.
  If you want to sell a program that contains
  Z80EMU.OBJ contact me first.

*/

#include <alloc.h>
#include <dos.h>

_emulate(unsigned z80seg,
          void far (*calln_handler)(int far *),
           void far (*halt_handler)(void));

void far halt_handler(void)
{
    puts("halt_handler called");
}

void far calln_handler(int far *regs) /* *regs can be changed */
{
/* AH=undef, AL=xx in ED ED xx, BX=HL, CX=BC, DX=DE, SI=PC */
    printf("calln executed, AX=%x, BX=%x, CX=%x, DX=%x, SI=%x\n",
            regs[0],regs[1],regs[2],regs[3],regs[4]);
    regs[1]++;
}

void main()
{
 char far *p;
 unsigned z80seg;

 if((p=farmalloc(65536l+15l))==NULL) {
    puts("Not enough memory.");
    exit(1);
 }
 z80seg=FP_SEG(p);
 if (FP_OFF(p)) z80seg++; /* Add one paragraph, o.k. because +15l */
 p=MK_FP(z80seg,0);
 /* now it would be a good idea, to clear
    the 64K Z80 space */

/* if you use the banked version you could set the banking this way */
/*  setcfg(z80seg,0,z80seg,0); */

 /* Enter some z80 codes */
 *p++=0x76; /* HALT */
 *p++=0xed; /* CALLN 0 */
 *p++=0xed;
 *p++=0x00;
 *p++=0xed; /* CALLN 0xff to end emulation */
 *p++=0xed;
 *p++=0xff;
 emulate(z80seg,calln_handler,halt_handler);
 printf("returned from emulation\n");
}

