/*****************************************************
 *
 * WinIo.h
 *
 *	This file contains declarations for I/O management that are
 *	intended for public consumption.
 *
 * revisions:
 *
 *	2007-04-09 rli: original version.
 *
 *****************************************************/

#ifndef WinIo_h_Included
#define WinIo_h_Included

/*****************************
 *
 *	TYPES
 *
 *****************************/

/***
 *
 * WinIo_PortReader_t
 *
 *	This type describes a handler for an input port. It is expected
 *	to have the following prototype:
 *
 *		BYTE PortHandler( BYTE Address, void *Cookie );
 *
 *	- Address: Supplies the number of the port to read.
 *
 *	- Cookie: An opaque value passed to the handler. This can
 *	  be used for things like locating a controlling data structure
 *	  associated with this port.
 *
 *	The routine returns the value read from the port.
 *
 * revisions:
 *
 *	2007-04-09 rli: original version.
 *
 * fields:
 *
 *	- Handler: A pointer to the input port handler.
 *
 *	- Cookie: An opaque cookie passed to the handler.
 *
 ***/

typedef struct WinIo_PortReader_s {
  BYTE (*Handler)( BYTE Address, void *Cookie );
  void *Cookie;
} WinIo_PortReader_t;

/***
 *
 * WinIo_PortWriter_t
 *
 *	This type describes a handler for an output port. It is
 *	expected to have the following prototype:
 *
 *		BYTE PortHandler( BYTE Address, BYTE Value, void *Cookie )
 *
 *	- Address: Supplies the address of the port to be written.
 *
 *	- Value: Supplies the value to be written to the port.
 *
 *	- Cookie: An opaque cookie passed to the handler. This can be used
 *	  for things like locating a controlling data structure associated
 *	  with the port.
 *
 * revisions:
 *
 *	2007-04-09 rli: original version.
 *
 * fields:
 *
 *	- Handler: A pointer to the output port handler.
 *
 *	- Cookie: An opaque cookie passed to the handler.
 *
 ***/

typedef struct WinIo_PortWriter_s {
  BYTE (*Handler)( BYTE Address, BYTE Value, void *Cookie );
  void *Cookie;
} WinIo_PortWriter_t;

/*********************************
 *
 *	PROTOTYPES
 *
 *********************************/

BYTE WinIo_DefaultReader( BYTE Address, void *Cookie );
BYTE WinIo_DefaultWriter( BYTE Address, BYTE Value, void *Cookie );
int WinIo_RegisterReader( BYTE Address, 
  BYTE (*Reader)( BYTE Address, void *Cookie ),
  void *Cookie );
int WinIo_RegisterWriter( BYTE Address, 
  BYTE (*Writer)( BYTE Address, BYTE Value, void *Cookie ),
  void *Cookie );

#endif /* WinIo_h_Included */
 
