	org 0

;**************************
;
; winboot.asm
;
;	This code is loaded into the Z80 RAM at startup. Essentially, it's
;	a boot ROM.
;
; revisions:
;
;	2007-04-12 rli: Attempt to read drive A.
;
;**************************

;	Udo Munk's bootstrap assumes it is loaded at zero, so we'll have
;	to jump around the first page so there's space to load the bootstrap.

	jp start

	org 128

;***
;
; start
;
;	Load the first block of drive A at address 0 and jump to it.
;
; revisions:
;
;	2007-04-12 rli: original version.
;
;***

start:

	xor a

;	Clear the DMA address register.

	out (15),a
	out (16),a

;	Clear the drive and track registers.

	out (10),a
	out (11),a

;	Sector numbers start at 1.

	inc a
	out (12),a

;	Issue a read command.

	xor a
	out (13),a

;	Whichever way we go from here, we'll need a stack to display
;	a message.

	ld hl, 0ffffh
	ld sp,hl

;	Look at the status to see what happened. 0 = success.

	in a,(14)
	or a
	jp nz, error

;	The load worked. Display a success message and jump to the
;	bootstrap.

	ld hl,success
	call puts

	jp 0

;	Failure. Display an error message and halt.

error:

	ld hl, error1
	call puts

	in a,(14)
	add a,30h
	out (0),a

	ld hl, error2
	call puts

	halt

;***
;
; puts
;
;	Display a null-terminated string on the console.
;
;***

puts:	ld a,(hl)
	or a
	ret z
	out (1),a
	inc hl
	jp puts

;*********

success:
	defb 'Bootstrap loaded. Entering.', 13, 10, 0

error1:
	defb 'Error reading bootstrap. Status: ', 0

error2:
	defb '. Halting.', 13, 10, 0

	end
