/***************************************************
 *
 * rli_glue.c
 *
 *	This file contains utility routines needed by the simulation that
 *	aren't part of the I/O or interrupt system.
 *
 * revisions:
 *
 *	2007-04-08 rli: original version.
 *
 ***************************************************/

/************************
 *
 *	INCLUDES
 *
 ************************/

#include <stdio.h>
#include <stdlib.h>

/************************
 *
 *	CODE
 *
 ************************/

/***
 *
 * nanosleep
 *
 *	This routine is called by the HALT opcode if it needs to poll for
 *	interrupts instead of just ending the simulation. That shouldn't
 *	happen here.
 *
 * revisions:
 *
 *	2007-04-08 rli: Original version.
 *
 * formal parameters:
 *
 *	- Interval: Supplies a pointer to a struct timespec that indicates
 *	  how long to wait before returning. This is not used.
 *
 *	- NotUsed: Not used. In Unix, it provides a pointer to a struct
 *	  timespec that is filled in with the unslept time if the sleep
 *	  was interrupted.
 *
 * informal parameters:
 *
 *	none.
 *
 * return value:
 *
 *	none.
 *
 * other effects:
 *
 *	- The program is aborted.
 *
 ***/

void nanosleep( void *Interval, void *NotUsed )
{
  fprintf( stderr, "nanosleep: Attempted to poll for interrupts.\n" );
  exit( EXIT_FAILURE );
}

/***
 *
 * exatoi
 *
 *	atoi for hexadecimal numbers
 *
 * revisions:
 *
 *	2007-04-08 rli: Original version.
 *
 * formal parameters:
 *
 *	- Victim: Supplies a pointer to the string to be converted.
 *
 * informal parameters:
 *
 *	none.
 *
 * return value:
 *
 *	- The converted number.
 *
 * other effects:
 *
 *	none.
 *
 ***/

int exatoi( char *Victim )
{
  int Result;

  Result = 0;

  while( 1 ) { 

    switch ( *Victim ) {

      case '0': case '1': case '2': case '3': case '4':
      case '5': case '6': case '7': case '8': case '9':
        Result = ( Result << 4 ) + ( *Victim & 0xf );
        break;

      case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
      case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':

        Result = ( Result << 4 ) + ( *Victim & 0xf ) + 9;
        break;

      default:
        return Result;

    }

    Victim++;

  }

}

