/****************
 *
 * rli_mon.c
 *
 *	The simulation enters here after initializing itself and parsing
 *	command line parameters.
 *
 * revisions:
 *
 *	2007-04-08 rli: Initial do-nothing version.
 *
 ****************/

/***
 *
 *	Udo didn't provide a prototype for cpu().
 *
 ***/

void cpu( void );

/*****************
 *
 *	INCLUDES
 *
 *****************/

#include <stdio.h>
#include <string.h>
#include "sim.h"
#include "simglb.h"
#include "WinBoot.h" /* generated from ../winboot/winboot.asm */

/*****************
 *
 *	CODE
 *
 *****************/

/***
 *
 * mon
 *
 *	This routine is called by the simulation after it has initialized
 *	itself. It is expected to start the shebang running.
 *
 * revisions:
 *
 *	2007-04-08 rli: Initial do-nothing version.
 *
 *	2007-04-09 rli: Poke a HALT into location 0 and try to execute it.
 * 
 *	2007-04-11 rli: Copy WinBoot into RAM. This allows a bootrom to
 *	  be built using an external assembler.
 *
 * formal parameters:
 *
 *	none.
 *
 * informal parameters:
 *
 *	- ram: The memory. This is a 64KB array of bytes from which the
 *	  processor fetches stuff.
 *
 *	- cpu_state: Status of the simulation. Values of interest are:
 *
 *	  - STOPPED: Causes the simulation to stop executing instructions
 *	    and exit.
 *
 *	  - SINGLE_STEP: The simulation will execute a single instruction
 *	    and return.
 *
 *	  - CONTIN_RUN: The simulation will run continuously.
 *
 *	- cpu_error: Error status of the simulation. When the simulation
 *	  returns, it places a code here. Values of interest are:
 *
 *	  - OPHALT: The CPU has executed a HALT instruction.
 *
 *	  - IOTRAP: The CPU has referred to an undefined I/O port.
 *
 *	  - NONE: The CPU has not encountered an error; the simulation
 *	    returned because, say, it was done stepping.
 *
 *	- PC: The program counter. This is a pointer into ram, not an
 *	  index; to figure out the RAM location referred to by the PC,
 *	  the base address of ram must be subtracted from it.
 *
 *	- WinBoot: Contains a binary image that is copied to RAM before
 *	  the CPU is started.
 *
 * return value:
 *
 *	- None. Return means it's time for the simulation to exit.
 *
 * other effects:
 *
 *	none.
 *
 ***/

void mon( void )
{

#ifdef HISIZE /*** debug ***/
  memset( (char *)his, 0, sizeof( struct history ) * HISIZE );
  h_next = 0;
  h_flag = 0;
#endif

  bcopy( WinBoot, ram, sizeof( WinBoot ) );

  cpu_state = CONTIN_RUN;
  cpu_error = NONE;
  cpu();

  switch( cpu_error ) {

    case OPHALT: printf( "HALT executed. " ); break;
    case IOTRAP: printf( "I/O trap. " ); break;
    default:     printf( "cpu_error %d. ", cpu_error ); break;

  }
  printf( "PC = %x\n", (int)PC - (int)ram );

#ifdef HISIZE /*** debug ***/

  {
    FILE *History;
    int i, l, b, e, c;

    if( ( h_next == 0 ) && ( h_flag == 0 ) ) {
      puts( "History memory is empty\n" );
      return;
    }

    History = fopen( "history.dat","w" );
    if( History == NULL ) {
      puts( "Could not create history.dat" );
      return;
    }

    e = h_next;
    b = (h_flag) ? h_next + 1 : 0;
    for( i = b; i != e; i++ ) {
      if( i == HISIZE ) i = 0;
      fprintf( History,
      "%4.4x AF=%4.4x BC=%4.4x DE=%4.4x HL=%4.4x IX=%4.4x IY=%4.4x SP=%4.4x\n",
        his[ i ].h_adr, his[ i ].h_af, his[ i ].h_bc,
        his[ i ].h_de, his[ i ].h_hl, his[ i ].h_ix,
        his[ i ].h_iy, his[ i ].h_sp );
    }
    fclose( History );

  }

#endif

  return;
}

