/*****************************************
 *
 * DumbCons.c
 *
 *	This file provides a dumb console in the console window. It's
 *	temporary.
 *
 * revisions:
 *
 *	2007-04-11 rli: original version.
 *
 *****************************************/

/******************
 *
 *	INCLUDES
 *
 ******************/

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#include "sim.h"
#include "WinIo.h"
#include "DumbCons.h"

/******************
 *
 *	CODE
 *
 ******************/

/***
 *
 * DumbCons_Register
 *
 *	This routine registers the dumb console. It occupies two read
 *	ports (0 and 1) and one write port (1).
 *
 * revisions:
 *
 *	2007-04-11 rli: original version.
 *
 * formal parameters:
 *
 *	none.
 *
 * informal parameters:
 *
 *	- port numbers are hard-coded.
 *
 * return value:
 *
 *	none.
 *
 * other effects:
 *
 *	- An error message is displayed and program execution stops if
 *	  a port could not be registered.
 *
 ***/

void DumbCons_Register( void )
{
  int Failures;

  Failures = WinIo_RegisterReader( 0, DumbCons_ConSt, NULL );
  Failures += WinIo_RegisterReader( 1, DumbCons_ConIn, NULL );
  Failures += WinIo_RegisterWriter( 1, DumbCons_ConOt, NULL );

  if( Failures != 0 ) {
    fprintf( stderr, "DumbCons: Could not register at port 0.\n" );
    exit( EXIT_FAILURE );
  }

  return;
}

/***
 *
 * DumbCons_ConSt
 *
 *	This routine checks to see if a character is available at the
 *	console.
 *
 * revisions:
 *
 *	2007-04-11 rli: original version.
 *
 * formal parameters:
 *
 *	- Address: Supplies the address of the port being read. This is
 *	  not used.
 *
 *	- Cookie: Not used.
 *
 * informal parameters:
 *
 *	none.
 *
 * return value:
 *
 *	- 0: No characters are available from the console.
 *
 *	- 0xff: A character is available from the console.
 *
 * other effects:
 *
 *	none.
 *
 ***/

BYTE DumbCons_ConSt( BYTE Address, void *Cookie )
{
  if( kbhit() == 0 ) return 0;
  return 0xff;
}

/***
 *
 * DumbCons_ConIn
 *
 *	This routine waits for a character to arrive at the console
 *	and returns that character. The character is not echoed.
 *
 * revisions:
 *
 *	2007-04-11 rli: original version.
 *
 * formal parameters:
 *
 *	- Address: Supplies the address of the port being read. This is
 *	  not used.
 *
 *	- Cookie: Not used.
 *
 * informal parameters:
 *
 *	none.
 *
 * return value:
 *
 *	- A character read from the console.
 *
 * other effects:
 *
 *	none.
 *
 ***/

BYTE DumbCons_ConIn( BYTE Address, void *Cookie )
{
  return getch( );
}

/***
 *
 * DumbCons_ConOt
 *
 *	This routine displays a character on the console.
 *
 * revisions:
 *
 *	2007-04-11 rli: original version.
 *
 * formal parameters:
 *
 *	- Address: Supplies the address of the port being written. This
 *	  is not used.
 *
 *	- Value: Supplies the character to write.
 *
 *	- Cookie: Not used.
 *
 * informal parameters:
 *
 *	none.
 *
 * return value:
 *
 *	- Zero is always returned.
 *
 * other effects:
 *
 *	none.
 *
 ***/

BYTE DumbCons_ConOt( BYTE Address, BYTE Value, void *Cookie )
{
  putch( Value );
  return 0;
}

