/*******************************************
 *
 * MunkStubs.c
 *
 *	This file contains stubs for the hardware touched by Udo Munk's
 *	CP/M 2 BIOS that I'm not ready to emulate.
 *
 * revisions:
 *
 *	2007-04-12 rli: original version.
 *
 *******************************************/

/*************************
 *
 *	INCLUDES
 *
 ************************/

#include <stdio.h>
#include <stdlib.h>

#include "sim.h"
#include "WinIo.h"
#include "MunkStubs.h"

/************************
 *
 *	CODE
 *
 ***********************/

/***
 *
 * MunkStubs_Register
 *
 *	This routine registers the I/O ports for the hardware touched
 *	by Udo Munk's CP/M 2 BIOS that I'm not ready to emulate.
 *
 *	The hardware is the printer, punch, and reader, which occupy
 *	ports 2, 3, and 5.
 *
 * revisions:
 *
 *	2007-04-12 rli: original version.
 *
 * formal parameters:
 *
 *	none.
 *
 * informal parameters:
 *
 *	- The port addresses are hard coded.
 *
 * return value:
 *
 *	none.
 *
 * other effects:
 *
 *	none.
 *
 ***/

void MunkStubs_Register( void )
{
  int Failures;

  Failures = WinIo_RegisterReader( 2, MunkStubs_In, NULL );
  Failures += WinIo_RegisterReader( 3, MunkStubs_In, NULL );
  Failures += WinIo_RegisterReader( 5, MunkStubs_In, NULL );

  Failures += WinIo_RegisterWriter( 2, MunkStubs_Out, NULL );
  Failures += WinIo_RegisterWriter( 3, MunkStubs_Out, NULL );
  Failures += WinIo_RegisterWriter( 5, MunkStubs_Out, NULL );

  if( Failures != 0 ) {
    fprintf( stderr, "MunkStubs: Could not register.\n" );
    exit( EXIT_FAILURE );
  }

}

/***
 *
 * MunkStubs_In
 *
 *	This routine reads a port used by one of Udo Munk's devices that
 *	I'm not ready to simulate.
 *
 * revisions:
 *
 *	2007-04-12 rli: original version.
 *
 * formal parameters:
 *
 *	- Address: Supplies the address of the port that is being read.
 *	  This is not used.
 *
 *	- Cookie: Not used.
 *
 * informal parameters:
 *
 *	none.
 *
 * return value:
 *
 *	- Zero is always returned.
 *
 * other effects:
 *
 *	none.
 *
 ***/

BYTE MunkStubs_In( BYTE Address, void *Cookie )
{
  return 0;
}

/***
 *
 * MunkStubs_Out
 *
 *	This routine writes a port used by one of Udo Munk's devices that
 *	I'm not ready to simulate.
 *
 * revisions:
 *
 *	2007-04-12 rli: original version.
 *
 * formal parameters:
 *
 *	- Address: Supplies the address of the port being written.
 *
 *	- Value: Supplies the data to be written to that port.
 *
 *	- Cookie: Not used.
 *
 * informal parameters:
 *
 *	none.
 *
 * return value:
 *
 *	- Zero is always returned.
 *
 * other effects:
 *
 *	none.
 *
 ***/

BYTE MunkStubs_Out( BYTE Address, BYTE Value, void *Cookie )
{
  return 0;
}

