/*******************************
 *
 * rli_glue.h
 *
 * 	This file defines some stuff needed to get the core simulation
 *	compiling.
 *
 * revisions:
 *
 *	2007-04-08 rli: original version.
 *
 *******************************/

/***
 *
 * timespec
 *
 *	The HALT opcode periodically polls for interrupts. It uses
 *	nanosleep to wait between polling intervals so it doesn't
 *	suck the entire CPU. We don't have nanosleep, but need to
 *	define this structure to compile that opcode.
 *
 * revisions:
 *
 *	2007-04-08 rli: Initial version.
 *
 ***/

struct timespec {
  int tv_sec;
  int tv_nsec;
};

/***
 *
 * nanosleep
 *
 *	The HALT opcode periodically polls for interrupts. It uses
 *	nanosleep to wait between polling intervals. We don't have
 *	nanosleep, but need a prototype for it to compile that opcode.
 *
 *	I'm not planning on using interrupts at the moment, so I don't
 *	need to poll for them, but I'll have to do *something* when
 *	a HALT is executed.
 *
 *	Oh yeah; the polling is only done if break_flag is zero. By
 *	default, it's initialized to 1 (by SIMGLB.C). So we shouldn't
 *	get here. Nevertheless, it needs to be defined.
 *	
 * revisions:
 *
 *	2007-04-08 rli: Initial version.
 *
 ***/

void nanosleep( void *Interval, void *NotUsed );
