#include <stdio.h>
#include <sys/types.h>

uint64_t Address;
unsigned char Buffer[ 16 ];
int BytesRead;
FILE *InFile;

void DumpAscii( void )
{
  int index;
  for( index = 0; index < 16; index++ ) {
    if( index > ( BytesRead-1 ) ) {
      printf( " " );
    } else {
      if( ( Buffer[ index ] > 31 ) && ( Buffer[ index ] < 127 ) ) {
        printf( "%c", Buffer[ index ] );
      } else {
        printf( "." );
      }
    }
  }
}

void DumpLine( void )
{
  int index;

  printf( "\n" );
  for( index = 15; index > -1; index-- ) {
    if( index > ( BytesRead-1 ) ) {
      printf( "  " );
    } else {
      printf( "%2.2X", Buffer[ index ] );
    }
    if( ( index & 3 ) == 0 ) printf( " " );
  }
  printf( ": " );
  DumpAscii();
  printf( " : %16.16llX", Address );
  Address += 16;
  if( ( Address & 0xff ) == 0 ) printf( "\n" );
}

void SuckLine( void )
{
  BytesRead = fread( Buffer, 1, 16, InFile );
}

void DumpStdin( void )
{
  do {
    SuckLine();
    DumpLine();
  } while( BytesRead == 16 );
}

int main( int ArgC, char **ArgV )
{
  if( ArgC != 2 ) {
    fprintf( stderr, "usage: dump file\n" );
    return 0;
  }

  InFile = fopen( ArgV[ 1 ], "rb" );
  if( InFile == NULL ) {
    perror( "open" );
    return 0;
  }

  DumpStdin();
  printf( "\n" );

  return 1;
}
