;============================================================================
;
;File:	Z80EM4.ASM - Z80 Emulator
;Date:  April 17, 1987
;
;============================================================================
;
	ORG	(80H*PG)+CBOP
RES0B	PROC	NEAR		;CB 80			RES 0,B
;				=========================================
	AND	DI,0FEFFH	;Reset bit 0 of B(DI)
	XOR	CL,CL
	NXTI
RES0B	ENDP
;
	ORG	(81H*PG)+CBOP
RES0C	PROC	NEAR		;CB 81			RES 0,C
;				=========================================
	AND	DI,0FFFEH	;Reset bit 0 of C(DI)
	XOR	CL,CL
	NXTI
RES0C	ENDP
;
	ORG	(82H*PG)+CBOP
RES0D	PROC	NEAR		;CB 82			RES 0,D
;				=========================================
	AND	DH,0FEH  	;Reset bit 0 of D(DH)
	XOR	CL,CL
	NXTI
RES0D	ENDP
;
	ORG	(83H*PG)+CBOP
RES0E	PROC	NEAR		;CB 83			RES 0,E
;				=========================================
	AND	DL,0FEH  	;Reset bit 0 of E(DL)
	XOR	CL,CL
	NXTI
RES0E	ENDP
;
	ORG	(84H*PG)+CBOP
RES0H	PROC	NEAR		;CB 84			RES 0,H
;				=========================================
	AND	BH,0FEH  	;Reset bit 0 of H(BH)
	XOR	CL,CL
	NXTI
RES0H	ENDP
;
	ORG	(85H*PG)+CBOP
RES0L	PROC	NEAR		;CB 85			RES 0,L
;				=========================================
	AND	BL,0FEH  	;Reset bit 0 of L(BL)
	XOR	CL,CL
	NXTI
RES0L	ENDP
;
	ORG	(86H*PG)+CBOP
RES0HL	PROC	NEAR		;CB 86			RES 0,(HL)
;				=========================================
	AND	BYTE PTR [BX],0FEH  	;Reset bit 0 of byte via (HL)
	XOR	CL,CL
	NXTI
RES0HL	ENDP
;
	ORG	(87H*PG)+CBOP
RES0A	PROC	NEAR		;CB 87			RES 0,A
;				=========================================
	AND	AL,0FEH  	;Reset bit 0 of A(AL)
	XOR	CL,CL
	NXTI
RES0A	ENDP
;
	ORG	(88H*PG)+CBOP
RES1B	PROC	NEAR		;CB 88			RES 1,B
;				=========================================
	AND	DI,0FDFFH	;Reset bit 1 of B(DI)
	XOR	CL,CL
	NXTI
RES1B	ENDP
;
	ORG	(89H*PG)+CBOP
RES1C	PROC	NEAR		;CB 89			RES 1,C
;				=========================================
	AND	DI,0FFFDH	;Reset bit 1 of C(DI)
	XOR	CL,CL
	NXTI
RES1C	ENDP
;
	ORG	(8AH*PG)+CBOP
RES1D	PROC	NEAR		;CB 8A			RES 1,D
;				=========================================
	AND	DH,0FDH  	;Reset bit 1 of D(DH)
	XOR	CL,CL
	NXTI
RES1D	ENDP
;
	ORG	(8BH*PG)+CBOP
RES1E	PROC	NEAR		;CB 8B			RES 1,E
;				=========================================
	AND	DL,0FDH  	;Reset bit 1 of E(DL)
	XOR	CL,CL
	NXTI
RES1E	ENDP
;
	ORG	(8CH*PG)+CBOP
RES1H	PROC	NEAR		;CB 8C			RES 1,H
;				=========================================
	AND	BH,0FDH  	;Reset bit 1 of H(BH)
	XOR	CL,CL
	NXTI
RES1H	ENDP
;
	ORG	(8DH*PG)+CBOP
RES1L	PROC	NEAR		;CB 8D			RES 1,L
;				=========================================
	AND	BL,0FDH  	;Reset bit 1 of L(BL)
	XOR	CL,CL
	NXTI
RES1L	ENDP
;
	ORG	(8EH*PG)+CBOP
RES1HL	PROC	NEAR		;CB 8E			RES 1,(HL)
;				=========================================
	AND	BYTE PTR [BX],0FDH  	;Reset bit 1 of byte via (HL)
	XOR	CL,CL
	NXTI
RES1HL	ENDP
;
	ORG	(8FH*PG)+CBOP
RES1A	PROC	NEAR		;CB 8F			RES 1,A
;				=========================================
	AND	AL,0FDH  	;Reset bit 1 of A(AL)
	XOR	CL,CL
	NXTI
RES1A	ENDP
;
	ORG	(90H*PG)+CBOP
RES2B	PROC	NEAR		;CB 90			RES 2,B
;				=========================================
	AND	DI,0FBFFH	;Reset bit 2 of B(DI)
	XOR	CL,CL
	NXTI
RES2B	ENDP
;
	ORG	(91H*PG)+CBOP
RES2C	PROC	NEAR		;CB 91			RES 2,C
;				=========================================
	AND	DI,0FFFBH	;Reset bit 2 of C(DI)
	XOR	CL,CL
	NXTI
RES2C	ENDP
;
	ORG	(92H*PG)+CBOP
RES2D	PROC	NEAR		;CB 92			RES 2,D
;				=========================================
	AND	DH,0FBH  	;Reset bit 2 of D(DH)
	XOR	CL,CL
	NXTI
RES2D	ENDP
;
	ORG	(93H*PG)+CBOP
RES2E	PROC	NEAR		;CB 93			RES 2,E
;				=========================================
	AND	DL,0FBH  	;Reset bit 2 of E(DL)
	XOR	CL,CL
	NXTI
RES2E	ENDP
;
	ORG	(94H*PG)+CBOP
RES2H	PROC	NEAR		;CB 94			RES 2,H
;				=========================================
	AND	BH,0FBH  	;Reset bit 2 of H(BH)
	XOR	CL,CL
	NXTI
RES2H	ENDP
;
	ORG	(95H*PG)+CBOP
RES2L	PROC	NEAR		;CB 95			RES 2,L
;				=========================================
	AND	BL,0FBH  	;Reset bit 2 of L(BL)
	XOR	CL,CL
	NXTI
RES2L	ENDP
;
	ORG	(96H*PG)+CBOP
RES2HL	PROC	NEAR		;CB 96			RES 2,(HL)
;				=========================================
	AND	BYTE PTR [BX],0FBH  	;Reset bit 2 of byte via (HL)
	XOR	CL,CL
	NXTI
RES2HL	ENDP
;
	ORG	(97H*PG)+CBOP
RES2A	PROC	NEAR		;CB 97			RES 2,A
;				=========================================
	AND	AL,0FBH  	;Reset bit 2 of A(AL)
	XOR	CL,CL
	NXTI
RES2A	ENDP
;
	ORG	(98H*PG)+CBOP
RES3B	PROC	NEAR		;CB 98			RES 3,B
;				=========================================
	AND	DI,0F7FFH	;Reset bit 3 of B(DI)
	XOR	CL,CL
	NXTI
RES3B	ENDP
;
	ORG	(99H*PG)+CBOP
RES3C	PROC	NEAR		;CB 99			RES 3,C
;				=========================================
	AND	DI,0FFF7H	;Reset bit 3 of C(DI)
	XOR	CL,CL
	NXTI
RES3C	ENDP
;
	ORG	(9AH*PG)+CBOP
RES3D	PROC	NEAR		;CB 9A			RES 3,D
;				=========================================
	AND	DH,0F7H  	;Reset bit 3 of D(DH)
	XOR	CL,CL
	NXTI
RES3D	ENDP
;
	ORG	(9BH*PG)+CBOP
RES3E	PROC	NEAR		;CB 9B			RES 3,E
;				=========================================
	AND	DL,0F7H  	;Reset bit 3 of E(DL)
	XOR	CL,CL
	NXTI
RES3E	ENDP
;
	ORG	(9CH*PG)+CBOP
RES3H	PROC	NEAR		;CB 9C			RES 3,H
;				=========================================
	AND	BH,0F7H  	;Reset bit 3 of H(BH)
	XOR	CL,CL
	NXTI
RES3H	ENDP
;
	ORG	(9DH*PG)+CBOP
RES3L	PROC	NEAR		;CB 9D			RES 3,L
;				=========================================
	AND	BL,0F7H  	;Reset bit 3 of L(BL)
	XOR	CL,CL
	NXTI
RES3L	ENDP
;
	ORG	(9EH*PG)+CBOP
RES3HL	PROC	NEAR		;CB 9E			RES 3,(HL)
;				=========================================
	AND	BYTE PTR [BX],0F7H  	;Reset bit 3 of byte via (HL)
	XOR	CL,CL
	NXTI
RES3HL	ENDP
;
	ORG	(9FH*PG)+CBOP
RES3A	PROC	NEAR		;CB 9F			RES 3,A
;				=========================================
	AND	AL,0F7H  	;Reset bit 3 of A(AL)
	XOR	CL,CL
	NXTI
RES3A	ENDP
;
	ORG	(0A0H*PG)+CBOP
RES4B	PROC	NEAR		;CB A0			RES 4,B
;				=========================================
	AND	DI,0EFFFH	;Reset bit 4 of B(DI)
	XOR	CL,CL
	NXTI
RES4B	ENDP
;
	ORG	(0A1H*PG)+CBOP
RES4C	PROC	NEAR		;CB A1			RES 4,C
;				=========================================
	AND	DI,0FFEFH	;Reset bit 4 of C(DI)
	XOR	CL,CL
	NXTI
RES4C	ENDP
;
	ORG	(0A2H*PG)+CBOP
RES4D	PROC	NEAR		;CB A2			RES 4,D
;				=========================================
	AND	DH,0EFH  	;Reset bit 4 of D(DH)
	XOR	CL,CL
	NXTI
RES4D	ENDP
;
	ORG	(0A3H*PG)+CBOP
RES4E	PROC	NEAR		;CB A3			RES 4,E
;				=========================================
	AND	DL,0EFH  	;Reset bit 4 of E(DL)
	XOR	CL,CL
	NXTI
RES4E	ENDP
;
	ORG	(0A4H*PG)+CBOP
RES4H	PROC	NEAR		;CB A4			RES 4,H
;				=========================================
	AND	BH,0EFH  	;Reset bit 4 of H(BH)
	XOR	CL,CL
	NXTI
RES4H	ENDP
;
	ORG	(0A5H*PG)+CBOP
RES4L	PROC	NEAR		;CB A5			RES 4,L
;				=========================================
	AND	BL,0EFH  	;Reset bit 4 of L(BL)
	XOR	CL,CL
	NXTI
RES4L	ENDP
;
	ORG	(0A6H*PG)+CBOP
RES4HL	PROC	NEAR		;CB A6			RES 4,(HL)
;				=========================================
	AND	BYTE PTR [BX],0EFH  	;Reset bit 4 of byte via (HL)
	XOR	CL,CL
	NXTI
RES4HL	ENDP
;
	ORG	(0A7H*PG)+CBOP
RES4A	PROC	NEAR		;CB A7			RES 4,A
;				=========================================
	AND	AL,0EFH  	;Reset bit 4 of A(AL)
	XOR	CL,CL
	NXTI
RES4A	ENDP
;
	ORG	(0A8H*PG)+CBOP
RES5B	PROC	NEAR		;CB A8			RES 5,B
;				=========================================
	AND	DI,0DFFFH	;Reset bit 5 of B(DI)
	XOR	CL,CL
	NXTI
RES5B	ENDP
;
	ORG	(0A9H*PG)+CBOP
RES5C	PROC	NEAR		;CB A9			RES 5,C
;				=========================================
	AND	DI,0FFDFH	;Reset bit 5 of C(DI)
	XOR	CL,CL
	NXTI
RES5C	ENDP
;
	ORG	(0AAH*PG)+CBOP
RES5D	PROC	NEAR		;CB AA			RES 5,D
;				=========================================
	AND	DH,0DFH  	;Reset bit 5 of D(DH)
	XOR	CL,CL
	NXTI
RES5D	ENDP
;
	ORG	(0ABH*PG)+CBOP
RES5E	PROC	NEAR		;CB AB			RES 5,E
;				=========================================
	AND	DL,0DFH  	;Reset bit 5 of E(DL)
	XOR	CL,CL
	NXTI
RES5E	ENDP
;
	ORG	(0ACH*PG)+CBOP
RES5H	PROC	NEAR		;CB AC			RES 5,H
;				=========================================
	AND	BH,0DFH  	;Reset bit 5 of H(BH)
	XOR	CL,CL
	NXTI
RES5H	ENDP
;
	ORG	(0ADH*PG)+CBOP
RES5L	PROC	NEAR		;CB AD			RES 5,L
;				=========================================
	AND	BL,0DFH  	;Reset bit 5 of L(BL)
	XOR	CL,CL
	NXTI
RES5L	ENDP
;
	ORG	(0AEH*PG)+CBOP
RES5HL	PROC	NEAR		;CB AE			RES 5,(HL)
;				=========================================
	AND	BYTE PTR [BX],0DFH  	;Reset bit 5 of byte via (HL)
	XOR	CL,CL
	NXTI
RES5HL	ENDP
;
	ORG	(0AFH*PG)+CBOP
RES5A	PROC	NEAR		;CB AF			RES 5,A
;				=========================================
	AND	AL,0DFH  	;Reset bit 5 of A(AL)
	XOR	CL,CL
	NXTI
RES5A	ENDP
;
	ORG	(0B0H*PG)+CBOP
RES6B	PROC	NEAR		;CB B0			RES 6,B
;				=========================================
	AND	DI,0BFFFH	;Reset bit 6 of B(DI)
	XOR	CL,CL
	NXTI
RES6B	ENDP
;
	ORG	(0B1H*PG)+CBOP
RES6C	PROC	NEAR		;CB B1			RES 6,C
;				=========================================
	AND	DI,0FFBFH	;Reset bit 6 of C(DI)
	XOR	CL,CL
	NXTI
RES6C	ENDP
;
	ORG	(0B2H*PG)+CBOP
RES6D	PROC	NEAR		;CB B2			RES 6,D
;				=========================================
	AND	DH,0BFH  	;Reset bit 6 of D(DH)
	XOR	CL,CL
	NXTI
RES6D	ENDP
;
	ORG	(0B3H*PG)+CBOP
RES6E	PROC	NEAR		;CB B3			RES 6,E
;				=========================================
	AND	DL,0BFH  	;Reset bit 6 of E(DL)
	XOR	CL,CL
	NXTI
RES6E	ENDP
;
	ORG	(0B4H*PG)+CBOP
RES6H	PROC	NEAR		;CB B4			RES 6,H
;				=========================================
	AND	BH,0BFH  	;Reset bit 6 of H(BH)
	XOR	CL,CL
	NXTI
RES6H	ENDP
;
	ORG	(0B5H*PG)+CBOP
RES6L	PROC	NEAR		;CB B5			RES 6,L
;				=========================================
	AND	BL,0BFH  	;Reset bit 6 of L(BL)
	XOR	CL,CL
	NXTI
RES6L	ENDP
;
	ORG	(0B6H*PG)+CBOP
RES6HL	PROC	NEAR		;CB B6			RES 6,(HL)
;				=========================================
	AND	BYTE PTR [BX],0BFH  	;Reset bit 6 of byte via (HL)
	XOR	CL,CL
	NXTI
RES6HL	ENDP
;
	ORG	(0B7H*PG)+CBOP
RES6A	PROC	NEAR		;CB B7			RES 6,A
;				=========================================
	AND	AL,0BFH  	;Reset bit 6 of A(AL)
	XOR	CL,CL
	NXTI
RES6A	ENDP
;
	ORG	(0B8H*PG)+CBOP
RES7B	PROC	NEAR		;CB B8			RES 7,B
;				=========================================
	AND	DI,07FFFH	;Reset bit 7 of B(DI)
	XOR	CL,CL
	NXTI
RES7B	ENDP
;
	ORG	(0B9H*PG)+CBOP
RES7C	PROC	NEAR		;CB B9			RES 7,C
;				=========================================
	AND	DI,0FF7FH	;Reset bit 7 of C(DI)
	XOR	CL,CL
	NXTI
RES7C	ENDP
;
	ORG	(0BAH*PG)+CBOP
RES7D	PROC	NEAR		;CB BA			RES 7,D
;				=========================================
	AND	DH,07FH  	;Reset bit 7 of D(DH)
	XOR	CL,CL
	NXTI
RES7D	ENDP
;
	ORG	(0BBH*PG)+CBOP
RES7E	PROC	NEAR		;CB BB			RES 7,E
;				=========================================
	AND	DL,07FH  	;Reset bit 7 of E(DL)
	XOR	CL,CL
	NXTI
RES7E	ENDP
;
	ORG	(0BCH*PG)+CBOP
RES7H	PROC	NEAR		;CB BC			RES 7,H
;				=========================================
	AND	BH,07FH  	;Reset bit 7 of H(BH)
	XOR	CL,CL
	NXTI
RES7H	ENDP
;
	ORG	(0BDH*PG)+CBOP
RES7L	PROC	NEAR		;CB BD			RES 7,L
;				=========================================
	AND	BL,07FH  	;Reset bit 7 of L(BL)
	XOR	CL,CL
	NXTI
RES7L	ENDP
;
	ORG	(0BEH*PG)+CBOP
RES7HL	PROC	NEAR		;CB BE			RES 7,(HL)
;				=========================================
	AND	BYTE PTR [BX],07FH  	;Reset bit 7 of byte via (HL)
	XOR	CL,CL
	NXTI
RES7HL	ENDP
;
	ORG	(0BFH*PG)+CBOP
RES7A	PROC	NEAR		;CB BF			RES 7,A
;				=========================================
	AND	AL,07FH  	;Reset bit 7 of A(AL)
	XOR	CL,CL
	NXTI
RES7A	ENDP
;
	ORG	(0C0H*PG)+CBOP
SET0B	PROC	NEAR		;CB C0			SET 0,B
;				=========================================
	OR 	DI,0100H	;Set bit 0 of B(DI)
	XOR	CL,CL
	NXTI
SET0B	ENDP
;
	ORG	(0C1H*PG)+CBOP
SET0C	PROC	NEAR		;CB C1			SET 0,C
;				=========================================
	OR 	DI,0001H	;Set bit 0 of C(DI)
	XOR	CL,CL
	NXTI
SET0C	ENDP
;
	ORG	(0C2H*PG)+CBOP
SET0D	PROC	NEAR		;CB C2			SET 0,D
;				=========================================
	OR 	DH,01H  	;Set bit 0 of D(DH)
	XOR	CL,CL
	NXTI
SET0D	ENDP
;
	ORG	(0C3H*PG)+CBOP
SET0E	PROC	NEAR		;CB C3			SET 0,E
;				=========================================
	OR 	DL,01H  	;Set bit 0 of E(DL)
	XOR	CL,CL
	NXTI
SET0E	ENDP
;
	ORG	(0C4H*PG)+CBOP
SET0H	PROC	NEAR		;CB C4			SET 0,H
;				=========================================
	OR 	BH,01H  	;Set bit 0 of H(BH)
	XOR	CL,CL
	NXTI
SET0H	ENDP
;
	ORG	(0C5H*PG)+CBOP
SET0L	PROC	NEAR		;CB C5			SET 0,L
;				=========================================
	OR 	BL,01H  	;Set bit 0 of L(BL)
	XOR	CL,CL
	NXTI
SET0L	ENDP
;
	ORG	(0C6H*PG)+CBOP
SET0HL	PROC	NEAR		;CB C6			SET 0,(HL)
;				=========================================
	OR 	BYTE PTR [BX],01H  	;Set bit 0 of byte via (HL)
	XOR	CL,CL
	NXTI
SET0HL	ENDP
;
	ORG	(0C7H*PG)+CBOP
SET0A	PROC	NEAR		;CB C7			SET 0,A
;				=========================================
	OR 	AL,01H  	;Set bit 0 of A(AL)
	XOR	CL,CL
	NXTI
SET0A	ENDP
;
	ORG	(0C8H*PG)+CBOP
SET1B	PROC	NEAR		;CB C8			SET 1,B
;				=========================================
	OR 	DI,0200H	;Set bit 1 of B(DI)
	XOR	CL,CL
	NXTI
SET1B	ENDP
;
	ORG	(0C9H*PG)+CBOP
SET1C	PROC	NEAR		;CB C9			SET 1,C
;				=========================================
	OR 	DI,0002H	;Set bit 1 of C(DI)
	XOR	CL,CL
	NXTI
SET1C	ENDP
;
	ORG	(0CAH*PG)+CBOP
SET1D	PROC	NEAR		;CB CA			SET 1,D
;				=========================================
	OR 	DH,02H  	;Set bit 1 of D(DH)
	XOR	CL,CL
	NXTI
SET1D	ENDP
;
	ORG	(0CBH*PG)+CBOP
SET1E	PROC	NEAR		;CB CB			SET 1,E
;				=========================================
	OR 	DL,02H  	;Set bit 1 of E(DL)
	XOR	CL,CL
	NXTI
SET1E	ENDP
;
	ORG	(0CCH*PG)+CBOP
SET1H	PROC	NEAR		;CB CC			SET 1,H
;				=========================================
	OR 	BH,02H  	;Set bit 1 of H(BH)
	XOR	CL,CL
	NXTI
SET1H	ENDP
;
	ORG	(0CDH*PG)+CBOP
SET1L	PROC	NEAR		;CB CD			SET 1,L
;				=========================================
	OR  	BL,02H  	;Set bit 1 of L(BL)
	XOR	CL,CL
	NXTI
SET1L	ENDP
;
	ORG	(0CEH*PG)+CBOP
SET1HL	PROC	NEAR		;CB CE			SET 1,(HL)
;				=========================================
	OR 	BYTE PTR [BX],02H  	;Set bit 1 of byte via (HL)
	XOR	CL,CL
	NXTI
SET1HL	ENDP
;
	ORG	(0CFH*PG)+CBOP
SET1A	PROC	NEAR		;CB CF			SET 1,A
;				=========================================
	OR 	AL,02H  	;Set bit 1 of A(AL)
	XOR	CL,CL
	NXTI
SET1A	ENDP
;
	ORG	(0D0H*PG)+CBOP
SET2B	PROC	NEAR		;CB D0			SET 2,B
;				=========================================
	OR 	DI,0400H	;Set bit 2 of B(DI)
	XOR	CL,CL
	NXTI
SET2B	ENDP
;
	ORG	(0D1H*PG)+CBOP
SET2C	PROC	NEAR		;CB D1			SET 2,C
;				=========================================
	OR 	DI,0004H	;Set bit 2 of C(DI)
	XOR	CL,CL
	NXTI
SET2C	ENDP
;
	ORG	(0D2H*PG)+CBOP
SET2D	PROC	NEAR		;CB D2			SET 2,D
;				=========================================
	OR 	DH,04H  	;Set bit 2 of D(DH)
	XOR	CL,CL
	NXTI
SET2D	ENDP
;
	ORG	(0D3H*PG)+CBOP
SET2E	PROC	NEAR		;CB D3			SET 2,E
;				=========================================
	OR 	DL,04H  	;Set bit 2 of E(DL)
	XOR	CL,CL
	NXTI
SET2E	ENDP
;
	ORG	(0D4H*PG)+CBOP
SET2H	PROC	NEAR		;CB D4			SET 2,H
;				=========================================
	OR 	BH,04H  	;Set bit 2 of H(BH)
	XOR	CL,CL
	NXTI
SET2H	ENDP
;
	ORG	(0D5H*PG)+CBOP
SET2L	PROC	NEAR		;CB D5			SET 2,L
;				=========================================
	OR 	BL,04H  	;Set bit 2 of L(BL)
	XOR	CL,CL
	NXTI
SET2L	ENDP
;
	ORG	(0D6H*PG)+CBOP
SET2HL	PROC	NEAR		;CB D6			SET 2,(HL)
;				=========================================
	OR 	BYTE PTR [BX],04H  	;Set bit 2 of byte via (HL)
	XOR	CL,CL
	NXTI
SET2HL	ENDP
;
	ORG	(0D7H*PG)+CBOP
SET2A	PROC	NEAR		;CB D7			SET 2,A
;				=========================================
	OR 	AL,04H  	;Set bit 2 of A(AL)
	XOR	CL,CL
	NXTI
SET2A	ENDP
;
	ORG	(0D8H*PG)+CBOP
SET3B	PROC	NEAR		;CB D8			SET 3,B
;				=========================================
	OR 	DI,0800H	;Set bit 3 of B(DI)
	XOR	CL,CL
	NXTI
SET3B	ENDP
;
	ORG	(0D9H*PG)+CBOP
SET3C	PROC	NEAR		;CB D9			SET 3,C
;				=========================================
	OR 	DI,0008H	;Set bit 3 of C(DI)
	XOR	CL,CL
	NXTI
SET3C	ENDP
;
	ORG	(0DAH*PG)+CBOP
SET3D	PROC	NEAR		;CB DA			SET 3,D
;				=========================================
	OR 	DH,08H  	;Set bit 3 of D(DH)
	XOR	CL,CL
	NXTI
SET3D	ENDP
;
	ORG	(0DBH*PG)+CBOP
SET3E	PROC	NEAR		;CB DB			SET 3,E
;				=========================================
	OR 	DL,08H  	;Set bit 3 of E(DL)
	XOR	CL,CL
	NXTI
SET3E	ENDP
;
	ORG	(0DCH*PG)+CBOP
SET3H	PROC	NEAR		;CB DC			SET 3,H
;				=========================================
	OR 	BH,08H  	;Set bit 3 of H(BH)
	XOR	CL,CL
	NXTI
SET3H	ENDP
;
	ORG	(0DDH*PG)+CBOP
SET3L	PROC	NEAR		;CB DD			SET 3,L
;				=========================================
	OR  	BL,08H  	;Set bit 3 of L(BL)
	XOR	CL,CL
	NXTI
SET3L	ENDP
;
	ORG	(0DEH*PG)+CBOP
SET3HL	PROC	NEAR		;CB DE			SET 3,(HL)
;				=========================================
	OR 	BYTE PTR [BX],08H  	;Set bit 3 of byte via (HL)
	XOR	CL,CL
	NXTI
SET3HL	ENDP
;
	ORG	(0DFH*PG)+CBOP
SET3A	PROC	NEAR		;CB DF			SET 3,A
;				=========================================
	OR 	AL,08H  	;Set bit 3 of A(AL)
	XOR	CL,CL
	NXTI
SET3A	ENDP
;
	ORG	(0E0H*PG)+CBOP
SET4B	PROC	NEAR		;CB E0			SET 4,B
;				=========================================
	OR 	DI,01000H	;Set bit 4 of B(DI)
	XOR	CL,CL
	NXTI
SET4B	ENDP
;
	ORG	(0E1H*PG)+CBOP
SET4C	PROC	NEAR		;CB E1			SET 4,C
;				=========================================
	OR 	DI,0010H	;Set bit 4 of C(DI)
	XOR	CL,CL
	NXTI
SET4C	ENDP
;
	ORG	(0E2H*PG)+CBOP
SET4D	PROC	NEAR		;CB E2			SET 4,D
;				=========================================
	OR 	DH,010H  	;Set bit 4 of D(DH)
	XOR	CL,CL
	NXTI
SET4D	ENDP
;
	ORG	(0E3H*PG)+CBOP
SET4E	PROC	NEAR		;CB E3			SET 4,E
;				=========================================
	OR 	DL,010H  	;Set bit 4 of E(DL)
	XOR	CL,CL
	NXTI
SET4E	ENDP
;
	ORG	(0E4H*PG)+CBOP
SET4H	PROC	NEAR		;CB E4			SET 4,H
;				=========================================
	OR 	BH,010H  	;Set bit 4 of H(BH)
	XOR	CL,CL
	NXTI
SET4H	ENDP
;
	ORG	(0E5H*PG)+CBOP
SET4L	PROC	NEAR		;CB E5			SET 4,L
;				=========================================
	OR 	BL,010H  	;Set bit 4 of L(BL)
	XOR	CL,CL
	NXTI
SET4L	ENDP
;
	ORG	(0E6H*PG)+CBOP
SET4HL	PROC	NEAR		;CB E6			SET 4,(HL)
;				=========================================
	OR 	BYTE PTR [BX],010H  	;Set bit 4 of byte via (HL)
	XOR	CL,CL
	NXTI
SET4HL	ENDP
;
	ORG	(0E7H*PG)+CBOP
SET4A	PROC	NEAR		;CB E7			SET 4,A
;				=========================================
	OR 	AL,010H  	;Set bit 4 of A(AL)
	XOR	CL,CL
	NXTI
SET4A	ENDP
;
	ORG	(0E8H*PG)+CBOP
SET5B	PROC	NEAR		;CB E8			SET 5,B
;				=========================================
	OR 	DI,02000H	;Set bit 5 of B(DI)
	XOR	CL,CL
	NXTI
SET5B	ENDP
;
	ORG	(0E9H*PG)+CBOP
SET5C	PROC	NEAR		;CB E9			SET 5,C
;				=========================================
	OR 	DI,0020H	;Set bit 5 of C(DI)
	XOR	CL,CL
	NXTI
SET5C	ENDP
;
	ORG	(0EAH*PG)+CBOP
SET5D	PROC	NEAR		;CB EA			SET 5,D
;				=========================================
	OR 	DH,020H  	;Set bit 5 of D(DH)
	XOR	CL,CL
	NXTI
SET5D	ENDP
;
	ORG	(0EBH*PG)+CBOP
SET5E	PROC	NEAR		;CB EB			SET 5,E
;				=========================================
	OR 	DL,020H  	;Set bit 5 of E(DL)
	XOR	CL,CL
	NXTI
SET5E	ENDP
;
	ORG	(0ECH*PG)+CBOP
SET5H	PROC	NEAR		;CB EC			SET 5,H
;				=========================================
	OR 	BH,020H  	;Set bit 5 of H(BH)
	XOR	CL,CL
	NXTI
SET5H	ENDP
;
	ORG	(0EDH*PG)+CBOP
SET5L	PROC	NEAR		;CB ED			SET 5,L
;				=========================================
	OR  	BL,020H  	;Set bit 5 of L(BL)
	XOR	CL,CL
	NXTI
SET5L	ENDP
;
	ORG	(0EEH*PG)+CBOP
SET5HL	PROC	NEAR		;CB EE			SET 5,(HL)
;				=========================================
	OR 	BYTE PTR [BX],020H  	;Set bit 5 of byte via (HL)
	XOR	CL,CL
	NXTI
SET5HL	ENDP
;
	ORG	(0EFH*PG)+CBOP
SET5A	PROC	NEAR		;CB EF			SET 5,A
;				=========================================
	OR 	AL,020H  	;Set bit 5 of A(AL)
	XOR	CL,CL
	NXTI
SET5A	ENDP
;
	ORG	(0F0H*PG)+CBOP
SET6B	PROC	NEAR		;CB F0			SET 6,B
;				=========================================
	OR 	DI,4000H	;Set bit 6 of B(DI)
	XOR	CL,CL
	NXTI
SET6B	ENDP
;
	ORG	(0F1H*PG)+CBOP
SET6C	PROC	NEAR		;CB F1			SET 6,C
;				=========================================
	OR 	DI,0040H	;Set bit 6 of C(DI)
	XOR	CL,CL
	NXTI
SET6C	ENDP
;
	ORG	(0F2H*PG)+CBOP
SET6D	PROC	NEAR		;CB F2			SET 6,D
;				=========================================
	OR 	DH,040H  	;Set bit 6 of D(DH)
	XOR	CL,CL
	NXTI
SET6D	ENDP
;
	ORG	(0F3H*PG)+CBOP
SET6E	PROC	NEAR		;CB F3			SET 6,E
;				=========================================
	OR 	DL,040H  	;Set bit 6 of E(DL)
	XOR	CL,CL
	NXTI
SET6E	ENDP
;
	ORG	(0F4H*PG)+CBOP
SET6H	PROC	NEAR		;CB F4			SET 6,H
;				=========================================
	OR 	BH,040H  	;Set bit 6 of H(BH)
	XOR	CL,CL
	NXTI
SET6H	ENDP
;
	ORG	(0F5H*PG)+CBOP
SET6L	PROC	NEAR		;CB F5			SET 6,L
;				=========================================
	OR 	BL,040H  	;Set bit 6 of L(BL)
	XOR	CL,CL
	NXTI
SET6L	ENDP
;
	ORG	(0F6H*PG)+CBOP
SET6HL	PROC	NEAR		;CB F6			SET 6,(HL)
;				=========================================
	OR 	BYTE PTR [BX],040H  	;Set bit 6 of byte via (HL)
	XOR	CL,CL
	NXTI
SET6HL	ENDP
;
	ORG	(0F7H*PG)+CBOP
SET6A	PROC	NEAR		;CB F7			SET 6,A
;				=========================================
	OR 	AL,040H  	;Set bit 6 of A(AL)
	XOR	CL,CL
	NXTI
SET6A	ENDP
;
	ORG	(0F8H*PG)+CBOP
SET7B	PROC	NEAR		;CB F8			SET 7,B
;				=========================================
	OR 	DI,08000H	;Set bit 7 of B(DI)
	XOR	CL,CL
	NXTI
SET7B	ENDP
;
	ORG	(0F9H*PG)+CBOP
SET7C	PROC	NEAR		;CB F9			SET 7,C
;				=========================================
	OR 	DI,0080H	;Set bit 7 of C(DI)
	XOR	CL,CL
	NXTI
SET7C	ENDP
;
	ORG	(0FAH*PG)+CBOP
SET7D	PROC	NEAR		;CB FA			SET 7,D
;				=========================================
	OR 	DH,080H  	;Set bit 7 of D(DH)
	XOR	CL,CL
	NXTI
SET7D	ENDP
;
	ORG	(0FBH*PG)+CBOP
SET7E	PROC	NEAR		;CB FB			SET 7,E
;				=========================================
	OR 	DL,080H  	;Set bit 7 of E(DL)
	XOR	CL,CL
	NXTI
SET7E	ENDP
;
	ORG	(0FCH*PG)+CBOP
SET7H	PROC	NEAR		;CB FC			SET 7,H
;				=========================================
	OR 	BH,080H  	;Set bit 7 of H(BH)
	XOR	CL,CL
	NXTI
SET7H	ENDP
;
	ORG	(0FDH*PG)+CBOP
SET7L	PROC	NEAR		;CB FD			SET 7,L
;				=========================================
	OR  	BL,080H  	;Set bit 7 of L(BL)
	XOR	CL,CL
	NXTI
SET7L	ENDP
;
	ORG	(0FEH*PG)+CBOP
SET7HL	PROC	NEAR		;CB FE			SET 7,(HL)
;				=========================================
	OR 	BYTE PTR [BX],080H  	;Set bit 7 of byte via (HL)
	XOR	CL,CL
	NXTI
SET7HL	ENDP
;
	ORG	(0FFH*PG)+CBOP
SET7A	PROC	NEAR		;CB FF			SET 7,A
;				=========================================
	OR 	AL,080H  	;Set bit 7 of A(AL)
	XOR	CL,CL
	NXTI
SET7A	ENDP
;
;------------------------------------------------------------------------
;
	ORG 	(009H*PG)+DDOP
ADIXBC	PROC	NEAR		;DD 09			ADD IX,BC
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	ADD	WORD PTR IX,DI	;Add BC(DI) to IX(FF70H)
	JNB	ADIXBC1		;jump on no carry
	INC	AH		;set carry flag
ADIXBC1	EQU	$
	XOR	CL,CL
	NXTI
ADIXBC	ENDP
;
	ORG 	(019H*PG)+DDOP
ADIXDE	PROC	NEAR		;DD 19			ADD IX,DE
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	ADD	WORD PTR IX,DX	;Add DE(DX) to IX(FF70H)
	JNB	ADIXDE1		;jump on no carry
	INC	AH		;set carry flag
ADIXDE1	EQU	$
	XOR	CL,CL
	NXTI
ADIXDE	ENDP
;
	ORG	(021H*PG)+DDOP
LDIXI	PROC	NEAR		;DD 21 D16		LD IX,D16
;				========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	MOV	WORD PTR IX,AX	;put immediate data in IX(FF70H)
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDIXI	ENDP
;
	ORG	(022H*PG)+DDOP
LDMIX	PROC	NEAR		;DD 22 D16		LD (D16),IX
;				========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	BX,WORD PTR IX	;save HL(BX), get IX(FF70H) in BX
	XCHG	DI,AX		;save BC(DI) in AX
	MOV	[DI],BX		;put IX in memory location D16  
	XCHG	DI,AX		;restore BC(DI) from AX
	XCHG	BX,IX		;restore HL(BX) and IX(FF70H)
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDMIX	ENDP
;
	ORG	(023H*PG)+DDOP
INCIX	PROC	NEAR		;DD 23			INC IX
;				==========================================
	INC	WORD PTR IX
	XOR	CL,CL
	NXTI
INCIX	ENDP
;
	ORG 	(029H*PG)+DDOP
ADIXIX	PROC	NEAR		;DD 29			ADD IX,IX
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	MOV	CX,WORD PTR IX	;put IX(FF70H) in CX
	ADD	WORD PTR IX,CX	;add IX(CX) to IX(FF70H)
	JNB	ADIXIX1		;jump on no carry
	INC	AH		;set carry flag
ADIXIX1	EQU	$
	XOR	CL,CL
	NXTI
ADIXIX	ENDP
;
	ORG	(02AH*PG)+DDOP
LDIXM	PROC	NEAR		;DD 2A D16		LD IX,(D16)
;				========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX
	MOV	DI,[DI]		;get memory location D16 in DI
	MOV	WORD PTR IX,DI	;put contents of mem loc D16 in IX(FF70H)
	XCHG	DI,AX		;restore BC(DI) from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDIXM	ENDP
;
	ORG	(02BH*PG)+DDOP
DECIX	PROC	NEAR		;DD 2B			DEC IX
;				==========================================
	DEC	WORD PTR IX
	XOR	CL,CL
	NXTI
DECIX	ENDP
;
	ORG	(034H*PG)+DDOP
INCIXD	PROC	NEAR		;DD 34 dd		INC (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	XCHG	DI,AX		;get displacement byte in DI
	ADD	DI,WORD PTR IX	;add IX to displacement
	SAHF			;save AH in flags
	INC	BYTE PTR [DI]	;increment byte at IX+displacement
	LAHF			;load AH from flags
	JO	INCIXD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	JMP	INCIXD2
INCIXD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
INCIXD2	EQU	$
	XOR	CL,CL
	NXTI
INCIXD	ENDP
;
	ORG	(035H*PG)+DDOP
DECIXD	PROC	NEAR		;DD 35 dd		DEC (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	XCHG	DI,AX		;get displacement byte in DI
	ADD	DI,WORD PTR IX	;add IX to displacement
	SAHF			;save AH in flags
	DEC	BYTE PTR [DI]	;decrement byte at IX+displacement
	LAHF			;load AH from flags
	JO	DECIXD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	JMP	DECIXD2
DECIXD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
DECIXD2	EQU	$
	XOR	CL,CL
	NXTI
DECIXD	ENDP
;
	ORG	(036H*PG)+DDOP
LDIXDI	PROC	NEAR		;DD 36 dd d8		LD (IX+dd),d8
;				=========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSB			;get 8-bit displacement byte
	CBW			;convert byte to word
	XCHG	DI,AX		;save BC(CI) in AX, get displacement in DI
	ADD	DI,WORD PTR IX	;add IX to displacement in DI
	PUSH	AX		;save BC in AX on stack
	LODSB			;get 8-bit immediate byte
	MOV	[DI],AL		;store immediate byte to (IX+displacement)
	POP	DI		;restore BC(DI) from stack
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDIXDI	ENDP
;
	ORG 	(039H*PG)+DDOP
ADIXSP	PROC	NEAR		;DD 39			ADD IX,SP
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	ADD	WORD PTR IX,BP	;Add SP(BP) to IX(FF70H)
	JNB	ADIXSP1		;jump on no carry
	INC	AH		;set carry flag
ADIXSP1	EQU	$
	XOR	CL,CL
	NXTI
ADIXSP	ENDP
;
	ORG	(046H*PG)+DDOP
LDBIXD	PROC	NEAR		;DD 46 dd		LD B,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	CH,[DI]		;get byte at that location in CH
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDBIXD	ENDP
;
	ORG	(04EH*PG)+DDOP
LDCIXD	PROC	NEAR		;DD 4E dd		LD C,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	CL,[DI]		;get byte at that location in CL
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDCIXD	ENDP
;
	ORG	(056H*PG)+DDOP
LDDIXD	PROC	NEAR		;DD 56 dd		LD D,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	DH,[DI]		;get byte at that location in D(DH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDDIXD	ENDP
;
	ORG	(05FH*PG)+DDOP
LDEIXD	PROC	NEAR		;DD 5E dd		LD E,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	DL,[DI]		;get byte at that location in E(DL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDEIXD	ENDP
;
	ORG	(066H*PG)+DDOP
LDHIXD	PROC	NEAR		;DD 66 dd		LD H,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	BH,[DI]		;get byte at that location in H(BH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDHIXD	ENDP
;
	ORG	(06EH*PG)+DDOP
LDLIXD	PROC	NEAR		;DD 6E dd		LD L,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	BL,[DI]		;get byte at that location in L(BL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDLIXD	ENDP
;
	ORG	(070H*PG)+DDOP
LDIXDB	PROC	NEAR		;DD 70 dd		LD (IX+dd),B
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	[DI],CH		;put byte at that location from B(CH)
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDIXDB	ENDP
;
	ORG	(071H*PG)+DDOP
LDIXDC	PROC	NEAR		;DD 71 dd		LD (IX+dd),C
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	[DI],CL		;put byte at that location from C(CL)
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDIXDC	ENDP
;
	ORG	(072H*PG)+DDOP
LDIXDD	PROC	NEAR		;DD 72 dd		LD (IX+dd),D
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	[DI],DH		;put byte at that location from D(DH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIXDD	ENDP
;
	ORG	(073H*PG)+DDOP
LDIXDE	PROC	NEAR		;DD 73 dd		LD (IX+dd),E
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	[DI],DL		;put byte at that location from E(DL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIXDE	ENDP
;
	ORG	(074H*PG)+DDOP
LDIXDH	PROC	NEAR		;DD 74 dd		LD (IX+dd),H
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	[DI],BH		;put byte at that location from H(BH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIXDH	ENDP
;
	ORG	(075H*PG)+DDOP
LDIXDL	PROC	NEAR		;DD 75 dd		LD (IX+dd),L
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	[DI],BL		;put byte at that location from L(BL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIXDL	ENDP
;
	ORG	(077H*PG)+DDOP
LDIXDA	PROC	NEAR		;DD 77 dd		LD (IX+dd),A
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	[DI],AL		;put byte at that location from A(AL)  
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIXDA	ENDP
;
	ORG	(07EH*PG)+DDOP
LDAIXD	PROC	NEAR		;DD 7E dd		LD A,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IX+dd) result in DI
	MOV	AL,[DI]		;get byte at that location in A(AL)  
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDAIXD	ENDP
;
	ORG	(086H*PG)+DDOP
ADAIXD	PROC	NEAR		;DD 86 dd		ADD A,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	ADD	AL,[DI]      	;add byte from IX+displacement to A(AL)
	LAHF			;load AH from flags
	JO	ADAIXD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	JMP	ADAIXD2
ADAIXD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
ADAIXD2	EQU	$
	XOR	CL,CL
	NXTI
ADAIXD	ENDP
;
	ORG	(08EH*PG)+DDOP
ADIXDA	PROC	NEAR		;DD 8E dd		ADC A,(IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	ADC	AL,[DI]      	;add byte from IX+displacement to A(AL)
	LAHF			;load AH from flags
	JO	ADIXDA1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	JMP	ADIXDA2
ADIXDA1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
ADIXDA2	EQU	$
	XOR	CL,CL
	NXTI
ADIXDA	ENDP
;
	ORG	(096H*PG)+DDOP
SUBIXD	PROC	NEAR		;DD 96 dd		SUB (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	SUB	AL,[DI]      	;subtract byte via IX+displacement from A(AL)
	LAHF			;load AH from flags
	JO	SUBIXD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XCHG	CX,DI		;restore BC(DI) from CX
	JMP	SUBIXD2
SUBIXD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,006H		;set parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
SUBIXD2	EQU	$
	XOR	CL,CL
	NXTI
SUBIXD	ENDP
;
	ORG	(09EH*PG)+DDOP
SBCIXD	PROC	NEAR		;DD 9E dd		SBC (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	SBB	AL,[DI]      	;subtract byte via IX+displacement from A(AL)
	LAHF			;load AH from flags
	JO	SBCIXD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XCHG	CX,DI		;restore BC(DI) from CX
	JMP	SBCIXD2
SBCIXD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,006H		;set parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
SBCIXD2	EQU	$
	XOR	CL,CL
	NXTI
SBCIXD	ENDP
;
	ORG	(0A6H*PG)+DDOP
ANDIXD	PROC	NEAR		;DD A6 dd		AND (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	AND	AL,[DI]      	;AND byte via IX+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
ANDIXD	ENDP
;
	ORG	(0AEH*PG)+DDOP
XORIXD	PROC	NEAR		;DD AE dd		XOR (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	XOR	AL,[DI]      	;XOR byte via IX+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	AND	AH,0ECH		;clear aux carry, subtract and carry flags
	XOR	CL,CL
	NXTI
XORIXD	ENDP
;
	ORG	(0B6H*PG)+DDOP
ORIXD	PROC	NEAR		;DD B6 dd		OR (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	OR 	AL,[DI]      	;OR byte via IX+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	AND	AH,0ECH		;clear aux carry, subtract and carry flags
	XOR	CL,CL
	NXTI
ORIXD	ENDP
;
	ORG	(0BEH*PG)+DDOP
CPIXD	PROC	NEAR		;DD BE dd		CP (IX+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IX	;add IX to displacement
	XCHG	DI,AX		;get IX+displacement byte in DI
	SAHF			;save AH in flags
	CMP	AL,[DI]      	;CMP byte via IX+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	JO	CPIXD1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,002H		;set subtract flag 
	JMP	CPIXD2
CPIXD1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,006H		;set overflow and subtract flags
CPIXD2	EQU	$
	XOR	CL,CL
	NXTI
CPIXD	ENDP
;
	ORG	(0E1H*PG)+DDOP
POPIX	PROC	NEAR		;DD E1   		POP IX    
;				=========================================
	MOV	CX,DS:[BP+00]	;get word in CX from stack
	MOV	WORD PTR IX,CX	;put it in IX(FF70H)
	INC	BP		;pop the stack
	INC	BP
	XOR	CL,CL
	NXTI
POPIX	ENDP
;
	ORG	(0E3H*PG)+DDOP
EXSPIX	PROC	NEAR		;DD E3   		EX (SP),IX
;				=========================================
	MOV	CX,WORD PTR IX	;get IX in CX
	XCHG	CX,DS:[BP+00]	;exchange IX(CX) with word on the stack
	MOV	WORD PTR IX,CX	;stack word to IX
	XOR	CL,CL
	NXTI
EXSPIX	ENDP
;
	ORG	(0E5H*PG)+DDOP
PUSHIX	PROC	NEAR		;DD E5   		PUSH IX   
;				=========================================
	DEC	BP		;push the stack
	DEC	BP
	MOV	CX,WORD PTR IX	;get IX in CX
	MOV	DS:[BP+00],CX	;put IX on the stack
	XOR	CL,CL
	NXTI
PUSHIX	ENDP
;
	ORG	(0E9H*PG)+DDOP
JPIX  	PROC	NEAR		;DD E9   		JMP (IX)  
;				=========================================
	MOV	SI,WORD PTR IX	;set P(SI) to IX and go there
	XOR	CL,CL
	NXTI
JPIX	ENDP
;
	ORG	(0F9H*PG)+DDOP
LDSPIX	PROC	NEAR		;DD F9   		LD SP,IX  
;				=========================================
	MOV	BP,WORD PTR IX	;set SP(BP) to IX
	XOR	CL,CL
	NXTI
LDSPIX	ENDP
;
;========================================================================
;
