;============================================================================
;
;File:	Z80EM5.ASM - Z80 Emulator
;Date:  April 17, 1987
;
;============================================================================
;
	ORG	(006H*PG)+CBDDOP
CBDD06	PROC	NEAR		;xx CBdd06		RLC (IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word
	ROL	BYTE PTR [DI],1	;rotate byte via DI left one bit
	INC	BYTE PTR [DI]
	DEC	BYTE PTR [DI]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;clear aux carry and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD06	ENDP
;
	ORG	(00EH*PG)+CBDDOP
CBDD0E	PROC	NEAR		;xx CBdd0E		RRC (IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word
	ROR	BYTE PTR [DI],1	;rotate byte via DI right one bit
	INC	BYTE PTR [DI]
	DEC	BYTE PTR [DI]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;clear aux carry and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD0E	ENDP
;
	ORG	(016H*PG)+CBDDOP
CBDD16	PROC	NEAR		;xx CBdd16		RL (IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word
	RCL	BYTE PTR [DI],1	;rotate byte via DI left thru carry one bit
	INC	BYTE PTR [DI]
	DEC	BYTE PTR [DI]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;clear aux carry and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD16	ENDP
;
	ORG	(01EH*PG)+CBDDOP
CBDD1E	PROC	NEAR		;xx CBdd1E		RR (IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word
	RCR	BYTE PTR [DI],1	;rotate byte via DI right thru carry one bit
	INC	BYTE PTR [DI]
	DEC	BYTE PTR [DI]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;clear aux carry and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD1E	ENDP
;
	ORG	(026H*PG)+CBDDOP
CBDD26	PROC	NEAR		;xx CBdd26		SLA (IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word
	SHL	BYTE PTR [DI],1	;shift byte via DI left one bit
	INC	BYTE PTR [DI]
	DEC	BYTE PTR [DI]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;clear aux carry and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD26	ENDP
;
	ORG	(02EH*PG)+CBDDOP
CBDD2E	PROC	NEAR		;xx CBdd2E		SRA (IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word
	SAR	BYTE PTR [DI],1	;shift byte via DI right one bit
	INC	BYTE PTR [DI]
	DEC	BYTE PTR [DI]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;clear aux carry and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD2E	ENDP
;
	ORG	(03EH*PG)+CBDDOP
CBDD3E	PROC	NEAR		;xx CBdd3E		SRL (IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word
	SHR	BYTE PTR [DI],1	;shift byte via DI logical right one bit
	INC	BYTE PTR [DI]
	DEC	BYTE PTR [DI]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;clear aux carry and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD3E	ENDP
;
	ORG	(046H*PG)+CBDDOP
CBDD46	PROC	NEAR		;xx CBdd46		BIT 0,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],01H	;test bit 0 of byte via DI
	JZ	CBDD46A		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD46A	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD46	ENDP
;
	ORG	(04EH*PG)+CBDDOP
CBDD4E	PROC	NEAR		;xx CBdd4E		BIT 1,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],02H	;test bit 1 of byte via DI
	JZ	CBDD4EA		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD4EA	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD4E	ENDP
;
	ORG	(056H*PG)+CBDDOP
CBDD56	PROC	NEAR		;xx CBdd56		BIT 2,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],04H	;test bit 2 of byte via DI
	JZ	CBDD56A		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD56A	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD56	ENDP
;
	ORG	(05EH*PG)+CBDDOP
CBDD5E	PROC	NEAR		;xx CBdd5E		BIT 3,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],08H	;test bit 3 of byte via DI
	JZ	CBDD5EA		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD5EA	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD5E	ENDP
;
	ORG	(066H*PG)+CBDDOP
CBDD66	PROC	NEAR		;xx CBdd66		BIT 4,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],001H	;test bit 4 of byte via DI
	JZ	CBDD66A		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD66A	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD66	ENDP
;
	ORG	(06EH*PG)+CBDDOP
CBDD6E	PROC	NEAR		;xx CBdd6E		BIT 5,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],020H	;test bit 5 of byte via DI
	JZ	CBDD6EA		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD6EA	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD6E	ENDP
;
	ORG	(076H*PG)+CBDDOP
CBDD76	PROC	NEAR		;xx CBdd76		BIT 6,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],040H	;test bit 5 of byte via DI
	JZ	CBDD76A		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD76A	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD76	ENDP
;
	ORG	(07EH*PG)+CBDDOP
CBDD7E	PROC	NEAR		;xx CBdd7E		BIT 7,(IX/Y+dd)
;				=========================================
	AND	AH,029H		;clr sign,zero,alt carry,overflow,subt flags
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	TEST	BYTE PTR [DI],080H	;test bit 7 of byte via DI
	JZ	CBDD7EA		;jump if not set
	OR	AH,010H		;set alt carry flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD7EA	EQU	$
	OR	AH,054H		;set zero, alt carry and overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD7E	ENDP
;
	ORG	(086H*PG)+CBDDOP
CBDD86	PROC	NEAR		;xx CBdd86		RES 0,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],0FEH	;reset bit 0 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD86	ENDP
;
	ORG	(08EH*PG)+CBDDOP
CBDD8E	PROC	NEAR		;xx CBdd8E		RES 1,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],0FDH	;reset bit 1 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD8E	ENDP
;
	ORG	(096H*PG)+CBDDOP
CBDD96	PROC	NEAR		;xx CBdd96		RES 2,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],0FBH	;reset bit 2 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD96	ENDP
;
	ORG	(09EH*PG)+CBDDOP
CBDD9E	PROC	NEAR		;xx CBdd9E		RES 3,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],0F7H	;reset bit 3 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDD9E	ENDP
;
	ORG	(0A6H*PG)+CBDDOP
CBDDA6	PROC	NEAR		;xx CBddA6		RES 4,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],0EFH	;reset bit 4 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDA6	ENDP
;
	ORG	(0AEH*PG)+CBDDOP
CBDDAE	PROC	NEAR		;xx CBddAE		RES 5,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],0DFH	;reset bit 5 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDAE	ENDP
;
	ORG	(0B6H*PG)+CBDDOP
CBDDB6	PROC	NEAR		;xx CBddB6		RES 6,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],0BFH	;reset bit 5 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDB6	ENDP
;
	ORG	(0BEH*PG)+CBDDOP
CBDDBE	PROC	NEAR		;xx CBddBE		RES 7,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	AND  	BYTE PTR [DI],07FH	;reset bit 7 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDBE	ENDP
;
	ORG	(0C6H*PG)+CBDDOP
CBDDC6	PROC	NEAR		;xx CBddC6		SET 0,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],01H	;set bit 0 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDC6	ENDP
;
	ORG	(0CEH*PG)+CBDDOP
CBDDCE	PROC	NEAR		;xx CBddCE		SET 1,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],02H	;set bit 1 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDCE	ENDP
;
	ORG	(0D6H*PG)+CBDDOP
CBDDD6	PROC	NEAR		;xx CBddD6		SET 2,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],04H	;set bit 2 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDD6	ENDP
;
	ORG	(0DEH*PG)+CBDDOP
CBDDDE	PROC	NEAR		;xx CBddDE		SET 3,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],08H	;set bit 3 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDDE	ENDP
;
	ORG	(0E6H*PG)+CBDDOP
CBDDE6	PROC	NEAR		;xx CBddE6		SET 4,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],001H	;set bit 4 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDE6	ENDP
;
	ORG	(0EEH*PG)+CBDDOP
CBDDEE	PROC	NEAR		;xx CBddEE		SET 5,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],020H	;set bit 5 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDEE	ENDP
;
	ORG	(0F6H*PG)+CBDDOP
CBDDF6	PROC	NEAR		;xx CBddF6		SET 6,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],040H	;set bit 5 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDF6	ENDP
;
	ORG	(0FEH*PG)+CBDDOP
CBDDFE	PROC	NEAR		;xx CBddFE		SET 7,(IX/Y+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	MOV	DI,WORD PTR IZ	;get IX/IY+displacement from temp word in DI
	OR  	BYTE PTR [DI],080H	;set bit 7 of byte via DI
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
CBDDFE	ENDP
;
;
	ORG 	(009H*PG)+FDOP
ADIYBC	PROC	NEAR		;FD 09			ADD IY,BC
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	ADD	WORD PTR IY,DI	;Add BC(DI) to IY(FF70H)
	JNB	ADIYBC1		;jump on no carry
	INC	AH		;set carry flag
ADIYBC1	EQU	$
	XOR	CL,CL
	NXTI
ADIYBC	ENDP
;
	ORG 	(019H*PG)+FDOP
ADIYDE	PROC	NEAR		;FD 19			ADD IY,DE
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	ADD	WORD PTR IY,DX	;Add DE(DX) to IY(FF70H)
	JNB	ADIYDE1		;jump on no carry
	INC	AH		;set carry flag
ADIYDE1	EQU	$
	XOR	CL,CL
	NXTI
ADIYDE	ENDP
;
	ORG	(021H*PG)+FDOP
LDIYI	PROC	NEAR		;FD 21 D16		LD IY,D16
;				========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	MOV	WORD PTR IY,AX	;put immediate data in IY(FF70H)
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDIYI	ENDP
;
	ORG	(022H*PG)+FDOP
LDMIY	PROC	NEAR		;FD 22 D16		LD (D16),IY
;				========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	BX,WORD PTR IY	;save HL(BX), get IY(FF70H) in BX
	XCHG	DI,AX		;save BC(DI) in AX
	MOV	[DI],BX		;put IY in memory location D16  
	XCHG	DI,AX		;restore BC(DI) from AX
	XCHG	BX,IY		;restore HL(BX) and IY(FF70H)
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDMIY	ENDP
;
	ORG	(023H*PG)+FDOP
INCIY	PROC	NEAR		;FD 23			INC IY
;				==========================================
	INC	WORD PTR IY
	XOR	CL,CL
	NXTI
INCIY	ENDP
;
	ORG 	(029H*PG)+FDOP
ADIYIY	PROC	NEAR		;FD 29			ADD IY,IY
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	MOV	CX,WORD PTR IY	;put IY(FF70H) in CX
	ADD	WORD PTR IY,CX	;add IY(CX) to IY(FF70H)
	JNB	ADIYIY1		;jump on no carry
	INC	AH		;set carry flag
ADIYIY1	EQU	$
	XOR	CL,CL
	NXTI
ADIYIY	ENDP
;
	ORG	(02AH*PG)+FDOP
LDIYM	PROC	NEAR		;FD 2A D16		LD IY,(D16)
;				========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX
	MOV	DI,[DI]		;get memory location D16 in DI
	MOV	WORD PTR IY,DI	;put contents of mem loc D16 in IY(FF70H)
	XCHG	DI,AX		;restore BC(DI) from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDIYM	ENDP
;
	ORG	(02BH*PG)+FDOP
DECIY	PROC	NEAR		;FD 2B			DEC IY
;				==========================================
	DEC	WORD PTR IY
	XOR	CL,CL
	NXTI
DECIY	ENDP
;
	ORG	(034H*PG)+FDOP
INCIYD	PROC	NEAR		;FD 34 dd		INC (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	XCHG	DI,AX		;get displacement byte in DI
	ADD	DI,WORD PTR IY	;add IY to displacement
	SAHF			;save AH in flags
	INC	BYTE PTR [DI]	;increment byte at IY+displacement
	LAHF			;load AH from flags
	JO	INCIYD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	JMP	INCIYD2
INCIYD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
INCIYD2	EQU	$
	XOR	CL,CL
	NXTI
INCIYD	ENDP
;
	ORG	(035H*PG)+FDOP
DECIYD	PROC	NEAR		;FD 35 dd		DEC (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	XCHG	DI,AX		;get displacement byte in DI
	ADD	DI,WORD PTR IY	;add IY to displacement
	SAHF			;save AH in flags
	DEC	BYTE PTR [DI]	;decrement byte at IY+displacement
	LAHF			;load AH from flags
	JO	DECIYD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
DECIYD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
DECIYD	ENDP
;
	ORG	(036H*PG)+FDOP
LDIYDI	PROC	NEAR		;FD 36 dd d8		LD (IY+dd),d8
;				=========================================
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSB			;get 8-bit displacement byte
	CBW			;convert byte to word
	XCHG	DI,AX		;save BC(CI) in AX, get displacement in DI
	ADD	DI,WORD PTR IY	;add IY to displacement in DI
	PUSH	AX		;save BC in AX on stack
	LODSB			;get 8-bit immediate byte
	MOV	[DI],AL		;store immediate byte to (IY+displacement)
	POP	DI		;restore BC(DI) from stack
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDIYDI	ENDP
;
	ORG 	(039H*PG)+FDOP
ADIYSP	PROC	NEAR		;FD 39			ADD IY,SP
;				=========================================
	AND	AH,0FCH		;clear subtract & carry flags
	ADD	WORD PTR IY,BP	;Add SP(BP) to IY(FF70H)
	JNB	ADIYSP1		;jump on no carry
	INC	AH		;set carry flag
ADIYSP1	EQU	$
	XOR	CL,CL
	NXTI
ADIYSP	ENDP
;
	ORG	(046H*PG)+FDOP
LDBIYD	PROC	NEAR		;FD 46 dd		LD B,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	CH,[DI]		;get byte at that location in CH
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDBIYD	ENDP
;
	ORG	(04EH*PG)+FDOP
LDCIYD	PROC	NEAR		;FD 4E dd		LD C,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	CL,[DI]		;get byte at that location in CL
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDCIYD	ENDP
;
	ORG	(056H*PG)+FDOP
LDDIYD	PROC	NEAR		;FD 56 dd		LD D,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	DH,[DI]		;get byte at that location in D(DH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDDIYD	ENDP
;
	ORG	(05FH*PG)+FDOP
LDEIYD	PROC	NEAR		;FD 5E dd		LD E,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	DL,[DI]		;get byte at that location in E(DL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDEIYD	ENDP
;
	ORG	(066H*PG)+FDOP
LDHIYD	PROC	NEAR		;FD 66 dd		LD H,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	BH,[DI]		;get byte at that location in H(BH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDHIYD	ENDP
;
	ORG	(06EH*PG)+FDOP
LDLIYD	PROC	NEAR		;FD 6E dd		LD L,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	BL,[DI]		;get byte at that location in L(BL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDLIYD	ENDP
;
	ORG	(070H*PG)+FDOP
LDIYDB	PROC	NEAR		;FD 70 dd		LD (IY+dd),B
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	[DI],CH		;put byte at that location from B(CH)
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDIYDB	ENDP
;
	ORG	(071H*PG)+FDOP
LDIYDC	PROC	NEAR		;FD 71 dd		LD (IY+dd),C
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	[DI],CL		;put byte at that location from C(CL)
	XCHG	DI,CX		;then to BC(DI)
	XOR	CL,CL
	NXTI
LDIYDC	ENDP
;
	ORG	(072H*PG)+FDOP
LDIYDD	PROC	NEAR		;FD 72 dd		LD (IY+dd),D
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	[DI],DH		;put byte at that location from D(DH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIYDD	ENDP
;
	ORG	(073H*PG)+FDOP
LDIYDE	PROC	NEAR		;FD 73 dd		LD (IY+dd),E
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	[DI],DL		;put byte at that location from E(DL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIYDE	ENDP
;
	ORG	(074H*PG)+FDOP
LDIYDH	PROC	NEAR		;FD 74 dd		LD (IY+dd),H
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	[DI],BH		;put byte at that location from H(BH)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIYDH	ENDP
;
	ORG	(075H*PG)+FDOP
LDIYDL	PROC	NEAR		;FD 75 dd		LD (IY+dd),L
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	[DI],BL		;put byte at that location from L(BL)
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIYDL	ENDP
;
	ORG	(077H*PG)+FDOP
LDIYDA	PROC	NEAR		;FD 77 dd		LD (IY+dd),A
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	[DI],AL		;put byte at that location from A(AL)  
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDIYDA	ENDP
;
	ORG	(07EH*PG)+FDOP
LDAIYD	PROC	NEAR		;FD 7E dd		LD A,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save BC(DI) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get displacement byte
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY(FF70H) to displacement in AX
	XCHG	DI,AX		;put (IY+dd) result in DI
	MOV	AL,[DI]		;get byte at that location in A(AL)  
	XCHG	DI,CX		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
LDAIYD	ENDP
;
	ORG	(086H*PG)+FDOP
ADAIYD	PROC	NEAR		;FD 86 dd		ADD A,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	ADD	AL,[DI]      	;add byte from IY+displacement to A(AL)
	LAHF			;load AH from flags
	JO	ADAIYD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
ADAIYD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
ADAIYD	ENDP
;
	ORG	(08EH*PG)+FDOP
ADIYDA	PROC	NEAR		;FD 8E dd		ADC A,(IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	ADC	AL,[DI]      	;add byte from IY+displacement to A(AL)
	LAHF			;load AH from flags
	JO	ADIYDA1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
ADIYDA1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,004H		;set parity/overflow flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
ADIYDA	ENDP
;
	ORG	(096H*PG)+FDOP
SUBIYD	PROC	NEAR		;FD 96 dd		SUB (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	SUB	AL,[DI]      	;subtract byte via IY+displacement from A(AL)
	LAHF			;load AH from flags
	JO	SUBIYD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
SUBIYD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,006H		;set parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
SUBIYD	ENDP
;
	ORG	(09EH*PG)+FDOP
SBCIYD	PROC	NEAR		;FD 9E dd		SBC (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	SBB	AL,[DI]      	;subtract byte via IY+displacement from A(AL)
	LAHF			;load AH from flags
	JO	SBCIYD1		;jump on overflow
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
SBCIYD1	EQU	$
	AND	AH,0F9H		;clear parity/overflow and subtract flags
	OR	AH,006H		;set parity/overflow and subtract flags
	XCHG	CX,DI		;restore BC(DI) from CX
	XOR	CL,CL
	NXTI
SBCIYD	ENDP
;
	ORG	(0A6H*PG)+FDOP
ANDIYD	PROC	NEAR		;FD A6 dd		AND (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	AND	AL,[DI]      	;AND byte via IY+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
ANDIYD	ENDP
;
	ORG	(0AEH*PG)+FDOP
XORIYD	PROC	NEAR		;FD AE dd		XOR (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	XOR	AL,[DI]      	;XOR byte via IY+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	AND	AH,0ECH		;clear aux carry, subtract and carry flags
	XOR	CL,CL
	NXTI
XORIYD	ENDP
;
	ORG	(0B6H*PG)+FDOP
ORIYD	PROC	NEAR		;FD B6 dd		OR (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	OR 	AL,[DI]      	;OR byte via IY+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	AND	AH,0ECH		;clear aux carry, subtract and carry flags
	XOR	CL,CL
	NXTI
ORIYD	ENDP
;
	ORG	(0BEH*PG)+FDOP
CPIYD	PROC	NEAR		;FD BE dd		CP (IY+dd)
;				=========================================
	XCHG	CX,DI		;save DI(BC) in CX
	XCHG	DI,AX		;save PSW(AX) in DI
	LODSB			;get immediate byte (displacement)
	CBW			;convert byte to word
	ADD	AX,WORD PTR IY	;add IY to displacement
	XCHG	DI,AX		;get IY+displacement byte in DI
	SAHF			;save AH in flags
	CMP	AL,[DI]      	;CMP byte via IY+displacement to A(AL)
	LAHF			;load AH from flags
	XCHG	CX,DI		;restore BC(DI) from CX
	JO	CPIYD1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,002H		;set subtract flag 
	XOR	CL,CL
	NXTI
CPIYD1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,006H		;set overflow and subtract flags
	XOR	CL,CL
	NXTI
CPIYD	ENDP
;
	ORG	(0E1H*PG)+FDOP
POPIY	PROC	NEAR		;FD E1   		POP IY    
;				=========================================
	MOV	CX,DS:[BP+00]	;get word in CX from stack
	MOV	WORD PTR IY,CX	;put it in IY(FF70H)
	INC	BP		;pop the stack
	INC	BP
	XOR	CL,CL
	NXTI
POPIY	ENDP
;
	ORG	(0E3H*PG)+FDOP
EXSPIY	PROC	NEAR		;FD E3   		EX (SP),IY
;				=========================================
	MOV	CX,WORD PTR IY	;get IY in CX
	XCHG	CX,DS:[BP+00]	;exchange IY(CX) with word on the stack
	MOV	WORD PTR IY,CX	;stack word to IY
	XOR	CL,CL
	NXTI
EXSPIY	ENDP
;
	ORG	(0E5H*PG)+FDOP
PUSHIY	PROC	NEAR		;FD E5   		PUSH IY   
;				=========================================
	DEC	BP		;push the stack
	DEC	BP
	MOV	CX,WORD PTR IY	;get IY in CX
	MOV	DS:[BP+00],CX	;put IY on the stack
	XOR	CL,CL
	NXTI
PUSHIY	ENDP
;
	ORG	(0E9H*PG)+FDOP
JPIY  	PROC	NEAR		;FD E9   		JMP (IY)  
;				=========================================
	MOV	SI,WORD PTR IY	;set P(SI) to IY and go there
	XOR	CL,CL
	NXTI
JPIY	ENDP
;
	ORG	(0F9H*PG)+FDOP
LDSPIY	PROC	NEAR		;FD F9   		LD SP,IY  
;				=========================================
	MOV	BP,WORD PTR IY	;set SP(BP) to IY
	XOR	CL,CL
	NXTI
LDSPIY	ENDP
;
;========================================================================
