;File:	RASM2.ASM
;Edit date:	86/10/06.
;Serial number 4
;
;	RP/M2 Assembler scan token module.
;
SCNORG	EQU	2400H	;module fwa
;
;	Entry points in the I/O module.
;
IOMORG	EQU	0300H	;I/O module fwa
IOMGNC	EQU	IOMORG+06H	;get next source character
IOMWBF	EQU	IOMORG+15H	;write print line buffer
IOMPER	EQU	IOMORG+18H	;put error flag in print line
IOMPCF	EQU	IOMORG+21H	;process chain source file
IOMBFB	EQU	IOMORG+2DH	;blank fill print line buffer
IOMBRK	EQU	IOMORG+36H	;process console break
;
;	Locations on page 1.
;	Print line buffer.
;
PLBFWA	EQU	010CH	;line buffer fwa
PLBSIZ	EQU	120	;line length
PLBFBP	EQU	PLBFWA+PLBSIZ	;buffer fill pointer
FPRCOL	EQU	16	;source line image starting column
;
;	Assembler control data.
;
TOKEN	EQU	PLBFBP+1	;current token
VALUE	EQU	TOKEN+1		;binary value
ACCLEN	EQU	VALUE+2		;accumulator length
ACCUM	EQU	ACCLEN+1	;accumulator fwa
ACCSIZ	EQU	64
EVALUE	EQU	ACCUM+ACCSIZ	;expression value
SYTOP	EQU	EVALUE+2	;current symbol table top
SYMAX	EQU	SYTOP+2		;symbol table lwa + 1
PASSN	EQU	SYMAX+2		;pass number, 0 or 1
HEXPC	EQU	PASSN+1		;current hex fill address
LOCCN	EQU	HEXPC+2		;assembler's location counter
;
;	Ascii character codes.
;
cr	EQU	0DH		;carriage return
lf	EQU	0AH		;line feed
eof	EQU	1AH		;control-z = end of file
tab	EQU	09H		;tabulate
;
;	Token definitions.
;
IDENT	EQU	1	;identifier
NUMBR	EQU	2	;number
STRNG	EQU	3	;string
SPECL	EQU	4	;other
;
;	Symbol types.
;
TCLB	EQU	 1	;code label
TDLB	EQU	 2	;data label
TEQU	EQU	 4	;defined by EQU
TSET	EQU	 5	;defined by SET
TMAC	EQU	 6	;defined by MACRO
TEXT	EQU	 8	;defined by EXT
TREF	EQU	11	;defined by REF
TGBL	EQU	12	;defined by GLOBAL
;
;	Radix values.
;
RADBIN	EQU	 2	;binary
RADOCT	EQU	 8	;octal
RADDEC	EQU	10	;decimal
RADHEX	EQU	16	;hexadecimal
;
	ORG	SCNORG
	JMP	ENDSCN
	JMP	INS	;preset token scan
	JMP	SNT	;scan next token
;
;	Module local data space.
;
LASTC:	DB	0	;last character
NEXTC:	DB	0	;look ahead character
STYPE:	DB	0	;radix value
;
;	GNC - Get next character.
;	Get source character and copy it to
;	the print line buffer.
;
GNC:	CALL	IOMGNC	;get next source char
	PUSH	PSW
	CPI cr ! JZ GNC1	;If carriage return
	CPI lf ! JZ GNC1	;If line feed
;
;	Pack the character in the print line.
;
	LDA	PLBFBP
	CPI	PLBSIZ
	JNC	GNC1		;If line buffer is full
;
	MOV E,A ! MVI D,0
	INR A ! STA PLBFBP	;advance buffer index
	LXI	H,PLBFWA
	DAD	D
	POP	PSW
	MOV	M,A
	RET
;
;	Omit this character from the print buffer.
;
GNC1:	POP	PSW
	RET
;
;	INS - Preset token scan.
;
INS:	CALL	CTK	;clear token accumulator
	STA	NEXTC	;reset look ahead
	STA	PLBFBP	;reset print line
	MVI	A,lf	;indicate end of line
	STA	LASTC
	CALL	IOMBFB	;clear print buffer
	MVI	A,FPRCOL
	STA	PLBFBP	;mark first source code column
	RET
;
;	CTK - Clear token accumulator.
;
CTK:	XRA	A
	STA	ACCLEN
	STA	STYPE	;reset radix
	RET
;
;	SAC - Store NEXTC into token accumulator.
;
SAC:	LXI	H,ACCLEN
	MOV	A,M
	CPI	ACCSIZ
	JC	SAC1	;If space available
;
;	Token being scanned is too long.
;
	MVI	M,0	;reset accumulator
	CALL	ERO	;operand overflow error
SAC1:	MOV E,M ! MVI D,0
	INR	M	;advance token length
	INX	H	;accumulator fwa
	DAD	D
	LDA	NEXTC	;copy char into token
	MOV	M,A
	RET
;
;	TDS - Test dollar sign.
;	Entry	HL = .NEXTC
;	Exit	 Z = true, if $
;	Note:  NEXTC is cleared, if it contains "$".
;
TDS:	MOV	A,M
	CPI	'$'
	RNZ		;If not dollar sign
;
	XRA	A	;clear NEXTC
	MOV	M,A
	RET
;
;	TDD - Test decimal digit.
;	Exit	 Z = true, if NEXTC not decimal
;
TDD:	LDA	NEXTC
	SUI	'0'
	CPI	10
	RAL		;carry was set if decimal
	ANI	1
	RET
;
;	THD - Test hex digit.
;	Exit	 Z = true, if NEXTC not hex digit
;
THD:	CALL	TDD	;test decimal
	RNZ		;If decimal digit
;
	LDA	NEXTC
	SUI	'A'
	CPI	'F'-'A'+1	;carry set if hex
	RAL
	ANI	1
	RET
;
;	TAC - Test alphabetic character.
;	Exit	 Z = true, if NEXTC not letter
;
TAC:	LDA	NEXTC
	SUI	'A'
	CPI	26	;carry set if upper case
	RAL
	ANI	1
	RET
;
;	TAN - Test alphanumeric character.
;	Exit	 Z = true, if NEXTC not alphanumeric
;
TAN:	CALL	TAC
	RNZ		;If upper case letter
;
	CALL	TDD	;test decimal digit
	RET
;
;	CFC - Case fold character.
;	Entry	 A = character
;	Exit	 A = upper case character
;
CFC:	CPI 'a' ! RC	;If not lower case
	CPI 'z'+1 ! RNC	;If not lower case
	ANI	5FH
	RET
;
;	CFN - Case fold NEXTC.
;
CFN:	LDA	NEXTC
	CALL	CFC
	STA	NEXTC
	RET
;
;	GNN - Get next character to NEXTC.
;	Note:  case fold NEXTC, if not in string.
;	Exit	 A = verbatim char
;
GNN:	CALL	GNC
	STA	NEXTC
	PUSH	PSW
	LDA	TOKEN
	CPI	STRNG
	CNZ	CFN	;If not in string
	POP	PSW
	RET
;
;	ELT - End of line test.
;	Entry	 A = character
;	Exit	 Z = true, if end of line
;
ELT:	CPI '!' ! RZ	;If logical end of line
;
;	ECT - End of comment test.
;	Entry	 A = character
;	Exit	 Z = true, if end of comment
;
ECT:	CPI eof ! RZ	;If control-z
	CPI cr  ! RET	;If carriage return
;
;	Enter here when chaining to next source file:
;
SNT0:	CALL	GNN	;preset NEXTC
;
;	SNT - Scan next token.
;
SNT:	XRA	A	;reset token
	STA	TOKEN
	CALL	CTK	;clear token accumulator
;
;	Skip leading spaces.
;
SNT1:	LDA	LASTC
	MOV	C,A
	LDA	NEXTC
	CALL	IOMPCF		;check leading "%"
	JZ	SNT0		;If chaining to new file
;
	CPI tab ! JZ SNT4	;If tab, same as blank
	CPI ';' ! JZ SNT2	;If comment preamble
	CPI '*' ! JNZ SNT3	;If not Proc Tech comment
;
;	Process Processor Technology comment.
;
	LDA	LASTC
	CPI lf  ! JNZ SNT3	;If not first char of line
;
;	Process comment string.
;
SNT2:	CALL	GNN	;get & print next character
	CALL	ECT
	JZ	SNT5	;If end of line
;
	JMP	SNT2	;loop to end of comment string
;
;	Check blank or 00.
;
SNT3:	ORI	' '
	CPI	' '
	JNZ	SNT5	;If non-blank found
;
;	We have 20H or 00H.
;
SNT4:	CALL	GNN	;get & print next character
	JMP	SNT1	;loop to non-blank character
;
;	We have found a non-blank character.
;	Identify the token type.
;
SNT5:	CALL	TAC
	JZ	SNT6	;If not a letter
;
;	Token = identifier.
;
	MVI	A,IDENT
	JMP	SNT10
;
SNT6:	CALL	TDD
	JZ	SNT7	;If not decimal digit
;
;	Token = numeric.
;
	MVI	A,NUMBR
	JMP	SNT10
;
SNT7:	LDA	NEXTC
	CPI	''''
	JNZ	SNT8	;If not string
;
;	Token = string.
;
	XRA	A	;omit quote mark
	STA	NEXTC
	MVI	A,STRNG
	JMP	SNT10
;
;	Token = other.
;
SNT8:	CPI	lf
	JNZ	SNT9	;If not end of line
;
;	We are at an end of source line.
;
	LDA	PASSN
	ORA	A
	CNZ	IOMWBF	;If pass 2
;
	LXI	H,PLBFWA	;clear error flag
	MVI	M,' '
	MVI	A,FPRCOL	;reset 1st source column
	STA	PLBFBP
	CALL	IOMBRK		;process console break
;
SNT9:	MVI	A,SPECL
SNT10:	STA	TOKEN
;
;	MNT - Move token into accumulator.
;
MNT:	LDA	NEXTC	;save last char
	STA	LASTC
	ORA	A
	CNZ	SAC	;If not marked to ignor
	CALL	GNN	;get & print next char
	LDA	TOKEN
	CPI	SPECL
	RZ		;If "other," we are done
;
;	Process identifier, number, or string.
;
	CPI	STRNG
	CNZ	CFN	;If not string, case fold NEXTC
	LXI	H,NEXTC
	LDA	TOKEN
	CPI	IDENT
	JNZ	MNT1	;If not identifier
;
;	Process identifier.
;
	CALL	TDS	;accept imbedded dollar signs
	JZ	MNT	;If "$"
;
	CALL	TAN
	RZ		;If not alphanumeric
;
	JMP	MNT	;loop to end of token
;
;	Process number or string.
;
MNT1:	CPI	NUMBR
	JNZ	MNT10	;If not number
;
;	Process number.
;
	CALL	TDS	;accept imbedded dollar signs
	JZ	MNT	;If "$"
;
	CALL	THD
	JNZ	MNT	;If hex digit, ok
;
;	We are at the end of a number.
;
	LDA	NEXTC	;check radix
	CPI 'O' ! JZ MNT2	;If octal
	CPI 'Q' ! JNZ MNT3	;If not octal
;
;	Set octal radix.
;
MNT2:	MVI	A,RADOCT
	JMP	MNT4
;
MNT3:	CPI 'H' ! JNZ MNT5	;If not hex
;
;	Set hexadecimal radix.
;
	MVI	A,RADHEX
MNT4:	STA	STYPE
	XRA	A	;clear look ahead
	STA	NEXTC
	JMP	MNT9
;
;	Binary or decimal radix indicator will
;	have been moved into the accumulator.
;
MNT5:	LDA	LASTC
	CPI 'B' ! JNZ MNT6	;If not binary
;
;	Set binary radix.
;
	MVI	A,RADBIN
	JMP	MNT7
;
MNT6:	CPI 'D'
	MVI	A,RADDEC
	JNZ	MNT8	;If not decimal
;
;	Remove radix indicator from the accumulator.
;
MNT7:	LXI	H,ACCLEN
	DCR	M
MNT8:	STA	STYPE	;store radix
;
;	Convert the accumulator to a binary value.
;
MNT9:	CALL	CAB
	RET
;
;	Process string.
;
MNT10:	LDA	NEXTC
	CPI	cr
	JZ	ERO	;If missing end quote mark
;
	CPI	''''
	JNZ	MNT	;If not end of string
;
;	Check double quote.
;
	CALL	GNN	;get & print next char
	CPI	''''
	RNZ		;If not double quote
;
;	Process quoted quote mark.
;
	JMP	MNT	;loop to end of string
;
;	CAB - Convert accumulator to binary.
;	Exit	VALUE = binary value
;
CAB:	LXI	H,0	;reset binary value
	SHLD	VALUE
	LXI	H,ACCLEN
	MOV	C,M	;digit count
	INX	H	;string fwa
;
;	Process next digit.
;
CAB1:	MOV	A,M
	INX	H	;advance index
	CPI	'A'
	JNC	CAB2	;If hex digit
;
	SUI	'0'
	JMP	CAB3
;
CAB2:	SUI	'A'-10
CAB3:	PUSH	H	;save index
	PUSH	B	;save digit count
	MOV	C,A
	LXI	H,STYPE	;radix value
	CMP	M
	CNC	ERV	;If digit undefined
;
	MVI	B,0	;BC=binary value of digit
	MOV	A,M	; A=radix
	LHLD	VALUE	;DE=accumulated value
	XCHG
	LXI	H,0	;HL=product accumulator
;
;	Multiply VALUE by radix.
;
CAB4:	ORA A ! JZ CAB6	;If multiply complete
	RAR ! JNC CAB5	;If radix lsb = 0
	DAD	D
;
;	Shift VALUE left.
;
CAB5:	XCHG
	DAD	H
	XCHG
	JMP	CAB4
;
;	Add in the next digit.
;
CAB6:	DAD	B
	SHLD	VALUE
	POP	B	;restore char count
	POP	H	;restore index
	DCR	C
	JNZ	CAB1	;loop over accumulator digits
	RET
;
;	ERV - Process error flag V.
;	Value error.
;
ERV:	PUSH	PSW
	MVI	A,'V'
	JMP	ERR
;
;	ERO - Process error flag O.
;	Operand overflow error.
;
ERO:	PUSH	PSW
	MVI	A,'O'
	JMP	ERR
;
;	ERR - Process error flag.
;	Entry	 A = error flag Ascii char
;	Enter with PSW pushed on stack.
;
ERR:	PUSH B ! PUSH H
	CALL	IOMPER	;pack error flag in print line
	POP H ! POP B
	POP	PSW
	RET
;
ENDSCN	EQU	($ AND 0FF00H) + 100H
