;File	RDOS1.ASM
;Edit date:	86/02/20.
;
;	WPD - Write protect disk.
;	Exit  CDISK marked read-only
;	Logical end of directory set to directory size
;
RFWPD	EQU	$
WPD:	LXI	H,ROVEC
	MOV C,M ! INX H ! MOV B,M
	CALL	SVB	;set bit for CDISK
	SHLD	ROVEC
;
;	Set directory logical end = physical end.
;
WPD1:	LHLD	DPBDRM	;directory size
	INX	H
	XCHG
;
;	Entry	DE = logical end of directory
;	Exit	BC = previous logical end of directory
;
WPD2:	LHLD	DTMP1	;set logical end of directory
	MOV C,M ! MOV M,E ! INX H
	MOV B,M ! MOV M,D
	RET
;
;	TRO - Test file read-only.
;	Exit to error processor if file R/O
;
TRO:	CALL	ADE	;address directory entry
TRO1:	LXI	D,9	;get t1'
	DAD	D
	MOV	A,M
	RAL		;t1' to carry
	RNC		;If not marked R/O
;
;	File is marked read-only.
;	Jump indirect to error processor.
;
	LXI	H,RPMA+6	;file R/O processor
	JMP	JPI
;
;	TRO2 - Test disk read-only.
;	Exit to error processor if disk R/O
;
TRO2:	CALL	DRO	;check R/O vector
	RZ		;If read/write
;
;	Disk marked read-only.
;	Jump indirect to error processor.
;
	LXI	H,RPMA+4	;disk R/O processor
	JMP	JPI
;
;	ADE - Address directory entry.
;	Exit	HL = directory entry fwa in DIRBUF
;
ADE:	LHLD	DIRLOC	;directory buffer fwa
	LDA	DBINDX
;
;	HLA - Set HL = HL + A.
;
HLA:	ADD L ! MOV L,A ! RNC	;If calc complete
	INR H ! RET
;
;	CNF - Create new file.
;
CNF:	CALL	TRO2	;test disk read-only
	LHLD	EARGDE	;save fcb
	PUSH	H
	LXI	H,EMPTY	;"E5"
	SHLD	EARGDE
;
	CALL	WPD1	;set full dir search
	PUSH	B
	MVI	C,1	;compare FNT 1 char only
	CALL	SFF	;find an empty dir space
	CALL	CAI	;advance index
	POP	D	;restore logical end dir
	CALL	WPD2
	POP	H
	SHLD	EARGDE
	RZ		;If directory full
;
	XCHG		;clear rc and RBT
	LXI	H,15
	DAD	D
	MVI	C,1+16
	XRA	A
CNF1:	MOV M,A ! INX H ! DCR C
	JNZ	CNF1	;loop through RBT
;
	CALL	ADO	;update directory eoi
	CALL	CFD	;copy fcb to directory
;
;	MNW - Mark file not written.
;	Set high bit of fcb byte s2.
;
MNW:	CALL	GS2	;get s2
	ORI	80H
	MOV	M,A
	RET
;
;	TED - Test logical end of directory.
;	Exit	HL = logical max dir ordinal
;		DE = directory ordinal
;		carry set, if ord < logical end of dir
;
TED:	LHLD	DIRORD
	XCHG
	LHLD	DTMP1	;logical end of directory
;
;	Compare  current ordinal : logical max ordinal
;
	MOV A,E ! SUB M ! INX H
	MOV A,D ! SBB M ! RET
;
;	ADO - Advance directory ending ordinal.
;	Mark the end of the active directory entries.
;
ADO:	CALL	TED	;test logical end
	RC		;If not past current logical end
;
	INX	D	;update logical end of dir
	MOV M,D ! DCX H ! MOV M,E
	RET
;
;	DMH - Calculate HL = DE - HL.
;
DMH:	MOV A,E ! SUB L ! MOV L,A
	MOV A,D ! SBB H ! MOV H,A
	RET
;
;	PDC - Process directory checksum.
;
PDC:	MVI	C,0FFH	;set calculate flag
;
PDC1:	LHLD	RECORD	;record ordinal
	XCHG
	LHLD	DPBCKS	;check size
	CALL	DMH
	RNC		;If done
;
	PUSH	B
	CALL	CCS	;A=checksum
	LHLD	CSVLOC	;checksum vector fwa
	XCHG
	LHLD	RECORD	;record ordinal
	DAD	D
	POP	B
	INR	C
	JZ	PDC2	;If calculating new checksum
;
;	Compare old and new checksums.
;
	CMP	M
	RZ		;If checksums agree
;
;	Disk evidently has been swapped.
;	Mark this drive read-only.
;
	CALL	WPD
	RET
;
;	Store new checksum in check vector.
;
PDC2:	MOV	M,A
	RET
;
;	CFD - Copy fcb values to directory.
;
CFD:	MVI	C,0	;fcb ordinal
	MVI	E,32	;byte count
;
;	Entry	 C = offset into fcb
;		 E = byte count
;
CFD1:	PUSH	D	;save byte count
	MVI	B,0
	LHLD	EARGDE	;fcb fwa
	DAD	B
	XCHG		;DE=start loc
	CALL	ADE	;HL=dir entry loc
	POP	B
	CALL	MCB	;move fcb bytes to dir
CFD2:	CALL	PPD	;position disk
;
;	DDB - Dump directory buffer to disk.
;
DDB:	CALL	SDA	;set DMA=dirbuf
	MVI	C,1	;CBIOS flag=directory write
	CALL	WDR
	CALL	PDC	;calculate checksum
	JMP	RUA	;go restore DMA
;
;	LDB - Load directory buffer from disk.
;
LDB:	CALL	SDA	;set DMA=dirbuf
	MVI	C,1	;CBIOS flag=directory read
	CALL	RDR
;
;	RUA - Restore user's DMA address.
;
RUA:	LXI	H,USRDMA
	JMP	SDA1
;
;	SDA - Set directory DMA.
;
SDA:	LXI	H,DIRLOC	;point to dir buf fwa
;
;	SDA1 - Set DMA.
;	Entry	HL = address of location containing DMA
;
SDA1:	MOV C,M ! INX H ! MOV B,M
	JMP	BIODMA	;CBIOS set DMA
;
;	CAI - Check advanced directory index.
;	Exit	HL = directory ordinal
;		 Z = true, if dirord=FFFF
;
CAI:	LHLD	DIRORD
	MOV	A,L
	CMP	H
	RNZ		;If not at end
;
	INR	A
	RET
;
;	ANE0 - Reset directory ordinal.
;
ANE0:	LXI	H,-1	;reset directory ordinal
	SHLD	DIRORD
	RET
;
;	ANE - Access next directory entry.
;	Entry	 C = checksum processing flag
;
ANE:	LHLD	DPBDRM	;max number of dir entries
	XCHG
	LHLD	DIRORD	;advance dir ord
	INX	H
	SHLD	DIRORD
;
	CALL	DMH	;HL=max-ord
	JC	ANE0	;If physical end of dir
;
ANE1:	LDA	DIRORD	;form buffer ord 0,1,2,3
	ANI	3
	MVI	B,5	;*32
ANE2:	ADD	A
	DCR	B
	JNZ	ANE2	;loop to multiply by 32
;
	STA	DBINDX	;index this entry
	ORA	A
	RNZ		;If entry is in buffer
;
;	Load the directory buffer.
;
	PUSH	B
	CALL	PPD	;position the disk
	CALL	LDB	;load directory buffer
	POP	B
	JMP	PDC1	;go process sector checksum
;
;
;	GRB - Get RBR bit.
;	Entry	BC = record block name
;	Exit	 A = RBR byte, block bit low
;		 D = bit ordinal
;		HL = byte address
;
GRB:	MOV	A,C	;form bit ord within byte
	ANI	7
	INR	A
	MOV E,A ! MOV D,A
;
	MOV	A,C	;BC=BC/8
	RRC ! RRC ! RRC
	ANI	1FH
	MOV	C,A
;
	MOV	A,B
	ADD A ! ADD A ! ADD A ! ADD A ! ADD A
	ORA	C
	MOV	C,A
;
	MOV	A,B
	RRC ! RRC ! RRC
	ANI	1FH
	MOV	B,A
;
	LHLD	RBRLOC	;RBR fwa
	DAD	B
	MOV	A,M
;
GRB1:	RLC
	DCR	E
	JNZ	GRB1	;loop to rotate bit low
	RET
;
;	TRB - Toggle reservation bit.
;	Entry	BC = record block
;		 E = 0 to clear
;		   = 1 to set
;
TRB:	PUSH	D
	CALL	GRB	;get RBR bit
	ANI	0FEH
	POP	B
	ORA	C
;
;	Restore bit position.
;
TRB1:	RRC
	DCR	D
	JNZ	TRB1	;loop to restore rotation
;
	MOV	M,A
	RET
;
;	PRT - Process record block table.
;	Entry	 C = 0 to clear RBR
;		   = 1 to set RBR
;
PRT:	CALL	ADE	;address directory entry
	LXI	D,16	;set HL=RBT fwa
	DAD	D
;
	PUSH	B
	MVI	C,16+1
PRT1:	POP	D
	DCR	C
	RZ		;If end of RBT entry
;
	PUSH	D
	LDA	RBTBF	;byte or word flag
	ORA	A
	JZ	PRT2	;If RBT words
;
;	Get RBT byte.
;
	PUSH	B
	PUSH	H
	MOV	C,M
	MVI	B,0
	JMP	PRT3
;
;	Get RBT word.
;
PRT2:	DCR	C
	PUSH	B
	MOV	C,M
	INX	H
	MOV	B,M
	PUSH	H
;
PRT3:	MOV	A,C
	ORA	B
	JZ	PRT4	;If empty RBT entry
;
	LHLD	DPBDSM	;max block number
	MOV A,L ! SUB C
	MOV A,H ! SBB B
	CNC	TRB	;If valid block number
;
PRT4:	POP	H
	INX	H
	POP	B
	JMP	PRT1
;
;
;	Process function 14.
;	Select disk.
RFSEL	EQU	$
;
;	SEL - Select disk.
;
SEL:	CALL	GDI	;check CDISK logged out
	LXI	H,CDISK
	JNZ	SEL1	;If CDISK logged in
;
;	Mark CDISK logged out.
;
	DCR	A
	MOV	M,A
SEL1:	LDA	EARGE	;entry E = disk number
	CMP	M
	RZ		;If we are now there
;
	MOV	M,A	;set CDISK
;
;	LDC - Log in CDISK.
;
LDC:	CALL	GDI	;HL=rotated log-in vector
	PUSH	H	;save rotated vector
	CALL	SDC	;select CDISK
	POP	H
	JZ	JPI0	;If device undefined
;
	MOV 	A,L
	RAR
	RC		;If drive already logged in
;
	LHLD	LGVEC
	MOV C,L ! MOV B,H
	CALL	SVB	;set vector bit CDISK
	SHLD	LGVEC
;
;	PDL - Process disk log-in.
;
;	Calculate number of bytes in RBR.
;
PDL:	LHLD	DPBDSM	;form max blk number/8
	MVI	C,3
	CALL	HRC
	INX	H
	MOV B,H ! MOV C,L	;BC=RBR byte count
;
;	Clear the RBR.
;
	LHLD	RBRLOC	;RBR fwa
PDL1:	MVI	M,0
	INX	H
	DCX	B
	MOV A,B ! ORA C
	JNZ	PDL1	;loop over RBR
;
;	Reserve the directory blocks.
;
	LHLD	DPBALB	;directory bits
	XCHG
	LHLD	RBRLOC
	MOV M,E ! INX H ! MOV M,D
;
	CALL	BIOHOM	;for 2.2 CBIOS compatibility
	LHLD	DTMP1	;preset logical end of dir
	MVI	M,3
	INX	H
	MVI	M,0
	CALL	ANE0	;reset directory ordinal
;
PDL2:	MVI	C,0FFH	;flag calc new checksums
	CALL	ANE	;access next directory entry
	CALL	CAI	;advance index
	RZ		;If done
;
	CALL	ADE	;address dir entry
	MOV	A,M
	ANI	0E0H
	JNZ	PDL2	;If not an RBT
;
;	We have an active directory entry.
;	Watch for "submit" file.
;
	LDA	CUSER
	CMP	M
	JNZ	PDL3	;If not this user's file
;
;	File belongs to current user, check '$$$.SUB'.
;
	INX	H
	MOV	A,M
	SUI	'$'
	JNZ	PDL3	;If not '$$$.SUB'
;
	LDA	CDISK	;indicate "submit" found
	INR	A
	STA	RARGA
;
PDL3:	MVI	C,1	;set RBR bits
	CALL	PRT	;set bits for this RBT
	CALL	ADO	;mark end of active entries
	JMP	PDL2
;
;	Process function 22.
;	Rename file.
;
RFREN	EQU	$
	CALL	PDS	;select disk
	CALL	REN	;rename FNT
;
;	RFF - Return file-found flag.
;
RFF:	LDA	FFFLAG
	JMP	RBV
;
;	CEX - Check physical extent.
;	Ignore logical extent bits.
;	Entry	BC = character indexes
;		DE = .fcb extent byte
;		HL = .dir extent byte
;	Exit	 Z = true, if physical exts match
;		BC = character indexes
;
CEX:	PUSH	B
	LDA	DPBEXM	;B=inverted ext mask
	CMA
	MOV	B,A
;
	MOV	A,M	;C=dir phy ext
	ANA	B
	MOV	C,A
;
	LDAX	D	;A=fcb phy ext
	ANA 	B
	CMP	C
;
	POP	B
	RET
;
;	PSF - Preset search for first occurence.
;	Entry	 C = compare length
;	Exit	HL = .fcb
;
PSF:	LXI	H,FSLEN	;set compare length
	MOV	M,C
	INX	H	;preset file not found
	MVI	M,0FFH
	LHLD	EARGDE	;set fcb fwa
	SHLD	FSFCB
	RET
;
;	DXU - Disable access to user 0.
;	Search only for the current user's files.
;
	IF	USRCOM
DXU:	LDA	CUSER
	STA	CSFNA
	RET
	ENDIF
	IF	NOT USRCOM
DXU	EQU	$
	ENDIF
;
;	SFF - Search for first occurence.
;	Entry	 C = compare length of FNT
;
SFF:	CALL	PSF	;preset search
SFF1:	CALL	ANE0	;reset directory ordinal
	CALL	BIOHOM	;for 2.2 CBIOS compatibility
;
;	SFN - Search for next occurence.
;
SFN:	MVI	C,0	;flag check dir checksums
	CALL	ANE	;access next directory entry
	CALL	CAI	;check advanced index
	JZ	SFN8	;If physical end of directory
;
	CALL	TED	;test end of active entries
	JNC	SFN8	;If logical end of directory
;
	LHLD	FSFCB	;DE=fcb fwa
	XCHG
;
SFN1:	CALL	ADE	;address directory entry
	LDA	FSLEN	;compare length
	MOV	C,A
	MVI	B,0	;char index
;
SFN2:	MOV	A,C	;check end of compare
	ORA	A
	JZ	SFN7	;If file found
;
;	Continue comparing FNTs.
;
	MOV	A,B
	CPI	0DH
	JZ	SFN5	;If unused byte
;
	CPI	0CH
	JZ	SFN4	;If ex byte
;
	CPI	0EH
	JZ	SFN3	;If s2 byte
;
	LDAX	D	;get fcb char
	CPI	'?'
	JZ	SFN5	;If ambiguous, hit
;
	MOV	A,B
	ORA	A
	JNZ	SFN3	;If not fcb(0)
;
;	We are checking fcb(0).
;
	LDAX	D
	CPI	0E5H
	JZ	SFN3	;If searching for empty
;
	MOV	A,M	;dir(0)
	ANI	0E0H
	JNZ	SFN	;If not an FNT entry
;
	MOV	A,M	;dir(0)
	CPI	0
CSFNA	EQU	$-1
	JZ	SFN5	;If user 0 file
;
SFN3:	LDAX	D
	SUB	M
	ANI	7FH
	JNZ	SFN	;If mismatch, advance dir
	JMP	SFN5	;advance compare
;
;	Process the extent byte.
;
SFN4:	CALL	CEX	;compare physical extents
	JNZ	SFN	;If mismatch, advance dir
;
;	Filenames match thus far, continue compare.
;
SFN5:	INX	D	;advance fcb
	INX	H	;advance dir
	INR	B	;advance char position
	DCR	C	;advance compare downcount
	JMP	SFN2
;
;	File found.
;
SFN7:	LDA	DIRORD	;set dir buff ordinal
	ANI	3
	STA	RARGA
	STA	FFFLAG		;mark file found
	RET
;
;	File not found.
;
SFN8:	CALL	ANE0	;reset directory ordinal
	MVI	A,0FFH	;return "not found"
	JMP	RBV
;
;	DEL - Delete file.
;
DEL:	CALL	TRO2	;test disk R/O
	MVI	C,1+8+3	;match through t3
	CALL	DXU	;find first occurence
	CALL	SFF
DEL1:	CALL	CAI	;advance index
	RZ		;If end of directory
;
	CALL	TRO	;test file R/O
	CALL	ADE	;address dir entry
	MVI	M,0E5H	;mark file erased
	MVI	C,0	;clear RBR bits
	CALL	PRT
	CALL	DDB	;rewrite dir record
	CALL	SFN	;find next occurence
	JMP	DEL1
;
;	RNB - Reserve next record block.
;	Entry	BC = last block used
;	Exit	HL = next nearby block, reserved
;		   = 0000 if disk full
;
RNB:	MOV D,B ! MOV E,C
RNB1:	MOV A,C ! ORA B
	JZ	RNB2	;If no previous block
;
;	We are extending an existing file.
;	Find a nearby block.
;	Look back.
;
	DCX	B
	PUSH D ! PUSH B
	CALL	GRB	;get RBR bit BC
	RAR
	JNC	RNB3	;If this block is available
;
	POP B ! POP D
;
;	Check disk limit.
;
RNB2:	LHLD	DPBDSM	;max block number
	MOV A,E ! SUB L
	MOV A,D ! SBB H
	JNC	RNB4	;If disk end reached
;
;	Look forward.
;
	INX	D
	PUSH B ! PUSH D
	MOV B,D ! MOV C,E
	CALL	GRB	;get RBR bit BC
	RAR
	JNC	RNB3	;If this block is available
;
	POP D ! POP B
	JMP	RNB1
;
;	Reserve this block.
;
RNB3:	RAL
	INR	A	;set RBR bit
	CALL	TRB1
	POP	H	;block number
	POP	D
	RET
;
RNB4:	MOV	A,C
	ORA	B
	JNZ	RNB1	;If lower side not exhausted
;
;	The disk is full.
;
	LXI	H,0
	RET
;
;	REN - Rename file.
;
REN:	LHLD	EARGDE	;copy user number
	MOV	E,M
	MVI	A,16
	STA	RENA	;copy FNT from fcb(16)
	CALL	HLA
	MOV	M,E
;
REN1:	CALL	TRO2	;test disk R/O
	MVI	C,1+8+3	;compare FNTs through t3
	CALL	DXU	;find first occurence
	CALL	SFF
;
REN2:	CALL	CAI	;advance index
	RZ		;If end of directory
;
	LDA	RENA
	ORA	A
	CNZ	TRO	;If rename, test file R/O
;
;	Copy the new FNT.
;
	MVI	C,16	;start at fcb(C)
RENA	EQU	$-1
	MVI	E,1+8+3	;byte count
	CALL	CFD1
;
	CALL	SFN	;find next occurence
	JMP	REN2
;
;	SAT - Set file attributes.
;
SAT:	XRA	A	;copy FNT from fcb(0)
	STA	RENA
	JMP	REN1
;
;	OVH - Open file via hash table.
;	Exit	 Z = true, if file not found
;		 C = 0     if file not found
;		   = 1     if found
;
OVH:	MVI	C,1+8+3+3	;compare FNTs through s2
	CALL	PSF
	MVI	C,1+8+3+3	;hash=sum through s2
	XRA	A
	CALL	CCS2
	CALL	PDA	;CBIOS get HL=dirord
	MOV	A,L
	ANI	0FCH
	MOV	L,A
	DCX	H
	SHLD	DIRORD
	CALL	SFN	;search for file
	INR	A
	RNZ		;If file found
;
;	Quick search did not find the file.
;	Search directory from the beginning.
;
	CALL	SFF1
	INR	A
	RET
;
;	OPN - Open file.
;
OPN:	CALL	OVH	;search via hash table
	RZ		;If file not found
;
;	File found.  Note: C is nonzero.
;
OPN1:	LHLD	DIRORD	;put dirord in hash table
	CALL	PDA
;
;	Copy directory entry to fcb.
;
	CALL	AEX	;HL=fcb address of ex byte
	MOV	A,M
	PUSH	PSW	;save fcb ext and its loc
	PUSH	H
;
	CALL	ADE	;HL=dir entry loc
	XCHG
	LHLD	EARGDE	;HL=fcb loc, DE=dir loc
	MVI	C,32	;byte count
	PUSH	D
	CALL	MCB	;move dir to fcb
	CALL	MNW	;mark file not written
;
	POP	D	;get c=dir ext
	LXI	H,12
	DAD	D
	MOV	C,M
;
	LXI	H,15	;get B=dir record count
	DAD	D
	MOV	B,M
;
	POP	H	;restore original ext in fcb
	POP	PSW
	MOV	M,A
;
	MOV	A,C	;dir ext - fcb ext
	CMP	M
	MOV	A,B	;dir rc
	JZ	OPN2	;If the end extent
;
;	We are opening a non-end extent.
;	Reset record count=0 if moving forward,
;	or set full extent =80H if moving back.
;
	MVI	A,0
	JC	OPN2	;If moving forward
;
	MVI	A,80H
OPN2:	LHLD	EARGDE	;set fcb record count
	LXI	D,15
	DAD	D
	MOV	M,A
	RET
;
;	CLO - Close file.
;	Copy fcb RBT to directory RBT.
;	Any existing directory RBT must match fcb values.
;
CLO:	CALL	TRO2	;check disk R/O
	CALL	GS2	;check file written
	ANI	80H
	RNZ		;If file not written
;
	CALL	DXU	;find first (and only) occurence
	CALL	OVH
	RZ		;If file not found
;
;	File found.
;
	LXI	B,16	;set DE=dir RBT fwa
	CALL	ADE
	DAD	B
	XCHG
;
	LHLD	EARGDE	;set HL=fcb RBT fwa
	DAD	B
	MVI	C,16	;RBT byte count
;
;	Process RBT bytes.
;
CLO1:	MOV	A,M
	ORA	A
	LDAX	D
	JNZ	CLO2	;If fcb RBT occupied
;
;	The fcb RBT byte is empty.
;
	MOV	M,A	;copy dir RBT to fcb RBT
CLO2:	ORA	A
	JNZ	CLO3	;If dir RBT occupied
;
;	Directory RBT empty, copy fcb to dir.
;
	MOV	A,M
	STAX	D
CLO3:	CMP	M
	JNZ	CLO7	;If RBTs mismatch, don't close
;
	INX D ! INX H
	DCR	C	;advance RBT byte
	JNZ	CLO1	;loop to end of RBT
;
	LXI	B,-20	;set DE=fcb ext byte
	DAD	B
	XCHG
	DAD	B	;set HL=dir ext byte
	DCX	H	;clear archive attribute
	MVI	A,7FH
	ANA	M
	MOV	M,A
	INX	H
	LDAX	D
	CMP	M
	JC	CLO6	;If dir ext > fcb ext
;
;	We have fcb logical ext > or = dir logical ext.
;	Update directory from fcb extent and rc.
;
	MOV	M,A	;set dir ext = fcb ext
	LXI	B,3
	DAD	B
	XCHG
	DAD	B
	MOV	A,M	;set dir rc = fcb rc
	STAX	D
;
CLO6:	MVI	A,0FFH	;enable extent mask
	STA	ENEXM
	JMP	CFD2	;go write directory
;
;	Close error.
;
CLO7:	LXI	H,RARGA	;return A=FF
	DCR	M
	RET
;
;	AFX - Advance file extent.
;	Advance write access.
;
AFX:	XRA	A	;disable ext mask
	STA	ENEXM
	CALL	CLO	;close previous extent
;
;	If closed, extent mask is now enabled.
;
	CALL	CAI	;advance index
	RZ		;If directory full
;
;	Advance read access.
;	Read enters with extent mask disabled.
AFX0:	CALL	AEX	;advance extent
	INR	M
	JZ	AFX1	;If ext > 255
;
;	Apply the extent mask.
;
	MOV	B,M
	LDA	DPBEXM
	ANA	B
	LXI	H,ENEXM
	ANA	M
	JZ	AFX2	;If new physical ext required
;
;	The directory entry is already in the buffer.
;
	JMP	AFX3	;open next logical extent
;
AFX1:	LXI	B,2	;advance s2
	DAD	B
	INR	M
	JZ	AFX5	;If file size limit exceeded
;
AFX2:	CALL	OVH	;open new ext via hash table
	JNZ	AFX3	;If new extent found
;
;	Next extent does not exist.
;
	LDA	RDSEQ
	INR	A
	JZ	AFX5	;If read sequential, eoi
;
;	We are writing.
;
	CALL	CNF	;create next physical ext
	CALL	CAI
	JZ	AFX5	;If no directory space
	JMP	AFX4
;
AFX3:	CALL	OPN1	;finish opening this ext
AFX4:	CALL	RID	;set record ID values
	XRA	A	;return A=0
	JMP	RBV
;
;	Indicate error condition.
;
AFX5:	CALL	RBV1	;return A=1
	JMP	MNW	;mark file not written
;
;	PBZ - Process block zero-fill.
;	Entry	AHL = record ordinal
;		  C = CBIOS blocking control flag
;
PBZ:	MOV	B,A
	LDA	ACFLAG
	ANA	C	;.and. new block
	DCR A ! DCR A
	RNZ		;If not write w/zero fill
;
;	Process random write with zero fill.
;	Clear directory buffer to use for zero data fill.
;
	PUSH B ! PUSH H	;save record ordinal
	LHLD	DIRLOC	;dir buffer fwa
	MOV	D,A	;reset byte counter
PBZ1:	MOV	M,A
	INX	H
	INR	D
	JP	PBZ1	;loop for 128 bytes
;
	LDA	DPBBLM	;B=rec/blk
	INR	A
	MOV	B,A
	MVI	C,2	;C=suppress pre-read
	PUSH	B
	CALL	SDA	;set DMA=dirbuf
	CALL	CFO	;AHL=ordinal, 1st rec of blk
	POP	B
PBZ2:	SHLD	DRORD	;set next record ordinal
	STA	DRORD+2
	PUSH	B
	CALL	PPD1	;position disk
	POP B ! PUSH B
	CALL	WDR	;write record
	LHLD	DRORD	;advance record ordinal
	LDA	DRORD+2
	LXI	D,1
	DAD	D
	ACI	0
	POP	B	;advance record count
	MVI	C,0	;normal pre-read
	DCR	B
	JNZ	PBZ2	;loop over entire block
;
;	Record block has been filled with 00.
;
	POP H ! POP B	;restore record ordinal
	SHLD	DRORD
	MOV	A,B
	STA	DRORD+2
	JMP	RUA	;restore user's DMA
;
;	WSR - Write sequential record.
;
WSR:	MVI	A,1	;set access control=seq
	STA	ACFLAG
;
;	Write record.
;	Entry	ACFLAG = 0  random
;			 1  sequential
;			 2  random write w/zero fill
;
WSR1:	MVI	A,0	;indicate write
	STA	RDSEQ
	CALL	TRO2	;test disk read-only
	LHLD	EARGDE	;test file read-only
	CALL	TRO1
	CALL	RID	;get current record ID
;
;	Verify valid record ordinal within logical extent.
;
	LDA	FCBCR
	CPI	80H
	JNC	RBV1	;If cr invalid, return A=1
;
	CALL	GBL	;get record block
	CALL	CBE	;check block empty
	MVI	C,0
	JNZ	WSR6	;If block not empty
;
;	Reserve a new block.
;
	CALL	FRO	;form A=RBT ord in dir entry
	STA	RBTORD
	LXI	B,0000
	ORA	A
	JZ	WSR2	;If new phy ext
;
;	Same physical extent.
;
	MOV	C,A
	DCX	B
	CALL	RBE	;HL=previous block
	MOV B,H ! MOV C,L
;
;	Reserve a nearby block.
;
WSR2:	CALL	RNB	;reserve next block
	MOV A,L ! ORA H
	JNZ	WSR3	;If block reserved
;
;	Disk is full, return A=2.
;
	MVI	A,2
	JMP	RBV
;
WSR3:	SHLD	RBTENT	;block
	XCHG
	LHLD	EARGDE	;fcb fwa
	LXI	B,16
	DAD	B	;HL=RBT fwa
	LDA	RBTBF
	ORA	A
	LDA	RBTORD	;A=ord within phy ext
	JZ	WSR4	;If RBT words
;
;	Store RBT byte in fcb.
;
	CALL	HLA	;HL=HL+A
	MOV	M,E
	JMP	WSR5
;
;	Store RBT word in fcb.
;
WSR4:	MOV	C,A
	MVI	B,0
	DAD B ! DAD B
	MOV M,E ! INX H ! MOV M,D
;
WSR5:	MVI	C,2	;writing into new block
;
WSR6:	LDA	RARGA
	ORA	A
	RNZ		;If error condition set
;
;	CBIOS flag = 0  normal write
;		     1  directory write
;		     2  write to new block
;
	PUSH	B	;save C for CBIOS
	CALL	CRO	;calc record ord
	POP B ! PUSH B	;C=preread flag
	CALL	PBZ	;process block zero-fill
;
;	Write the data record.
;
	CALL	PPD1	;position disk
	POP B ! PUSH B	;C=preread flag for CBIOS
	CALL	WDR	;write record
	CALL	GS2	;mark file written
	ANI	7FH
	MOV	M,A
;
	POP	B
	LDA	FCBCR	;current record,cr
	LXI	H,FCBRC	;record count,rc
	CMP	M	;cr-rc
	JC	WSR11	;If rc>cr
;
;	File is being extended, advance record count.
;
	MOV	M,A	;set rc=cr+1
	INR	M
WSR11:	CPI	7FH
	JNZ	WSR13	;If not last record of ext
;
;	We have written the last record of current
;	logical extent.
;
	LDA	ACFLAG
	CPI	1
	JNZ	WSR13	;If not seq access
;
;	We are processing a sequential write.
;	Advance fcb next record byte.
;	Close current extent, open next extent.
;
	CALL	AFR	;advance fcb
	CALL	AFX	;advance file extent
;
;	Check successful advance.
;
	LXI	H,RARGA
	MOV	A,M
	ORA	A
	JNZ	WSR12	;If error flag set
;
;	Preset current record to -1 for AFR.
;
	DCR	A
	STA	FCBCR
WSR12:	MVI	M,0	;return A=0
WSR13:	JMP	AFR	;go advance fcb
;
;	PRA - Process random access.
;	Parse r2,r1,r0 into s2,ex,cr.
;	Entry	 C = FF  random read
;		   = 00  random write
;	Exit	 Z = true, if record accessible
;
PRA:	XRA	A	;set access flag=random
	STA	ACFLAG
;
PRA1:	PUSH	B	;save read/write flag
	LHLD	EARGDE	;DE=fcb fwa
	XCHG
	LXI	H,35	;point to r2
	DAD	D
	MOV	A,M	;r2
	ANI	0C0H
	JNZ	PRA4	;If beyond addressing range
;
	DCX H ! DCX H
	MOV	A,M	;r0
	ANI	7FH
	PUSH	PSW	;save cr bits
;
;	Extract extent bits.
;
	MOV	A,M	;r0
	RAL		;high bit to carry
	INX	H	;point to r1
	MOV	A,M	;r1
	RAL		;bring in carry from r0
	MOV	C,A	;extent bits
;
;	Extract s2 bits.
;
	INX	H	;point to r2
	MOV	A,M
	RAL
	MOV	B,A	;s2 bits
;
	LXI	H,32	;set cr
	DAD	D
	POP	PSW
	MOV	M,A
;
	LXI	H,12	;check fcb ext
	DAD	D
	MOV	A,C
	SUB	M
	JNZ	PRA2	;If not same extent
;
	LXI	H,14	;check fcb s2
	DAD	D
	MOV	A,B
	SUB	M
	ANI	7FH
	JZ	PRA3	;If same extent
;
PRA2:	PUSH	B	;save extent bits
	PUSH	D	;save fcb fwa
	CALL	CLO	;If written into, close current ext
	POP	D
	POP	B
;
	MVI	L,3	;err 3=cannot close current ext
	LDA	RARGA
	INR	A
	JZ	PRA5	;If close error
;
	LXI	H,12	;set new extent
	DAD	D
	MOV	M,C
;
	LXI	H,14	;set new s2
	DAD	D
	MOV	M,B
	CALL	OPN	;open new extent
	LDA	RARGA
	INR	A
	JNZ	PRA3	;If opened
;
;	Referenced extent not found.
;	We must be writing.
;
	POP	B	;check read/write
	PUSH	B
	MVI	L,4	;err 4=reading unwritten rec
	INR	C
	JZ	PRA5	;If reading, error
;
;	We are writing.
;	Create new extent.
;
	CALL	CNF	;create new extent
	MVI	L,5	;err 5=no directory space
	LDA	RARGA
	INR	A
	JZ	PRA5	;If directory full
;
;	Random record ord r2,r1,r0 now in extent,cr.
;
PRA3:	POP	B
	XRA	A	;return A=0, no errors
	JMP	RBV
;
PRA4:	MVI	L,6	;err 6=beyond addressing range
;
;	Process error condition L.
;
PRA5:	POP	B
	MOV	A,L
	STA	RARGA
	JMP	MNW	;mark file not written
;
;	Process function 33.
;	Read random record.
;
RFRRR	EQU	$
	CALL	PDS	;select disk
;
;	RRR - Read random record.
;
RRR:	MVI	C,0FFH	;read
	CALL	PRA
	CZ	RSR1	;If record is accessible
	RET
%RDOS2.ASM
