# SConscript for Altogether
# $Id: SConscript 421 2004-06-16 08:09:49Z eric $
# Copyright 2007 Eric L. Smith <eric@brouhaha.com>

# Altogether is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.  Note that I am not
# granting permission to redistribute or modify Altogether under the
# terms of any later version of the General Public License.

# Altogether is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program (in the file "COPYING"); if not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111, USA.

Import ('env')

import os.path, zipfile, SCons

def zipflat (target, source, env):
    zf = zipfile.ZipFile (str (target [0]), 'w', zipfile.ZIP_DEFLATED)
    for s in source:
        flatname = os.path.basename (str (s))
        zf.write (str (s), flatname)
    zf.close ()
    

zipflat_bld = Builder (action = zipflat,
                       target_factory = SCons.Node.FS.default_fs.Entry,
                       source_factory = SCons.Node.FS.default_fs.Entry)

env.Append (BUILDERS = {'ZipFlat' : zipflat_bld})

