/*
 * Altogether: Xerox Alto microcode-level simulator
 * Bit-mapped display simulation
 * $Id: display.h 117 2004-12-31 19:03:27Z eric $
 * Copyright 2001, 2003 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111  USA
 */

#define ACTIVE_LINE_COUNT 808

#define PIXELS_PER_LINE 606


void install_display (void);


#if (((! defined (NATIVE_DISPLAY_MSB_LEFT)) && \
     (! defined (NATIVE_DISPLAY_LSB_LEFT))) || \
     ((defined (NATIVE_DISPLAY_MSB_LEFT)) && \
      (defined (NATIVE_DISPLAY_LSB_LEFT))))
#error Must define either NATIVE_DISPLAY_MSB_LEFT or NATIVE_DISPLAY_LSB_LEFT
#endif

#if (((! defined (NATIVE_DISPLAY_MIN_IS_BLACK)) && \
     (! defined (NATIVE_DISPLAY_MIN_IS_WHITE))) || \
     ((defined (NATIVE_DISPLAY_MIN_IS_BLACK)) && \
      (defined (NATIVE_DISPLAY_MIN_IS_WHITE))))
#error Must define either NATIVE_DISPLAY_MIN_IS_WHITE or NATIVE_DISPLAY_MIN_IS_BLACK
#endif

/*
 * The frame buffer is allocated by install_display(), and is kept in
 * little-endian bit ordering.  Each scan line is represented as a
 * series of BYTES_PER_LINE bytes.  The leftmost pixels are in the
 * first byte (offset 0) within the line.  The bit order is determined
 * by defining either NATIVE_DISPLAY_MSB_LEFT or
 * NATIVE_DISPLAY_LSB_LEFT.  The values of the bits represent black or
 * white as determined by NATIVE_DISPLAY_MIN_IS_BLACK or
 * NATIVE_DISPLAY_MIN_IS_WHITE.  Two bits of the last byte in the scan
 * line are unused, since PIXELS_PER_LINE is not an integral multiple
 * of 8.
 * 
 * The scan lines are stored consecutively in order from top to bottom.
 */

#define BYTES_PER_LINE ((PIXELS_PER_LINE + 7) / 8)  /* round up */
#define FRAME_BUFFER_SIZE (ACTIVE_LINE_COUNT * BYTES_PER_LINE)


/*
 * The GUI can install a callback to be notified when a complete
 * display frame is ready.
 */

typedef void (* frame_ready_fn_t)(uint8_t *frame_buffer);

void install_frame_ready_fn (frame_ready_fn_t fn);
