/*
 * Altogether: Xerox Alto microcode-level simulator
 * Main program
 * $Id: main.h 117 2004-12-31 19:03:27Z eric $
 * Copyright 2001, 2003 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111  USA
 */

/* don't set these directly, use the functions below */
extern bool runflag;   /* enable simulation */
extern int stepflag;      /* count of instructions to step,
			     when decremented to zero, clear runflag */
extern bool traceflag; /* enable trace output */

extern bool task_switch_break [TASK_COUNT];


/* values for why */
#define INTBREAK 1
#define ERRORBRK 2
#define UBREAKPT 3
#define STEP 4
#define USTOP 5
#define TASK_SWITCH 6


void clear_runflag (int why);
void set_runflag (void);


void sim_go (void);
void sim_step (int count);
void sim_trace (void);
void sim_stop (void);
