/*
 * Altogether: Xerox Alto microcode-level simulator
 * Main memory simulation
 * $Id: main_mem.h 117 2004-12-31 19:03:27Z eric $
 * Copyright 2001, 2003 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111  USA
 */


#if ALTO_XM
#define RAM_SIZE 262144
#else
#define RAM_SIZE 65536
#endif


#define IO_PAGE_BASE 0177000
#define IO_PAGE_SIZE 0001000


void init_main_mem (void);


/* memory access functions */

void load_main_mem_addr (int addr);

bool check_read_main_mem_stall (void);
uint16_t read_main_mem (void);

bool check_write_main_mem_stall (void);
void write_main_mem (uint16_t data);


/* debug access */

uint16_t debug_read_mem (int addr);
void debug_write_mem (int addr, uint16_t data);


/*
 * This module is also responsible for dispatching memory-mapped I/O
 * access.  Each I/O device code needs to register read and write
 * functions for the addresses it owns.
 */


/* typedefs for callback functions */
typedef uint16_t (* mmio_read_fn_t)(uint16_t address);
typedef void (* mmio_write_fn_t)(uint16_t address, uint16_t data);

/* install callbacks functions */
void install_memory_mapped_io (uint16_t first_address,
			       uint16_t last_address,
			       mmio_read_fn_t read_fn,
			       mmio_write_fn_t write_fn);
