/*
 * Altogether: Xerox Alto microcode-level simulator
 * Scheduler
 * $Id: scheduler.h 126 2005-04-09 07:20:18Z eric $
 * Copyright 2001, 2003, 2004 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111  USA
 */


typedef uint64_t sim_time_t;
#define END_OF_TIME UINT64_MAX
#define PRI_u_SIM_TIME PRIu64

extern sim_time_t current_time;


#define MAX_QUEUED_EVENTS 255


typedef void (*event_fn_t)(uint32_t arg1, void *arg2);


void init_scheduler (void);

/* returns END_OF_TIME if no scheduled events */
sim_time_t next_scheduled_event_time (void);

void run_scheduler_until (sim_time_t time);

bool schedule_event (sim_time_t time, event_fn_t event_fn, uint32_t arg1, void *arg2);
