/*
 * Altogether: Xerox Alto microcode-level simulator
 * 3 Mbit/s Ethernet controller and media simulation
 * $Id: ethernet.c 117 2004-12-31 19:03:27Z eric $
 * Copyright 2001, 2003, 2004 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111  USA
 */

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>

#include "alto.h"
#include "cpu.h"
#include "ethernet.h"


#define bs_ether_eidfct  bs_task_4

#define f1_ether_eilfct  f1_task_13
#define f1_ether_epfct   f1_task_14
#define f1_ether_ewfct   f1_task_15

#define f2_ether_eodfct  f2_task_10
#define f2_ether_eosfct  f2_task_11
#define f2_ether_erbfct  f2_task_12
#define f2_ether_eefct   f2_task_13
#define f2_ether_ebfct   f2_task_14
#define f2_ether_ecbfct  f2_task_15
#define f2_ether_eisfct  f2_task_16


void bs_fn_ether_eidfct_early (int task, int code)
{
  // input data function
  // Read one word from FIFO and increment the read pointer.
}


void f1_fn_ether_eilfct_early (int task, int code)
{
  // input look function
  // Read one word from FIFO without incrementing the read pointer.
}

void f1_fn_ether_epfct_early (int task, int code)
{
  // post function
  // gates interface status to BUS[8-15].  Resets the interface.
}

void f1_fn_ether_ewfct_early (int task, int code)
{
  // countdown wakeup function
  // Sets a flip-flop in the interface that will cause a wakeup to the
  // Ether task on the next tick of SWAKMRT.  This function must be issued
  // in the instruction after a TASK.  The resulting wakeup is cleared when
  // the Ether task next runs.
}


void f2_fn_ether_eodfct_late (int task, int code)
{
  // output data function
  // Loads the FIFO from BUS[0-15], then increments the write pointer at
  // the end of the cycle
}

void f2_fn_ether_eosfct_early (int task, int code)
{
  // output start function
  // Sets the OBUSY flip-flop in the interface, starting data wakeups to
  // fill the FIFO for output.  When the FIFO is full, or EEFCT has been
  // issued, the interface will wait for silence on the Ether and begin
  // transmitting.
}

void f2_fn_ether_erbfct_late (int task, int code)
{
  // reset branch function
  // This command dispatch function merges the ICMD and OCMD flip-flops
  // into NEXT[6-7].  These flip-flops are the means of communication
  // between the emulator task and the Ethernet task.  The emulator task
  // sets them from BUS[14-15] with the STARTF function, causing the
  // Ethernet task to wakeup, dispatch on them and then reset them with
  // EPFCT.
}

void f2_fn_ether_eefct_early (int task, int code)
{
  // end of transmission function
  // This function is issued when all of the main memory output buffer
  // has been transferred to the FIFO.  EEFCT disables further data
  // wakeups.
}

void f2_fn_ether_ebfct_late (int task, int code)
{
  // branch function
  // ORs a one into NEXT[7] if an input data late is detected, or an
  // SIO with AC0[14:15] non-zero is issued, or if the transmitter or
  // receiver goes done.  ORs a one into NEXT[6] if a collision is
  // detected.
}

void f2_fn_ether_ecbfct_late (int task, int code)
{
  // countdown branch function
  // ORs a one into NEXT[7] if the FIFO is not empty.
}

void f2_fn_ether_eisfct_early (int task, int code)
{
  // input start function
  // Sets the IBUSY flip-flop in the interface, causing it to hunt
  // for the beginning of a pcaket:  silence on the Ether followed by
  // a transition.  When the interface has collected two words, it
  // will begin generating data wakeups to the microcode.
}


void install_ethernet (int task)
{
  install_bus_select_fn (task_ethernet, bs_ether_eidfct, & bs_fn_ether_eidfct_early, NULL);

  install_f1_fn (task_ethernet, f1_ether_eilfct,    & f1_fn_ether_eilfct_early, NULL);
  install_f1_fn (task_ethernet, f1_ether_epfct,     & f1_fn_ether_epfct_early, NULL);
  install_f1_fn (task_ethernet, f1_ether_ewfct,     & f1_fn_ether_ewfct_early, NULL);

  install_f2_fn (task_ethernet, f2_ether_eodfct,    NULL, & f2_fn_ether_eodfct_late);
  install_f2_fn (task_ethernet, f2_ether_eosfct,    & f2_fn_ether_eosfct_early, NULL);
  install_f2_fn (task_ethernet, f2_ether_erbfct,    NULL, & f2_fn_ether_erbfct_late);
  install_f2_fn (task_ethernet, f2_ether_eefct,     & f2_fn_ether_eefct_early, NULL);
  install_f2_fn (task_ethernet, f2_ether_ebfct,     NULL, & f2_fn_ether_ebfct_late);
  install_f2_fn (task_ethernet, f2_ether_ecbfct,    NULL, & f2_fn_ether_ecbfct_late);
  install_f2_fn (task_ethernet, f2_ether_eisfct,    & f2_fn_ether_eisfct_early, NULL);
}
