/*
 * Altogether: Xerox Alto microcode-level simulator
 * GUI main
 * $Id: gui.h 117 2004-12-31 19:03:27Z eric $
 * Copyright 2001, 2003 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111  USA
 */

void init_gui (int *argc, char **argv []);

/*
 * gui_main() will not return until the program exits.  After gui_main()
 * is called, the only way the simulator gets the CPU is through the use
 * of an idle callback.
 */
void gui_main (void);



typedef void (* idle_fn_t)(void);

/* install the function that the GUI may call when idle */
void gui_set_idle_function (idle_fn_t fn);

/* enable/disable the idle function */
void gui_set_idle (bool enable);

/* the idle function should periodically call back into the GUI to
   check for events */
void gui_idle_callback (void);


#define GUI_IO_READ_EVENT (1 << 0)
#define GUI_IO_WRITE_EVENT (1 << 1)
#define GUI_IO_EXCEPTION_EVENT (1 << 2)

typedef void (* io_fn_t)(void *data, int fd, int event);

/* returns tag for use in gui_clear_io_callback */
int gui_set_io_callback (int fd, int events, io_fn_t fn, void *data);

void gui_clear_io_callback (int tag);
