/*
 * Altogether: Xerox Alto microcode-level simulator
 * Priority Queue
 * $Id: priority_queue.h 121 2005-01-20 02:03:33Z eric $
 * Copyright 2001 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111  USA
 */


typedef uint64_t priority_t;
#define PQ_LOWEST_PRIORITY 0xffffffffffffffffULL


typedef struct priority_queue_t priority_queue_t;


priority_queue_t *new_priority_queue (int max_entries);

bool priority_queue_empty (priority_queue_t *q);

bool priority_queue_full (priority_queue_t *q);

int priority_queue_size (priority_queue_t *q);

bool priority_queue_add (priority_queue_t *q,
			 priority_t priority, void *data);

bool priority_queue_peek (priority_queue_t *q,
			  priority_t *priority, void **data);

bool priority_queue_remove (priority_queue_t *q,
			    priority_t *priority, void **data);

/* returns PQ_LOWEST_PRIORITY if queue is empty */
priority_t priority_queue_head (priority_queue_t *q);
