/*----------------------------------------------------------------------*/
/* fd2bin.c                                                             */
/* Floppy disk image file maker                                         */
/*----------------------------------------------------------------------*/
/* Usage:                                                               */
/*  fd2bin [/force] drive: outputfilename                               */
/* Options:                                                             */
/*  /force         create image file even if read error is occured.     */
/*  drive:         drive letter of floppy disk drive                    */
/*  outputfilename image filename                                       */
/* Example:                                                             */
/*  fd2bin /force a: fddimage.bin                                       */
/*----------------------------------------------------------------------*/
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <windows.h>

typedef struct _media_info {
    int fdc1mMode;
    int cylinders;
    int heads;
    char sectors;
    DWORD sectorsize;
    DWORD mediasize;
    char n;
    char eot;
    char gpl;
    char fgpl;
    MEDIA_TYPE mType;
} STRMEDIAINFO;

#define MAX_FDDTYPES    (6)
const STRMEDIAINFO g_mediaInfo[] = {
    { 0,  0,   0,   0,    0,         0,    0,  0,   0,   0, Unknown},
    { 1, 77,   2,   8, 1024,   1261568,    3,  8,  53, 116, F3_1Pt23_1024}, /* 1.23M */
    { 0, 80,   2,   9,  512,    737280,    2,  9,  42,  80, F3_720_512},    /* 720K */
    { 0, 80,   2,   8,  512,    655360,    2,  8,  42,  80, F3_640_512},    /* 640K */
    { 2, 80,   2,  18,  512,   1474560,    2, 18,  27,   0, F3_1Pt44_512},  /* 1.44M */
    { 1, 80,   2,  15,  512,   1228800,    2, 15,  27,  84, F3_1Pt2_512}    /* 1.2M(2hc) */
};

const int g_convMediaType[] = {
    0,  5,  4,  0,  0,  2,  0,  0,  0,  0,  0, -1, -1,  0,  3,  3,
    2,  5,  1,  1,  0,  0,  0,  0,  0,  0
};

const char *acMediaType[] = {
    "Format is unknown",
    "5.25\" floppy, with 1.2MB and 512 bytes/sector",
    "3.5\" floppy, with 1.44MB and 512 bytes/sector",
    "3.5\" floppy, with 2.88MB and 512 bytes/sector",
    "3.5\" floppy, with 20.8MB and 512 bytes/sector",
    "3.5\" floppy, with 720KB and 512 bytes/sector",
    "5.25\" floppy, with 360KB and 512 bytes/sector",
    "5.25\" floppy, with 320KB and 512 bytes/sector",
    "5.25\" floppy, with 320KB and 1024 bytes/sector",
    "5.25\" floppy, with 180KB and 512 bytes/sector",
    "5.25\" floppy, with 160KB and 512 bytes/sector",
    "media other than floppy",
    "hard disk media",
    "3.5\" floppy, with 120MB and 512 bytes/sector",
    "3.5\" floppy, with 640KB and 512 bytes/sector",
    "5.25\" floppy, with 640KB and 512 bytes/sector",
    "5.25\" floppy, with 720KB and 512 bytes/sector",
    "3.5\" floppy, with 1.2MB and 512 bytes/sector",
    "3.5\" floppy, with 1.23MB and 1024 bytes/sector",
    "5.25\" floppy, with 1.23KB and 1024 bytes/sector",
    "3.5\" floppy, with 128MB and 512 bytes/sector",
    "3.5\" floppy, with 230MB and 512 bytes/sector",
    "8\" floppy, with 256KB and 128 bytes/sector",
    "3.5\" floppy, with 200MB and 512 bytes/sector. (HiFD)",
    "3.5\" floppy, with 240MB and 512 bytes/sector. (HiFD)",
    "3.5\" floppy, with 32MB and 512 bytes/sector"
};

typedef enum {
    evtEnd = -1,
    evtNoevent = 0,
    evtGeometry,
    evtRead,
    evtReadRetry,
    evtWrite,
    evtError
} EFEVENT;

typedef struct _work_ {
    void   *hEvent;
    volatile EFEVENT event;
    char   *buffer;
    DWORD  tsize;
    DWORD  sc;
    int    flag;
    HANDLE dh;
    HANDLE fh;
    int    fddType;
    const STRMEDIAINFO *pMediaInfo;
    OVERLAPPED ol;
    DISK_GEOMETRY dgeo;
} STRWORK;

void threadOverlapped(void *param)
{
    STRWORK *pWork = (STRWORK *)param;
    DWORD size;
    int inLoop = TRUE;

    while(inLoop) {
        WaitForSingleObject(pWork->hEvent, INFINITE);
        if(pWork->event == evtEnd) {
            inLoop = FALSE;
            continue;
        }
        GetOverlappedResult(pWork->dh, &pWork->ol, &size, TRUE);
        switch(pWork->event) {
        case evtGeometry:
            break;
        case evtRead:
            if(size != pWork->tsize) {
                printf("ReadError (%d) at Cylinder : %d\n", GetLastError(), pWork->ol.Offset / pWork->tsize);
                pWork->event = evtReadRetry;
                continue;
            }
            break;
        case evtReadRetry:
            if(size != pWork->pMediaInfo->sectorsize) {
                printf("ReadError at Head : %d Sector : %d\n",
                        pWork->sc % pWork->pMediaInfo->heads, pWork->sc / pWork->pMediaInfo->heads + 1);
                pWork->event = evtError;
                continue;
            }
            break;
        case evtWrite:
            if(size != pWork->pMediaInfo->mediasize) {
                printf("WriteError\n");
                pWork->event = evtError;
                continue;
            }
            break;
        default:
            break;
        }
        pWork->event = evtNoevent;
    }
    CloseHandle(pWork->hEvent);
    pWork->hEvent = NULL;
    pWork->event = evtNoevent;
}

void closeThread(STRWORK *pWork)
{
    pWork->event = evtEnd;
    SetEvent(pWork->hEvent);
    while(pWork->event == evtEnd);
}

DWORD checkGeometry(STRWORK *pWork)
{
    DWORD lastError;
    DWORD bytes;
    BOOL ret;

    pWork->ol.Offset     = 0;
    pWork->ol.OffsetHigh = 0;
    pWork->ol.hEvent     = pWork->hEvent;
    pWork->event = evtGeometry;
    memset(&pWork->dgeo, 0, sizeof(DISK_GEOMETRY));
    ret = DeviceIoControl(pWork->dh, IOCTL_DISK_GET_DRIVE_GEOMETRY,
                          NULL, 0, &pWork->dgeo, sizeof(DISK_GEOMETRY), &bytes, &pWork->ol);
    if(!ret) {
        lastError = GetLastError();
        if(lastError != ERROR_IO_PENDING) {
            printf("error :lasterror = %d\n", lastError);
            return lastError;
        }
        while(pWork->event == evtGeometry);
    }
    pWork->fddType = pWork->dgeo.MediaType;
    return ERROR_SUCCESS;
}

BOOL readMedia(STRWORK *pWork)
{
    DWORD lastError;
    DWORD sectors = pWork->pMediaInfo->heads * pWork->pMediaInfo->sectors;
    BOOL ret;
    int c;

    pWork->tsize = sectors * pWork->pMediaInfo->sectorsize;
    for(c = 0; c < pWork->pMediaInfo->cylinders; c++) {
        pWork->ol.Offset     = c * pWork->tsize;
        pWork->ol.OffsetHigh = 0;
        pWork->ol.hEvent     = pWork->hEvent;
        pWork->event = evtRead;
        ret = ReadFile(pWork->dh, &pWork->buffer[pWork->ol.Offset], pWork->tsize, NULL, &pWork->ol);
        if(!ret) {
            lastError = GetLastError();
            if(lastError != ERROR_IO_PENDING) {
                printf("error :lasterror = %d\n", lastError);
                return FALSE;
            }
            while(pWork->event == evtRead);
            if(pWork->event != evtReadRetry) {
                printf("\rCylinder %d Readed.", c);
                continue;
            }
            if((pWork->flag & 0x01) == 0) {
                return FALSE;
            }
            for(pWork->sc = 0; pWork->sc < sectors; pWork->sc++) {
                pWork->ol.Offset     = c * pWork->tsize + pWork->sc * pWork->pMediaInfo->sectorsize;
                pWork->ol.OffsetHigh = 0;
                pWork->ol.hEvent     = pWork->hEvent;
                pWork->event = evtReadRetry;
                ret = ReadFile(pWork->dh, &pWork->buffer[pWork->ol.Offset], pWork->pMediaInfo->sectorsize, NULL, &pWork->ol);
                if(!ret) {
                    lastError = GetLastError();
                    if(lastError != ERROR_IO_PENDING) {
                        printf("ReadError at Head : %d Sector : %d\n",
                               pWork->sc % pWork->pMediaInfo->heads, pWork->sc / pWork->pMediaInfo->heads);
                        memset(&pWork->buffer[pWork->ol.Offset], 0xee, pWork->pMediaInfo->sectorsize);
                        continue;
                    }
                    while(pWork->event == evtReadRetry);
                    if(pWork->event == evtError) {
                        memset(&pWork->buffer[pWork->ol.Offset], 0xee, pWork->pMediaInfo->sectorsize);
                    }
                }
            }
        }
    }
    return TRUE;
}

BOOL writeFile(STRWORK *pWork)
{
    DWORD lastError;
    BOOL ret;

    pWork->ol.Offset     = 0;
    pWork->ol.OffsetHigh = 0;
    pWork->ol.hEvent     = pWork->hEvent;
    pWork->event = evtWrite;
    ret = WriteFile(pWork->fh, pWork->buffer, pWork->pMediaInfo->mediasize, NULL, &pWork->ol);
    if(!ret) {
        lastError = GetLastError();
        if(lastError != ERROR_IO_PENDING) {
            printf("error :lasterror = %d\n", lastError);
            return FALSE;
        }
        while(pWork->event == evtWrite);
        if(pWork->event == evtError) {
            return FALSE;
        }
    }
    return TRUE;
}

int main(int argc, char *argv[])
{
    char drive[8] = "\\\\.\\A:";
    char *file = NULL;
    STRWORK *pWork;
    uintptr_t hThread;
    DWORD lastError;
    int err = FALSE;
    int ch;
    int i;

    pWork = calloc(sizeof(STRWORK), 1);
    if(pWork == NULL) {
        printf("Ɗ쐬ɃG[܂\n");
    }

    for(i = 1; i < argc; i++) {
        if(argv[i][0] == '/') {
            if(strcmp(&argv[i][1], "force") == 0) {
                pWork->flag |= 1;
            }
        } else if((argv[i][1] == 0) || ((argv[i][1] == ':') && (argv[i][2] == 0))) {
            drive[4] = (argv[i][0] <= 'Z') ? argv[i][0] : (argv[i][0] - 'a' + 'A');
            if((drive[4] < 'A') || ('Z' < drive[4])) {
                err = TRUE;
                break;
            }
        } else {
            file = argv[i];
        }
    }
    printf("tbs[fBXNC[Wt@C쐬c[\n");
    if(err || (file == NULL)) {
        printf("USAGE: fd2bin [/force] drive: outputfilename\n");
        printf("   /force : fBXNǂݎ蒆ɃZN^[G[oꍇłC[Wt@C쐬܂\n");
        free(pWork);
        exit(-1);
    }
    if((err = GetDriveType(&drive[4])) != 2) {
        printf("hCu%c͗LȃhCuł͂܂\n", drive[4]);
        free(pWork);
        exit(-1);
    }
    printf("C[Wtbs[fBXNhCu%cɃZbgA^[Ă\n", drive[4]);
    printf("(ESCŏ𒆒f܂)\n");
    do {
        ch = _getch();
        if((ch == 0x1b) || (ch == 0x03)) {
            free(pWork);
            exit(-1);
        }
    } while(ch != 0x0d);

    err = TRUE;
    pWork->hEvent  = CreateEvent(NULL, FALSE, FALSE, NULL);
    if(pWork->hEvent != NULL) {
        hThread = _beginthread(threadOverlapped, 0, pWork);
        if(hThread != 1L) {
            err = FALSE;
        } else {
            CloseHandle(pWork->hEvent);
        }
    }
    if(err) {
        printf("Ɗ쐬ɃG[܂\n");
        free(pWork);
        exit(-1);
    }

    pWork->dh = CreateFile(drive, GENERIC_READ, FILE_SHARE_READ, NULL,
                           OPEN_EXISTING, FILE_FLAG_NO_BUFFERING | FILE_FLAG_OVERLAPPED, NULL);
    if(pWork->dh == INVALID_HANDLE_VALUE) {
        printf("hCuI[vG[ : Code %x\n", GetLastError());
        closeThread(pWork);
        exit(-1);
    }

    lastError = checkGeometry(pWork);
    if(lastError == ERROR_SUCCESS) {
        if(g_convMediaType[pWork->fddType] <= 0) {
            if(g_convMediaType[pWork->fddType] < 0) {
                printf("w肳ꂽhCu̓tbs[fBXNhCuƔFł܂łB𒆒f܂\n");
            } else {
                printf("ofBA̓C[Wł܂B𒆒f܂\n");
            }
            CloseHandle(pWork->dh);
            closeThread(pWork);
            free(pWork);
            exit(-1);
        }
    } else {
        if(lastError == ERROR_NOT_READY) {
            printf("fBȀoĂ܂B𒆒f܂\n");
        } else {
            printf("fBAւ̃ANZXɃG[o܂B𒆒f܂\n");
        }
        CloseHandle(pWork->dh);
        closeThread(pWork);
        free(pWork);
        exit(-1);
    }

    pWork->fh = CreateFile(file, GENERIC_WRITE, 0, NULL,
                           CREATE_NEW, FILE_FLAG_NO_BUFFERING | FILE_FLAG_OVERLAPPED, NULL);
    if(pWork->fh == INVALID_HANDLE_VALUE) {
        lastError = GetLastError();
        if(lastError == ERROR_FILE_EXISTS) {
            printf("o̓t@C͂łɑ݂܂B㏑܂(Y/n)\n");
            do {
                ch = _getch();
                ch = (ch <= 'Z') ? ch : (ch - 'a' + 'A');
                if((ch == 'N')) {
                    CloseHandle(pWork->dh);
                    closeThread(pWork);
                    free(pWork);
                    exit(-1);
                }
            } while(ch != 'Y');
            pWork->fh = CreateFile(file, GENERIC_WRITE, 0, NULL,
                                   CREATE_ALWAYS, FILE_FLAG_NO_BUFFERING | FILE_FLAG_OVERLAPPED, NULL);
            lastError = GetLastError();
        }
        if(pWork->fh == INVALID_HANDLE_VALUE) {
            if(lastError == ERROR_ACCESS_DENIED) {
                printf("o̓t@C֏݂o܂\n");
            } else {
                printf("o̓t@CI[vG[ : Code %x\n", lastError);
            }
            CloseHandle(pWork->dh);
            closeThread(pWork);
            free(pWork);
            exit(-1);
        }
    }
    err = TRUE;
    pWork->pMediaInfo = &g_mediaInfo[g_convMediaType[pWork->fddType]];
    pWork->buffer = calloc(pWork->pMediaInfo->mediasize, 1);
    if(pWork->buffer == NULL) {
        printf("Ɗ쐬ɃG[܂\n");
    } else {
        printf("ofBA %s ł\n", acMediaType[pWork->fddType]);
        printf("fBA̓ǂݎJn܂\n");
        if(readMedia(pWork)) {
            printf("\nt@C쐬܂");
            if(writeFile(pWork)) {
                printf("\nt@C̍쐬I܂BvOI܂\n");
                err = FALSE;
            } else {
                printf("\nt@CݒɃG[ߏ𒆒f܂\n");
            }
        } else {
            printf("\nfBAǂݎ蒆ɃG[ߏ𒆒f܂\n");
        }
        free(pWork->buffer);
    }
    CloseHandle(pWork->fh);
    CloseHandle(pWork->dh);
    closeThread(pWork);
    free(pWork);
    return err ? -1 : 0;
}
