/*----------------------------------------------------------------------*/
/* bin2fd.c                                                             */
/* Writeback image file to Floppy disk tool                             */
/*----------------------------------------------------------------------*/
/* Usage:                                                               */
/*  bin2fd [/force] imagefilename drive:                                */
/* Options:                                                             */
/*  /force         continue to write to floopy disk even if write error */
/*                 is occured. (for test)                               */
/*  imagefilename  image file to write                                  */
/*  drive:         drive letter of floppy disk drive                    */
/* Example:                                                             */
/*  bin2fd /force fddimage.bin a:                                       */
/*----------------------------------------------------------------------*/
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <windows.h>

typedef struct _media_info {
    int fdc1mMode;
    int cylinders;
    int heads;
    char sectors;
    DWORD sectorsize;
    DWORD mediasize;
    char n;
    char eot;
    char gpl;
    char fgpl;
    MEDIA_TYPE mType;
} STRMEDIAINFO;

#define MAX_FDDTYPES    (6)
const STRMEDIAINFO g_mediaInfo[] = {
    { 0,  0,   0,   0,    0,         0,    0,  0,   0,   0, Unknown},
    { 1, 77,   2,   8, 1024,   1261568,    3,  8,  53, 116, F3_1Pt23_1024}, /* 1.23M */
    { 0, 80,   2,   9,  512,    737280,    2,  9,  42,  80, F3_720_512},    /* 720K */
    { 0, 80,   2,   8,  512,    655360,    2,  8,  42,  80, F3_640_512},    /* 640K */
    { 2, 80,   2,  18,  512,   1474560,    2, 18,  27,   0, F3_1Pt44_512},  /* 1.44M */
    { 1, 80,   2,  15,  512,   1228800,    2, 15,  27,  84, F3_1Pt2_512}    /* 1.2M(2hc) */
};

const int g_convMediaType[] = {
    0,  5,  4,  0,  0,  2,  0,  0,  0,  0,  0, -1, -1,  0,  3,  3,
    2,  5,  1,  1,  0,  0,  0,  0,  0,  0
};

const char *acMediaType[] = {
    "Format is unknown",
    "1.2MB and 512 bytes/sector",
    "1.44MB and 512 bytes/sector",
    "2.88MB and 512 bytes/sector",
    "20.8MB and 512 bytes/sector",
    "720KB and 512 bytes/sector",
    "360KB and 512 bytes/sector",
    "320KB and 512 bytes/sector",
    "320KB and 1024 bytes/sector",
    "180KB and 512 bytes/sector",
    "160KB and 512 bytes/sector",
    "media other than floppy",
    "hard disk media",
    "120MB and 512 bytes/sector",
    "640KB and 512 bytes/sector",
    "640KB and 512 bytes/sector",
    "720KB and 512 bytes/sector",
    "1.2MB and 512 bytes/sector",
    "1.23MB and 1024 bytes/sector",
    "1.23KB and 1024 bytes/sector",
    "128MB and 512 bytes/sector",
    "230MB and 512 bytes/sector",
    "256KB and 128 bytes/sector",
    "200MB and 512 bytes/sector. (HiFD)",
    "240MB and 512 bytes/sector. (HiFD)",
    "32MB and 512 bytes/sector"
};

typedef enum {
    evtEnd = -1,
    evtNoevent = 0,
    evtGeometry,
    evtRead,
    evtFormat,
    evtWrite,
    evtWriteRetry,
    evtError
} EFEVENT;

typedef struct _work_ {
    void   *hEvent;
    volatile EFEVENT event;
    char   *buffer;
    DWORD  tsize;
    DWORD  sc;
    int    flag;
    HANDLE dh;
    HANDLE fh;
    int    fddType;
    const STRMEDIAINFO *pMediaInfo;
    OVERLAPPED ol;
    DISK_GEOMETRY dgeo;
    char work[128];
} STRWORK;

void threadOverlapped(void *param)
{
    STRWORK *pWork = (STRWORK *)param;
    DWORD size;
    int inLoop = TRUE;

    while(inLoop) {
        WaitForSingleObject(pWork->hEvent, INFINITE);
        if(pWork->event == evtEnd) {
            inLoop = FALSE;
            continue;
        }
        GetOverlappedResult(pWork->dh, &pWork->ol, &size, TRUE);
        switch(pWork->event) {
        case evtGeometry:
            break;
        case evtRead:
            if(size != pWork->tsize) {
                printf("ReadError\n");
                pWork->event = evtError;
                continue;
            }
            break;
        case evtFormat:
            if(size > 0) {
                printf("FormatError %d\n", pWork->work[0]);
                pWork->event = evtError;
                continue;
            }
            break;
        case evtWrite:
            if(size != pWork->tsize) {
                printf("WriteError at Cylinder : %d\n", pWork->ol.Offset / pWork->tsize);
                pWork->event = evtWriteRetry;
                continue;
            }
            break;
        case evtWriteRetry:
            if(size != pWork->pMediaInfo->sectorsize) {
                printf("WriteError at Head : %d Sector : %d\n",
                        pWork->sc % pWork->pMediaInfo->heads, pWork->sc / pWork->pMediaInfo->heads + 1);
                pWork->event = evtError;
                continue;
            }
            break;
        default:
            break;
        }
        pWork->event = evtNoevent;
    }
    CloseHandle(pWork->hEvent);
    pWork->hEvent = NULL;
    pWork->event = evtNoevent;
}

void closeThread(STRWORK *pWork)
{
    pWork->event = evtEnd;
    SetEvent(pWork->hEvent);
    while(pWork->event == evtEnd);
}

DWORD checkGeometry(STRWORK *pWork)
{
    DWORD lastError;
    DWORD bytes;
    BOOL ret;

    pWork->ol.Offset     = 0;
    pWork->ol.OffsetHigh = 0;
    pWork->ol.hEvent     = pWork->hEvent;
    pWork->event = evtGeometry;
    memset(&pWork->dgeo, 0, sizeof(DISK_GEOMETRY));
    ret = DeviceIoControl(pWork->dh, IOCTL_DISK_GET_DRIVE_GEOMETRY,
                          NULL, 0, &pWork->dgeo, sizeof(DISK_GEOMETRY), &bytes, &pWork->ol);
    if(!ret) {
        lastError = GetLastError();
        if(lastError != ERROR_IO_PENDING) {
            printf("error :lasterror = %d\n", lastError);
            return lastError;
        }
        while(pWork->event == evtGeometry);
    }
    pWork->fddType = pWork->dgeo.MediaType;
    return ERROR_SUCCESS;
}

void checkFile(STRWORK *pWork)
{
    DWORD size, sizeHigh;
    int i;

    size = GetFileSize(pWork->fh, &sizeHigh);
    if(sizeHigh == 0) {
        for(i = 1; i < MAX_FDDTYPES; i++) {
            if(size == g_mediaInfo[i].mediasize) {
                pWork->pMediaInfo = &g_mediaInfo[i];
                pWork->fddType = (int)g_mediaInfo[i].mType;
                return;
            }
        }
    }
    pWork->fddType = (int)Unknown;
}

BOOL readFile(STRWORK *pWork)
{
    DWORD lastError;
    BOOL ret;

    pWork->ol.Offset     = 0;
    pWork->ol.OffsetHigh = 0;
    pWork->ol.hEvent     = pWork->hEvent;
    pWork->event = evtRead;
    pWork->tsize = pWork->pMediaInfo->mediasize;
    ret = ReadFile(pWork->fh, pWork->buffer, pWork->tsize, NULL, &pWork->ol);
    if(!ret) {
        lastError = GetLastError();
        if(lastError != ERROR_IO_PENDING) {
            printf("error :lasterror = %d\n", lastError);
            return FALSE;
        }
        while(pWork->event == evtRead);
    }
    return TRUE;
}

BOOL formatMedia(STRWORK *pWork)
{
    FORMAT_PARAMETERS fp;
    DWORD lastError;
    DWORD bytes;
    DWORD sectorSize = pWork->pMediaInfo->sectors * pWork->pMediaInfo->sectorsize;
    BOOL ret;
    int i, j;

    for(i = 0; i < pWork->pMediaInfo->cylinders; i++) {
        for(j = 0; j < pWork->pMediaInfo->heads; j++) {
            pWork->ol.Offset     = (i * pWork->pMediaInfo->heads + j) * sectorSize;
            pWork->ol.OffsetHigh = 0;
            pWork->ol.hEvent     = pWork->hEvent;
            pWork->event = evtFormat;

            fp.MediaType           = pWork->fddType;
            fp.StartCylinderNumber = i;
            fp.EndCylinderNumber   = i;
            fp.StartHeadNumber     = j;
            fp.EndHeadNumber       = j;
            ret = DeviceIoControl(pWork->dh, IOCTL_DISK_FORMAT_TRACKS, &fp, sizeof(FORMAT_PARAMETERS),
                                  pWork->work, sizeof(pWork->work), &bytes, &pWork->ol);
            printf("\rForrmatting at Cilynder : %d Head : %d", i, j);
            if(!ret) {
                lastError = GetLastError();
                if(lastError != ERROR_IO_PENDING) {
                    printf("\rFormatting Error at Cilynder : %d Head : %d | %d\n", i, j, lastError);
                    if((pWork->flag % 0x01) == 0) {
                        return FALSE;
                    }
                    pWork->flag |= 0x80;
                    continue;
                }
                while(pWork->event == evtFormat);
                if(pWork->event == evtError) {
                    printf("\rFormatting Error at Cilynder : %d Head : %d\n", i, j);
                    if((pWork->flag % 0x01) == 0) {
                        return FALSE;
                    }
                    pWork->flag |= 0x80;
                }
            }
        }
    }
    printf("\n");
    return TRUE;
}

BOOL writeMedia(STRWORK *pWork)
{
    DWORD lastError;
    DWORD sectors = pWork->pMediaInfo->heads * pWork->pMediaInfo->sectors;
    BOOL ret;
    int c;

    pWork->tsize = sectors * pWork->pMediaInfo->sectorsize;
    for(c = 0; c < pWork->pMediaInfo->cylinders; c++) {
        pWork->ol.Offset     = c * pWork->tsize;
        pWork->ol.OffsetHigh = 0;
        pWork->ol.hEvent     = pWork->hEvent;
        pWork->event = evtWrite;
        ret = WriteFile(pWork->dh, &pWork->buffer[pWork->ol.Offset], pWork->tsize, NULL, &pWork->ol);
        if(!ret) {
            lastError = GetLastError();
            if(lastError != ERROR_IO_PENDING) {
                printf("error :lasterror = %d\n", lastError);
                return lastError;
            }
            while(pWork->event == evtWrite);
            if(pWork->event != evtWriteRetry) {
                printf("\rCylinder %d Writed.   ", c);
                continue;
            }
            if((pWork->flag & 0x01) == 0) {
                return FALSE;
            }
            pWork->flag |= 0x80;
            for(pWork->sc = 0; pWork->sc < sectors; pWork->sc++) {
                pWork->ol.Offset     = c * pWork->tsize + pWork->sc * pWork->pMediaInfo->sectorsize;
                pWork->ol.OffsetHigh = 0;
                pWork->ol.hEvent     = pWork->hEvent;
                pWork->event = evtWriteRetry;
                ret = WriteFile(pWork->dh, &pWork->buffer[pWork->ol.Offset], pWork->pMediaInfo->sectorsize, NULL, &pWork->ol);
                if(!ret) {
                    lastError = GetLastError();
                    if(lastError != ERROR_IO_PENDING) {
                        printf("WriteError at Head : %d Sector : %d\n",
                               pWork->sc % pWork->pMediaInfo->heads, pWork->sc / pWork->pMediaInfo->heads);
                        continue;
                    }
                    while(pWork->event == evtWriteRetry);
                }
            }
        }
    }
    return TRUE;
}

int main(int argc, char *argv[])
{
    char drive[8] = "\\\\.\\A:";
    char *file = NULL;
    STRWORK *pWork;
    uintptr_t hThread;
    DWORD lastError;
    int err = FALSE;
    int ch;
    int i;

    pWork = calloc(sizeof(STRWORK), 1);
    if(pWork == NULL) {
        printf("Ɗ쐬ɃG[܂\n");
    }

    for(i = 1; i < argc; i++) {
        if(argv[i][0] == '/') {
            if(strcmp(&argv[i][1], "force") == 0) {
                pWork->flag |= 1;
            }
        } else if((argv[i][1] == 0) || ((argv[i][1] == ':') && (argv[i][2] == 0))) {
            drive[4] = (argv[i][0] <= 'Z') ? argv[i][0] : (argv[i][0] - 'a' + 'A');
            if((drive[4] < 'A') || ('Z' < drive[4])) {
                err = TRUE;
                break;
            }
        } else {
            file = argv[i];
        }
    }
    printf("tbs[fBXNC[WCeBOc[\n");
    if(err || (file == NULL)) {
        printf("USAGE: bin2fd [/force] inputfilename drive:\n");
        printf("   /force : fBXNݒɃZN^[G[oꍇł݂p܂\n");
        free(pWork);
        exit(-1);
    }
    if((err = GetDriveType(&drive[4])) != 2) {
        printf("hCu%c͗LȃhCuł͂܂\n", drive[4]);
        free(pWork);
        exit(-1);
    }
    printf("C[Wރtbs[fBXNhCu%cɃZbgA\n", drive[4]);
    printf("^[Ă(ESCŏ𒆒f܂)\n");
    do {
        ch = _getch();
        if((ch == 0x1b)) {
            free(pWork);
            exit(-1);
        }
    } while(ch != 0x0d);

    err = TRUE;
    pWork->hEvent  = CreateEvent(NULL, FALSE, FALSE, NULL);
    if(pWork->hEvent != NULL) {
        hThread = _beginthread(threadOverlapped, 0, pWork);
        if(hThread != 1L) {
            err = FALSE;
        } else {
            CloseHandle(pWork->hEvent);
        }
    }
    if(err) {
        printf("Ɗ쐬ɃG[܂\n");
        free(pWork);
        exit(-1);
    }

    pWork->dh = CreateFile(drive, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, NULL,
                           OPEN_EXISTING, FILE_FLAG_NO_BUFFERING | FILE_FLAG_OVERLAPPED, NULL);
    if(pWork->dh == INVALID_HANDLE_VALUE) {
        printf("hCuI[vG[ : Code %x\n", GetLastError());
        closeThread(pWork);
        free(pWork);
        exit(-1);
    }

    lastError = checkGeometry(pWork);
    if(lastError == ERROR_SUCCESS) {
        if(g_convMediaType[pWork->fddType] < 0) {
            printf("w肳ꂽhCu̓tbs[fBXNhCuƔFł܂łB𒆒f܂\n");
            CloseHandle(pWork->dh);
            closeThread(pWork);
            free(pWork);
            exit(-1);
        }
    } else {
        if(lastError == ERROR_NOT_READY) {
            printf("fBȀoĂ܂B𒆒f܂\n");
        } else {
            printf("fBAւ̃ANZXɃG[o܂B𒆒f܂\n");
        }
        CloseHandle(pWork->dh);
        closeThread(pWork);
        free(pWork);
        exit(-1);
    }

    pWork->fh = CreateFile(file, GENERIC_READ, FILE_SHARE_READ, NULL,
                    OPEN_EXISTING, FILE_FLAG_NO_BUFFERING | FILE_FLAG_OVERLAPPED, NULL);
    if(pWork->fh == INVALID_HANDLE_VALUE) {
        lastError = GetLastError();
        printf("C[Wt@CI[vG[ : Code %x\n", lastError);
        CloseHandle(pWork->dh);
        closeThread(pWork);
        free(pWork);
        exit(-1);
    }
    checkFile(pWork);
    if(pWork->fddType == (int)Unknown) {
        printf("w肳ꂽt@C̓TCYC[Wt@CƔfł܂ł\n");
        CloseHandle(pWork->fh);
        CloseHandle(pWork->dh);
        closeThread(pWork);
        free(pWork);
        exit(-1);
    }

    err = TRUE;
    pWork->buffer = calloc(pWork->pMediaInfo->mediasize, 1);
    if(pWork->buffer == NULL) {
        printf("Ɗ쐬ɃG[܂\n");
    } else {
        if(!readFile(pWork)) {
            printf("C[Wt@C̓ǂݏoɎs܂\n");
        } else {
            printf("w肳ꂽt@C %s ̃C[Wt@Cł\n", acMediaType[pWork->fddType]);
            if(!formatMedia(pWork)) {
                printf("fBÃtH[}bgɎs܂\n");
            } else if(writeMedia(pWork)) {
                if((pWork->flag & 0x80) != 0) {
                    printf("\nfBAւ݂̏I܂BݎɃG[߃f[^̐M͒Ⴂł\n");
                } else {
                    printf("\nfBAւ݂̏I܂BvOI܂\n");
                }
                err = FALSE;
            } else {
                printf("\nfBAւ̏ݒɃG[ߏ𒆒f܂\n");
            }
        }
        free(pWork->buffer);
    }
    CloseHandle(pWork->fh);
    CloseHandle(pWork->dh);
    closeThread(pWork);
    free(pWork);
    return err ? -1 : 0;
}
