/***************************************************************************

  memmap.h

  This include file contains definitions of memory addresses, I/O ports,
  dip switch settings, used by the emulation

***************************************************************************/

/***************************************************************************

Crazy Climber memory map (preliminary)
as described by Lionel Theunissen (lionelth@ozemail.com.au)

0000h-4fffh ;20k program ROMs. ROM11=0000h
                               ROM10=1000h
                               ROM09=2000h
                               ROM08=3000h
                               ROM07=4000h

8000h-83ffh ;1k scratchpad RAM.
8800h-87ffh ;256 bytes Bigsprite RAM.
9000h-93ffh ;1k screen RAM.
9800h-981fh ;Column smooth scroll position. Corresponds to each char
             column. *This is actually part of the colour RAM.
9880-0x989f ; sprites. 8 groups of 4 bytes:
              1st byte sprite code (bits 0-5), flipping (bits 6-7)
              2nd byte color (bit 4 selects second sprite set)
              3rd byte Y position
              4th byte X position
98dch ;big sprite control.
98ddh ;big sprite colour.
98deh ;big sprite y position.
98dfh ;big sprite x position.

9c00h-9fffh ;1k Colour RAM: Bits 0-3: char colour scheme.
                            Bit    4: 0=charset1, 1=charset2.



0a000h ;RD: player 1 cntl. WR: NMI: 0=disable, 1=enable.
0a001h ;WR: Video horizontal invert.
0a002h ;WR: Video vertical invert
0a004h ;WR: dig sound trigger?
0a800h ;RD: player 2 cntl. WR: dig sound speed?
0b000h ;RD: dip switches.  WR: dig sound volume?
0b800h ;RD: machine switches/watchdog.

I/O 8  ;AY-3-8910 Reg?
I/O 9  ;AY-3-8910 Reg?

***************************************************************************/


#define ROM_END 0x4fff

#define INTERRUPT_ENABLE 0xa000

#define VIDEO_RAM_START 0x9000
#define MIRROR_VIDEO_RAM_START 0x9400
#define VIDEO_RAM_SIZE 0x400
#define COLOR_RAM_START 0x9c00

#define SPRITES_BASE 0x9880
#define SPRITES_SIZE 0x20

#define BIGSPRITE_START 0x8800
#define BIGSPRITE_SIZE 0x100
#define BIGSPRITE_COLOR_START 0x8900
#define BIGSPRITE_CTRL_BASE 0x98dc

#define COLUMN_SCROLL_BASE 0x9800

#define DIGSND_TRIGGER 0xa004
#define DIGSND_FREQ 0xa800
#define DIGSND_VOLUME 0xb000


#define SNDCTRL_PORT 0x08
#define SNDWRITE_PORT 0x09
#define SNDREAD_PORT 0x0c


/*
 * IN0 Player 1 controls (NOT inverted)
 * bit 7 :\            RIGHT
 * bit 6 :| right      LEFT
 * bit 5 :| joystick   DOWN
 * bit 4 :/            UP
 * bit 3 :\            RIGHT
 * bit 2 :| left       LEFT
 * bit 1 :| joystick   DOWN
 * bit 0 :/            UP
 */
#define IN0_PORT 0xA000
#define IN0_RIGHT_RIGHT (1<<7)
#define IN0_RIGHT_LEFT (1<<6)
#define IN0_RIGHT_DOWN (1<<5)
#define IN0_RIGHT_UP (1<<4)
#define IN0_LEFT_RIGHT (1<<3)
#define IN0_LEFT_LEFT (1<<2)
#define IN0_LEFT_DOWN (1<<1)
#define IN0_LEFT_UP (1<<0)

/*
 * IN1 Player 2 controls (NOT inverted) (TABLE only)
 * bit 7 :\            RIGHT
 * bit 6 :| right      LEFT
 * bit 5 :| joystick   DOWN
 * bit 4 :/            UP
 * bit 3 :\            RIGHT
 * bit 2 :| left       LEFT
 * bit 1 :| joystick   DOWN
 * bit 0 :/            UP
 */
#define IN1_PORT 0xA800
#define IN1_RIGHT_RIGHT (1<<7)
#define IN1_RIGHT_LEFT (1<<6)
#define IN1_RIGHT_DOWN (1<<5)
#define IN1_RIGHT_UP (1<<4)
#define IN1_LEFT_RIGHT (1<<3)
#define IN1_LEFT_LEFT (1<<2)
#define IN1_LEFT_DOWN (1<<1)
#define IN1_LEFT_UP (1<<0)

/*
 * IN2 (bits NOT inverted)
 * bit 7 : unused
 * bit 6 : unused
 * bit 5 : unused
 * bit 4 : TABLE or STANDUP cabinet select (1 = STANDUP)
 * bit 3 : START 2
 * bit 2 : START 1
 * bit 1 : CREDIT
 * bit 0 : COIN
 */
#define IN2_PORT 0xB800
#define IN2_STANDUP (1<<4)
#define IN2_START2 (1<<3)
#define IN2_START1 (1<<2)
#define IN2_CREDIT (1<<1)
#define IN2_COIN (1<<0)

/*
 * DSW1 (bits NOT inverted)
 * bit 7 : DIP SWITCH 8\ games per credit   00 = 1  01 = 2
 * bit 6 : DIP SWITCH 7/                    10 = 3  11 = free play
 * bit 5 : DIP SWITCH 6\ 00 = 1 coin 1 credit 01 = 2 coins 1 credit
 * bit 4 : DIP SWITCH 5/ 10 = 3 coins 1 credit 11 = 4 coins 1 credit
 * bit 3 : DIP SWITCH 4/ RACK TEST
 * bit 2 : DIP SWITCH 3  0 = bonus at 30000 1 = bonus at 50000
 * bit 1 : DIP SWITCH 2\ 00 = 3 lives  01 = 4 lives
 * bit 0 : DIP SWITCH 1/ 10 = 5 lives  11 = 6 lives
 */
#define DSW1_PORT 0xB000
#define DSW1_SW8 (1<<7)
#define DSW1_SW7 (1<<6)
#define DSW1_SW6 (1<<5)
#define DSW1_SW5 (1<<4)
#define DSW1_SW4 (1<<3)
#define DSW1_SW3 (1<<2)
#define DSW1_SW2 (1<<1)
#define DSW1_SW1 (1<<0)

#define DSW1_RACK_TEST (DSW1_SW4)
