#include "roms.h"

const struct RomModule ccrom[] =
{
	{ "cc11", 0x0000, 0x1000 },
	{ "cc10", 0x1000, 0x1000 },
	{ "cc09", 0x2000, 0x1000 },
	{ "cc08", 0x3000, 0x1000 },
	{ "cc07", 0x4000, 0x1000 },
	{ 0 }	/* end of table */
};
const struct RomModule ccbootrom[] =
{
	{ "m11.bin", 0x0000, 0x1000 },
	{ "m10.bin", 0x1000, 0x1000 },
	{ "m09.bin", 0x2000, 0x1000 },
	{ "m08.bin", 0x3000, 0x1000 },
	{ "m07.bin", 0x4000, 0x1000 },
	{ 0 }	/* end of table */
};


const struct DSW ccdsw[] =
{
	{ 0, 0x03, "LIVES", { "3", "4", "5", "6" } },
	{ 0, 0x04, "BONUS", { "30000", "50000" } },
	{ -1 }
};


const struct GameInfo gameinfo[] =
{
	{ "cclimber", ccrom, ccdsw, { 0x00 } },
	{ 0, ccbootrom, ccdsw, { 0x00 } }	/* generic entry */
};




const struct RomModule ccgfx[] =
{
	{ "cc06", 0x0000, 0x0800 },
	{ "cc04", 0x0800, 0x0800 },
	{ "cc05", 0x1000, 0x0800 },
	{ "cc03", 0x1800, 0x0800 },
	{ "cc02", 0x2000, 0x0800 },
	{ "cc01", 0x2800, 0x0800 },
	{ 0 }	/* end of table */
};
const struct RomModule ccbootgfx[] =
{
	{ "m06.bin", 0x0000, 0x0800 },
	{ "m04.bin", 0x0800, 0x0800 },
	{ "m05.bin", 0x1000, 0x0800 },
	{ "m03.bin", 0x1800, 0x0800 },
	{ "m02.bin", 0x2000, 0x0800 },
	{ "m01.bin", 0x2800, 0x0800 },
	{ 0 }	/* end of table */
};



struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	256,	/* 256 characters */
	2,	/* 2 bits per pixel */
	256*8*8,	/* the two bitplanes are separated */
	{ 0, 1, 2, 3, 4, 5, 6, 7 },	/* pretty straightforward layout */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every char takes 8 consecutive bytes */
};
struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	64,	/* 64 sprites */
	2,	/* 2 bits per pixel */
	64*16*16,	/* the two bitplanes are separated */
	{ 0, 1, 2, 3, 4, 5, 6, 7,	/* pretty straightforward layout */
			8*8+0, 8*8+1, 8*8+2, 8*8+3, 8*8+4, 8*8+5, 8*8+6, 8*8+7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			16*8, 17*8, 18*8, 19*8, 20*8, 21*8, 22*8, 23*8 },
	32*8	/* every sprite takes 32 consecutive bytes */
};



/* "What is the palette doing here", you might ask, "it's not a ROM!" */
/* Well, actually the palette and lookup table were stored in PROMs, whose */
/* image, unfortunately, is usually unavailable. So we have to supply our */
/* own. */
const unsigned char ccpalette[3 * TOTAL_COLORS] =
{
	0x00,0x00,0x00,	/* BLACK */
	0x49,0x00,0x00,	/* DKRED1 */
	0x92,0x00,0x00,	/* DKRED2 */
	0xff,0x00,0x00,	/* RED */
	0x00,0x24,0x00,	/* DKGRN1 */
	0x92,0x24,0x00,	/* DKBRN1 */
	0xb6,0x24,0x00,	/* DKBRN2 */
	0xff,0x24,0x00,	/* LTRED1 */
	0xdb,0x49,0x00,	/* BROWN */
	0x00,0x6c,0x00,	/* DKGRN2 */
	0xff,0x6c,0x00,	/* LTORG1 */
	0x00,0x92,0x00,	/* DKGRN3 */
	0x92,0x92,0x00,	/* DKYEL */
	0xdb,0x92,0x00,	/* DKORG */
	0xff,0x92,0x00,	/* ORANGE */
	0x00,0xdb,0x00,	/* GREEN1 */
	0x6d,0xdb,0x00,	/* LTGRN1 */
	0x00,0xff,0x00,	/* GREEN2 */
	0x49,0xff,0x00,	/* LTGRN2 */
	0xff,0xff,0x00,	/* YELLOW */
	0x00,0x00,0x49,	/* DKBLU1 */
	0xff,0x00,0x49,	/* DKPNK1 */
	0xff,0x24,0x49,	/* DKPNK2 */
	0xff,0x6d,0x49,	/* LTRED2 */
	0xdb,0x92,0x49,	/* LTBRN */
	0xff,0x92,0x49,	/* LTORG2 */
	0x24,0xff,0x49,	/* LTGRN3 */
	0x49,0xff,0x49,	/* LTGRN4 */
	0xff,0xff,0x49,	/* LTYEL */
	0x00,0x00,0x92,	/* DKBLU2 */
	0xff,0x00,0x92,	/* PINK1 */
	0x00,0x24,0x92,	/* DKBLU3 */
	0xff,0x24,0x92,	/* PINK2 */
	0xdb,0xdb,0x92,	/* CREAM */
	0xff,0xdb,0x92,	/* LTORG3 */
	0x00,0x00,0xdb,	/* BLUE */
	0xdb,0x00,0xdb,	/* PURPLE */
	0x00,0xb6,0xdb,	/* LTBLU1 */
	0x92,0xdb,0xdb,	/* LTBLU2 */
	0xdb,0xdb,0xdb,	/* WHITE1 */
	0xff,0xff,0xdb	/* WHITE2 */
};

enum {BLACK,DKRED1,DKRED2,RED,DKGRN1,DKBRN1,DKBRN2,LTRED1,BROWN,DKGRN2,
	LTORG1,DKGRN3,DKYEL,DKORG,ORANGE,GREEN1,LTGRN1,GREEN2,LTGRN2,YELLOW,
	DKBLU1,DKPNK1,DKPNK2,LTRED2,LTBRN,LTORG2,LTGRN3,LTGRN4,LTYEL,DKBLU2,
	PINK1,DKBLU3,PINK2,CREAM,LTORG3,BLUE,PURPLE,LTBLU1,LTBLU2,WHITE1,
	WHITE2};

const unsigned char cccolortable[4 * COLOR_CODES] =
{
	/* characters and sprites */
	BLACK,LTGRN3,DKRED2,PINK1,	/* vase */
	BLACK,LTORG3,WHITE2,LTRED2,	/* 1st level man throwing vase */
	BLACK,BLUE,LTBLU1,LTBLU2,	/* play area left and right border */
	BLACK,YELLOW,DKRED2,GREEN2,	/* bird's egg; vase */
	BLACK,DKBRN2,LTGRN4,LTORG3,	/* 1st level map */
	BLACK,RED,DKORG,DKRED1,		/* bird's... well, shit */
	BLACK,ORANGE,BROWN,GREEN1,	/* climber */
	BLACK,LTORG3,LTBLU2,DKBRN1,	/* 1st level skyscraper */
	BLACK,DKPNK2,WHITE1,DKYEL,	/* falling objects on 2nd level */
	BLACK,CREAM,WHITE2,LTRED2,	/* 2nd level man throwing vase */
	BLACK,LTGRN1,BLACK,LTORG3,	/* title screen background & text */
	BLACK,LTBRN,BLACK,LTGRN2,	/* title screen copyright notice */
	BLACK,BLUE,YELLOW,LTORG3,	/* 2nd level map */
	BLACK,DKGRN3,LTBLU2,BROWN,	/* lives left */
	BLACK,WHITE2,LTYEL,PINK1,	/* title screen Nihon Bussan logo */
	BLACK,CREAM,LTBLU2,BLUE,	/* 2nd level skyscraper */

	/* big sprite */
	BLACK,WHITE2,DKGRN2,BLUE,	/* helicopter */
	BLACK,WHITE2,PURPLE,PINK2,	/* air balloon */
	BLACK,LTRED2,WHITE2,LTORG1,	/* bird */
	BLACK,WHITE2,BLUE,LTORG2,	/* title screen Crazy Climber logo */
	BLACK,DKPNK1,LTYEL,DKBLU2,	/* 2nd level electric sign */
	BLACK,DKBLU3,DKPNK1,LTYEL,	/* 3rd level sign */
	BLACK,LTYEL,DKBLU3,DKPNK1,	/* 2nd level sign */
	BLACK,DKBLU1,DKGRN1,WHITE2	/* 1st level sign */
};



const struct GameVidInfo gamevidinfo[] =
{
	{ "cclimber", ccgfx, &charlayout, &spritelayout, ccpalette, cccolortable },
	{ 0, ccbootgfx, &charlayout, &spritelayout, ccpalette, cccolortable }	/* generic entry */
};



const struct RomModule ccsound[] =
{
	{ "cc13", 0x0000, 0x1000 },
	{ "cc12", 0x1000, 0x1000 },
	{ 0 }	/* end of table */
};
const struct RomModule ccbootsound[] =
{
	{ "m13.bin", 0x0000, 0x1000 },
	{ "m12.bin", 0x1000, 0x1000 },
	{ 0 }	/* end of table */
};



const struct GameSndInfo gamesndinfo[] =
{
	{ "cclimber", ccsound },
	{ 0, ccbootsound }	/* generic entry */
};
