
#include <stdio.h>
#include "regs.h"
#include "trace.h"
#include "io.h"

char prtview[5][81];
long total_cycles;

void lights()
{
	char *status;
	register c1, c2;

	printf("%c[H", 0x1B);
#ifdef UNDEF
	printf("   IBM 709 Simulator         cycles: %10ld    total: %10ld\n\n",
		cycle_count, total_cycles + cycle_count);
#endif

	/*
	 *   TRAP  SIMULATE ACCUMULATOR QUOTIENT READ/WRITE DIVIDE  IO	 MACHINE
	 *		     OVERFLOW	OVERFLOW   SELECT   CHECK  CHECK  CHECK
	 * PROGRAM STOP  SSW bbbbbb  SL bbbb  CYCLE   RUN d+ooo
	 * IC ooooo INSTR +oooo FLAG TAG o ADDR ooooo  EA ooooo
	 * XRA ooooo  XRB ooooo  XRC ooooo	     SCNT   ooo
	 * SR + oooooooooooo	 ENB oooooooooooo     IND     o
	 * AC +ooooooooooooo      SI oooooooooooo
	 * MQ + oooooooooooo	 ADDRESS STOP	ooooo
	 *
	 * A ..........   B ..........   C ..........   D ..........
	 * OP +o UN oooR  OP +o UN oooW  OP +o UN ooo	OP +o UN ooo
	 * AR	  oooooT  AR	 ooooo	 AR	ooooo	AR     ooooo
	 * WR	  oooooE  WR	 ooooo	 WR	ooooo	WR     ooooo
	 * LR	  oooooC  LR	 ooooo	 LR	ooooo	LR     ooooo
	 * oooooooooooo   oooooooooooo	 oooooooooooo	oooooooooooo
	 */

	printf("  %s  %s %s %s %s %s %s %s\n",
		trap?	"TRAP"          : "    ",
		simulate?"SIMULATE"     : "        ",
		acoflo? "ACCUMULATOR"   : "           ",
		mqoflo? "QUOTIENT"      : "        ",
		rwsel?	"READ/WRITE"    : "          ",
		divchk? "DIVIDE"        : "      ",
		iochk?	" IO  "         : "     ",
		machchk?"MACHINE"       : "       ");
	printf("                 %s %s %s %s %s %s\n",
		acoflo? " OVERFLOW  "   : "           ",
		mqoflo? "OVERFLOW"      : "        ",
		rwsel?	"  SELECT  "    : "          ",
		divchk? "CHECK "        : "      ",
		iochk?	"CHECK"         : "     ",
		machchk?" CHECK "       : "       ");
	if (!automatic)
		status = "MANUAL      ";
	else if (stop)
		status = "PROGRAM STOP";
	else if (run)
		status = "AUTOMATIC   ";
	else
		status = "READY       ";
	printf("%s  SSW %o%o%o%o%o%o  SL %o%o%o%o  %s   RUN %d+%03o\n",
		status,
		(ssw >> 5) & 1,
		(ssw >> 4) & 1,
		(ssw >> 3) & 1,
		(ssw >> 2) & 1,
		(ssw >> 1) & 1,
		ssw & 1,
		(sl >> 3) & 1,
		(sl >> 2) & 1,
		(sl >> 1) & 1,
		sl & 1,
		single_cycle? "CYCLE" : "     ",
		run, chan_in_op);
	printf("IC %05o INSTR %c%04o %s TAG %o ADDR %05o  EA %05o\n",
	       ic, (op & 0100000)? '-' : '+', op & 07777,
	       flag? "FLAG" : "    ", tag, addr, y);
	printf("XRA %05o  XRB %05o  XRC %05o           SCNT   %03o\n",
	       xr[1], xr[2], xr[4], shcnt);
	printf("SR %c %02o%010lo     ENB 00%010lo     IND     %01o\n",
		(srh & SIGN)? '-' : '+',
		((srh & HMSK) << 2) | (short)(srl >> 30),
		srl & 07777777777,
		ctrap_enb, ctrap_ind);
	printf("AC %c%03o%010lo      SI %02o%010lo\n",
		(ach & SIGN)? '-' : '+',
		((ach & 037) << 2) | (short)(acl >> 30),
		acl & 07777777777,
		((sih & 017) << 2) | (short)(sil >> 30),
		sil & 07777777777);
	printf("MQ %c %02o%010lo",
		(mqh & SIGN)? '-' : '+',
		((mqh & HMSK) << 2) | (short)(mql >> 30),
		mql & 07777777777);

	if (addrstop)
		printf("     ADDRESS STOP   %05o\n", stopic);
	else
		printf("                         \n");

	for (c1 = 0; c1 < NUMCHAN; c1 += 4) {
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++) {
			int dev;
			char c;

			printf("%c ", c2 + 'A');
			for (dev = 10*c2 + 3; dev <= 10*c2 + 12; dev++) {
				if ((cun[c2] & 0100) == 0 &&
				    dev == (cun[c2] & 017) + 2 + 10*c2) {
					c = 'S';
				} else if (iofd[dev] == NULL) {
					c = '.';
				} else if (iopos[dev] == 0) {
					c = 'b';
				} else if (iorw[dev] < 2) {
					c = 'p';
				} else {
					c = 'o';
				}
				printf("%c", c);
			}
			printf("  ");
		}
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("OP %o%c UN %03o%c ",
			       cop[c2] & 007,
			       (cop[c2] & 010)? 'N' : ' ',
			       cun[c2],
			       " RWBFM"[csel[c2]]);
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("AR     %05o%c ", car[c2], ctrp[c2]? 'T' : ' ');
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("WR     %05o%c ", cwr[c2], ceof[c2]? 'E' : ' ');
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("LR     %05o%c ", clr[c2], cchk[c2]? 'C' : ' ');
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("%02o%010lo  ",
				((cdrh[c2] & SIGN) >> 2) |
				((cdrh[c2] & HMSK) << 2) |
				(short)(cdrl[c2] >> 30),
				cdrl[c2] & 07777777777);
		printf("\n");
	}
}

void pview()
{
	register i;

	printf("\n");
	for (i = 0; i < 5; i++)
		printf("%s\n", prtview[i]);
	printf("\n");
}

void help()
{

 printf("\n");
 printf("  h  - help         r  - reset   clear - clear   sw# - toggle SSW#\n");
 printf("  o  - mount file   q  - quit    sc - cycle     +,-,0-7,. set keys\n");
 printf("  lt - load tape    lc - load cards                               \n");
 printf("  em - enter MQ     ei - enter instruction    a - auto  m - manual\n");
 printf("  st - start/step   ds - display storage  dn - next   sa - adrstop\n");
 printf("\n");
}

void trace()
{
	int i, j, tp;

	printf("\n");
printf("Instruction trace:                                                 \n");
	tp = itrc_idx;
	for (i = 0; i < 4; i++) {
		printf("  ");
		for (j = 0; j < 8; j++) {
			if (j > 0) {
				printf(" ");
			}
			printf(" %c %05o",
				" ABCDEFGH"[itrc_buf[tp] >> 16],
				itrc_buf[tp] & 077777);
			tp++;
			if (tp == 32)
				tp = 0;
		}
		printf("\n");
	}
	printf("\n");
}

void long_trace()
{
	int i, j, tp;

	printf("\n");
printf("Instruction trace:                                                 \n");
	tp = itrc_idx;
	for (i = 0; i < 16; i++) {
		for (j = 0; j < 2; j++) {
			if (j > 0) {
				printf("        ");
			}
			printf(" %c %05o  %c %02o%010lo",
				" ABCDEFGH"[itrc_buf[tp] >> 16],
				itrc_buf[tp] & 077777,
				(itrc_h[tp] & SIGN)? '-' : '+',
				((itrc_h[tp] & HMSK) << 2) |
				 (short)(itrc_l[tp] >> 30),
				itrc_l[tp] & 07777777777);
			tp++;
			if (tp == 32)
				tp = 0;
		}
		printf("        \n");
	}
	printf("\n");
}
