
#define SIGN	0200
#define QCARRY	0040
#define Q	0020
#define P	0010
#define HMSK	0007

#define MEMLIMIT 32767

char memh[MEMLIMIT+1];
#ifndef SMALL
unsigned long meml[MEMLIMIT + 1];
#define getmeml(a) meml[a]
#define setmeml(a, v) meml[a] = v
#else SMALL
unsigned long getmeml();
#endif

char srh; unsigned long srl;
char ach; unsigned long acl;
char mqh; unsigned long mql;
char sih; unsigned long sil;
char kyh; unsigned long kyl;
char adderh; unsigned long adderl;
unsigned char ssw;
unsigned char sl;
unsigned short ic;
unsigned short xr[8];

unsigned char automatic;
unsigned char run;
unsigned char stop;
unsigned char trap;
unsigned char simulate;
unsigned char multtag;
unsigned char acoflo;
unsigned char mqoflo;
unsigned char rwsel;
unsigned char divchk;
unsigned char iochk;
unsigned char machchk;

unsigned short op;
unsigned char tag;
unsigned char flag;
unsigned short addr;
unsigned short decr;
unsigned short y;
unsigned char shcnt;
unsigned short spill;

unsigned long cycle_count;
unsigned long next_steal;
unsigned char single_cycle;
#define NEXTLIGHTS 83333
unsigned long next_lights;
#define CYCLE() \
	cycle_count++; \
	if (cycle_count >= next_steal) steal_cycle();
#define DCYCLE() \
	if (cycle_count >= next_steal-1) steal_cycle(); \
	else { CYCLE() }

#define ACCESS(a) srh = memh[a]; srl = getmeml(a); CYCLE()

#define NUMCHAN 2
#define MAXCHAN 8
unsigned char cop[MAXCHAN];
unsigned short car[MAXCHAN];
unsigned short cwr[MAXCHAN];
unsigned short clr[MAXCHAN];
unsigned char cdrh[MAXCHAN];
unsigned long cdrl[MAXCHAN];
unsigned short cun[MAXCHAN];
unsigned char csel[MAXCHAN];
unsigned char cchk[MAXCHAN];
unsigned char ceof[MAXCHAN];
unsigned char cbot[MAXCHAN];
unsigned char ceot[MAXCHAN];
unsigned char ceor[MAXCHAN];
unsigned char ctrp[MAXCHAN];
unsigned long ccyc[MAXCHAN];
unsigned char cact[MAXCHAN];
#define READ_SEL	1
#define WRITE_SEL	2
#define BSR_SEL 	3
#define BSF_SEL 	4
#define WEF_SEL 	5
unsigned long ctrap_enb;
unsigned char ctrap_ind;
unsigned char chan_in_op;
