//******************************************************************************
//  IBM 7094 Emulator - Operator control language Display Form
//  By Rob Storey 2001-2004 intabits@optushome.com.au
//------------------------------------------------------------------------------
// This unit provides user display functions for the Operator Control Language
// script interpreter.
//------------------------------------------------------------------------------
Unit B709OCLD;

Interface

Uses Windows, Messages, SysUtils, Classes,
     Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
     B709Defs; // General definitions

// Types of display items that can be generated on the form
Type TDispItemTypes=(
       DIBlankLine,    // Blank space
       DITextLabel,    // A simple text label
       DIClikLabel     // A label that can be clicked
     );

Type
  TScriptForm = class(TForm)
    PADisp: TPanel;
    PBCancel: TButton;
    PBContinue: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PBContinueClick(Sender: TObject);
    procedure PBCancelClick(Sender: TObject);
    procedure ClickHandler(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    ActiveCtr:  Integer;      // Number of active (clickable) items
    XPos,YPos:  Integer;      // Position to place next item on form
    MaxWid:     Integer;
  protected
  public
    SelectIndex: Integer;     // Indicates which active item was selected
    ContEnable:  Boolean;     // Show "Continue" button
    TColour:   TColor;
    HColour:   TColor;
    Procedure ClearDispItems;
    Procedure AddDispItem(DS: String; DT: TDispItemTypes);
    Procedure ShowHide(SH: Boolean);
  end;

Var ScriptForm: TScriptForm;

Implementation

{$R *.DFM}

Uses B709OCLI; // To terminate scripts

procedure TScriptForm.FormCreate(Sender: TObject);
begin
  FormHandles[FIScript]:=Handle;
  TColour:=CLBlack;
end;

procedure TScriptForm.FormDestroy(Sender: TObject);
begin
  ScriptForm:=NIL;  // To stop abend in scripter reset
end;

procedure TScriptForm.ClearDispItems;
Var XC: Integer;
    CO: TControl;
begin
  For XC:=PADisp.ControlCount-1 Downto 0 do begin
    CO:=PADisp.Controls[XC];
    If CO.Tag<0 then Continue;   // Don't delete the OK & Cancel buttons
    PADisp.RemoveControl(CO);
    CO.Free;
  End;
  PADisp.RePaint;
  ActiveCtr:=0; MaxWid:=300;
  XPos:=15; YPos:=15;
End;

procedure TScriptForm.AddDispItem(DS: String; DT: TDispItemTypes);
Var DI: TControl;
begin
  Case DT of
    DIBlankLine:  Begin
                    DI:=NIL;
                    Inc(YPos,20);
                  End;
    DITextLabel:  Begin
                    DI:=TLabel.Create(NIL);
                    With TLabel(DI) do begin
                      Caption:=DS;
                      With Font do begin
                        Size:=10; Color:=TColour; Style:=[];
                      End;
                    End;
                    DI.Tag:=0;
                  End;
    DIClikLabel:  Begin
                    DI:=TLabel.Create(NIL);
                    With TLabel(DI) do begin
                      Caption:=DS;
                      With Font do begin
                        Size:=10; Color:=HColour; Style:=[FSBold];
                      End;
                      OnClick:=ClickHandler;
                    End;
                    DI.Cursor:=CRHandPoint;
                    Inc(ActiveCtr);
                    DI.Tag:=ActiveCtr;
                  End;
    Else          Exit;
  End;
  If DI<>NIL then
    With DI do begin
      Parent:=PADisp; Visible:=True;
      Left:=XPos; Top:=YPos;
      If Width>MaxWid then MaxWid:=Width;
      Inc(YPos,Height);
    End;
  Width:=10+MaxWid+25;
  Height:=YPos+10+70;
End;

procedure TScriptForm.ClickHandler(Sender: TObject);
begin
  Inherited;
  Hide;
  With (Sender As TControl) do
    SelectIndex:=Tag;
  OCLThread.Resume;
  EMCMsg(CCSCRIPTRESUME,0,0,'');
end;

procedure TScriptForm.PBContinueClick(Sender: TObject);
begin
  Hide;
  OCLThread.Resume;
  EMCMsg(CCSCRIPTRESUME,0,0,'');
end;

procedure TScriptForm.PBCancelClick(Sender: TObject);
begin
  Hide;
  ShowWindow(FormHandles[FIMain],SW_Show);
  OCLThread.TerminateScript;
end;

procedure TScriptForm.ShowHide(SH: Boolean);
begin
  Caption:=OCLThread.ScriptName;
  SelectIndex:=0;
  PBContinue.Visible:=ContEnable;
  If SH then Show else Hide;
end;

End.

