//******************************************************************************
//  IBM 7094 Emulator - Operator control language Editor
//  By Rob Storey 2001-2004 intabits@optushome.com.au
//------------------------------------------------------------------------------
// This unit provides a very simple editor for Operator Control Language scripts.
//------------------------------------------------------------------------------
Unit B709OCLE;

Interface

Uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, StdCtrls, ExtCtrls, ComCtrls,
     B709Defs, // Global, utility, and miscellaneous definitions
     B709CnFg, // Configuration form
     B709OCLI; // Operator Control Language (OCL) interpreter

Type
  TEditForm = class(TForm)
    Panel1: TPanel;
    REEdit: TRichEdit;
    PBOpen: TButton;
    PBSave: TButton;
    PBRun: TButton;
    PBClose: TButton;
    PBNew: TButton;
    procedure FormShow(Sender: TObject);
    procedure PBSaveClick(Sender: TObject);
    procedure REEditChange(Sender: TObject);
    procedure PBOpenClick(Sender: TObject);
    procedure PBRunClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PBCloseClick(Sender: TObject);
    procedure PBNewClick(Sender: TObject);
  private
    NewFile:  Boolean;
    procedure LoadEditFile(FN: String);
    function  SaveFirstCheck: Boolean;
    procedure SetHeading(FN: String);
  public
    EditFileName: String;      // Name of main script file
    Procedure RunScript(SP: String);
  end;

Var EditForm: TEditForm;

Implementation

uses B709Main;

{$R *.DFM}

procedure TEditForm.FormCreate(Sender: TObject);
begin
  FormHandles[FIFileEdit]:=Handle;
//  Width:=450; Height:=500;
end;

procedure TEditForm.FormShow(Sender: TObject);
begin
  If EditFileName='' then
    EditFileName:=ConfigForm.GetStartScript;
  LoadEditFile(EditFileName);
end;

procedure TEditForm.REEditChange(Sender: TObject);
begin
  PBSave.Enabled:=REEdit.Modified;
end;

procedure TEditForm.PBCloseClick(Sender: TObject);
begin
  SaveFirstCheck;                                // Save current file?
  Hide;
end;

procedure TEditForm.PBNewClick(Sender: TObject);
begin
  SaveFirstCheck;                                // Save current file?
  LoadEditFile('');                                // Create new file in editor
end;

procedure TEditForm.PBOpenClick(Sender: TObject);
Var FN: String;
begin
  SaveFirstCheck;                                     // Save current file?
  If ConfigForm.OpenFileDialog(FGSAM,FN,False) then   // Get new file name
    LoadEditFile(FN);                                   // Load into editor
end;

procedure TEditForm.PBSaveClick(Sender: TObject);
Var FN: String;
begin
  If Not REEdit.Modified then Exit;              // Modified?
  // Created by New?
  If NewFile then begin
    // Get new name to save file as
    If Not ConfigForm.OpenFileDialog(FGSAM,FN,True) then Exit;
    // Already exists, Find out if it should be replaced;
    If FileExists(FN) then
      If MessageDlg('File exists. Replace?',
                    MTWarning,[MBYES,MBCANCEL],0)<>MRYES then Exit;
    NewFile:=False;
    SetHeading(FN);
  End;
  // Save file, adjust buttons
  REEdit.Lines.SaveToFile(EditFileName);
  REEdit.Modified:=False;
  PBSave.Enabled:=False;
end;

procedure TEditForm.PBRunClick(Sender: TObject);
begin
  SaveFirstCheck;                                // Save first?
  RunScript(EditFileName);                     // then run it
end;

Function TEditForm.SaveFirstCheck: Boolean;
begin
  // Check if current file should be saved first
  If REEdit.Modified then begin
    Result:=MessageDlg('Save current file?',MTWarning,[MBYES,MBNO],0)=MRYES;
    If Result then
       PBSaveClick(Self);
  End else
    Result:=False;
End;

procedure TEditForm.LoadEditFile(FN: String);
Begin
  FN:=Trim(FN);
  If FileExists(FN) then begin
    REEdit.Lines.LoadFromFile(FN);
    REEdit.Modified:=False;
    PBRun.Enabled:=ExtractFileExt(FN)='.EC7';
    PBSave.Enabled:=False;
    NewFile:=False;
  End else Begin
    PBRun.Enabled:=False;
    REEdit.Clear;
    NewFile:=True;
    If FN='' then FN:='Untitled';
  End;
  SetHeading(FN);
End;

Procedure TEditForm.SetHeading(FN: String);
Begin
  EditFileName:=FN;
  Caption:='IBM 7094 Emulation Editor - '+EditFileName;
End;

// Run an OCL script file
Procedure TEditForm.RunScript(SP: String);
Var PL: TPList;
Begin
  FillChar(PL,SizeOf(PL),#0);                    // Clear PList and
  PL[0]:=SP;                                     // Insert exec name
  EditFileName:=SP;                              // Note for re-run/editing
  Caption:=Heading+' - '+ExtractFileName(SP);    // Show in caption
  With MainForm do
    Caption:=Heading+' - '+ExtractFileName(SP);  // In main form also
  OCLThread.Reset;                               // Drop any existing scripts
  OCLThread.RunScript(SP,PL);                    // Load and run new script
  OCLThread.Resume;
End;

End.
