Unit B709Plot;

Interface

Uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs,
     B709Defs; // General definitions

Type
  TPlotForm = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
  public
    procedure Initialize;
    procedure PlotClear;
    procedure PlotFetch(AD: Word);
    procedure PlotRead(AD: Word);
    procedure PlotWrite(AD: Word);
  end;

Var PlotForm: TPlotForm;
    PlotDisp: Boolean;
    TracDisp: Boolean;

Implementation

{$R *.DFM}

procedure TPlotForm.FormCreate(Sender: TObject);
begin
  FormHandles[FIPlot]:=Handle;
  Width:=128+6;
  Height:=256+25;
end;

Procedure TPlotForm.Initialize;
//Var X,Y: Integer;
begin
//X:=ClientWidth;
//Y:=ClientHeight;
  PlotClear;
end;

procedure TPlotForm.PlotClear;
Begin
  With Canvas do begin
    Brush.Color:=ClBlack;
    FillRect(ClientRect);
  End;
  Application.ProcessMessages;
end;

Var P: Integer=0;
    Q: Integer=0;

procedure TPlotForm.PlotFetch(AD: Word);
Var X,Y: Integer;
begin
  X:=AD And $7F;
  Y:=(AD Shr 7);
  With Canvas do begin
    Pixels[P,Q]:=$0057572D;
    Pixels[X,Y]:=ClWhite;
  End;
  P:=X; Q:=Y;
end;

procedure TPlotForm.PlotRead(AD: Word);
Var X,Y: Integer;
begin
  X:=AD And $7F;
  Y:=(AD Shr 7);
  With Canvas do begin
//    Pixels[P,Q]:=$0057572D;
    Pixels[X,Y]:=$00006200;
  End;
end;

procedure TPlotForm.PlotWrite(AD: Word);
Var X,Y: Integer;
begin
  X:=AD And $7F;
  Y:=(AD Shr 7);
  With Canvas do begin
    Pixels[X,Y]:=$008B2E6A;
  End;
end;

End.
