//******************************************************************************
//  IBM 7094 Emulator - Configuration Setup form
//  By Rob Storey 2001-2004 intabits@optushome.com.au
//------------------------------------------------------------------------------
//  This unit defines the configuration setup form, and contains procedures for
//  Loading, saving, maintaining and distributing the system setup information
//------------------------------------------------------------------------------
Unit B709Cnfg;

Interface

Uses Windows, Messages, SysUtils, Classes, Graphics, Contnrs, Controls,
     Forms, Dialogs, StdCtrls, Grids, DirOutln, IniFiles, ExtCtrls,
     B709Defs, // General definitions
     B709Trce; // Log/Trace functions

// File groups for open dialog
Type TFileGroup=(
       FGSAM,    // Use same file group as last time
       FGCRD,    // Card image files
       FGTAP,    // Tape image files
       FGJCL,    // IBSYS Job Control Language files
       FGFOR,    // FORTRAN source files
       FGCOB,    // COBOL source files
       FGMAP,    // MAP Assembler source files
       FGSCR,    // Script files
       FGTRC,    // Trace files
       FGANY);   // Any file

Type
  TConfigForm = class(TForm)
    DLOpen: TOpenDialog;
    Panel1: TPanel;
    PBSave: TButton;
    PBCancel: TButton;
    PBOpen: TButton;
    LADesc: TLabel;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    EBSearchPath: TEdit;
    PBBrwSP: TButton;
    GroupBox2: TGroupBox;
    EBPOSName: TEdit;
    PBBrwSS: TButton;
    CBRunScript: TCheckBox;
    Label1: TLabel;
    EBTrueFactor: TEdit;
    CBCoreInitCheck: TCheckBox;
    DLSave: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PBSaveClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PBBrwSSClick(Sender: TObject);
    procedure PBBrwSPClick(Sender: TObject);
  Private
    IniFile:     TIniFile;
    LastIndex: Integer;
    procedure LoadConfigData;
    procedure SaveConfigData;
    procedure LoadFormData;
    Procedure SaveFormData;
    procedure LoadTraceColours;
    procedure SaveTraceColours;
  public
    Procedure Initialize;
    procedure SaveMiscData;
    Function OpenFileDialog(FG: TFileGroup; Var FN: String; SM: Boolean): Boolean;
    Function GetStartScript: String;
  end;

Var ConfigForm: TConfigForm;

Var EXEName:   String;
    EXEPath:   String;

Var LastChan:  Byte;                   // Actual number of channels on system

Implementation

{$R *.DFM}

Uses B709OCLE; // To set current script name

Procedure SetCBValue(CB: TCheckBox; VA: Boolean; Var VV: Boolean);
Begin
  VV:=VA;           // Set variable for access by other units
  CB.Checked:=VA;   // And set checkbox
End;

procedure TConfigForm.FormCreate(Sender: TObject);
begin
  LADesc.Caption:='';
  // Load open/save dialog file filters
  DLOpen.Filter:=
    'Column Binary card files (*.CBN)|*.CBN|'+                  // FGCRD
    'Binary and BCD tape files (*.BIN,*.BCD)|*.BIN;*.BCD|'+     // FGTAP
    'Job Control Language card files (*.JCL)|*.JCL|'+           // FGJCL
    'FORTRAN Source files (*.FOR)|*.FOR|'+                      // FGFOR
    'COBOL Source files (*.COB)|*.COB|'+                        // FGCOB
    'MAP Assembler Source files (*.MAP)|*.MAO|'+                // FGMAP,
    'B7094 Script Language files (*.EC7)|*.EC7|'+               // FGSCR
    'B7094 Trace files (*.TRC)|*.TRC|'+                         // FGTRC
    'Any file (*.*)|*.*';                                       // FGANY
  IniFile:=TIniFile.Create(EXEPath+EXEName+'.INI');
  LastIndex:=Ord(FGSCR);                 // Set initial default group
end;

procedure TConfigForm.FormDestroy(Sender: TObject);
begin
  IniFile.Free;
end;

Procedure TConfigForm.Initialize;
Begin
  LoadConfigData;            // Load configuration data
  LoadFormData;              // Set form positions & sizes
  LoadTraceColours;          // Set trace form display colours
End;

procedure TConfigForm.FormShow(Sender: TObject);
begin
  LoadConfigData;            // Reload configuration data
end;

Procedure TConfigForm.LoadConfigData;
Begin
  With IniFile do begin
    EBPOSName.Text:=ReadString('Operation','StartupScript','PowerOn.EC7');
    CBRunScript.Checked:=ReadBool('Operation','RunStartUpScript',True);
  End;
End;

Procedure TConfigForm.SaveConfigData;
Begin
  With IniFile do begin
    EBPOSName.Text:=Trim(EBPOSName.Text);
    If EBPOSName.Text<>'' then
      EBPOSName.Text:=ChangeFileExt(EBPOSName.Text,'.EC7');
    WriteString('Operation','StartupScript',EBPOSName.Text);
    WriteBool('Operation','RunStartUpScript',CBRunScript.Checked);
    WriteBool('Operation','CoreInitCheck',CBCoreInitCheck.Checked);
    UpdateFile;
  End;
End;

procedure TConfigForm.PBSaveClick(Sender: TObject);
begin
  If ModalResult=MROK then begin
    SaveConfigData;
    EditForm.EditFileName:=GetStartScript;
  End;
end;

// Return startup script file name if enabled, check it exists
Function TConfigForm.GetStartScript: String;
Begin
  If CBRunScript.Checked then begin
    Result:=EBPosName.Text;
    If FileExists(Result) then Exit;
    ShowMessage('Startup script not found:-'+#$D+Result);
  End;
  Result:='';
End;

// Open dialog to select file search path
procedure TConfigForm.PBBrwSPClick(Sender: TObject);
Var SP,FN: String;
begin
  If OpenFileDialog(FGANY,FN,False) then begin
    SP:=Trim(EBSearchPath.Text);
    If Pos(FN,SP)>0 then Exit;
    If SP='' then SP:=FN
             else SP:=SP+';'+FN;
  End;
end;

// Open dialog to set startup script
procedure TConfigForm.PBBrwSSClick(Sender: TObject);
Var FN: STring;
begin
  If OpenFileDialog(FGSCR,FN,False) then
    EBPosName.Text:=FN;
end;

Procedure TConfigForm.SaveMiscData;
Begin
  SaveFormData;
  SaveTraceColours;
End;

// Load saved form positions
Procedure TConfigForm.LoadFormData;
Var FI: TFormID;
    FN: String;
    WL,WT,WW,WH: Integer;
Begin
  With IniFile do begin
    For FI:=Low(TFormID) to High(TFormID) do begin
      // Get form name
      FN:=FormNames[FI];
      // Load its position/size values
      WT:=ReadInteger('Forms',FN+'.Top',0);
      WL:=ReadInteger('Forms',FN+'.Lft',0);
      WW:=ReadInteger('Forms',FN+'.Wid',0);
      WH:=ReadInteger('Forms',FN+'.Hgt',0);
      // Move it to position
      If WW>0 then
        MoveWindow(FormHandles[FI],WL,WT,WW,WH,True);
    End;
  End;
End;

// Save current form positions for next startup
Procedure TConfigForm.SaveFormData;
Var FI: TFormID;
    FN: String;
    WR: TRect;
Begin
  With IniFile do begin
    For FI:=Low(TFormID) to High(TFormID) do begin
      // Get window screen extents, Convert Bottom/Right to Height/Width
      GetWindowRect(FormHandles[FI],WR);
      With WR do begin
        Right:=Right-Left; Bottom:=Bottom-Top;
      End;
      // Get form name, Save its position/size values
      FN:=FormNames[FI];
      WriteInteger('Forms',FN+'.Top',WR.Top);
      WriteInteger('Forms',FN+'.Lft',WR.Left);
      WriteInteger('Forms',FN+'.Wid',WR.Right);
      WriteInteger('Forms',FN+'.Hgt',WR.Bottom);
    End;
    UpdateFile;
  End;
End;

// Load colours for trace display
Procedure TConfigForm.LoadTraceColours;
Var CI: TTraceID;
    TN: String;
Begin
  With IniFile do begin
    For CI:=Low(TTraceID) to High(TTraceID) do begin
      TN:='TI'+IntToStr(Ord(CI));
      With TraceColors[CI] do begin
        CLBrush:=ReadInteger('Trace Colours',TN+'.BGd',CLWhite);
        CLFont :=ReadInteger('Trace Colours',TN+'.Txt',ClBlack);
      End;
    End;
  End;
End;

// Save colours for trace display
Procedure TConfigForm.SaveTraceColours;
Var CI: TTraceID;
    TN: String;
Begin
  With IniFile do begin
    For CI:=Low(TTraceID) to High(TTraceID) do begin
      TN:='TI'+IntToStr(Ord(CI));
      With TraceColors[CI] do begin
        WriteInteger('Trace Colours',TN+'.BGd',CLBrush);
        WriteInteger('Trace Colours',TN+'.Txt',CLFont);
      End;
    End;
    UpdateFile;
  End;
End;

// General purpose open/save dialog procedure
// File group parameter sets filter for types of files allowed for that group
Function  TConfigForm.OpenFileDialog(FG: TFileGroup; Var FN: String; SM: Boolean): Boolean;
Var FP: String;
Begin
  With DLOpen do begin
    If FG=FGSAM then FilterIndex:=LastIndex      // Use same filter s last open?
                else FilterIndex:=Ord(FG);       // Or the one specified?
    If SM then begin                             // Save Mode?
      Title:='Save file as';                     // Set dialog caption
      Options:=Options-[OfFileMustExist];        // File needn't exists
    End else Begin
      Title:='Open file';
      Options:=Options+[OfFileMustExist];        // File must exits
    End;
    Result:=Execute;                             // Run the open dialog
    If Result then begin
      FN:=FileName;                              // Save pathname it returned
      FP:=ExtractFilePath(FN);                   // If path is the default,
      If AnsiCompareText(FP,EXEPath)=0 then      // remove path information
        FN:=ExtractFileName(FN);                 // for clarity
    End;
    LastIndex:=FilterIndex;                      // Save for next time
  End;
End;

Initialization
  EXEName:=ExtractFileName(Application.EXEName);
  EXEName:=Copy(EXEName,1,Pos('.',EXEName)-1);
  EXEPath:=ExtractFilePath(Application.EXEName);
End.
