//******************************************************************************
//  IBM 7094 Emulator - Tape Drive device
//  By Rob Storey 2001-2004 intabits@optushome.com.au
//------------------------------------------------------------------------------
//  This unit defines the "TTapesForm" form window, which is simply the parent
//  container for all the tape drive displays.
//  Each defined tape drive is represented by an instance of TDevTAP, and each
//  of these has an associated form window ("TFormMTape") to display its status.
//  These windows are all contained in the window defined by this unit.
//  The definitions for the TDevTAP and TFormMTape classes are contained in
//  B709TapF.
//------------------------------------------------------------------------------
Unit B709DTAP;

Interface

Uses SysUtils,Windows,Forms,Messages, StdCtrls,ComCtrls,
     Controls, Classes, ExtCtrls, Dialogs, Contnrs,
     B709Defs, // General definitions
     B709Cnfg, // Configuration Information
     B709Misc, // Miscellaneous utility functions
     B709Trce, // Log/Trace functions
     B709Chan; // I/O Channel and Device functions

Const Heading='IBM 729 Tape Drives';
      MaxDrives=20;

Type
  TTapesForm = class(TForm)
    Procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    DriveForms: TObjectList;
  public
    Procedure Initialize;
    Procedure DisplayDrives;
    Procedure DefineDrive(DA: Word);
    Procedure DeleteDrive(DA: Word);
  end;

Var TapesForm: TTapesForm;             // Form instance

Implementation

Uses B709TapF, // Tape Drive display subform
     B709Main,
     B709DRDR; // For form positioning

{$R *.DFM}

//******************************************************************************
//  Form Functions
//------------------------------------------------------------------------------
procedure TTapesForm.FormCreate(Sender: TObject);
begin
  FormHandles[FITapes]:=Handle;
  Caption:=Heading;
  DriveForms:=TObjectList.Create;
End;

procedure TTapesForm.FormDestroy(Sender: TObject);
begin
  DriveForms.Free;
end;

procedure TTapesForm.Initialize;
Begin
//Left:=MainForm.Width;
//Height:=100;
//Top:=ReaderForm.Height;
End;

Procedure TTapesForm.DefineDrive(DA: Word);
Begin
  If GetDevice(DA,False)=NIL then
    DefineDevice(DA,DT729);
End;

Procedure TTapesForm.DeleteDrive(DA: Word);
Begin
  If DA=0 then DeleteTypeDevices(DT729)
          else DeleteDevice(DA);
End;

Procedure TTapesForm.DisplayDrives;
Var TP,FW,FH: Integer;
    DI: Integer;
    DV: TDevTAP;
    FM: TFormTape;
Begin
  DriveForms.Clear;
  // Position and Display all drive forms
  TP:=0; FW:=0; DI:=0; FH:=0;
  Repeat
    DV:=TDevTAP(GetNextDevice(DI,DT729));
    If DV=NIL then Break;
    FM:=TFormTape.Create(Self);
    With FM do begin                   // Set up form position
      Parent:=Self; Top:=TP;
      FW:=Width; FH:=Height;
      If Odd(DI) then begin
        Left:=0;
      End else Begin
        Left:=Width; Inc(TP,FH);
      End;
      TAPDev:=DV;
      Initialize;                     // Initialize the form
    End;
    DriveForms.Add(FM);
  Until False;
  Width:=(FW*2)+10; Height:=(((DriveForms.Count+1) Div 2)*FH)+25;
End;

End.

