//******************************************************************************
//  IBM 7094 Emulator - Miscellaneous Functions
//  By Rob Storey 2001-2004 intabits@optushome.com.au
//------------------------------------------------------------------------------
//  This unit provides miscellaneous procedures and functions for other units
//------------------------------------------------------------------------------
Unit B709Misc;

Interface

Uses SysUtils,Windows,
     B709Defs; // General definitions

Function  Pad(SS: String; SL: Integer): String;
Function  Num2Str(IV: TWord; ND: Byte; HM: Boolean): ShortString;
Function  OctStrToInt(OS: ShortString): TWord;
Function  IntToOct(IV: TWord; ND: Byte): ShortString;
Function  InstOct(OC: TInst): ShortString;
Procedure Error(EM: String);
Procedure ProcessCheck(CM: String; AD: Word);
Procedure IOCheck(CM: String; AD: Word);

Implementation

// Pad a string to specified length
Function Pad(SS: String; SL: Integer): String;
Begin
  SL:=SL-Length(SS);                        // Pad input to 80 chars
  If SL>0 then SS:=SS+StringOfChar(' ',SL);
  Result:=SS;
End;

// General error handler - Raises an exception
Procedure Error(EM: String);
Begin
  Raise Exception.Create(EM);
End;

// Error handler for CPU error conditions
Procedure ProcessCheck(CM: String; AD: Word);
Begin
  Error('Process Check. '+CM+' '+IntToStr(AD));
End;

// Error handler for I/O error conditions
Procedure IOCheck(CM: String; AD: Word);
//Var EX: EIOCheck;
Begin
{  EX:=EIOCheck.Create(CM);
  With EX do begin
    Message:=CM;
    Address:=AD;
  End;
  Raise EX;}
  Error('I/O Check. '+CM+' '+IntToStr(AD));
End;

// Convert a binary word value to string, optionally in hex format
Function Num2Str(IV: TWord; ND: Byte; HM: Boolean): ShortString;
Var DC,CV: Byte;
Begin
  Result:='';
  If HM then
    For DC:=1 to ND do begin
      CV:=IV And $F;
      If CV>9 then Inc(CV,7);
      Result:=Chr(CV+$30)+Result;
      IV:=IV Shr 4;
    End
  Else
    For DC:=1 to ND do begin
      Result:=Chr((IV And 7)+$30)+Result;
      IV:=IV Shr 3;
    End;
End;

// Convert an octal string value to binary word value
Function OctStrToInt(OS: ShortString): TWord;
Var CC: Byte;
Begin
  Result:=0;
  For CC:=1 to Length(OS) do
    Result:=(Result Shl 3) Or (Ord(OS[CC])-$30);
End;

// Convert a binary word value to a string in octal format
Function IntToOct(IV: TWord; ND: Byte): ShortString;
Var DC: Byte;
Begin
  Result:='';
  For DC:=1 to ND do begin
    Result:=Chr((IV And 7)+$30)+Result;
    IV:=IV Shr 3;
  End;
End;

// Convert a binary instruction opcode value to a string in octal format
Function InstOct(OC: TInst): ShortString;
Var DC: Byte;
Begin
  Result:='';
  For DC:=1 to 3 do begin
    Result:=Chr((OC And 7)+$30)+Result;
    OC:=OC Shr 3;
  End;
  Result:=Chr((OC And 3)+$30)+Result;
  If (OC And 4)=0 then Result:='+'+Result
                  else Result:='-'+Result;
End;

// Convert a binary word value to a string in binary format
Function WordBits(WW: TWord): String;
Var BC: Integer;
    BM: TWord;
    SS: String;
Begin
  BM:=$800000000;
  SS:=StringOfChar('-',36);
  For BC:=1 to 36 do begin
    If (WW And BM)>0 then SS[BC]:='*';
    BM:=BM Shr 1;
  End;
  Result:=SS;
End;

End.

