//******************************************************************************
//  IBM 7094 Emulator - Process Stops panel
//  By Rob Storey 2001-2004 intabits@optushome.com.au
//------------------------------------------------------------------------------
//  This unit provides facilities to set conditions for processing stops
//------------------------------------------------------------------------------
Unit B709Stop;

Interface

Uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, StdCtrls,
     B709Defs, // General definitions
     B709Misc; // Miscellaneous utility functions

Type
  TStopsForm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    EBFetchAddr: TEdit;
    RBFetchStop: TRadioButton;
    RBFetchTrace: TRadioButton;
    CBFetchEnab: TCheckBox;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    EBAlterAddr: TEdit;
    RBAlterStop: TRadioButton;
    RBAlterTrace: TRadioButton;
    CBAlterEnab: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure SetupFetchStop(Sender: TObject);
    procedure SetupAlterStop(Sender: TObject);
  private
  public
  end;

Var StopsForm:   TStopsForm;
    FetchStopAddr:  Word;
    FetchStopCount: Word;
    FetchStopCtr:   Word;
    FetchStopStop:  Boolean;
    FetchStopTrace: Boolean;
    AlterStopAddr:  Word;
    AlterStopStop:  Boolean;
    AlterStopTrace: Boolean;

Implementation

Uses B709Main;  // To access CBStops (make CB a Btn/Lbl and use hide instead) 

{$R *.DFM}

procedure TStopsForm.FormCreate(Sender: TObject);
begin
  Caption:=Heading+' - Process Stops and Tracing';
  FetchStopAddr:=$8000;
  AlterStopAddr:=$8000;
end;

procedure TStopsForm.SetupFetchStop(Sender: TObject);
begin
  FetchStopAddr:=OctStrToInt(EBFetchAddr.Text);
  FetchStopCount:=1;
  FetchStopCtr:=0;
  FetchStopStop:=RBFetchStop.Checked;
  FetchStopTrace:=RBFetchTrace.Checked;
  If Sender<>CBFetchEnab then CBFetchEnab.Checked:=True;
  If Not CBFetchEnab.Checked then FetchStopAddr:=$8000;
end;

procedure TStopsForm.SetupAlterStop(Sender: TObject);
begin
  AlterStopAddr:=OctStrToInt(EBAlterAddr.Text);
  AlterStopStop:=RBAlterStop.Checked;
  AlterStopTrace:=RBAlterTrace.Checked;
  If Sender<>CBAlterEnab then CBAlterEnab.Checked:=True;
  If Not CBAlterEnab.Checked then AlterStopAddr:=$8000;
end;

procedure TStopsForm.FormDeactivate(Sender: TObject);
begin
  MainForm.CBStops.Checked:=False;
end;

End.
