//******************************************************************************
//  IBM 7094 Emulator - Tape Drive device
//  By Rob Storey 2001-2004 intabits@optushome.com.au
//------------------------------------------------------------------------------
//  This unit defines the splash screen shown on emulator startup
//------------------------------------------------------------------------------
Unit B709Spls;

Interface

Uses SysUtils,Windows, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, StdCtrls, ExtCtrls,
     B709Defs, // General definitions
     B709Trce; // Log/Trace functions

Const WebPageURL='http://members.optushome.com.au/intaemul/Emul7094.htm';
      EmailAdr='intabits@optushome.com.au';

Type
  TSplashForm = class(TForm)
    Panel3: TPanel;
    Label6: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    LAVersion: TLabel;
    Label4: TLabel;
    LACreateDate: TLabel;
    LAWebPage: TLabel;
    PBClose: TButton;
    Timer: TTimer;
    LACopyright: TLabel;
    LAEmail: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure PBCloseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LAWebPageClick(Sender: TObject);
  private
  public
  end;

Var SplashForm:   TSplashForm;

Implementation

{$R *.DFM}

procedure TSplashForm.FormCreate(Sender: TObject);
begin
Exit;
  LAVersion.Caption:=IntToStr(RelVer)+'.'+IntToStr(RelLvl)+RelMod;
  LACreateDate.Caption:=FormatDateTime(
    'DD MMM YYYY',FileDateToDateTime(FileAge(Application.EXEName)));
  Timer.Enabled:=True;
  LAWebPage.Caption:=WebPageURL;
  LAEmail.Caption:=EmailAdr;
  Show;
  Application.ProcessMessages;
end;

procedure TSplashForm.FormShow(Sender: TObject);
begin
  PBClose.Visible:=TraceForm<>NIL;  // Show close button if not splashing
  Application.ProcessMessages;      // TraceForm doesn't exist yet if starting up
end;

procedure TSplashForm.TimerTimer(Sender: TObject);
begin
  Timer.Enabled:=False;
  Timer.Free;
  Hide;
end;

procedure TSplashForm.PBCloseClick(Sender: TObject);
begin
//Timer.Enabled:=False;
  Hide;
end;

procedure TSplashForm.LAWebPageClick(Sender: TObject);
begin
//HelpForm.ShowWebPage(WebPageURL,False);
end;

End.
