C
C   Prime number generator using the sieve of Eratosthenes
C
      INTEGER I,NUM,MULT,PRIME,SIZE
      DIMENSION IFLAGS(1000)
C     *** SET ENDING NUMBER TO BE TESTED (must match array dimension)
      SIZE=1000
C     *** MARK ALL NUMBERS IN THE SIEVE AS PRIME INITIALLY, EXCEPT 2
      DO 10 I=1,SIZE
   10   IFLAGS(I)=1
      IFLAGS(1)=0
C
C     *** WORK THROUGH THE LIST, FINDING THE NEXT MARKED NUMBER
C
      DO 40 NUM=1,SIZE
        IF (IFLAGS(NUM).EQ.0) GOTO 40
C       *** MARKED NUMBER IS THE CURRENT PRIME, FORM ITS FIRST MULTIPLE
        PRIME=NUM
        MULT=PRIME+PRIME
C       *** UNMARK ALL MULTIPLES OF THE CURRENT PRIME
   20   IF (MULT.GT.SIZE) GOTO 40
        DO 30 I=MULT,SIZE,PRIME
   30     IFLAGS(I)=0
C     *** GO FIND NEXT UNMARKED NUMBER
   40 CONTINUE
C
C     *** PRINT RESULTS - ALL NUMBERS THAT ARE STILL MARKED
C
      WRITE(6,900)
      DO 50 NUM=1,SIZE
        IF (IFLAGS(NUM).EQ.0) GOTO 50
        WRITE(6,901) NUM
   50 CONTINUE
      STOP
C
  900 FORMAT(22H LIST OF PRIME NUMBERS)
  901 FORMAT(1X,I5)
      END

