       HED     TI-980 FORTH
       IDT     FORTH
************************************************************
*
* FORTH/980
*
* The following routines are system dependent and may
* need to be modified for use on a particular system:
*      KEY.............Character input
*      EMIT............Character output
*      ?TERMINAL.......Test for BREAK key
*      R/W.............Disk I/O interface
*
************************************************************
*
* REGISTER EQUATES
*
A      EQU  0
E      EQU  1
X      EQU  2
M      EQU  3
S      EQU  4
L      EQU  5
B      EQU  6
P      EQU  7
* IXB MODE
BR     EQU  1
*
* CONFIGURATION PARAMETERS
*
*
TRMADD EQU     >5              TERMINAL ADDRESS
*
DSKADD EQU     >1              DISK ADDRESS (DMA DEVICE)
DSKSTS EQU     >9A             DISK STATUS LOC
*
PRTADD EQU     >5              PRINTER ADDRESS (DMA DEVICE)
PRTSTS EQU     >A2             PRINTER STATUS LOC
       PEJ
*
* SYSTEM PARAMETERS
*
SYSWRD EQU     11              # WORDS FOR SYSTEM VARS.
ZCR    EQU     >0D             CARRIAGE RETURN
ZPEROD EQU     '.'             PERIOD
ZFF    EQU     >0C             FORM FEED
ZLF    EQU     >0A             LINE FEED
ZBS    EQU     >08             BACKSPACE
ZBELL  EQU     >07             BELL
ZSPACE EQU     ' '             SPACE
ZLNLEN EQU     80+1            LINE LENGTH
ZDQOTE EQU     '"'             DBL. QUOTE
ZRPARN EQU     ')'             RGT. PAREN.
ZSLASH EQU     '/'             SLASH
ZZERO  EQU     '0'
ZMINUS EQU     '-'
ZLETI  EQU     'I'
ZLETO  EQU     'O'
ZXON   EQU     >11             X-ON
ZXOFF  EQU     >13             X-OFF
ZCTLC  EQU     >03             CTRL-C
ZUSCOR EQU     '_'             UNDERSCORE
*
SECSIZ EQU     128
       PEJ
*
* STARTING POINT
*
ORIG   EQU    $
       BRU    MAIN1            COLD START
       @BRU   MAIN2            WARM START
*
* INITIALIZATION TABLE
*
       BRS     $               BASE REGISTER ORIGIN
BRSVAL DATA    980,1           CPU TYPE, REVISION
GETBRS DATA    BRSVAL
*
* "REGISTERS"
*
ZIP    DATA    0               INSTRUCTION POINTER
ZW     DATA    0               CODE RETURN POINTER
ZR     DATA    0               RETURN STACK POINTER
ZSP    DATA    0               PARAMETER STACK POINTER
ZNEXT  DATA    0               NEXT POINTER
ZTEMP1 DATA    0               TEMP 1
ZTEMP2 DATA    0               TEMP 2
ZTEMP3 DATA    0               TEMP 3
*
XBS    DATA    ZBS
UP     DATA    USER0           USER VARIABLE POINTER
* INITIAL VALUES FOR USER VARIABLES
XUSER0 DATA    0,0,0
XSP    DATA    STAX            BASE OF THE STACK
XR     DATA    RSTAX           BASE OF THE RETURN STACK
XTIB   DATA    STAX            TERMINAL INPUT BUFFER
XWIDTH DATA    31              NAME WIDTH
XWARNG DATA    0               NO DISK YET
XFENCE DATA    VEND            PROTECTED DICTIONARY
XGDP   DATA    LOWRAM          COLD START DP
XGVLNK DATA    FORLNK
*
* VARIOUS SYSTEM CONSTANTS
*
XNEXT  DATA    NEXT
XIPC   DATA    COLD+1          COLD VALUE FOR IP
XIPW   DATA    ABORT           WARM VALUE FOR IP
XVCLNK DATA    FORLNK          COLD START FOR VOC-LINK
XVLINK DATA    VLINK           COLD START FOR VOC POINTER
XRF    BSS     7               REGISTER FILE
       PEJ
*
* COLD START ENTRY POINT
*
MAIN1  LDA     GETBRS           SET BASE REGISTER
       RMO     A,B
       LDA     XIPC
       STA     ZIP
       LDA     XVLINK
       @STA    FORLNK+1        RESET VOC POINTER
*
* CONFIGURE THE NUMBER OF BUFFERS AVAILABLE BASED ON THE AVAILABLE
* MEMORY (DYNAMIC ALLOCATION)
*
       @LDA    =ZBUFF          BUFFERS BEGINNING
SEARCH ADD     =64+2           WORDS/BUFFER + OVERHEAD
       @CPL    =>7FF0          IF WE GET THIS BIG 
       SLT
       BRU     SEATOP             IT'S GOOD ENOUGH
       STA     ZTEMP1
       LDE     *ZTEMP1         GET CONTENTS
       IMO     *ZTEMP1         TRY TO FLIP IT
       LDX     *ZTEMP1
       RCL     X,E             IF IT CHANGED THEN
       SEQ
       BRU     SEARCH             KEEP SEARCHING
* NON-EXISTANT MEMORY ENCOUNTERED
SEATOP SUB     =64+2           BACK UP TO LAST GOOD LOC
       @STA    ENDROM          SAVE DEBUG POINTER
       @STA    HI+1            SAVE HI ADDRESS
       @STA    LIMIT+1         SAVE NEW LIMIT
       BRU     START
*
GETBYT @SRF    XRF             GET A BYTE (USES BYTE ADDRESSING)
       RMO     L,B
       LDA     *0,BR
       RMO     A,B
       LDA     0,BR
       RMO     L,B
       LDE     *1,BR
       LDX     =1
       RCL     E,X
       SEQ
       BRU     GETEVN
       IMO     *0,BR
       BRU     GETODD
GETEVN LRA     8
GETODD @AND    =>FF
       REO     X,E
       STE     *1,BR
       STA     XRF
       @LRF    XRF
       RIN     L,L
       RIN     L,P
*
PUTBYT @SRF    XRF             PUT A BYTE (USES BYTE ADDRESSING)
       RMO     L,B
       LDM     =>7F
       LDE     *1,BR
       LDX     =1
       RCL     E,X
       SEQ
       BRU     PUTEVN
       CRM     8
       BRU     PUTODD
PUTEVN LLA     8
PUTODD LDX     *0,BR
       RMO     X,B
       LDX     0,BR
       RAN     M,X
       ROR     A,X
       STX     0,BR
       RMO     L,B
       LDX     =1
       RCL     E,X
       SNE
       IMO     *0,BR
       REO     X,E
       STE     *1,BR
       @LRF    XRF
       RIN     L,L
       RIN     L,P
*
ADRBYT @SRF    XRF             CONVERT BYTE ADDRESS TO WORD/NDX
       RMO     L,B
       LDM     =1
       RMO     A,E
       RAN     M,E
       STE     *1,BR           BYTE INDEX (0 OR 1)
       LRA     1
       STA     *0,BR           WORD ADDRESS
       @LRF    XRF
       RIN     L,L
       RIN     L,P
*
DECBYT @SRF    XRF             DECREMENT BYTE POINTER
       RMO     L,B
       LDA     *0,BR
       LDE     *1,BR
       LDX     =1
       RCL     E,X
       SEQ
       BRU     BAKEVN
       RDE     E,E
       BRU     BAKODD
BAKEVN RDE     A,A
       RMO     X,E
BAKODD STA     *0,BR
       STE     *1,BR
       @LRF    XRF
       RIN     L,L
       RIN     L,P
       PEJ
*
* WARM START ENTRY
*
MAIN2  LDA     GETBRS           SET BASE REGISTER
       RMO     A,B
       LDA     XIPW
       STA     ZIP
*
START  LDA     XSP
       STA     ZSP
       LDA     XR
       STA     ZR
       LDA     XNEXT
       STA     ZNEXT
*
* GET NEXT WORD
*
NEXT   LDA     *ZIP
       IMO     ZIP
       STA     ZW
       LDA     *ZW             ZW POINTS TO PFA !!
       IMO     ZW
       STA     ZTEMP1
       BRU     *ZTEMP1
*
       DATA    >834E,>4FD0    'NOP'
       DATA    0               END OF LINK LIST
NOP    DATA    $+1
       BRU     *ZNEXT          ALLOWS FOR BREAKPOINTS
       PEJ
*
* START OF DICTIONARY
*
       DATA    >834C,>49D4    'LIT'
       DATA    NOP-3
LIT    DATA    $+1
       DMT     ZSP
       LDA     *ZIP            PICKUP & STORE LITERAL
       IMO     ZIP
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8745,'XECU',>54C5
       DATA    LIT-3
EXEC   DATA    $+1
       LDA     *ZSP            GET ADDRESS
       IMO     ZSP
       STA     ZW
       LDA     *ZW
       IMO     ZW
       STA     ZTEMP1
       BRU     *ZTEMP1         GO DO IT
*
       DATA    >8642,'RANC',>48A0
       DATA    EXEC-5
BRAN   DATA    $+1
BRAN2  LDA     ZIP
       ADD     *ZIP
       STA     ZIP
       BRU     *ZNEXT          TRANSFER
*
       DATA    >8730,'BRAN',>43C8
       DATA    BRAN-5
ZBRAN  DATA    $+1
       LDA     *ZSP            CONDITIONAL BRANCH
       IMO     ZSP
       CPL     =0
       SNE
       BRU     BRAN2
BUMP   IMO     ZIP
       BRU     *ZNEXT
*
       DATA    >8628,'LOOP',>29A0
       DATA    ZBRAN-5
LOOP   DATA    $+1
       IMO     *ZR
       LDX     ZR
       RMO     B,M
       RMO     X,B
       BRU     PLOP1
*
       DATA    >8728,'+LOO',>50A9
       DATA    LOOP-5
PLOOP  DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       LDE     ZR
       RMO     B,M
       RMO     E,B
       ADD     0,BR            ADD LOOP INDEX
       STA     0,BR
       CPA     =0              CHECK DIRECTION
       SGE
       BRU     PLOP2
PLOP1  LDA     0,BR
       CPA     1,BR            CHECK LIMIT
       SLT
       BRU     PLOP5           EXIT
       BRU     PLOP6
PLOP2  LDA     0,BR
       CPA     1,BR            CHECK LIMIT
       SLE
       BRU     PLOP6
PLOP5  RMO     M,B
       IMO     ZR              DROP LOOP ADDRESS
       IMO     ZR
       BRU     BUMP
PLOP6  RMO     M,B
       BRU     BRAN2
*
       DATA    >8428,'DO',>29A0
       DATA    PLOOP-5
DO     DATA    $+1
       LDA     ZR
       SUB     =2
       STA     ZR
       LDE     *ZSP            GET TERMINAL VALUE
       IMO     ZSP
       LDX     *ZSP            GET INITIAL VALUE
       IMO     ZSP
       RMO     B,M
       RMO     A,B
       STE     0,BR            PUSH TERMINAL VALUE
       STX     1,BR            PUSH INITIAL VALUE
       RMO     M,B
       BRU     *ZNEXT
*
       DATA    >81C9
       DATA    DO-4
I      DATA    $+1
       DMT     ZSP
       LDA     *ZR             GET INNER LOOP INDEX
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >81CA
       DATA    I-2
J      DATA    $+1
       DMT     ZSP
       LDA     ZR
       ADD     =2
       STA     ZTEMP1
       LDA     *ZTEMP1         GET OUTER LOOP INDEX
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8544,'IG',>49D4
       DATA    J-2
DIGIT  DATA    $+1
       LDE     *ZSP            BASE
       IMO     ZSP
       LDA     *ZSP
       SUB     =>30
       LDX     =10
       RCL     A,X
       SGT
       BRU     DIG1
       SUB     =7              HEX
       RCL     E,X
       SLT
       BRU     DIG1
DIG3   LDX     =0              BAD RANGE
       BRU     DIGX
DIG1   RCL     A,E
       SLT
       BRU     DIG3
       STA     *ZSP
       DMT     ZSP
       LDX     =1
DIGX   STX     *ZSP
       BRU     *ZNEXT
*
       DATA    >8628,'FIND',>29A0
       DATA    DIGIT-4
PFIND  DATA    $+1
       LDA     *ZSP            GET POINTER TO FIRST VOCAB WORD
       STA     BYTPTR
       LDA     =0
       STA     *ZSP
       STA     BYTNDX
       LDA     ZSP
       RIN     A,A
       STA     ZTEMP1
       RIN     A,A
       STA     ZTEMP2
PF1    LDA     *ZTEMP1         ENTERED STRING POINTER
       STA     ENTPTR
       LDA     =0
       STA     ENTNDX
       BRL     GETBYT          GET COUNT BYTE
       DATA    BYTPTR,BYTNDX
       STA     *ZSP
       RMO     A,M
       BRL     GETBYT
       DATA    ENTPTR,ENTNDX
       REO     M,A
       AND     =>3F
       CPL     =0              EQUAL LENGTH?
       SEQ
       BRU     PF3             NO, GET NEXT WORD
PF2    BRL     GETBYT          GET COMMAND WORD BYTE
       DATA    BYTPTR,BYTNDX
       RMO     A,M
       BRL     GETBYT          GET ENTERED BYTE
       DATA    ENTPTR,ENTNDX
       REO     M,A
       RMO     A,E
       CPL     =0              EQUAL?
       SNE
       BRU     PF2             YES, KEEP CHECKING
       AND     =>7F            NO, AT END?
       CPL     =0
       SNE
       BRU     PF21            YES, RETURN
       RMO     E,A
       LRA     7
       CPL     =0
       SEQ
       BRU     PF4
       BRU     PF3
PF21   LDA     =1
       DMT     ZSP
       STA     *ZSP
       LDA     BYTPTR
       ADD     =2
       STA     *ZTEMP1
       BRU     *ZNEXT
PF3    BRL     GETBYT          SKIP REMAINDER OF WORD
       DATA    BYTPTR,BYTNDX
       LRA     7
       CPL     =0
       SNE
       BRU     PF3
PF4    LDA     *BYTPTR         GET POINTER TO NEXT WORD
       STA     BYTPTR
       LDX     =0
       STX     BYTNDX
       CPL     =0              END IF LIST
       SEQ
       BRU     PF1
       IMO     ZSP
       STX     *ZSP
       BRU     *ZNEXT          FAILURE EXIT
BYTPTR DATA    0
BYTNDX DATA    0
ENTPTR DATA    0
ENTNDX DATA    0
*
       DATA    >8745,'NCLO',>53C5
       DATA    PFIND-5
ENCL   DATA    $+1
       LDX     *ZSP            DELIMITER
       IMO     ZSP
       LDA     *ZSP            ADDRESS
       BRL     ADRBYT
       DATA    ENCPTR,ENCNDX
       LDE     =-1
ENC1   RIN     E,E
       BRL     GETBYT         SKIP INITIAL DELIMITERS
       DATA    ENCPTR,ENCNDX
       RCL     X,A
       SNE
       BRU     ENC1
       BRL     DECBYT
       DATA    ENCPTR,ENCNDX
       DMT     ZSP
       STE     *ZSP
       DMT     ZSP
       LDA     ZSP
       STA     ZTEMP1
       DMT     ZSP
       STE     *ZSP
       RIN     E,E
       STE     *ZTEMP1
       BRL     GETBYT
       DATA    ENCPTR,ENCNDX
       CPL     =0
       SNE
       BRU     *ZNEXT
ENC2   STE     *ZTEMP1
       BRL     GETBYT
       DATA    ENCPTR,ENCNDX
       CPL     =0
       SNE
       BRU     ENC3
       RIN     E,E
       RCL     A,X
       SEQ
       BRU     ENC2
ENC3   STE     *ZSP
       BRU     *ZNEXT
ENCPTR DATA    0
ENCNDX DATA    0
       PEJ
*
* KEY, EMIT, CR, ?TERMINAL ARE HERE
*
       DATA    >834B,>45D9
       DATA    ENCL-5
KEY    DATA    $+1
       DMT     ZSP             MAKE ROOM
       RDS     TRMADD
       DATA    >80
       BRU     $-2
       AND     =>7F
       CPL     =>7F
       SNE
       LDA     =ZBS
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8445,'MI',>54A0
       DATA    KEY-3
EMIT   DATA    $+1
       @LDA    GPRTBS          IF THIS IS SET
       CPL     =0
       SEQ
       BRU     EMI010          WE GO TO THE PRINTER
       LDA     *ZSP            OTHERWISE TO THE CONSOLE
       IMO     ZSP
       AND     =>7F
       @IOR    =>5000
       WDS     TRMADD
       DATA    >80
       BRU     $-2
EMI005 @IMO    GOUT
       BRU     *ZNEXT
EMI010 @BRL    PEMIT
       BRU     EMI005
*
       DATA    >8550,'BA',>53C5
       DATA    EMIT-4
PBASE  DATA    DOUSER,GPRTBS-USER0
*
       DATA    >8642,'YTAD',>52A0
       DATA    PBASE-4
BYTADR DATA    $+1             CONVERT ADDRESS TO BYTE FORMAT
       LDA     *ZSP
       LLA     1
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8657,'RDAD',>52A0
       DATA    BYTADR-5
WRDADR DATA    $+1             CONVERT BYTE ADDRESS TO WORD
       LDA     *ZSP
       LRA     1
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8243,>52A0
       DATA    WRDADR-5
CR     DATA    DOCOL,PTYPE     ISSUE <CR> <LF>
       DATA    >020D,>0A00
       DATA    SEMIS
*
       DATA    >893F,'TERMIN',>41CC
       DATA    CR-3
QTERM  DATA    $+1
       LDA     =0
       RDS     TRMADD
       DATA    >80
       BRU     NOBRK
       AND     =>7F
       CPL     =ZCTLC          CTRL-C
       SNE
       LDA     =1
NOBRK  DMT     ZSP
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8543,'MO',>56C5
       DATA    QTERM-6
CMOVE  DATA    $+1             USES BYTE ADDRESSES
       LDX     *ZSP            COUNT
       IMO     ZSP
       LDA     *ZSP
       IMO     ZSP             DEST
       BRL     ADRBYT
       DATA    CMDPTR,CMDNDX
       LDA     *ZSP
       IMO     ZSP             SOURCE
       BRL     ADRBYT
       DATA    CMSPTR,CMSNDX
       RMO     X,A
       CPL     =0
       SGT
       BRU     CM1
       RCO     X,X
CM2    STX     CMSXRG
       BRL     GETBYT
       DATA    CMSPTR,CMSNDX
       BRL     PUTBYT
       DATA    CMDPTR,CMDNDX
       LDX     CMSXRG
       BIX     CM2
CM1    BRU     *ZNEXT
CMSXRG DATA    0
CMSPTR DATA    0
CMSNDX DATA    0
CMDPTR DATA    0
CMDNDX DATA    0
*
       DATA    >854D,'OV',>45A0
       DATA    CMOVE-4
MOVE   DATA    $+1
       LDX     *ZSP            COUNT
       IMO     ZSP
       LDA     *ZSP
       IMO     ZSP             DEST
       STA     ZTEMP1
       LDA     *ZSP
       IMO     ZSP             SOURCE
       STA     ZTEMP2
       RMO     X,A
       CPL     =0
       SGT
       BRU     MOV1
       RCO     X,X
MOV2   LDA     *ZTEMP2
       IMO     ZTEMP2
       STA     *ZTEMP1
       IMO     ZTEMP1
       BIX     MOV2
MOV1   BRU     *ZNEXT
*
       DATA    >8255,>2AA0
       DATA    MOVE-4
MULT   DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       MPY     *ZSP            UNSIGNED MULTIPLY
       CRE     15              ALLOW FOR 980 DP NUMBERS
       LRD     1
       DMT     ZSP
       DST     *ZSP
       BRU     *ZNEXT
*
       DATA    >8255,>2FA0
       DATA    MULT-3
DIV    DATA    $+1
       LDA     ZSP
       IMO     ZSP
       RMO     B,M
       RMO     A,B
       DLD     1,BR
       LLD     1               ALLOW FOR 980 DP NUMBERS
       CRE     1
       DIV     0,BR            UNSIGNED DIVIDE
       DST     1,BR
       RMO     M,B
       BRU     *ZNEXT
*
       DATA    >8341,>4EC4
       DATA    DIV-3
AND    DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       AND     *ZSP            LOGICAL AND
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >824F,>52A0
       DATA    AND-3
OR     DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       IOR     *ZSP            LOGICAL OR
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8358,>4FD2
       DATA    OR-3
XOR    DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       LDE     *ZSP
       REO     A,E             LOGICAL EXCLUSIVE OR
       STE     *ZSP
       BRU     *ZNEXT
*
       DATA    >8353,>50C0
       DATA    XOR-3
SPAT   DATA    $+1
       DMT     ZSP
       LDA     ZSP
       STA     *ZSP            PUSH STACK POINTER
       IMO     *ZSP
       BRU     *ZNEXT
*
       DATA    >8353,>50A1
       DATA    SPAT-3
SPSTOR DATA    $+1
       LDA     UP              INIT STACK POINTER
       RMO     B,M
       RMO     A,B
       LDA     GSZERO-USER0,BR
       RMO     M,B
       STA     ZSP
       BRU     *ZNEXT
*
       DATA    >8352,>50A1
       DATA    SPSTOR-3
RPSTOR DATA    $+1
       LDA     UP              INIT RETURN POINTER
       RMO     B,M
       RMO     A,B
       LDA     GRZERO-USER0,BR
       RMO     M,B
       STA     ZR
       BRU     *ZNEXT
*
       DATA    >823B,>53A0
       DATA    RPSTOR-3
SEMIS  DATA    $+1
       LDA     *ZR             GET RETURN
       IMO     ZR
       STA     ZIP
       BRU     *ZNEXT
*
       DATA    >854C,'EA',>56C5
       DATA    SEMIS-3
LEAVE  DATA    $+1
       LDA     *ZR             FORCE EXIT
       LDE     ZR
       STE     ZTEMP1
       IMO     ZTEMP1
       STA     *ZTEMP1
       BRU     *ZNEXT
*
       DATA    >823E,>52A0
       DATA    LEAVE-4
TOR    DATA    $+1
       DMT     ZR
       LDA     *ZSP            MOVE STACK TO RETURN
       IMO     ZSP
       STA     *ZR
       BRU     *ZNEXT
*
       DATA    >8252,>3EA0
       DATA    TOR-3
FROMR  DATA    $+1
       DMT     ZSP              MOVE RETURN TO STACK
       LDA     *ZR
       IMO     ZR
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >81D2
       DATA    FROMR-3
R      DATA    $+1
       DMT     ZSP             COPY RETURN TO STACK
       LDA     *ZR
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8230,>3DA0
       DATA    R-2
ZEQU   DATA    $+1
       LDA     *ZSP            TEST FOR EQUAL TO ZERO
       CPA     =0
       SEQ
       BRU     PSHFL
       BRU     PSHTR
*
       DATA    >8230,>3CA0
       DATA    ZEQU-3
ZLESS  DATA    $+1
       LDA     *ZSP            TEST FOR LESS THAN ZERO
       CPA     =0
       SGE
       BRU     PSHTR
PSHFL  LDA     =0
       BRU     PSHVL
PSHTR  LDA     =1
PSHVL  STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >81AB
       DATA    ZLESS-3
PLUS   DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       ADD     *ZSP            ADD TWO ITEMS
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8244,>2BA0
       DATA    PLUS-2
DPLUS  DATA    $+1
       DLD     *ZSP
       IMO     ZSP
       IMO     ZSP
       RMO     A,M
       LDA     ZSP
       STA     ZTEMP1
       RMO     M,A
       LDX     *ZTEMP1
       IMO     ZTEMP1
       LDM     *ZTEMP1
       RAD     X,A
       RAD     M,E
       SNC
       RIN     A,A
       DST     *ZSP
       BRU     *ZNEXT
*
       DATA    >854D,'IN',>55D3
       DATA    DPLUS-3
MINUS  DATA    $+1
       LDA     *ZSP            NEGATE TOP
       RCO     A,A
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8644,'MINU',>53A0
       DATA    MINUS-4
DMINUS DATA    $+1
       DLD     *ZSP            DOUBLE PRECISION NEGATE
       LDM     =1
       RIV     A,A
       RIV     E,E
       RAD     M,E
       SNC 
       RIN     A,A             UNDERFLOW
       DST     *ZSP
       BRU     *ZNEXT
*
       DATA    >844F,'VE',>52A0
       DATA    DMINUS-5
OVER   DATA    $+1
       DMT     ZSP             N1 N2 -> N1 N2 N1
       LDA     ZSP
       RMO     B,M
       RMO     A,B
       LDA     2,BR
       STA     0,BR
       RMO     M,B
       BRU     *ZNEXT
*
       DATA    >8444,'RO',>50A0
       DATA    OVER-4
DROP   DATA    $+1
       IMO     ZSP             N1 N2 -> N1
       BRU     *ZNEXT
*
       DATA    >8453,'WA',>50A0
       DATA    DROP-4
SWAP   DATA    $+1
       LDA     ZSP             N1 N2 -> N2 N1
       RMO     B,M
       RMO     A,B
       LDA     0,BR
       LDE     1,BR
       STE     0,BR
       STA     1,BR
       RMO     M,B
       BRU     *ZNEXT
*
       DATA    >8344,>55D0
       DATA    SWAP-4
DUP    DATA    $+1
       DMT     ZSP             N -> N N
       RMO     B,M
       LDA     ZSP
       RMO     A,B
       LDA     1,BR
       STA     0,BR
       RMO     M,B
       BRU     *ZNEXT
*
       DATA    >822B,>21A0
       DATA    DUP-3
PSTORE DATA    $+1
       LDA     *ZSP            ADD STACK TO MEMORY
       IMO     ZSP
       STA     ZTEMP1
       LDA     *ZSP
       IMO     ZSP
       ADD     *ZTEMP1
       STA     *ZTEMP1
       BRU     *ZNEXT
*
       DATA    >8654,'OGGL',>45A0
       DATA    PSTORE-3
TOGGLE DATA    $+1
       LDE     *ZSP            VALUE
       IMO     ZSP
       LDA     *ZSP            ADDRESS
       IMO     ZSP
       BRL     ADRBYT
       DATA    CATPTR,CATNDX
       BRL     GETBYT
       DATA    CATPTR,CATNDX
       REO     E,A
       BRL     DECBYT
       DATA    CATPTR,CATNDX
       BRL     PUTBYT
       DATA    CATPTR,CATNDX
       BRU     *ZNEXT
*
       DATA    >81C0
       DATA    TOGGLE-5
AT     DATA    $+1
       LDA     *ZSP            GET ADDRESS
       STA     ZTEMP1
       LDA     *ZTEMP1         GET CONTENTS
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8243,>40A0
       DATA    AT-2
CAT    DATA    $+1             USES BYTE ADDRESSES
       LDA     *ZSP
       BRL     ADRBYT
       DATA    CATPTR,CATNDX
       BRL     GETBYT
       DATA    CATPTR,CATNDX
       STA     *ZSP            CHARACTERS IN LOW BYTE
       BRU     *ZNEXT
CATPTR DATA    0
CATNDX DATA    0
*
       DATA    >81A1
       DATA    CAT-3
STORE  DATA    $+1
       LDA     *ZSP            GET ADDRESS
       IMO     ZSP
       STA     ZTEMP1
       LDA     *ZSP
       IMO     ZSP
       STA     *ZTEMP1         STORE VALUE
       BRU     *ZNEXT
*
       DATA    >8243,>21A0
       DATA    STORE-2
CSTORE DATA    $+1             USES BYTE ADDRESSES
       LDA     *ZSP
       IMO     ZSP
       BRL     ADRBYT
       DATA    CSTPTR,CSTNDX
       LDA     *ZSP
       IMO     ZSP
       BRL     PUTBYT          STORE CHARACTER
       DATA    CSTPTR,CSTNDX
       BRU     *ZNEXT
CSTPTR DATA    0
CSTNDX DATA    0
*
       DATA    >81BA
       DATA    CSTORE-3
COLON  DATA    DOCOL,QEXEC,STRCSP,CURR,AT,CONT
       DATA    STORE,CREATE,RTBKT,PSCODE
DOCOL  DMT     ZR              BASIC
       LDA     ZIP
       STA     *ZR
       LDA     ZW
       STA     ZIP
       BRU     *ZNEXT
*
       DATA    >C1BB
       DATA    COLON-2
SEMI   DATA    DOCOL,QCSP,COMPI,SEMIS,SMUDGE,LBKT,SEMIS
*
       DATA    >8843,'ONSTAN',>54A0
       DATA    SEMI-2
CON    DATA    DOCOL,CREATE,SMUDGE,COMMA,PSCODE
DOCON  DMT     ZSP             BASIC
       LDA     *ZW             PUSH CONSTANT
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8856,'ARIABL',>45A0
       DATA    CON-6
VAR    DATA    DOCOL,CON,PSCODE
DOVAR  DMT     ZSP
       LDA     ZW
       STA     *ZSP            PUSH ADDRESS
       BRU     *ZNEXT
*
       DATA    >8455,'SE',>52A0
       DATA    VAR-6
USER   DATA    DOCOL,CON,PSCODE
DOUSER DMT     ZSP
       LDA     *ZW
       ADD     UP
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >873C,'BUIL',>44D3
       DATA    USER-4
BUILDS DATA    DOCOL,ZERO,CON,SEMIS
*
       DATA    >8544,'OE',>53BE
       DATA    BUILDS-5
DOES   DATA    DOCOL,FROMR,LATEST,PFA,STORE,PSCODE
* OUT OF ORDER DUE TO SHORT JUMP
DODOES DMT     ZSP
       LDA     ZW
       ADD     =1
       STA     *ZSP
       LDA     *ZW
       STA     ZW
       BRU     DOCOL
*
       DATA    >81B0
       DATA    DOES-4
ZERO   DATA    DOCON,0
*
       DATA    >81B1
       DATA    ZERO-2
ONE    DATA    DOCON,1
*
       DATA    >81B2
       DATA    ONE-2
TWO    DATA    DOCON,2
*
       DATA    >81B3
       DATA    TWO-2
THREE  DATA    DOCON,3
*
       DATA    >8242,>4CA0
       DATA    THREE-2
BL     DATA    DOCON,ZSPACE
*
       DATA    >8343,>2FCC
       DATA    BL-3
CL     DATA    DOCON,64
*
       DATA    >8546,'IR',>53D4
       DATA    CL-3
FIRST  DATA    DOCON,ZBUFF
*
       DATA    >854C,'IM',>49D4
       DATA    FIRST-4
LIMIT  DATA    DOCON,ZHI
*
       DATA    >8542,'/B',>55C6
       DATA    LIMIT-4
BPBUF  DATA    DOCON,SECSIZ
*
       DATA    >8542,'/S',>43D2
       DATA    BPBUF-4
BPSCR  DATA    DOCON,8
*
       DATA    >8253,>30A0
       DATA    BPSCR-4
SZERO  DATA    DOUSER,GSZERO-USER0
*
       DATA    >8252,>30A0
       DATA    SZERO-3
RZERO  DATA    DOUSER,GRZERO-USER0
*
       DATA    >8354,>49C2
       DATA    RZERO-3
TIB    DATA    DOUSER,GTIB-USER0
*
       DATA    >8557,'ID',>54C8
       DATA    TIB-3
WIDTH  DATA    DOUSER,GWIDTH-USER0
*
       DATA    >8757,'ARNI',>4EC7
       DATA    WIDTH-4
WARNG  DATA    DOUSER,GWARNG-USER0
*
       DATA    >8546,'EN',>43C5
       DATA    WARNG-5
FENCE  DATA    DOUSER,GFENCE-USER0
*
       DATA    >8244,>50A0
       DATA    FENCE-4
DP     DATA    DOUSER,GDP-USER0
*
       DATA    >8856,'OC-LIN',>4BA0
       DATA    DP-3
VOCLNK DATA    DOUSER,GVLNK-USER0
*
       DATA    >8342,>4CCB
       DATA    VOCLNK-6
BLK    DATA    DOUSER,GBLK-USER0
*
       DATA    >8249,>4EA0
       DATA    BLK-3
IN     DATA    DOUSER,GIN-USER0
*
       DATA    >834F,>55D4
       DATA    IN-3
OUT    DATA    DOUSER,GOUT-USER0
*
       DATA    >8353,>43D2
       DATA    OUT-3
SCR    DATA    DOUSER,GSCR-USER0
*
       DATA    >864F,'FFSE',>54A0
       DATA    SCR-3
OFFSET DATA    DOUSER,GOFSET-USER0
*
       DATA    >8453,'KE',>57A0
       DATA    OFFSET-5
SKEW   DATA    DOUSER,GSKEW-USER0
*
       DATA    >8743,'ONTE',>58D4
       DATA    SKEW-4
CONT   DATA    DOUSER,GCONT-USER0
*
       DATA    >8743,'URRE',>4ED4
       DATA    CONT-5
CURR   DATA    DOUSER,GCURR-USER0
*
       DATA    >8553,'TA',>54C5
       DATA    CURR-5
STATE  DATA    DOUSER,GSTATE-USER0
*
       DATA    >8442,'AS',>45A0
       DATA    STATE-4
BASE   DATA    DOUSER,GBASE-USER0
*
       DATA    >8344,>50CC
       DATA    BASE-4
DPL    DATA    DOUSER,GDPL-USER0
*
       DATA    >8346,>4CC4
       DATA    DPL-3
FLD    DATA    DOUSER,GFLD-USER0
*
       DATA    >8343,>53D0
       DATA    FLD-3
CSP    DATA    DOUSER,GCSP-USER0
*
       DATA    >8252,>23A0
       DATA    CSP-3
RNUM   DATA    DOUSER,GRNUM-USER0
*
       DATA    >8348,>4CC4
       DATA    RNUM-3
HLD    DATA    DOUSER,GHLD-USER0
*
       DATA    >8231,>2BA0
       DATA    HLD-3
ONEP   DATA    $+1
       IMO     *ZSP            INCREMENT STACK TOP
       BRU     *ZNEXT
*
       DATA    >8232,>2BA0
       DATA    ONEP-3
TWOP   DATA    $+1
       IMO     *ZSP            ADD 2 TO STACK TOP
       IMO     *ZSP
       BRU     *ZNEXT
*
       DATA    >8448,'ER',>45A0
       DATA    TWOP-3
HERE   DATA    DOCOL,DP,AT,SEMIS
*
       DATA    >8541,'LL',>4FD4
       DATA    HERE-4
ALLOT  DATA    DOCOL,DP,AT,BYTADR,PLUS,ONEP,WRDADR
       DATA    DP,STORE,SEMIS
*
       DATA    >81AC
       DATA    ALLOT-4
COMMA  DATA    DOCOL,HERE,STORE,ONE,ALLOT,SEMIS
*
       DATA    >8243,>2CA0
       DATA    COMMA-2
CCOMMA DATA    DOCOL,HERE,CSTORE,ONE,ALLOT,SEMIS
*
       DATA    >81AD
       DATA    CCOMMA-3
SUB    DATA    $+1
       LDX     *ZSP
       IMO     ZSP
       LDA     *ZSP
       RSU     X,A
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >81BD
       DATA    SUB-2
EQUAL  DATA    DOCOL,SUB,ZEQU,SEMIS
*
       DATA    >81BC
       DATA    EQUAL-2
LESS   DATA    DOCOL,SUB,ZLESS,SEMIS
*
       DATA    >81BE
       DATA    LESS-2
GREAT  DATA    DOCOL,SWAP,SUB,ZLESS,SEMIS
*
       DATA    >8352,>4FD4
       DATA    GREAT-2
ROT    DATA    DOCOL,TOR,SWAP,FROMR,SWAP,SEMIS
*
       DATA    >8553,'PA',>43C5
       DATA    ROT-3
SPACE  DATA    DOCOL,BL,EMIT,SEMIS
*
       DATA    >842D,'DU',>50A0
       DATA    SPACE-4
DDUP   DATA    DOCOL,DUP,ZBRAN,QDUP1-$,DUP
QDUP1  DATA    SEMIS
*
       DATA    >8854,'RAVERS',>45A0
       DATA    DDUP-4
TRAVRS DATA    DOCOL,SWAP
TRA1   DATA    OVER,PLUS,LIT,>7F,OVER
       DATA    CAT,LESS,ZBRAN,TRA1-$
       DATA    SWAP,DROP,SEMIS
*
       DATA    >834C,>46C1
       DATA    TRAVRS-6
LFA    DATA    DOCOL,LIT,4,SUB,SEMIS
*
       DATA    >8343,>46C1
       DATA    LFA-3
CFA    DATA    DOCOL,ONE,SUB,SEMIS
*
       DATA    >834E,>46C1
       DATA    CFA-3
NFA    DATA    DOCOL,LIT,5,SUB,LIT,-1,TRAVRS,SEMIS
*
       DATA    >8350,>46C1
       DATA    NFA-3
PFA    DATA    DOCOL,ONE,TRAVRS,LIT,5,PLUS,SEMIS
*
       DATA    >864C,'ATES',>54A0
       DATA    PFA-3
LATEST DATA    DOCOL,CURR,AT,AT,SEMIS
*
       DATA    >8421,'CS',>50A0
       DATA    LATEST-5
STRCSP DATA    DOCOL,SPAT,CSP,STORE,SEMIS
*
       DATA    >863F,'ERRO',>52A0
       DATA    STRCSP-4
QERROR DATA    DOCOL,SWAP,ZBRAN,QERR1-$,ERROR,SEMIS
QERR1  DATA    DROP,SEMIS
*
       DATA    >853F,'CO',>4DD0
       DATA    QERROR-5
QCOMP  DATA    DOCOL,STATE,AT,ZEQU,LIT,17,QERROR,SEMIS
*
       DATA    >853F,'EX',>45C3
       DATA    QCOMP-4
QEXEC  DATA    DOCOL,STATE,AT,LIT,18,QERROR,SEMIS
*
       DATA    >863F,'PAIR',>53A0
       DATA    QEXEC-4
QPAIRS DATA    DOCOL,SUB,LIT,19,QERROR,SEMIS
*
       DATA    >843F,'CS',>50A0
       DATA    QPAIRS-5
QCSP   DATA    DOCOL,SPAT,CSP,AT,SUB,LIT,20,QERROR,SEMIS
*
       DATA    >883F,'LOADIN',>47A0
       DATA    QCSP-4
QLOAD  DATA    DOCOL,BLK,AT,ZEQU,LIT,22,QERROR,SEMIS
*
       DATA    >8743,'OMPI',>4CC5
       DATA    QLOAD-6
COMPI  DATA    DOCOL,QCOMP,FROMR,DUP,ONEP,TOR,AT,COMMA,SEMIS
*
       DATA    >C1DB
       DATA    COMPI-5
LBKT   DATA    DOCOL,ZERO,STATE,STORE,SEMIS
*
       DATA    >81DD
       DATA    LBKT-2
RTBKT  DATA    DOCOL,LIT,>C0,STATE,STORE,SEMIS
*
       DATA    >8653,'MUDG',>45A0
       DATA    RTBKT-2
SMUDGE DATA    DOCOL,LATEST,BYTADR,LIT,>20,TOGGLE,SEMIS
*
       DATA    >8348,>45D8
       DATA    SMUDGE-5
HEX    DATA    DOCOL,LIT,16,BASE,STORE,SEMIS
*
       DATA    >8744,'ECIM',>41CC
       DATA    HEX-3
DEC    DATA    DOCOL,LIT,10,BASE,STORE,SEMIS
*
       DATA    >8728,';COD',>45A9
       DATA    DEC-5
PSCODE DATA    DOCOL,FROMR,LATEST,BYTADR,PFA,CFA,WRDADR,STORE,SEMIS
*
       DATA    >C53B,'CO',>44C5
       DATA    PSCODE-5
SEMIC  DATA    DOCOL,QCSP,COMPI,PSCODE,LBKT,SMUDGE,ASSMB
       DATA    SEMIS
*
       DATA    >C543,'OU',>4ED4
       DATA    SEMIC-4
COUNT  DATA    DOCOL,DUP,ONEP,SWAP,CAT,SEMIS
*
       DATA    >8454,'YP',>45A0
       DATA    COUNT-4
TYPE   DATA    DOCOL,DDUP,ZBRAN,TYP2-$,OVER,PLUS,SWAP,DO
TYP1   DATA    I,CAT,EMIT,LOOP,TYP1-$,SEMIS
TYP2   DATA    DROP,SEMIS
*
       DATA    >892D,'TRAILI',>4EC7
       DATA    TYPE-4
DTRAIL DATA    DOCOL,DUP,ZERO,DO
DTRL1  DATA    OVER,OVER,PLUS,ONE,SUB,CAT,BL,SUB
       DATA    ZBRAN,DTRL2-$,LEAVE,BRAN,DTRL3-$
DTRL2  DATA    ONE,SUB
DTRL3  DATA    LOOP,DTRL1-$,SEMIS
*
       DATA    >8428,'."',>29A0
       DATA    DTRAIL-6
PTYPE  DATA    DOCOL,R,BYTADR,COUNT,DUP,WRDADR,ONEP,FROMR,PLUS
       DATA    TOR,TYPE,SEMIS
*
       DATA    >C22E,>22A0
       DATA    PTYPE-4
STRING DATA    DOCOL,LIT,ZDQOTE,STATE,AT,ZBRAN,STR1-$
       DATA    COMPI,PTYPE,WORD,HERE,BYTADR,CAT,ONEP
       DATA    ALLOT,SEMIS
STR1   DATA    WORD,HERE,BYTADR,COUNT,TYPE,SEMIS
*
       DATA    >863F,'STAC',>4BA0
       DATA    STRING-3
QSTACK DATA    DOCOL,SPAT,SZERO,AT,GREAT,ONE,QERROR
       DATA    SPAT,HERE,LESS,TWO,QERROR,SEMIS
*
       DATA    >8645,'XPEC',>54A0
       DATA    QSTACK-5
EXPECT DATA    DOCOL,OVER,PLUS,OVER,DO
EXP1   DATA    KEY,DUP,LIT,XBS,AT,EQUAL,ZBRAN,EXP2-$
       DATA    DROP,LIT,ZBS,OVER,I,EQUAL,DUP,FROMR,TWO,SUB
       DATA    PLUS,TOR,SUB
       DATA    DUP,LIT,ZBS,EQUAL,ZBRAN,EXP1A-$
       DATA    LIT,ZBS,EMIT,LIT,ZSPACE,EMIT
EXP1A  DATA    BRAN,EXP3-$
EXP2   DATA    DUP,LIT,ZCR,EQUAL,ZBRAN,EXP4-$
       DATA    LEAVE,DROP,BL,ZERO,BRAN,EXP5-$
EXP4   DATA    DUP
EXP5   DATA    I,CSTORE,ZERO,I,ONEP,CSTORE,ZERO,I,TWOP
       DATA    CSTORE
EXP3   DATA    EMIT
       DATA    LOOP,EXP1-$,DROP,SEMIS
*
       DATA    >8551,'UE',>52D9
       DATA    EXPECT-5
QUERY  DATA    DOCOL,TIB,AT,BYTADR,LIT,ZLNLEN,EXPECT
       DATA    ZERO,IN,STORE,SEMIS
*
       DATA    >C180
       DATA    QUERY-4
NULL   DATA    DOCOL,BLK,AT,ZBRAN,NULL2-$,ONE
       DATA    BLK,PSTORE,ZERO,IN,STORE,BLK,AT
       DATA    BPSCR,MOD,ZEQU,ZBRAN,NULL4-$,QEXEC
NULL2  DATA    FROMR,DROP
NULL4  DATA    SEMIS
*
       DATA    >8446,'IL',>4CA0
       DATA    NULL-2
FILL   DATA    DOCOL,SWAP,TOR,OVER,CSTORE,DUP,ONEP
       DATA    FROMR,ONE,SUB,CMOVE,SEMIS
*
       DATA    >8457,'FI',>4CCC
       DATA    FILL-4
WFILL  DATA    DOCOL,SWAP,TOR,OVER,STORE,DUP,ONEP
       DATA    FROMR,ONE,SUB,MOVE,SEMIS
*
       DATA    >8545,'RA',>53C5
       DATA    WFILL-4
ERASE  DATA    DOCOL,ZERO,WFILL,SEMIS
*
       DATA    >8642,'LANK',>53A0
       DATA    ERASE-4
BLANKS DATA    DOCOL,BL,FILL,SEMIS
*
       DATA    >8448,'OL',>44A0
       DATA    BLANKS-5
HOLD   DATA    DOCOL,LIT,-1,HLD,PSTORE,HLD,AT,CSTORE,SEMIS
*
       DATA    >8350,>41C4
       DATA    HOLD-4
PAD    DATA    DOCOL,HERE,BYTADR,LIT,68,PLUS,SEMIS
*
       DATA    >8457,'OR',>44A0
       DATA    PAD-3
WORD   DATA    DOCOL,BLK,AT,ZBRAN,WORD1-$,BLK,AT
       DATA    BLOCK,BRAN,WORD2-$
WORD1  DATA    TIB,AT
WORD2  DATA    BYTADR,IN,AT,PLUS,SWAP,ENCL,HERE,BYTADR,LIT,34,BLANKS
       DATA    IN,PSTORE,OVER,SUB,TOR,R,HERE,BYTADR,CSTORE
       DATA    PLUS,HERE,BYTADR,ONEP,FROMR,CMOVE,SEMIS
*
       DATA    >8828,'NUMBER',>29A0
       DATA    WORD-4
PNUMB  DATA    DOCOL
PNUM0  DATA    ONEP,DUP,TOR,CAT,BASE,AT,DIGIT,ZBRAN
       DATA    PNUM1-$,SWAP,BASE,AT,MULT,DROP,ROT
       DATA    BASE,AT,MULT,DPLUS,DPL,AT,ONEP,ZBRAN
       DATA    PNUM2-$,ONE,DPL,PSTORE
PNUM2  DATA    FROMR,BRAN,PNUM0-$
PNUM1  DATA    FROMR,SEMIS
*
       DATA    >864E,'UMBE',>52A0
       DATA    PNUMB-6
NUMB   DATA    DOCOL,ZERO,ZERO,ROT,BYTADR,DUP,ONEP,CAT,LIT
       DATA    ZMINUS,EQUAL,DUP,TOR,PLUS,LIT,-1
NUM3   DATA    DPL,STORE,PNUMB,DUP,CAT,BL,SUB,ZBRAN
       DATA    NUM1-$,DUP,CAT,LIT,ZPEROD,SUB,ZERO
       DATA    QERROR,ZERO,BRAN,NUM3-$
NUM1   DATA    DROP,FROMR,ZBRAN,NUM2-$,DMINUS
NUM2   DATA    SEMIS
*
       DATA    >852D,'FI',>4EC4
       DATA    NUMB-5
DFIND  DATA    DOCOL,BL,WORD,HERE,CONT,AT,AT,PFIND,DUP
       DATA    ZEQU,ZBRAN,PTIC1-$,DROP,HERE,LATEST,PFIND
PTIC1  DATA    SEMIS
*
       DATA    >8728,'ABOR',>54A9
       DATA    DFIND-4
PABORT DATA    DOCOL,ABORT,SEMIS
*
       DATA    >8545,'RR',>4FD2
       DATA    PABORT-5
ERROR  DATA    DOCOL,ZERO,PBASE,STORE,WARNG,AT,ZLESS,ZBRAN,ERR1-$
       DATA    PABORT
ERR1   DATA    HERE,BYTADR,COUNT,TYPE,PTYPE,>0320,'? '
       DATA    MESSAG,SPSTOR,IN,AT,BLK,AT,QUIT,SEMIS
*
       DATA    >8349,>44AE
       DATA    ERROR-4
IDDOT  DATA    DOCOL,PAD,LIT,ZSPACE,LIT,ZUSCOR,FILL,BYTADR,DUP,PFA
       DATA    LFA,OVER,SUB,PAD,SWAP,CMOVE,PAD,COUNT
       DATA    LIT,>1F,AND,TYPE,SPACE,SEMIS
*
       DATA    >8643,'REAT',>45A0
       DATA    IDDOT-3
CREATE DATA    DOCOL,DFIND,ZBRAN,CRE1-$,DROP,BYTADR,NFA,WRDADR,IDDOT
       DATA    LIT,4,MESSAG,SPACE
CRE1   DATA    HERE,BYTADR,DUP,CAT,WIDTH,AT,MIN,ONEP
       DATA    ALLOT,DUP,LIT,>A0,TOGGLE,HERE,BYTADR,ONE,SUB
       DATA    LIT,>80,TOGGLE,LATEST,COMMA,WRDADR,CURR,AT
       DATA    STORE,HERE,ONEP,COMMA,SEMIS
*
       DATA    >C95B,'COMPIL',>45DD
       DATA    CREATE-5
BCOMPI DATA    DOCOL,DFIND,ZEQU,ZERO,QERROR,DROP,CFA
       DATA    COMMA,SEMIS
*
       DATA    >C74C,'ITER',>41CC
       DATA    BCOMPI-6
LITER  DATA    DOCOL,STATE,AT,ZBRAN,LIT1-$,COMPI
       DATA    LIT,COMMA
LIT1   DATA    SEMIS
*
       DATA    >C844,'LITERA',>4CA0
       DATA    LITER-5
DLITER DATA    DOCOL,STATE,AT,ZBRAN,DLIT1-$,SWAP
       DATA    LITER,LITER
DLIT1  DATA    SEMIS
*
       DATA    >8949,'NTERPR',>45D4
       DATA    DLITER-6
INTER  DATA    DOCOL
INT1   DATA    DFIND,ZBRAN,INT2-$,STATE,AT,LESS
       DATA    ZBRAN,INT4-$,CFA,COMMA,BRAN,INT1-$
INT4   DATA    CFA,EXEC,QSTACK,BRAN,INT1-$
INT2   DATA    HERE,NUMB,DPL,AT,ONEP,ZBRAN,INT3-$
       DATA    DLITER,BRAN,INT5-$
INT3   DATA    DROP,LITER
INT5   DATA    QSTACK,BRAN,INT1-$
*
       DATA    >8949,'MMEDIA',>54C5
       DATA    INTER-6
IMMED  DATA    DOCOL,LATEST,BYTADR,LIT,>40,TOGGLE,SEMIS
*
       DATA    >8A56,'OCABULAR',>59A0
       DATA    IMMED-6
VOCAB  DATA    DOCOL,BUILDS,LIT,>81A0,COMMA,CURR
       DATA    AT,CFA,COMMA,HERE,VOCLNK,AT,COMMA
       DATA    VOCLNK,STORE,DOES
DOVOC  DATA    ONEP,CONT,STORE,SEMIS
*
       DATA    >C546,'OR',>54C8
       DATA    VOCAB-7
FORTH  DATA    DODOES,DOVOC
FORLNK DATA    >81A0,VLINK,0
*
       DATA    >8B44,'EFINITIO',>4ED3
       DATA    FORTH-4
DEFIN  DATA    DOCOL,CONT,AT,CURR,STORE,SEMIS
*
       DATA    >C1A8
       DATA    DEFIN-7
PAREN  DATA    DOCOL,LIT,ZRPARN,WORD,SEMIS
*
       DATA    >8451,'UI',>54A0
       DATA    PAREN-2
QUIT   DATA    DOCOL,ZERO,BLK,STORE,LBKT
QUIT1  DATA    RPSTOR,CR,QUERY,INTER,STATE,AT
       DATA    ZEQU,ZBRAN,QUIT1-$,PTYPE,>0320,'OK'
       DATA    BRAN,QUIT1-$
*
       DATA    >8541,'BO',>52D4
       DATA    QUIT-4
ABORT  DATA    DOCOL,SPSTOR,DEC,CR,PTYPE
       DATA    MSIZE*256+>54
TITLE  DATA    'I-980 FORTH 1.0.1'
MSIZE  EQU     $-TITLE*2
       DATA    FORTH,DEFIN,QUIT
*
       DATA    >8443,'OL',>44A0
       DATA    ABORT-4
COLD   DATA    ORIG,LIT,XUSER0,LIT,USER0,LIT,SYSWRD
       DATA    MOVE,DR0,EMPBUF,LIT,-1,DPL,STORE,ABORT
*
       DATA    >8453,'->',>44A0
       DATA    COLD-4
STOD   DATA    $+1
       LDE     =-1             ASSUME MINUS
       LDA     *ZSP            TEST VALUE
       CPA     =0
       SLT
       LDE     =0              POSITIVE
       DMT     ZSP
       STE     *ZSP            PUSH UPPER VALUE
       BRU     *ZNEXT
*
       DATA    >822B,>2DA0
       DATA    STOD-4
PM     DATA    DOCOL,ZLESS,ZBRAN,PM1-$,MINUS
PM1    DATA    SEMIS
*
       DATA    >8344,>2BAD
       DATA    PM-3
DPM    DATA    DOCOL,ZLESS,ZBRAN,DPM1-$,DMINUS
DPM1   DATA    SEMIS
*
       DATA    >8341,>42D3
       DATA    DPM-3
ABS    DATA    $+1
       LDA     *ZSP            ABSOLUTE VALUE
       CPA     =0
       SGE
       RCO     A,A
       STA     *ZSP
       BRU     *ZNEXT
*
       DATA    >8444,'AB',>53A0
       DATA    ABS-3
DABS   DATA    DOCOL,DUP,DPM,SEMIS
*
       DATA    >834D,>49CE
       DATA    DABS-4
MIN    DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       LDE     *ZSP
       RCA     E,A
       SLT
       STA     *ZSP            PUT MIN ON TOP
       BRU     *ZNEXT
*
       DATA    >834D,>41D8
       DATA    MIN-3
MAX    DATA    $+1
       LDA     *ZSP
       IMO     ZSP
       LDE     *ZSP
       RCA     E,A
       SGT
       STA     *ZSP            PUT MAX ON TOP
       BRU     *ZNEXT
*
       DATA    >824D,>2AA0
       DATA    MAX-3
MSTAR  DATA    DOCOL,OVER,OVER,XOR,TOR,ABS,SWAP,ABS
       DATA    MULT,FROMR,DPM,SEMIS
*
       DATA    >824D,>2FA0
       DATA    MSTAR-3
MSLASH DATA    DOCOL,OVER,TOR,TOR,DABS,R,ABS,DIV
       DATA    FROMR,R,XOR,PM,SWAP,FROMR,PM,SWAP,SEMIS
*
       DATA    >81AA
       DATA    MSLASH-3
TIMES  DATA    DOCOL,MULT,DROP,SEMIS
*
       DATA    >842F,'MO',>44A0
       DATA    TIMES-2
DMOD   DATA    DOCOL,TOR,STOD,FROMR,MSLASH,SEMIS
*
       DATA    >81AF
       DATA    DMOD-4
DDIV   DATA    DOCOL,DMOD,SWAP,DROP,SEMIS
*
       DATA    >834D,>4FC4
       DATA    DDIV-2
MOD    DATA    DOCOL,DMOD,DROP,SEMIS
*
       DATA    >852A,'/M',>4FC4
       DATA    MOD-3
MDMOD  DATA    DOCOL,TOR,MSTAR,FROMR,MSLASH,SEMIS
*
       DATA    >822A,>2FA0
       DATA    MDMOD-4
MD     DATA    DOCOL,MDMOD,SWAP,DROP,SEMIS
*
       DATA    >854D,'/M',>4FC4
       DATA    MD-3
MSLMOD DATA    DOCOL,TOR,ZERO,R,DIV,FROMR,SWAP
       DATA    TOR,DIV,FROMR,SEMIS
*
       DATA    >8355,>53C5
       DATA    MSLMOD-4
USE    DATA    DOVAR,ZBUFF
*
       DATA    >8450,'RE',>56A0
       DATA    USE-3
PREV   DATA    DOVAR,ZBUFF
*
       DATA    >842B,'BU',>46A0
       DATA    PREV-4
PLSBF  DATA    DOCOL,BPBUF,LIT,4,PLUS,PLUS,DUP,LIMIT
       DATA    EQUAL,ZBRAN,PLSB1-$,DROP,FIRST
PLSB1  DATA    DUP,PREV,AT,SUB,SEMIS
*
       DATA    >8655,'PDAT',>45A0
       DATA    PLSBF-4
UPDATE DATA    DOCOL,PREV,AT,AT,LIT,>8000,OR,PREV,AT
       DATA    STORE,SEMIS
*
       DATA    >8D45,'MPTY-BUFFE',>52D3
       DATA    UPDATE-5
EMPBUF DATA    DOCOL,FIRST,LIMIT,OVER,SUB,ERASE,SEMIS
*
       DATA    >8344,>52B0
       DATA    EMPBUF-8
DR0    DATA    DOCOL,ZERO,OFFSET,STORE,SEMIS
*
       DATA    >8344,>52B1
       DATA    DR0-3
DR1    DATA    DOCOL,LIT,2000,OFFSET,STORE,SEMIS
*
       DATA    >8642,'UFFE',>52A0
       DATA    DR1-3
BUFFER DATA    DOCOL,USE,AT,DUP,TOR
BUF1   DATA    PLSBF,ZBRAN,BUF1-$,USE,STORE,R,AT,ZLESS
       DATA    ZBRAN,BUF2-$,R,TWOP,R,AT,LIT,>7FFF,AND
       DATA    ZERO,RSLW
BUF2   DATA    R,STORE,R,PREV,STORE,FROMR,TWOP,SEMIS
*
       DATA    >8542,'LO',>43CB
       DATA    BUFFER-5
BLOCK  DATA    DOCOL,OFFSET,AT,PLUS,TOR,PREV,AT,DUP,AT
       DATA    R,SUB,DUP,PLUS,ZBRAN,BLK1-$
BLK2   DATA    PLSBF,ZEQU,ZBRAN,BLK3-$,DROP,R,BUFFER,DUP
       DATA    R,ONE,RSLW,TWO,SUB
BLK3   DATA    DUP,AT,R,SUB,DUP,PLUS,ZEQU,ZBRAN,BLK2-$
       DATA    DUP,PREV,STORE
BLK1   DATA    FROMR,DROP,TWOP,SEMIS
*
       DATA    >8628,'LINE',>29A0
       DATA    BLOCK-4
PLINE  DATA    DOCOL,TOR,LIT,SECSIZ/2,BPBUF,MDMOD,FROMR,BPSCR
       DATA    TIMES,PLUS,BLOCK,BYTADR,PLUS,LIT,64,SEMIS
*
       DATA    >852E,'LI',>4EC5
       DATA    PLINE-5
DOTLN  DATA    DOCOL,PLINE,DTRAIL,TYPE,SEMIS
*
       DATA    >874D,'ESSA',>47C5
       DATA    DOTLN-4
MESSAG DATA    DOCOL,ZERO,PBASE,STORE,WARNG,AT,ZBRAN,MSG1-$
       DATA    DDUP,ZBRAN,MSG2-$
       DATA    LIT,4,OFFSET,AT,BPSCR,DIV,SUB,DOTLN,SEMIS
MSG1   DATA    PTYPE,>0720,'MSG # '
       DATA    DOT
MSG2   DATA    SEMIS
*
       DATA    >844C,'OA',>44A0
       DATA    MESSAG-5
LOAD   DATA    DOCOL,BLK,AT,TOR,IN,AT,TOR,ZERO,IN,STORE
       DATA    BPSCR,TIMES,BLK,STORE,INTER,FROMR,IN
       DATA    STORE,FROMR,BLK,STORE,SEMIS
*
       DATA    >C32D,>2DBE
       DATA    LOAD-4
ARRO   DATA    DOCOL,QLOAD,ZERO,IN,STORE,BPSCR,BLK,AT
       DATA    OVER,MOD,SUB,BLK,PSTORE,SEMIS
*
       DATA    >8248,>49A0
       DATA    ARRO-3
HI     DATA    DOCON,ZHI
*
       DATA    >824C,>4FA0
       DATA    HI-3
LO     DATA    DOCON,ZLO
*
       DATA    >8352,>2FD7
       DATA    LO-3
RSLW   DATA    DOCOL,LIT,DBUFF+6,BYTADR,HLD,STORE,SWAP,ZERO
       DATA    OVER,GREAT,OVER,LIT,3999,GREAT,OR,LIT,6
       DATA    QERROR,LIT,ZCR,HOLD,LIT,2000,DMOD,HL,DROP
       DATA    LIT,ZSLASH,HOLD,BL,HOLD,LIT,26,DMOD,SWAP
       DATA    ONEP,HL,HL,DROP,BL,HOLD,HL,HL,DROP,BL,HOLD
       DATA    ZBRAN,RSLW1-$,LIT,ZLETI,BRAN,RSLW2-$
RSLW1  DATA    LIT,ZLETO
RSLW2  DATA    HOLD,HLD,AT,DISKRW,LIT,8,QERROR,SEMIS
*
* DISK READ/WRITE ROUTINE
*
* PARAMETER BUFFER FORMAT:
*
*      C TT SS /D
*
*  WHERE:      C  - I=INPUT, O=OUTPUT
*              TT - TRACK NUMBER (0-77)
*              SS - SECTOR (1-26)
*              D  - DRIVE NUMBER
*
DISKRW DATA    $+1
       LDA     *ZSP            GET PARAMETER POINTER
       IMO     ZSP
       LDE     *ZSP            GET DATA ADDRESS
       @BRL    DISKH           CALL DISK HANDLER
       STA     *ZSP            STORE ERROR CODE
       BRU     *ZNEXT
*
* INTERNAL ROUTINE
*
HL     DATA    DOCOL,ZERO,LIT,10,DIV,SWAP,LIT,ZZERO
       DATA    PLUS,HOLD,SEMIS
*
* HERE ENDS THE META COMPILER
*
       DATA    >8543,'AS',>45BA
       DATA    RSLW-3
CASE   DATA    DOCOL,BUILDS,SMUDGE,ABS,ONE,SUB,COMMA
       DATA    RTBKT,DOES
DOCASE DATA    DUP,AT,ROT,ABS,MIN,DUP,PLUS,PLUS,ONEP
       DATA    AT,EXEC,SEMIS
*
       DATA    >C1A7
       DATA    CASE-4
TICK   DATA    DOCOL,DFIND,ZEQU,ZERO,QERROR,DROP,LITER,SEMIS
*
       DATA    >8646,'ORGE',>54A0
       DATA    TICK-2
FORGET DATA    DOCOL,CURR,AT,CONT,AT,SUB,LIT,24,QERROR
       DATA    TICK,DUP,FENCE,AT,LESS,LIT,21,QERROR,BYTADR,DUP
       DATA    NFA,WRDADR,DP,STORE,LFA,WRDADR,AT,CURR,AT,STORE,SEMIS
*
       DATA    >8442,'AC',>4BA0
       DATA    FORGET-5
BACK   DATA    DOCOL,HERE,SUB,COMMA,SEMIS
*
       DATA    >C542,'EG',>49CE
       DATA    BACK-4
BEGIN  DATA    DOCOL,QCOMP,HERE,ONE,SEMIS
*
       DATA    >C545,'ND',>49C6
       DATA    BEGIN-4
ENDIF  DATA    DOCOL,QCOMP,TWO,QPAIRS,HERE,OVER,SUB,SWAP
       DATA    STORE,SEMIS
*
       DATA    >C454,'HE',>4EA0
       DATA    ENDIF-4
THEN   DATA    DOCOL,ENDIF,SEMIS
*
       DATA    >C244,>4FA0
       DATA    THEN-4
IDO    DATA    DOCOL,COMPI,DO,HERE,THREE,SEMIS
*
       DATA    >C44C,'OO',>50A0
       DATA    IDO-3
ILOOP  DATA    DOCOL,THREE,QPAIRS,COMPI,LOOP,BACK,SEMIS
*
       DATA    >C52B,'LO',>4FD0
       DATA    ILOOP-4
IPLUP  DATA    DOCOL,THREE,QPAIRS,COMPI,PLOOP,BACK,SEMIS
*
       DATA    >C555,'NT',>49CC
       DATA    IPLUP-4
UNTIL  DATA    DOCOL,ONE,QPAIRS,COMPI,ZBRAN,BACK,SEMIS
*
       DATA    >C345,>4EC4
       DATA    UNTIL-4
END    DATA    DOCOL,UNTIL,SEMIS
*
       DATA    >C541,'GA',>49CE
       DATA    END-3
AGAIN  DATA    DOCOL,ONE,QPAIRS,COMPI,BRAN,BACK,SEMIS
*
       DATA    >C652,'EPEA',>54A0
       DATA    AGAIN-4
REPEAT DATA    DOCOL,TOR,TOR,AGAIN,FROMR,FROMR,TWO
       DATA    SUB,ENDIF,SEMIS
*
       DATA    >C249,>46A0
       DATA    REPEAT-5
IF     DATA    DOCOL,COMPI,ZBRAN,HERE,ZERO,COMMA,TWO,SEMIS
*
       DATA    >C557,'HI',>4CC5
       DATA    IF-3
WHILE  DATA    DOCOL,IF,ONEP,SEMIS
*
       DATA    >C445,'LS',>45A0
       DATA    WHILE-4
ELSE   DATA    DOCOL,TWO,QPAIRS,COMPI,BRAN,HERE,ZERO
       DATA    COMMA,SWAP,TWO,ENDIF,TWO,SEMIS
*
       DATA    >8653,'PACE',>53A0
       DATA    ELSE-4
SPACS  DATA    DOCOL,ZERO,MAX,DDUP,ZBRAN,SPS2-$,ZERO,DO
SPS1   DATA    SPACE,LOOP,SPS1-$
SPS2   DATA    SEMIS
*
       DATA    >823C,>23A0
       DATA    SPACS-5
STRTCN DATA    DOCOL,PAD,HLD,STORE,SEMIS
*
       DATA    >8223,>3EA0
       DATA    STRTCN-3
STPCNV DATA    DOCOL,DROP,DROP,HLD,AT,PAD,OVER,SUB,SEMIS
*
       DATA    >8453,'IG',>4EA0
       DATA    STPCNV-3
SIGN   DATA    DOCOL,ROT,ZLESS,ZBRAN,SGN2-$,LIT,ZMINUS,HOLD
SGN2   DATA    SEMIS
*
       DATA    >81A3
       DATA    SIGN-4
NUMSGN DATA    DOCOL,PAD,HLD,AT,SUB,DPL,AT,EQUAL,ZBRAN
       DATA    NS2-$,LIT,ZPEROD,HOLD
NS2    DATA    BASE,AT,MSLMOD,ROT,LIT,9,OVER,LESS,ZBRAN
       DATA    NS1-$,LIT,7,PLUS
NS1    DATA    LIT,ZZERO,PLUS,HOLD,SEMIS
*
       DATA    >8223,>53A0
       DATA    NUMSGN-2
NUMS   DATA    DOCOL,NUMSGN,OVER,OVER,OR,ZEQU,ZBRAN
       DATA    NUMS+1-$,SEMIS
*
       DATA    >8344,>2ED2
       DATA    NUMS-3
DDOTR  DATA    DOCOL,TOR,SWAP,OVER,DABS,STRTCN,NUMS,SIGN
       DATA    STPCNV,FROMR,OVER,SUB,SPACS,TYPE,SEMIS
*
       DATA    >822E,>52A0
       DATA    DDOTR-3
DOTR   DATA    DOCOL,TOR,STOD,FROMR,DDOTR,SEMIS
*
       DATA    >8244,>2EA0
       DATA    DOTR-3
DDOT   DATA    DOCOL,ZERO,DDOTR,SPACE,SEMIS
*
       DATA    >81AE
       DATA    DDOT-3
DOT    DATA    DOCOL,STOD,DDOT,SEMIS
*
       DATA    >81BF
       DATA    DOT-2
QMRK   DATA    DOCOL,AT,DOT,SEMIS
*
       DATA    >8255,>2EA0
       DATA    QMRK-2
UDOT   DATA    DOCOL,ZERO,DDOT,SEMIS
*
       DATA    >844C,'IS',>54A0
       DATA    UDOT-3
LIST   DATA    DOCOL,BASE,AT,SWAP,DEC,CR,DUP,SCR,STORE,PTYPE
       DATA    >0653,'CR # '
       DATA    DOT,LIT,16,ZERO,DO
LIST1  DATA    CR,I,THREE,DOTR,SPACE,I,SCR,AT,DOTLN
       DATA    LOOP,LIST1-$,CR,BASE,STORE,SEMIS
*
       DATA    >8549,'ND',>45D8
       DATA    LIST-4
INDEX  DATA    DOCOL,BASE,AT,ROT,ROT,LIT,ZFF,EMIT
       DATA    CR,ONEP,SWAP,DEC,DO
IDX1   DATA    CR,I,THREE,DOTR,SPACE,ZERO,I,DOTLN
       DATA    LOOP,IDX1-$,BASE,STORE,SEMIS
*
       DATA    >8554,'RI',>41C4
       DATA    INDEX-4
TRIAD  DATA    DOCOL,LIT,ZFF,EMIT,THREE,DDIV,THREE
       DATA    TIMES,THREE,OVER,PLUS,SWAP,DO
TRI1
*      DATA    CR,I,LIST,LOOP,TRI1-$,CR,LIT,15
*      DATA    MESSAG,CR,SEMIS
       DATA    CR,I,LIST,LOOP,TRI1-$,CR
       DATA    SEMIS
*
VLINK  DATA    >8556,'LI',>53D4
       DATA    TRIAD-4
VLIST  DATA    DOCOL,LIT,ZLNLEN,OUT,STORE,CONT,AT,AT
HELP1  DATA    OUT,AT,LIT,70,GREAT,ZBRAN,HELP2-$
       DATA    CR,ZERO,OUT,STORE
HELP2  DATA    DUP,IDDOT,SPACE,SPACE,BYTADR,PFA,LFA,WRDADR
       DATA    AT,DUP,ZEQU,QTERM,OR,ZBRAN,HELP1-$,DROP,SEMIS
*
* END OF PROTECTED WORDS
*
VEND   EQU     $
*
ASSMB  EQU     $
       DATA    DOCOL,SEMIS
       DATA    -1
ENDROM DATA    ENDRAM
       PEJ
*
* DATA DEFINITIONS
*
DSIZE  EQU     2               SIZE OF DICTIONAY (IN KWORDS)
LOWRAM EQU     $               STACKS
       BSS     512*DSIZE       START OF RAM DICTIONARY
       BSS     64
STAX   EQU     $               PARAMETER STACK
       BSS     80              INPUT BUFFER
RSTAX  EQU     $               RETURN STACK
*
* USER VARIABLES
*
USER0  BSS     3
GSZERO BSS     1               S0
GRZERO BSS     1               R0
GTIB   BSS     1               TERMINAL INPUT BUFFER
GWIDTH BSS     1               NAME WIDTH
GWARNG BSS     1               WARNING FLAG, DISK=1
GFENCE BSS     1               PROTECTED DICTIONARY
GDP    BSS     1               DICTIONARY POINTER
GVLNK  BSS     1               VOCABULARY LINK
*
* THE FOLLOWING ARE INITIALIZED BY PROGRAM
*
GBLK   BSS     1               BLOCK NUMBER
GIN    BSS     1               NEXT INPUT CHAR. OFFSET
GOUT   BSS     1               OUTPUT POINTER
GSCR   BSS     1               CURRENT SCREEN
GOFSET BSS     1               DISK OFFSET
GCONT  BSS     1               CONTEXT VOCABULARY
GCURR  BSS     1               CURRENT VOCABULARY
GSTATE BSS     1               COMPILING OR NOT
GBASE  BSS     1               NUMBER BASE (RADIX)
GDPL   BSS     1               DECIMAL POINT LOCATION
GFLD   BSS     1               OUTPUT FIELD WIDTH
GCSP   BSS     1               CHECK OF STACK POSITION
GRNUM  BSS     1               EDIT CURSOR POSITION
GHLD   BSS     1               POINTER TO FORMATED OUTPUT
GPRTBS BSS     1               OUTPUT PRINTER FLAG
GSKEW  BSS     1               SKEW SWITCH
*
DBUFF  BSS     6               DISK COMMAND BUFFER
       PEJ
*
* DISK HANDLER
*
SECWRD FRM     1,7,8           INTERRUPT/START SECTOR/SECTOR COUNT
CMDWRD FRM     1,3,4,8         CHAIN/COMMAND/HEAD/CYLINDER
*
DKREAD EQU     >0000
DKWRIT EQU     >4000
*
DISKH  @SRF    IORF
       STE     DKLIST          SAVE BUFFER ADDRESS
       BRL     ADRBYT
       DATA    DKCPTR,DKCNDX
       BRL     GETBYT          GET COMMAND BYTE
       DATA    DKCPTR,DKCNDX
       @LDM    =DKWRIT         SET FOR WRITE
       CPL     =ZLETI          IF INPUT THEN
       SEQ
       BRU     DK010
       @LDM    =DKREAD            SET FOR READ
DK010  BRL     GETNUM          GET TRACK
       ROR     M,A             MERGE WITH R/W SUB COMMAND
       STA     DKLIST+2
       BRL     GETNUM          GET SECTOR
       RDE     A,A             OUR DISK IS ZERO BASED SECTORS
       LLA     8               POSITION
       IOR     =1              ONLY 1 SECTOR PER OPERATION
       STA     DKLIST+1
       BRL     GETBYT          SKIP TO DRIVE
       DATA    DKCPTR,DKCNDX
       BRL     GETBYT
       DATA    DKCPTR,DKCNDX
       BRL     GETBYT          GET DRIVE
       DATA    DKCPTR,DKCNDX
       SUB     =>30
       LLA     4               POSITION FOR COMMAND
       IOR     DKCMD           MAKE THE COMMAND
       STA     DK020
       LDE     =0              PRESET SUCCESS
DK020  DATA    $-$             ISSUE DISK COMMAND
       DATA    DKLIST
       LDA     *DKSTAT         CHECK STATUS
       SNZ     A
       BRU     $-2
       @CPL    =>8000          ANY ERRORS?
       SEQ
       LDE     =-1             YES, SET CODE.
       STE     IORF
       @LRF    IORF
       RMO     L,P
*
DKLIST DATA    $-$             DISK COMMAND LIST
       SECWRD  0,$-$,1
       CMDWRD  0,$-$,0,$-$
       DATA    0
DKSTAT DATA    DSKSTS          DISK STATUS WORD
DKCMD  ATI     DSKADD          DISK COMMAND
DKCPTR DATA    0
DKCNDX DATA    0
*
GETNUM RMO     L,S
       BRL     GETBYT          GET NUMBER FROM PARAMETERS
       DATA    DKCPTR,DKCNDX
       CPL     =ZSPACE         IGNORE LEADING SPACES
       SNE
       BRU     GETNUM+1
       SUB     =>30
       MPY     =10
       BRL     GETBYT
       DATA    DKCPTR,DKCNDX
       SUB     =>30
       RAD     E,A
       RMO     S,P
*
IORF   BSS     7               I/O REGISTER FILE
       PEJ
*
* PRINTER EMIT
*
PEMIT  @SRF    IORF
       LDA     PRFLAG          IF START
       CPL     =0
       SEQ
       BRU     PEM010
       LDA     PRLIST          THEN INITIALIZE
       STA     PRPTR
       LDA     =0
       STA     PRNDX
       STA     PRLIST+1
       IMO     PRFLAG
PEM010 LDA     *ZSP            PICK UP CHARACTER
       IMO     ZSP
       AND     =>7F
       CPL     =0
       SNE
       BRU     PEMXIT
       BRL     PUTBYT          IF NOT NULL, PUT IN BUFFER
       DATA    PRPTR,PRNDX
       IMO     PRLIST+1
       CPL     =ZLF            IF LF
       SEQ
       BRU     PEMXIT
       ATI     PRTADD          THEN PRINT BUFFER
       DATA    PRLIST
       LDA     *PRSTAT
       CPL     =1
       SEQ
       BRU     $-3
       LDA     =0
       STA     PRFLAG
PEMXIT @LRF    IORF
       RMO     L,P
*
PRLIST DATA    PBUFF,$-$,0,0   PRINTER COMMAND LIST
PRSTAT DATA    PRTSTS          PRINTER STATUS WORD
PRFLAG DATA    0
PRPTR  DATA    $-$
PRNDX  DATA    $-$
PBUFF  BSS     67              PRINTER BUFFER
       PEJ
*
* SCREEN BUFFERS
*
NSCR   EQU     16              BUFFER FOR 16 SCREENS
ZBUFF  BSS     64+2*8*NSCR     I/O BUFFERS
ZLO    EQU     ZBUFF           PSEUDO DISK
ZHI    EQU     $
ENDRAM EQU     ZHI
*
       END     MAIN1
