/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.mp3;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;

public class MP3ElementaryInputStream
extends FilterInputStream {
    public static final AudioFormat.Encoding MP3 = new AudioFormat.Encoding("MP3");
    private Frame frame;
    private long pos;
    private static final int[][] BIT_RATES = new int[][]{{-1, -1, -1, -1, -1}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-2, -2, -2, -2, -2}};
    private static final int[][] SAMPLE_RATES = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};

    public MP3ElementaryInputStream(File file) throws IOException {
        super(new PushbackInputStream(new BufferedInputStream(new FileInputStream(file)), 6));
    }

    public MP3ElementaryInputStream(InputStream in) {
        super(new PushbackInputStream(in, 6));
    }

    public Frame getNextFrame() throws IOException {
        block14: {
            int h3;
            int h2;
            int h1;
            int h0;
            long skipped;
            while (this.frame != null && this.pos < this.frame.getBodyOffset() + (long)this.frame.getBodySize() && (skipped = this.skip(this.frame.getBodyOffset() + (long)this.frame.getBodySize() - this.pos)) >= 0L) {
            }
            while (true) {
                int b;
                if ((b = this.read0()) == -1) {
                    this.frame = null;
                    break block14;
                }
                if (b != 255) continue;
                h0 = b;
                h1 = this.read0();
                if (h1 == -1 || (h1 & 0xE0) != 224) continue;
                h2 = this.read0();
                h3 = this.read0();
                if (h3 == -1) continue;
                this.frame = new Frame(h0 << 24 | h1 << 16 | h2 << 8 | h3);
                if (this.frame.getBitRate() != -1 && this.frame.getLayer() != -1 && this.frame.getSampleRate() != -1) break;
                PushbackInputStream pin = (PushbackInputStream)this.in;
                pin.unread(h3);
                pin.unread(h2);
                pin.unread(h1);
                this.pos -= 3L;
            }
            int crc0 = -1;
            int crc1 = -1;
            if (this.frame.hasCRC()) {
                crc0 = this.read0();
                crc1 = this.read0();
                if (crc1 == -1) {
                    throw new EOFException();
                }
                this.frame.crc = crc0 << 8 | crc1;
            }
            this.frame.bodyOffset = this.pos;
            if (this.frame.getBitRate() <= 0 || this.frame.getSampleRate() <= 0) {
                this.frame.bodySize = 0;
            } else if (this.frame.getLayer() == 1) {
                this.frame.bodySize = (int)(12000L * (long)this.frame.getBitRate() / (long)this.frame.getSampleRate() * 4L) - this.frame.getHeaderSize() + this.frame.getPaddingSize();
            } else if (this.frame.getLayer() == 2 || this.frame.getLayer() == 3) {
                if (this.frame.getChannelCount() == 1) {
                    this.frame.bodySize = (int)(72000L * (long)this.frame.getBitRate() / (long)(this.frame.getSampleRate() + this.frame.getPaddingSize())) - this.frame.getHeaderSize() + this.frame.getPaddingSize();
                } else {
                    this.frame.bodySize = (int)(144000L * (long)this.frame.getBitRate() / (long)(this.frame.getSampleRate() + this.frame.getPaddingSize())) - this.frame.getHeaderSize() + this.frame.getPaddingSize();
                }
            }
            PushbackInputStream pin = (PushbackInputStream)this.in;
            if (this.frame.hasCRC()) {
                pin.unread(crc1);
                pin.unread(crc0);
                this.pos -= 2L;
            }
            pin.unread(h3);
            pin.unread(h2);
            pin.unread(h1);
            pin.unread(h0);
            this.pos -= 4L;
            assert (this.pos == this.frame.getFrameOffset()) : this.pos + "!=" + this.frame.getFrameOffset();
        }
        return this.frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public AudioFormat getFormat() {
        if (this.frame == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("vbr", true);
        return new AudioFormat(MP3, this.frame.getSampleRate(), this.frame.getSampleSize(), this.frame.getChannelCount(), this.frame.getFrameSize(), this.frame.getFrameRate(), true, properties);
    }

    private int read0() throws IOException {
        int b = super.read();
        if (b != -1) {
            ++this.pos;
        }
        return b;
    }

    @Override
    public int read() throws IOException {
        if (this.frame == null || this.pos >= this.frame.getBodyOffset() + (long)this.frame.getBodySize()) {
            return -1;
        }
        return this.read0();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.frame == null) {
            return -1;
        }
        int maxlen = (int)(this.frame.getBodyOffset() + (long)this.frame.getBodySize() - this.pos);
        if (maxlen < 1) {
            return -1;
        }
        int count = super.read(b, off, len = Math.min(maxlen, len));
        if (count != -1) {
            this.pos += (long)count;
        }
        return count;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
            this.pos += (long)count;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.frame == null) {
            return -1L;
        }
        int maxlen = (int)(this.frame.getBodyOffset() + (long)this.frame.getBodySize() - this.pos);
        if (maxlen < 1) {
            return -1L;
        }
        long skipped = this.in.skip(n = Math.min((long)maxlen, n));
        if (skipped > 0L) {
            this.pos += skipped;
        }
        return skipped;
    }

    public long getStreamPosition() {
        return this.pos;
    }

    public static class Frame {
        private int header;
        private int crc;
        private int bodySize;
        private long bodyOffset;

        public Frame(int header) {
            this.header = header;
        }

        public int getHeaderCode() {
            return this.header;
        }

        public int getVersion() {
            switch (this.getVersionCode()) {
                case 0: {
                    return 25;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 1;
                }
            }
            return -1;
        }

        public int getVersionCode() {
            return this.header >>> 19 & 3;
        }

        public int getLayer() {
            switch (this.getLayerCode()) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 1;
                }
            }
            return -1;
        }

        public int getLayerCode() {
            return this.header >>> 17 & 3;
        }

        public int getBitRate() {
            int v;
            if (this.getVersion() < 0 || this.getLayer() < 0) {
                return -1;
            }
            int n = v = this.getVersion() == 1 ? 0 : 3;
            int l = this.getVersion() == 1 ? this.getLayer() - 1 : (this.getLayer() == 1 ? 0 : 1);
            return BIT_RATES[this.getBitRateCode()][v + l];
        }

        public int getBitRateCode() {
            return this.header >>> 12 & 0xF;
        }

        public boolean hasCRC() {
            return (this.header >>> 16 & 1) == 0;
        }

        public int getCRC() {
            return this.crc;
        }

        public boolean hasPadding() {
            return (this.header >>> 9 & 1) == 1;
        }

        public int getSampleRate() {
            if (this.getVersion() < 0 || this.getLayer() < 0) {
                return -1;
            }
            int v = this.getVersion() == 25 ? 2 : this.getVersion() - 1;
            return SAMPLE_RATES[this.getSampleRateCode()][v];
        }

        public int getSampleRateCode() {
            return this.header >>> 10 & 3;
        }

        public int getSampleCount() {
            if (this.getLayer() < 0) {
                return -1;
            }
            return (this.getLayer() == 1 ? 192 : 576) * this.getChannelCount();
        }

        public int getChannelCount() {
            return this.getChannelModeCode() == 3 ? 1 : 2;
        }

        public int getSampleSize() {
            return 16;
        }

        public int getChannelModeCode() {
            return this.header >>> 6 & 3;
        }

        public byte[] headerToByteArray() {
            byte[] data = new byte[this.hasCRC() ? 6 : 4];
            this.headerToByteArray(data, 0);
            return data;
        }

        public int headerToByteArray(byte[] data, int offset) {
            if (data.length - offset < this.getHeaderSize()) {
                throw new IllegalArgumentException("data array is too small");
            }
            data[offset + 0] = (byte)(this.header >>> 24);
            data[offset + 1] = (byte)(this.header >>> 16);
            data[offset + 2] = (byte)(this.header >>> 8);
            data[offset + 3] = (byte)(this.header >>> 0);
            if (this.hasCRC()) {
                data[offset + 4] = (byte)(this.crc >>> 8);
                data[offset + 5] = (byte)(this.crc >>> 0);
            }
            return this.getHeaderSize();
        }

        public void writeHeader(OutputStream out) throws IOException {
            out.write(this.header >>> 24);
            out.write(this.header >>> 16);
            out.write(this.header >>> 8);
            out.write(this.header >>> 0);
            if (this.hasCRC()) {
                out.write(this.crc >>> 8);
                out.write(this.crc >>> 0);
            }
        }

        public long getFrameOffset() {
            return this.getBodyOffset() - (long)this.getHeaderSize();
        }

        public int getFrameSize() {
            return this.getHeaderSize() + this.getBodySize();
        }

        public long getHeaderOffset() {
            return this.getFrameOffset();
        }

        public int getHeaderSize() {
            return this.hasCRC() ? 6 : 4;
        }

        public long getSideInfoOffset() {
            return this.bodyOffset;
        }

        public int getSideInfoSize() {
            return this.getChannelCount() == 1 ? 17 : 32;
        }

        public long getBodyOffset() {
            return this.bodyOffset;
        }

        public int getBodySize() {
            return this.bodySize;
        }

        public int getPaddingSize() {
            if (this.hasPadding()) {
                return this.getLayer() == 1 ? 4 : 1;
            }
            return 0;
        }

        private float getFrameRate() {
            return (float)this.getSampleRate() / (float)this.getSampleCount();
        }
    }
}

