/*
 * Decompiled with CFR 0.152.
 */
package nintaco;

import java.io.Serializable;
import java.util.Arrays;
import nintaco.App;
import nintaco.CPU;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.ScreenRenderer;
import nintaco.api.local.LocalAPI;
import nintaco.gui.image.preferences.View;
import nintaco.gui.rob.RobController;
import nintaco.input.DeviceMapper;
import nintaco.input.zapper.ZapperMapper;
import nintaco.mappers.Mapper;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;

public class PPU
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int[] INVERSE_PALETTE = new int[]{11, 39, 40, 57, 58, 44, 60, 16, 45, 52, 34, 0, 38, 32, 48, 56, 7, 24, 42, 41, 43, 59, 33, 28, 17, 35, 36, 37, 23, 55, 53, 51, 13, 22, 10, 25, 26, 27, 12, 1, 2, 19, 18, 20, 5, 8, 49, 54, 14, 46, 62, 31, 9, 30, 47, 29, 15, 3, 4, 21, 6, 63, 50, 61};
    public static final int PRE_RENDER_SCANLINE = -1;
    private static final int SECONDARY_OAM_OFFSET = 256;
    private static final int OAM_DUMMY_BYTE_INDEX = 288;
    private static final int OAM_DUMMY_BYTE_VALUE = 255;
    private static final int EVAL_STATE_COPY_Y = 0;
    private static final int EVAL_STATE_COPY_REMAINING = 1;
    private static final int EVAL_STATE_SPRITE_8_Y = 2;
    private static final int EVAL_STATE_SPRITE_8_REMAINING = 3;
    private static final int EVAL_STATE_SPIN = 4;
    private static final int BACKGROUND_NAMETABLE_ADDRESS = 0;
    private static final int BACKGROUND_ATTRIBUTES = 1;
    private static final int BACKGROUND_BITMAP_0 = 2;
    private static final int BACKGROUND_BITMAP_1 = 3;
    private static final int SPRITE_Y = 0;
    private static final int SPRITE_TILE = 1;
    private static final int SPRITE_ATTRIBUTES = 2;
    private static final int SPRITE_X = 3;
    private static final int SPRITE_DATA_ATTRIBUTES = 0;
    private static final int SPRITE_DATA_X = 1;
    private static final int ATTRIBUTES_PALETTE_0 = 0;
    private static final int ATTRIBUTES_PALETTE_1 = 1;
    private static final int ATTRIBUTES_BEHIND_BACKGROUND = 5;
    private static final int ATTRIBUTES_HORIZONTAL_FLIP = 6;
    private static final int ATTRIBUTES_VERTICAL_FLIP = 7;
    public static final int REG_PPU_CTRL = 8192;
    public static final int REG_PPU_MASK = 8193;
    public static final int REG_PPU_STATUS = 8194;
    public static final int REG_OAM_ADDR = 8195;
    public static final int REG_OAM_DATA = 8196;
    public static final int REG_PPU_SCROLL = 8197;
    public static final int REG_PPU_ADDR = 8198;
    public static final int REG_PPU_DATA = 8199;
    private static final long[] BITMAP_0_BITS = new long[256];
    private static final long[] BITMAP_1_BITS = new long[256];
    private static boolean spritesEnabled;
    private static boolean spriteBoxesEnabled;
    private static boolean backgroundEnabled;
    private static boolean showInputDevices;
    private static int highlightedSpriteX;
    private static int highlightedSpriteY;
    private static int highlightColor;
    private static int zapperLightDetectionMargin;
    private CPU cpu;
    private Mapper mapper;
    private volatile transient MachineRunner machineRunner;
    private transient ScreenRenderer screenRenderer;
    private transient int[] lastScreen;
    private transient int[] screen;
    private final int[] OAM = new int[289];
    private final int[] xOAM = new int[256];
    private final int[] paletteRAM = new int[32];
    private int grayscale;
    private int emphasis;
    private int vramAddressIncrement;
    private int spritePatternTableAddress;
    private int backgroundPatternTableAddress;
    private boolean showLeftmostBackground;
    private boolean showLeftmostSprites;
    private boolean showBackground;
    private boolean showSprites;
    private boolean sprite0Hit;
    private boolean NMI_occurred;
    private boolean NMI_output;
    private int ppuDataReadBuffer;
    private boolean ntsc;
    private boolean pal;
    private int palCounter;
    private ZapperMapper zapper;
    private boolean zapperLightNotDetected;
    private int zapperMinScanline;
    private int zapperMaxScanline;
    private int zapperMinScanlineCycle;
    private int zapperMaxScanlineCycle;
    private RobController rob;
    private int V;
    private int T;
    private int X;
    private boolean W;
    private final long[] backgroundTiles = new long[34];
    private final int[] vramData = new int[4];
    private int tileBitmap;
    private int lastReadValue;
    public boolean frameRendering = true;
    private volatile int frameCounter;
    private boolean evenFrame = true;
    private int scanline = -1;
    private int scanlineCount;
    private int scanlineCycle;
    private int scanlineCycleCount;
    private int nmiScanline;
    private boolean rendering;
    private int screenIndex;
    private int vramAddress;
    private int patternTableAddress;
    private final long[] spriteTiles = new long[64];
    private final int[][] spriteDatas = new int[64][2];
    private int primaryOamIndex;
    private int oamIndex;
    private int oamValue;
    private int secondaryOamIndex;
    private int spriteEvalState;
    private boolean evalSprite0InScanline;
    private int evalSpriteCount;
    private boolean spriteOverflow;
    private boolean spriteSize8x16;
    private int spriteBottomOffset;
    private int spriteCount;
    private boolean sprite0InScanline;
    private boolean noSpriteLimit;
    private int writeDelay;
    private int readDelay;
    private int ioValue;
    private int ioAddress;
    protected volatile transient LocalAPI localAPI;

    public static void setSpritesEnabled(boolean spritesEnabled) {
        PPU.spritesEnabled = spritesEnabled;
    }

    public static void setSpriteBoxesEnabled(boolean spriteBoxesEnabled) {
        PPU.spriteBoxesEnabled = spriteBoxesEnabled;
    }

    public static void setBackgroundEnabled(boolean backgroundEnabled) {
        PPU.backgroundEnabled = backgroundEnabled;
    }

    public static void setShowInputDevices(boolean showInputDevices) {
        PPU.showInputDevices = showInputDevices;
    }

    public static void setHighlightedSprite(int highlightedSpriteX, int highlightedSpriteY) {
        PPU.highlightedSpriteX = highlightedSpriteX;
        PPU.highlightedSpriteY = highlightedSpriteY;
    }

    public static void clearHighlightedSprite() {
        PPU.setHighlightedSprite(-1, -1);
    }

    public static void setZapperLightDetectionMargin(int zapperLightDetectionMargin) {
        PPU.zapperLightDetectionMargin = zapperLightDetectionMargin;
    }

    public static void init() {
        AppPrefs prefs = AppPrefs.getInstance();
        View view = prefs.getView();
        PPU.setBackgroundEnabled(view.isBackgroundEnabled());
        PPU.setSpritesEnabled(view.isSpritesEnabled());
        PPU.setShowInputDevices(view.isShowInputDevices());
        PPU.setZapperLightDetectionMargin(prefs.getInputs().getZapperLightDetectionMargin());
    }

    public PPU() {
        this.reset();
    }

    public void reset() {
        Arrays.fill(this.OAM, 0);
        Arrays.fill(this.xOAM, 0);
        Arrays.fill(this.paletteRAM, 0);
        Arrays.fill(this.backgroundTiles, 0L);
        Arrays.fill(this.vramData, 0);
        Arrays.fill(this.spriteTiles, 0L);
        for (int i = this.spriteDatas.length - 1; i >= 0; --i) {
            Arrays.fill(this.spriteDatas[i], 0);
        }
        this.grayscale = 0;
        this.emphasis = 0;
        this.vramAddressIncrement = 0;
        this.spritePatternTableAddress = 0;
        this.backgroundPatternTableAddress = 0;
        this.showLeftmostBackground = false;
        this.showLeftmostSprites = false;
        this.showBackground = false;
        this.showSprites = false;
        this.sprite0Hit = false;
        this.NMI_occurred = false;
        this.NMI_output = false;
        this.ppuDataReadBuffer = 0;
        this.palCounter = 0;
        this.zapperLightNotDetected = false;
        this.zapperMinScanline = 0;
        this.zapperMaxScanline = 0;
        this.zapperMinScanlineCycle = 0;
        this.zapperMaxScanlineCycle = 0;
        this.V = 0;
        this.T = 0;
        this.X = 0;
        this.W = false;
        this.tileBitmap = 0;
        this.lastReadValue = 0;
        this.frameRendering = true;
        this.scanline = -1;
        this.scanlineCycle = 0;
        this.scanlineCycleCount = 0;
        this.rendering = false;
        this.screenIndex = 0;
        this.vramAddress = 0;
        this.patternTableAddress = 0;
        this.primaryOamIndex = 0;
        this.oamIndex = 0;
        this.oamValue = 0;
        this.secondaryOamIndex = 0;
        this.spriteEvalState = 0;
        this.evalSprite0InScanline = false;
        this.evalSpriteCount = 0;
        this.spriteOverflow = false;
        this.spriteSize8x16 = false;
        this.spriteBottomOffset = 0;
        this.spriteCount = 0;
        this.sprite0InScanline = false;
        this.writeDelay = 0;
        this.readDelay = 0;
        this.ioValue = 0;
        this.ioAddress = 0;
        this.OAM[288] = 255;
        this.writePPUCtrl(0);
        this.writePPUMask(0);
    }

    public void setMachine(Machine machine) {
        this.cpu = machine.getCPU();
        this.mapper = machine.getMapper();
    }

    public void setCPU(CPU cpu) {
        this.cpu = cpu;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setMachineRunner(MachineRunner machineRunner) {
        this.machineRunner = machineRunner;
    }

    public void setTVSystem(TVSystem tvSystem) {
        this.ntsc = tvSystem == TVSystem.NTSC;
        this.pal = tvSystem == TVSystem.PAL;
        this.scanlineCount = tvSystem.getScanlineCount();
        this.nmiScanline = tvSystem.getNmiScanline();
        if (this.scanline >= this.scanlineCount - 1) {
            this.scanline = this.scanlineCount - 2;
        }
    }

    public void setZapper(ZapperMapper zapper) {
        this.zapper = zapper;
        if (zapper == null) {
            this.zapperLightNotDetected = false;
        } else {
            int coordinates = zapper.getCoordinates();
            if (coordinates == 65535) {
                this.zapperLightNotDetected = false;
            } else {
                this.zapperLightNotDetected = true;
                int x = coordinates & 0xFF;
                this.zapperMinScanlineCycle = x - zapperLightDetectionMargin;
                if (this.zapperMinScanlineCycle < 0) {
                    this.zapperMinScanlineCycle = 0;
                }
                this.zapperMaxScanlineCycle = x + zapperLightDetectionMargin;
                if (this.zapperMaxScanlineCycle > 255) {
                    this.zapperMaxScanlineCycle = 255;
                }
                int y = coordinates >> 8 & 0xFF;
                this.zapperMinScanline = y - zapperLightDetectionMargin;
                if (this.zapperMinScanline < 0) {
                    this.zapperMinScanline = 0;
                }
                this.zapperMaxScanline = y + zapperLightDetectionMargin;
                if (this.zapperMaxScanline > 239) {
                    this.zapperMaxScanline = 239;
                }
            }
        }
    }

    public ZapperMapper getZapper() {
        return this.zapper;
    }

    public RobController getRob() {
        return this.rob;
    }

    public void setRob(RobController rob) {
        this.rob = rob;
    }

    public boolean isFrameRendering() {
        return this.frameRendering;
    }

    public void setFrameRendering(boolean frameRendering) {
        this.frameRendering = frameRendering;
    }

    public int getFrameCounter() {
        return this.frameCounter;
    }

    public void setFrameCounter(int frameCounter) {
        this.frameCounter = frameCounter;
    }

    public void setScreenRenderer(ScreenRenderer renderer) {
        this.lastScreen = this.screen;
        this.screenRenderer = renderer;
        this.screen = renderer.render();
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public int[] getOAM() {
        return this.OAM;
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public boolean isShowSprites() {
        return this.showSprites;
    }

    public boolean isShowBackground() {
        return this.showBackground;
    }

    public boolean isSpriteSize8x16() {
        return this.spriteSize8x16;
    }

    public int getSpritePatternTableAddress() {
        return this.spritePatternTableAddress;
    }

    public int getScanline() {
        return this.scanline;
    }

    public int getScanlineCycle() {
        return this.scanlineCycle;
    }

    public boolean isSprite0Hit() {
        return this.sprite0Hit;
    }

    public void setSprite0Hit(boolean sprite0Hit) {
        this.sprite0Hit = sprite0Hit;
    }

    public int getScanlineCount() {
        return this.scanlineCount;
    }

    public boolean isNoSpriteLimit() {
        return this.noSpriteLimit;
    }

    public void setNoSpriteLimit(boolean noSpriteLimit) {
        this.noSpriteLimit = noSpriteLimit;
    }

    public void setV(int V) {
        this.V = V & Short.MAX_VALUE;
    }

    public int getV() {
        return this.V;
    }

    public void setT(int T) {
        this.T = T & Short.MAX_VALUE;
    }

    public int getT() {
        return this.T;
    }

    public void setX(int X) {
        this.X = X & 7;
    }

    public int getX() {
        return this.X;
    }

    public void setW(boolean W) {
        this.W = W;
    }

    public boolean isW() {
        return this.W;
    }

    public void writeRegister(int register, int value) {
        this.lastReadValue = value;
        switch (register) {
            case 8192: {
                this.writePPUCtrl(value);
                break;
            }
            case 8193: {
                this.writePPUMask(value);
                break;
            }
            case 8195: {
                this.writeOAMAddr(value);
                break;
            }
            case 8196: {
                this.writeOAMData(value);
                break;
            }
            case 8197: {
                this.writePPUScroll(value);
                break;
            }
            case 8198: {
                this.writePPUAddr(value);
                break;
            }
            case 8199: {
                this.writePPUData(value);
            }
        }
    }

    public int peekRegister(int register) {
        switch (register) {
            case 8194: {
                return this.peekPPUStatus();
            }
            case 8196: {
                return this.peekOAMData();
            }
            case 8199: {
                return this.peekPPUData();
            }
        }
        return this.lastReadValue;
    }

    public int readRegister(int register) {
        switch (register) {
            case 8194: {
                return this.readPPUStatus();
            }
            case 8196: {
                return this.readOAMData();
            }
            case 8199: {
                return this.readPPUData();
            }
        }
        return this.lastReadValue;
    }

    public void update() {
        if (this.pal) {
            if (this.palCounter == 4) {
                this.palCounter = 0;
                this.executeCycle();
            } else {
                ++this.palCounter;
            }
        }
        this.executeCycle();
        this.executeCycle();
        this.executeCycle();
    }

    private void incrementCoarseX() {
        this.V = (this.V & 0x1F) == 31 ? (this.V ^= 0x41F) : ++this.V;
    }

    private void incrementY() {
        if ((this.V & 0x7000) == 28672) {
            int y = this.V & 0x3E0;
            this.V &= 0xFFF;
            this.V = y == 928 ? (this.V ^= 0xBA0) : (y == 992 ? (this.V ^= 0x3E0) : (this.V += 32));
        } else {
            this.V += 4096;
        }
    }

    private void incrementVRAMAddress() {
        if (this.rendering) {
            if ((this.scanlineCycle & 7) != 3 || this.scanlineCycle > 251 && (this.scanlineCycle < 320 || this.scanlineCycle >= 337)) {
                this.incrementCoarseX();
            }
            if (this.scanlineCycle != 251) {
                this.incrementY();
            }
        } else {
            this.V = this.V + this.vramAddressIncrement & Short.MAX_VALUE;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void evaluateSprites() {
        block24: {
            block27: {
                block28: {
                    block26: {
                        block25: {
                            block23: {
                                readCycle = MathUtil.isOdd(this.scanlineCycle);
                                if (this.scanlineCycle != 0) break block23;
                                if (this.scanline == -1 && (this.primaryOamIndex & 248) != 0) {
                                    System.arraycopy(this.OAM, this.primaryOamIndex & 248, this.OAM, 0, 8);
                                }
                                this.secondaryOamIndex = 0;
                                this.primaryOamIndex = 0;
                                this.oamIndex = 0;
                                break block24;
                            }
                            if (this.scanlineCycle > 64) break block25;
                            if (readCycle) {
                                this.oamIndex = 288;
                                this.oamValue = this.OAM[this.oamIndex];
                            } else {
                                this.oamIndex = 256 | this.secondaryOamIndex;
                                this.OAM[this.oamIndex] = this.oamValue;
                                this.secondaryOamIndex = this.secondaryOamIndex + 1 & 31;
                            }
                            if (this.scanlineCycle == 64) {
                                this.spriteEvalState = 0;
                                this.evalSpriteCount = 0;
                                this.evalSprite0InScanline = false;
                            }
                            break block24;
                        }
                        if (this.scanlineCycle > 256) break block26;
                        if (readCycle) {
                            this.oamIndex = this.primaryOamIndex;
                            this.oamValue = this.OAM[this.oamIndex];
                        } else {
                            switch (this.spriteEvalState) {
                                case 0: {
                                    this.oamIndex = 256 | this.secondaryOamIndex;
                                    this.OAM[this.oamIndex] = this.oamValue;
                                    if (this.scanline >= this.oamValue && this.scanline <= this.oamValue + this.spriteBottomOffset) {
                                        ++this.evalSpriteCount;
                                        if (this.primaryOamIndex == 0) {
                                            this.evalSprite0InScanline = true;
                                        }
                                        this.spriteEvalState = 1;
                                        this.primaryOamIndex = this.primaryOamIndex + 1 & 255;
                                        this.secondaryOamIndex = this.secondaryOamIndex + 1 & 31;
                                        break;
                                    }
                                    this.primaryOamIndex = this.primaryOamIndex + 4 & 252;
                                    if (this.primaryOamIndex != 0) break;
                                    this.spriteEvalState = 4;
                                    break;
                                }
                                case 1: {
                                    this.oamIndex = 256 | this.secondaryOamIndex;
                                    this.OAM[this.oamIndex] = this.oamValue;
                                    this.primaryOamIndex = this.primaryOamIndex + 1 & 255;
                                    this.secondaryOamIndex = this.secondaryOamIndex + 1 & 31;
                                    if ((this.secondaryOamIndex & 3) != 0) break;
                                    if (this.primaryOamIndex < 4) {
                                        this.spriteEvalState = 4;
                                        break;
                                    }
                                    if (this.secondaryOamIndex == 0) {
                                        this.spriteEvalState = 2;
                                        break;
                                    }
                                    this.spriteEvalState = 0;
                                    break;
                                }
                                case 2: {
                                    this.oamIndex = 256 | this.secondaryOamIndex;
                                    if (this.scanline >= this.oamValue && this.scanline <= this.oamValue + this.spriteBottomOffset) {
                                        this.spriteEvalState = 3;
                                        this.spriteOverflow = true;
                                        this.primaryOamIndex = this.primaryOamIndex + 1 & 255;
                                        this.secondaryOamIndex = 1;
                                        break;
                                    }
                                    this.primaryOamIndex = this.primaryOamIndex + ((this.primaryOamIndex & 3) == 3 ? 1 : 5) & 255;
                                    if (this.primaryOamIndex >= 4) break;
                                    this.spriteEvalState = 4;
                                    break;
                                }
                                case 3: {
                                    this.oamIndex = 256;
                                    this.primaryOamIndex = this.primaryOamIndex + 1 & 255;
                                    if (++this.secondaryOamIndex != 4) break;
                                    this.secondaryOamIndex = 0;
                                    this.primaryOamIndex = (this.primaryOamIndex & 3) != 0 ? (this.primaryOamIndex &= 252) : this.primaryOamIndex + 4 & 252;
                                    this.spriteEvalState = 4;
                                    break;
                                }
                                case 4: {
                                    this.oamIndex = 256 | this.secondaryOamIndex;
                                    this.primaryOamIndex = this.primaryOamIndex + 4 & 252;
                                }
                            }
                        }
                        break block24;
                    }
                    if (this.scanlineCycle > 320) break block27;
                    if (this.scanlineCycle != 257) break block28;
                    this.spriteCount = this.evalSpriteCount << 2;
                    this.sprite0InScanline = this.evalSprite0InScanline;
                    this.secondaryOamIndex = 0;
                    this.primaryOamIndex = 0;
                    if (!this.noSpriteLimit) break block28;
                    if (this.spriteCount != 32) ** GOTO lbl98
                    y = this.OAM[284];
                    x = this.OAM[287];
                    for (i = 6; i > 0; --i) {
                        address = 256 | i << 2;
                        if (y == this.OAM[address] && x == this.OAM[address | 3]) {
                            continue;
                        }
lbl98:
                        // 3 sources

                        System.arraycopy(this.OAM, 256, this.xOAM, 0, this.spriteCount);
                        x = 0;
                        for (p = 0; p < 256; p += 4) {
                            spriteY = this.OAM[p];
                            if (this.scanline < spriteY || this.scanline > spriteY + this.spriteBottomOffset) continue;
                            if (x >= this.spriteCount) {
                                this.xOAM[x] = this.OAM[p];
                                this.xOAM[x | 1] = this.OAM[p | 1];
                                this.xOAM[x | 2] = this.OAM[p | 2];
                                this.xOAM[x | 3] = this.OAM[p | 3];
                            }
                            x += 4;
                        }
                        if (x <= this.spriteCount) break;
                        this.spriteCount = x;
                        break;
                    }
                }
                this.oamIndex = 256 | this.secondaryOamIndex;
                if ((this.scanlineCycle - 1 & 4) < 4) {
                    this.secondaryOamIndex = this.secondaryOamIndex + 1 & 31;
                }
                break block24;
            }
            this.oamIndex = 256;
        }
    }

    private void executeCycle() {
        ++this.scanlineCycle;
        if (this.scanlineCycle == 256) {
            if (this.scanline < 240) {
                for (int i = this.backgroundTiles.length - 1; i >= 0; --i) {
                    this.backgroundTiles[i] = 0L;
                }
            }
        } else if (this.scanlineCycle >= 279 && this.scanlineCycle <= 303) {
            if (this.rendering && this.scanline == -1) {
                this.V = this.V & 0x841F | this.T & 0x7BE0;
            }
        } else if (this.scanlineCycle == 338) {
            this.scanlineCycleCount = this.scanline == -1 && this.evenFrame && this.rendering && this.ntsc ? 340 : 341;
        } else if (this.scanlineCycle == this.scanlineCycleCount) {
            this.scanlineCycle = 0;
            ++this.scanline;
            if (this.scanline == 240) {
                LocalAPI api;
                DeviceMapper[] deviceMappers;
                MachineRunner runner = this.machineRunner;
                this.drawHighlightedSprite();
                if (showInputDevices && (deviceMappers = this.mapper.getDeviceMappers()) != null) {
                    for (int i = deviceMappers.length - 1; i >= 0; --i) {
                        deviceMappers[i].render(this.screen);
                    }
                }
                if ((api = this.localAPI) != null) {
                    api.frameRendered(this.screen);
                }
                if (this.rob != null) {
                    this.rob.signal(PaletteUtil.ROB_COLORS[this.screen[0]]);
                }
                if (runner != null) {
                    runner.frameRendered(this.screen);
                }
                this.lastScreen = this.screen;
                this.screen = this.screenRenderer.render();
            } else if (this.scanline == this.nmiScanline) {
                this.NMI_occurred = true;
                if (this.NMI_output) {
                    this.cpu.setNMI(true);
                }
            } else if (this.scanline == this.scanlineCount - 1) {
                this.scanline = -1;
                this.evenFrame = !this.evenFrame;
                this.screenIndex = 0;
                this.frameRendering = false;
                ++this.frameCounter;
            }
            if (this.zapper != null) {
                this.zapper.handleScanline();
            }
            this.updateRendering();
        } else if (this.scanline == -1 && this.scanlineCycle == 1) {
            this.NMI_occurred = false;
            this.sprite0Hit = false;
            this.spriteOverflow = false;
        }
        if (this.rendering) {
            this.evaluateSprites();
            boolean writeCycle = MathUtil.isOdd(this.scanlineCycle);
            if (writeCycle) {
                if (this.writeDelay > 0 || this.readDelay > 0) {
                    this.ioValue = 0;
                    this.vramData[this.scanlineCycle >> 1 & 3] = 0;
                    if (this.writeDelay == 1) {
                        this.writeVRAM(this.vramAddress, 0);
                    }
                } else {
                    this.vramData[this.scanlineCycle >> 1 & 3] = this.readVRAM(this.vramAddress);
                }
            }
            if (this.scanlineCycle < 256) {
                switch (this.scanlineCycle & 7) {
                    case 0: {
                        this.vramAddress = 0x2000 | this.V & 0xFFF;
                        break;
                    }
                    case 1: {
                        this.patternTableAddress = this.vramData[0] << 4 | this.V >> 12 | this.backgroundPatternTableAddress;
                        break;
                    }
                    case 2: {
                        this.vramAddress = 0x23C0 | this.V & 0xC00 | (this.V & 0x380) >> 4 | (this.V & 0x1C) >> 2;
                        break;
                    }
                    case 3: {
                        this.backgroundTiles[this.scanlineCycle + 13 >> 3] = (long)(this.vramData[1] >> ((this.V & 0x40) >> 4 | this.V & 2) & 3) * 0x404040404040404L;
                        this.incrementCoarseX();
                        if (this.scanlineCycle != 251) break;
                        this.incrementY();
                        break;
                    }
                    case 4: {
                        this.vramAddress = this.patternTableAddress;
                        break;
                    }
                    case 5: {
                        this.tileBitmap = BitUtil.reverseBits(this.vramData[2]);
                        int n = this.scanlineCycle + 11 >> 3;
                        this.backgroundTiles[n] = this.backgroundTiles[n] | BITMAP_0_BITS[this.tileBitmap];
                        break;
                    }
                    case 6: {
                        this.vramAddress = this.patternTableAddress | 8;
                        break;
                    }
                    case 7: {
                        this.tileBitmap = BitUtil.reverseBits(this.vramData[3]);
                        int n = this.scanlineCycle + 9 >> 3;
                        this.backgroundTiles[n] = this.backgroundTiles[n] | BITMAP_1_BITS[this.tileBitmap];
                    }
                }
            } else if (this.scanlineCycle < 320) {
                switch (this.scanlineCycle & 7) {
                    case 0: {
                        this.vramAddress = 0x2000 | this.V & 0xFFF;
                        break;
                    }
                    case 1: {
                        if (this.scanlineCycle != 257) break;
                        this.V = this.V & 0x7BE0 | this.T & 0x41F;
                        break;
                    }
                    case 2: {
                        this.vramAddress = 0x2000 | this.V & 0xFFF;
                        break;
                    }
                    case 3: {
                        int spriteOffset = this.scanlineCycle >> 1 & 0x1C;
                        this.tileBitmap = this.OAM[0x100 | spriteOffset | 1];
                        int spriteScanline = this.scanline - this.OAM[0x100 | spriteOffset];
                        if (this.spriteSize8x16) {
                            this.patternTableAddress = (this.tileBitmap & 0xFE) << 4 | (this.tileBitmap & 1) << 12 | spriteScanline & 7 ^ (BitUtil.getBitBool(this.OAM[0x100 | spriteOffset | 2], 7) ? 23 : 0) ^ (spriteScanline & 8) << 1;
                            break;
                        }
                        this.patternTableAddress = this.tileBitmap << 4 | spriteScanline & 7 ^ (BitUtil.getBitBool(this.OAM[0x100 | spriteOffset | 2], 7) ? 7 : 0) | this.spritePatternTableAddress;
                        break;
                    }
                    case 4: {
                        this.vramAddress = this.patternTableAddress;
                        break;
                    }
                    case 5: {
                        int spriteTileOffset = this.scanlineCycle >> 1 & 0x1E;
                        this.tileBitmap = (this.OAM[0x100 | spriteTileOffset] & 0x40) != 0 ? this.vramData[2] : BitUtil.reverseBits(this.vramData[2]);
                        this.spriteTiles[spriteTileOffset >> 2] = BITMAP_0_BITS[this.tileBitmap] | (long)(this.OAM[0x100 | spriteTileOffset] & 3) * 0x404040404040404L;
                        break;
                    }
                    case 6: {
                        this.vramAddress = this.patternTableAddress | 8;
                        break;
                    }
                    case 7: {
                        int spriteIndex;
                        int spriteTileOffset = this.scanlineCycle >> 1 & 0x1E;
                        this.tileBitmap = (this.OAM[0x100 | spriteTileOffset] & 0x40) != 0 ? this.vramData[3] : BitUtil.reverseBits(this.vramData[3]);
                        int n = spriteIndex = spriteTileOffset >> 2;
                        this.spriteTiles[n] = this.spriteTiles[n] | BITMAP_1_BITS[this.tileBitmap];
                        this.spriteDatas[spriteIndex][0] = this.OAM[0x100 | spriteTileOffset];
                        this.spriteDatas[spriteIndex][1] = this.OAM[0x100 | spriteTileOffset | 1];
                        break;
                    }
                }
                if (this.noSpriteLimit && this.scanlineCycle == 319 && this.spriteCount > 32) {
                    for (int i = 0; i < this.spriteCount; i += 4) {
                        int bitmap = this.xOAM[i | 1];
                        int spriteScanline = this.scanline - this.xOAM[i];
                        int address = this.spriteSize8x16 ? (bitmap & 0xFE) << 4 | (bitmap & 1) << 12 | spriteScanline & 7 ^ (BitUtil.getBitBool(this.xOAM[i | 2], 7) ? 23 : 0) ^ (spriteScanline & 8) << 1 : bitmap << 4 | spriteScanline & 7 ^ (BitUtil.getBitBool(this.xOAM[i | 2], 7) ? 7 : 0) | this.spritePatternTableAddress;
                        boolean flipHorizontally = (this.xOAM[i | 2] & 0x40) != 0;
                        int value = this.peekVRAM(address);
                        bitmap = flipHorizontally ? value : BitUtil.reverseBits(value);
                        int spriteIndex = i >> 2;
                        this.spriteTiles[spriteIndex] = BITMAP_0_BITS[bitmap] | (long)(this.xOAM[i | 2] & 3) * 0x404040404040404L;
                        value = this.peekVRAM(address | 8);
                        bitmap = flipHorizontally ? value : BitUtil.reverseBits(value);
                        int n = spriteIndex;
                        this.spriteTiles[n] = this.spriteTiles[n] | BITMAP_1_BITS[bitmap];
                        this.spriteDatas[spriteIndex][0] = this.xOAM[i | 2];
                        this.spriteDatas[spriteIndex][1] = this.xOAM[i | 3];
                    }
                }
            } else if (this.scanlineCycle < 337) {
                switch (this.scanlineCycle & 7) {
                    case 0: {
                        this.vramAddress = 0x2000 | this.V & 0xFFF;
                        break;
                    }
                    case 1: {
                        this.patternTableAddress = this.vramData[0] << 4 | this.V >> 12 | this.backgroundPatternTableAddress;
                        if (this.scanlineCycle != 321) break;
                        App.scanlineRendered(this.scanline);
                        break;
                    }
                    case 2: {
                        this.vramAddress = 0x23C0 | this.V & 0xC00 | (this.V & 0x380) >> 4 | (this.V & 0x1C) >> 2;
                        break;
                    }
                    case 3: {
                        this.backgroundTiles[this.scanlineCycle - 323 >> 3] = (long)(this.vramData[1] >> ((this.V & 0x40) >> 4 | this.V & 2) & 3) * 0x404040404040404L;
                        this.incrementCoarseX();
                        break;
                    }
                    case 4: {
                        this.vramAddress = this.patternTableAddress;
                        break;
                    }
                    case 5: {
                        this.tileBitmap = BitUtil.reverseBits(this.vramData[2]);
                        int n = this.scanlineCycle - 325 >> 3;
                        this.backgroundTiles[n] = this.backgroundTiles[n] | BITMAP_0_BITS[this.tileBitmap];
                        break;
                    }
                    case 6: {
                        this.vramAddress = this.patternTableAddress | 8;
                        break;
                    }
                    case 7: {
                        this.tileBitmap = BitUtil.reverseBits(this.vramData[3]);
                        int n = this.scanlineCycle - 327 >> 3;
                        this.backgroundTiles[n] = this.backgroundTiles[n] | BITMAP_1_BITS[this.tileBitmap];
                    }
                }
            } else if (this.scanlineCycle == 338) {
                this.vramAddress = 0x2000 | this.V & 0xFFF;
            }
            if (!writeCycle) {
                this.handlePpuCycle(this.scanline, this.scanlineCycle, this.vramAddress, this.rendering);
                if (this.writeDelay == 1) {
                    this.writeVRAM(this.vramAddress, this.vramAddress & 0xFF);
                }
            }
        }
        if (!(this.rendering || this.writeDelay != 3 && this.readDelay != 3)) {
            this.handlePpuCycle(this.scanline, this.scanlineCycle, this.ioAddress, this.rendering);
        }
        if (this.writeDelay > 0 && --this.writeDelay == 0 && !this.rendering) {
            this.writeVRAM(this.ioAddress, this.ioValue);
        }
        if (this.readDelay > 0 && --this.readDelay == 0 && !this.rendering) {
            this.ppuDataReadBuffer = this.readVRAM(this.ioAddress);
        }
        if (!this.rendering && (this.writeDelay | this.readDelay) == 0) {
            this.handlePpuCycle(this.scanline, this.scanlineCycle, this.V, this.rendering);
        }
        if (this.scanline < 240 && this.scanline != -1 && this.scanlineCycle < 256) {
            if (this.showBackground && (this.scanlineCycle >= 8 || this.showLeftmostBackground)) {
                int index = this.scanlineCycle + this.X;
                this.tileBitmap = (byte)(this.backgroundTiles[index >> 3] >> ((index & 7) << 3));
            } else {
                this.tileBitmap = 0;
            }
            boolean spriteRendered = false;
            boolean invertPalette = false;
            if (this.showSprites && (this.scanlineCycle >= 8 || this.showLeftmostSprites)) {
                for (int y = 0; y < this.spriteCount; y += 4) {
                    int spritePixel = this.scanlineCycle - this.spriteDatas[y >> 2][1];
                    if ((spritePixel & 0xFFFFFFF8) != 0) continue;
                    byte spriteTile = (byte)(this.spriteTiles[y >> 2] >> (spritePixel << 3));
                    if ((spriteTile & 3) != 0) {
                        if (this.sprite0InScanline && y == 0 && (this.tileBitmap & 3) != 0 && this.scanlineCycle < 255) {
                            this.sprite0Hit = true;
                            this.sprite0InScanline = false;
                            LocalAPI api = this.localAPI;
                            if (api != null) {
                                api.spriteZeroHit(this.scanline, this.scanlineCycle);
                            }
                        }
                        if (!spritesEnabled || (this.tileBitmap & 3) != 0 && (this.spriteDatas[y >> 2][0] & 0x20) != 0) break;
                        this.tileBitmap = spriteTile | 0x10;
                        spriteRendered = true;
                        break;
                    }
                    invertPalette = spriteBoxesEnabled;
                }
            }
            if (!spriteRendered && !backgroundEnabled) {
                this.tileBitmap = 0;
            }
            int paletteIndex = !this.rendering && (this.V & 0x3F00) == 16128 ? this.paletteRAM[this.V & 0x1F] : ((this.tileBitmap & 3) != 0 ? this.paletteRAM[this.tileBitmap & 0x1F] : this.paletteRAM[0]);
            if (this.zapperLightNotDetected && this.scanline >= this.zapperMinScanline && this.scanline <= this.zapperMaxScanline && this.scanlineCycle >= this.zapperMinScanlineCycle && this.scanlineCycle <= this.zapperMaxScanlineCycle && PaletteUtil.ZAPPER_COLORS[paletteIndex]) {
                this.zapperLightNotDetected = false;
                this.zapper.handleLightDetected();
            }
            this.screen[this.screenIndex++] = this.emphasis | (invertPalette ? INVERSE_PALETTE[paletteIndex & this.grayscale] : paletteIndex & this.grayscale);
        }
    }

    private void drawHighlightedSprite() {
        int spriteX = highlightedSpriteX;
        if (spriteX < 0) {
            return;
        }
        int spriteY = highlightedSpriteY;
        if (spriteY >= 240) {
            return;
        }
        GuiUtil.drawRect(this.screen, spriteX, spriteY, 8, this.spriteSize8x16 ? 16 : 8, highlightColor);
        highlightColor = highlightColor + 1 & 0x1F;
    }

    private void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        this.mapper.handlePpuCycle(scanline, scanlineCycle, address, rendering);
        LocalAPI api = this.localAPI;
        if (api != null) {
            api.cyclePerformed(scanline, scanlineCycle, address, rendering);
        }
    }

    public int[] getScreen() {
        return this.screen;
    }

    public int[] getLastScreen() {
        return this.lastScreen;
    }

    public LocalAPI getLocalAPI() {
        return this.localAPI;
    }

    public void setLocalAPI(LocalAPI localAPI) {
        this.localAPI = localAPI;
    }

    public void clearLocalAPI() {
        this.setLocalAPI(null);
    }

    public int getNextScanline() {
        int value = this.scanline + 1;
        return value == this.scanlineCount - 1 ? -1 : value;
    }

    public int getNextScanlineCycle() {
        int value = this.scanlineCycle + 1;
        return value >= (this.scanline == -1 && this.evenFrame && this.rendering && this.ntsc ? 340 : 341) ? 0 : value;
    }

    public int[] getPaletteRAM() {
        return this.paletteRAM;
    }

    public int getPaletteRamValue(int index) {
        return this.paletteRAM[(index & 3) == 0 ? 0 : index & 0x1F];
    }

    public void setPaletteRamValue(int index, int value) {
        this.paletteRAM[(index & 3) == 0 ? 0 : index & 0x1F] = value;
    }

    public int getBackgroundPatternTableAddress() {
        return this.backgroundPatternTableAddress;
    }

    public int getScrollX() {
        return this.V >> 2 & 0x100 | this.V << 3 & 0xF8 | this.X & 7;
    }

    public void setScrollX(int scrollX) {
        this.X = scrollX & 7;
        this.V = this.V & 0x7BE0 | (scrollX & 0x100) << 2 | (scrollX & 0xF8) >> 3;
    }

    public int getScrollY() {
        int scrollY = this.V >> 3 & 0x100 | this.V >> 2 & 0xF8 | this.V >> 12 & 7;
        return scrollY >= 240 ? scrollY - 16 : scrollY;
    }

    public void setScrollY(int scrollY) {
        if ((scrollY &= 0x1FF) >= 240) {
            scrollY += 16;
        }
        this.V = this.V & 0xC1F | (scrollY & 0x100) << 3 | (scrollY & 0xF8) << 2 | (scrollY & 7) << 12;
    }

    private void writePPUCtrl(int value) {
        boolean nextNmiOutput = BitUtil.getBitBool(value, 7);
        if (nextNmiOutput) {
            if (!this.NMI_output && this.NMI_occurred) {
                this.cpu.setNMI(true);
            }
        } else if (this.scanline == this.nmiScanline && this.scanlineCycle < 3) {
            this.cpu.setNMI(false);
        }
        this.vramAddressIncrement = BitUtil.getBitBool(value, 2) ? 32 : 1;
        this.spritePatternTableAddress = BitUtil.getBit(value, 3) << 12;
        this.backgroundPatternTableAddress = BitUtil.getBit(value, 4) << 12;
        this.spriteSize8x16 = BitUtil.getBitBool(value, 5);
        this.spriteBottomOffset = this.spriteSize8x16 ? 15 : 7;
        this.NMI_output = nextNmiOutput;
        this.T = this.T & 0x73FF | (value & 3) << 10;
    }

    private void writePPUMask(int value) {
        this.grayscale = BitUtil.getBitBool(value, 0) ? 48 : 63;
        this.showLeftmostBackground = BitUtil.getBitBool(value, 1);
        this.showLeftmostSprites = BitUtil.getBitBool(value, 2);
        this.showBackground = BitUtil.getBitBool(value, 3);
        this.showSprites = BitUtil.getBitBool(value, 4);
        this.emphasis = (value & 0xE0) << 1;
        this.updateRendering();
    }

    private int readPPUStatus() {
        int value = this.lastReadValue & 0x1F;
        if (this.NMI_occurred) {
            value |= 0x80;
        }
        if (this.sprite0Hit) {
            value |= 0x40;
        }
        if (this.spriteOverflow) {
            value |= 0x20;
        }
        this.NMI_occurred = false;
        if (this.scanline == this.nmiScanline) {
            if (this.scanlineCycle == 0) {
                value &= 0x7F;
            }
            if (this.scanlineCycle < 3) {
                this.cpu.setNMI(false);
            }
        }
        this.W = false;
        this.lastReadValue = value;
        return this.lastReadValue;
    }

    private int peekPPUStatus() {
        int value = this.lastReadValue & 0x1F;
        if (this.NMI_occurred) {
            value |= 0x80;
        }
        if (this.sprite0Hit) {
            value |= 0x40;
        }
        if (this.spriteOverflow) {
            value |= 0x20;
        }
        if (this.scanline == this.nmiScanline && this.scanlineCycle == 0) {
            value &= 0x7F;
        }
        return value;
    }

    private void writeOAMAddr(int value) {
        this.primaryOamIndex = value;
    }

    private int readOAMData() {
        this.lastReadValue = this.OAM[this.rendering ? this.oamIndex : this.primaryOamIndex];
        return this.lastReadValue;
    }

    private int peekOAMData() {
        return this.OAM[this.rendering ? this.oamIndex : this.primaryOamIndex];
    }

    private void writeOAMData(int value) {
        if (this.rendering) {
            value = 255;
        }
        if ((this.primaryOamIndex & 3) == 2) {
            value &= 0xE3;
        }
        this.OAM[this.primaryOamIndex] = value;
        this.primaryOamIndex = this.primaryOamIndex + 1 & 0xFF;
    }

    private void writePPUScroll(int value) {
        if (this.W) {
            this.T = this.T & 0xC1F | (value & 7) << 12 | (value & 0xF8) << 2;
        } else {
            this.T = this.T & 0x7FE0 | value >> 3;
            this.X = value & 7;
        }
        this.W = !this.W;
    }

    private void writePPUAddr(int value) {
        if (this.W) {
            this.V = this.T = this.T & 0x7F00 | value;
        } else {
            this.T = this.T & 0xFF | (value & 0x3F) << 8;
        }
        this.W = !this.W;
    }

    private void writePPUData(int value) {
        if ((this.V & 0x3F00) == 16128) {
            int address = this.V & 0x1F;
            this.paletteRAM[address] = value &= 0x3F;
            if ((address & 3) == 0) {
                this.paletteRAM[address ^ 0x10] = value;
            }
        } else {
            this.ioAddress = this.V;
            this.ioValue = value;
            this.writeDelay = 3;
        }
        this.incrementVRAMAddress();
    }

    private int readPPUData() {
        this.readDelay = 3;
        this.ioAddress = this.V;
        this.incrementVRAMAddress();
        if ((this.ioAddress & 0x3F00) == 16128) {
            this.lastReadValue &= 0xC0;
            this.lastReadValue = this.grayscale == 48 ? (this.lastReadValue |= this.paletteRAM[this.ioAddress & 0x1F] & 0x30) : (this.lastReadValue |= this.paletteRAM[this.ioAddress & 0x1F]);
        } else {
            this.lastReadValue = this.ppuDataReadBuffer;
        }
        return this.lastReadValue;
    }

    private int peekPPUData() {
        int value = this.lastReadValue;
        value = (this.ioAddress & 0x3F00) == 16128 ? value & 0xC0 | this.paletteRAM[this.ioAddress & 0x1F] : this.ppuDataReadBuffer;
        return value;
    }

    public int peekVRAM(int address) {
        return this.mapper.peekVRAM(this.mapper.maskVRAMAddress(address));
    }

    private int readVRAM(int address) {
        return this.mapper.readVRAM(this.mapper.maskVRAMAddress(address));
    }

    public void writeVRAM(int address, int value) {
        this.mapper.writeVRAM(this.mapper.maskVRAMAddress(address), value);
    }

    private void updateRendering() {
        this.rendering = (this.showSprites || this.showBackground) && this.scanline < 240;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                BITMAP_0_BITS[n] = BITMAP_0_BITS[n] | (long)BitUtil.getBit(i, j) << (j << 3);
            }
            PPU.BITMAP_1_BITS[i] = BITMAP_0_BITS[i] << 1;
        }
        spritesEnabled = true;
        backgroundEnabled = true;
        highlightedSpriteX = -1;
        highlightedSpriteY = -1;
        zapperLightDetectionMargin = 3;
    }
}

