/*
 * Decompiled with CFR 0.152.
 */
package nintaco.api.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import nintaco.api.API;
import nintaco.api.AccessPointListener;
import nintaco.api.ActivateListener;
import nintaco.api.ControllersListener;
import nintaco.api.DeactivateListener;
import nintaco.api.FrameListener;
import nintaco.api.ScanlineCycleListener;
import nintaco.api.ScanlineListener;
import nintaco.api.SpriteZeroListener;
import nintaco.api.StatusListener;
import nintaco.api.StopListener;
import nintaco.api.local.AccessPoint;
import nintaco.api.local.ScanlineCyclePoint;
import nintaco.api.local.ScanlinePoint;
import nintaco.api.server.DataStream;
import nintaco.util.ThreadUtil;

public abstract class RemoteBase
implements API {
    private static final int[] EVENT_TYPES = new int[]{1, 3, 5, 9, 11, 13, 15, 17, 19, 21};
    public static final int EVENT_REQUEST = 255;
    public static final int EVENT_RESPONSE = 254;
    public static final int HEARTBEAT = 253;
    public static final int READY = 252;
    public static final long RETRY_MILLIS = 1000L;
    protected final Map<Object, Integer> listenerIDs = new IdentityHashMap<Object, Integer>();
    protected final Map<Integer, Map<Integer, Object>> listenerObjects = new HashMap<Integer, Map<Integer, Object>>();
    protected String host;
    protected int port;
    protected DataStream stream;
    protected int nextID;
    protected boolean running;

    public RemoteBase(String host, int port) {
        this.host = host;
        this.port = port;
        for (int eventType : EVENT_TYPES) {
            this.listenerObjects.put(eventType, new HashMap());
        }
    }

    @Override
    public void run() {
        if (this.running) {
            return;
        }
        this.running = true;
        while (true) {
            this.fireStatusChanged("Connecting to %s:%d...", this.host, this.port);
            try {
                Socket socket = new Socket(this.host, this.port);
                this.stream = new DataStream(new DataOutputStream(new BufferedOutputStream(socket.getOutputStream())), new DataInputStream(new BufferedInputStream(socket.getInputStream())));
            }
            catch (Throwable t) {
                this.fireStatusChanged("Failed to establish connection.", new Object[0]);
            }
            if (this.stream != null) {
                try {
                    this.fireStatusChanged("Connection established.", new Object[0]);
                    this.sendListeners();
                    this.sendReady();
                    while (true) {
                        this.probeEvents();
                    }
                }
                catch (EOFException e) {
                    this.fireDeactivated();
                    this.fireStatusChanged("Disconnected.", new Object[0]);
                    this.stream = null;
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                        this.fireDeactivated();
                        this.fireStatusChanged("Disconnected.", new Object[0]);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.stream = null;
                    }
                }
            }
            ThreadUtil.sleep(1000L);
        }
    }

    protected void fireDeactivated() {
        for (Object obj : new ArrayList<Object>(this.listenerObjects.get(3).values())) {
            ((DeactivateListener)obj).apiDisabled();
        }
    }

    protected void fireStatusChanged(String message, Object ... params) {
        String msg = String.format(message, params);
        for (Object obj : new ArrayList<Object>(this.listenerObjects.get(21).values())) {
            ((StatusListener)obj).statusChanged(msg);
        }
    }

    protected void sendReady() {
        if (this.stream != null) {
            try {
                this.stream.writeByte(252);
                this.stream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void sendListeners() {
        for (Map.Entry<Integer, Map<Integer, Object>> e1 : this.listenerObjects.entrySet()) {
            for (Map.Entry<Integer, Object> e2 : e1.getValue().entrySet()) {
                this.sendListener(e2.getKey(), e1.getKey(), e2.getValue());
            }
        }
    }

    protected void probeEvents() throws Throwable {
        this.stream.writeByte(255);
        this.stream.flush();
        int eventType = this.stream.readByte();
        if (eventType == 253) {
            this.stream.writeByte(254);
            this.stream.flush();
            return;
        }
        int listenerID = this.stream.readInt();
        Object obj = this.listenerObjects.get(eventType).get(listenerID);
        if (obj != null) {
            if (eventType == 9) {
                int type = this.stream.readInt();
                int address = this.stream.readInt();
                int value = this.stream.readInt();
                int result = ((AccessPoint)obj).getListener().accessPointHit(type, address, value);
                this.stream.writeByte(254);
                this.stream.writeInt(result);
            } else {
                switch (eventType) {
                    case 1: {
                        ((ActivateListener)obj).apiEnabled();
                        break;
                    }
                    case 3: {
                        ((DeactivateListener)obj).apiDisabled();
                        break;
                    }
                    case 5: {
                        ((StopListener)obj).dispose();
                        break;
                    }
                    case 11: {
                        ((ControllersListener)obj).controllersProbed();
                        break;
                    }
                    case 13: {
                        ((FrameListener)obj).frameRendered();
                        break;
                    }
                    case 15: {
                        ((ScanlinePoint)obj).getListener().scanlineRendered(this.stream.readInt());
                        break;
                    }
                    case 17: {
                        ((ScanlineCyclePoint)obj).getListener().cyclePerformed(this.stream.readInt(), this.stream.readInt(), this.stream.readInt(), this.stream.readBoolean());
                        break;
                    }
                    case 19: {
                        ((SpriteZeroListener)obj).spriteZeroHit(this.stream.readInt(), this.stream.readInt());
                        break;
                    }
                    case 21: {
                        ((StatusListener)obj).statusChanged(this.stream.readString());
                        break;
                    }
                    default: {
                        throw new IOException("Unknown listener type: " + eventType);
                    }
                }
                this.stream.writeByte(254);
            }
        }
        this.stream.flush();
    }

    protected void sendListener(int listenerID, int eventType, Object listenerObject) {
        if (this.stream != null) {
            try {
                this.stream.writeByte(eventType);
                this.stream.writeInt(listenerID);
                switch (eventType) {
                    case 9: {
                        AccessPoint point = (AccessPoint)listenerObject;
                        this.stream.writeInt(point.type);
                        this.stream.writeInt(point.minAddress);
                        this.stream.writeInt(point.maxAddress);
                        this.stream.writeInt(point.bank);
                        break;
                    }
                    case 15: {
                        ScanlinePoint point = (ScanlinePoint)listenerObject;
                        this.stream.writeInt(point.scanline);
                        break;
                    }
                    case 17: {
                        ScanlineCyclePoint point = (ScanlineCyclePoint)listenerObject;
                        this.stream.writeInt(point.scanline);
                        this.stream.writeInt(point.scanlineCycle);
                        break;
                    }
                }
                this.stream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void addListener(Object listener, int eventType) {
        if (listener != null) {
            this.sendListener(this.addListenerObject(listener, eventType), eventType, listener);
        }
    }

    public void removeListener(Object listener, int eventType, int methodValue) {
        int listenerID;
        if (listener != null && (listenerID = this.removeListenerObject(listener, eventType)) >= 0 && this.stream != null) {
            try {
                this.stream.writeByte(methodValue);
                this.stream.writeInt(listenerID);
                this.stream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected int addListenerObject(Object listener, int eventType) {
        return this.addListenerObject(listener, eventType, listener);
    }

    protected int addListenerObject(Object listener, int eventType, Object listenerObject) {
        Integer listenerID = this.nextID++;
        this.listenerIDs.put(listener, listenerID);
        this.listenerObjects.get(eventType).put(listenerID, listenerObject);
        return listenerID;
    }

    protected int removeListenerObject(Object listener, int eventType) {
        Integer listenerID = this.listenerIDs.remove(listener);
        if (listenerID != null) {
            this.listenerObjects.get(eventType).remove(listenerID);
            return listenerID;
        }
        return -1;
    }

    @Override
    public void addActivateListener(ActivateListener listener) {
        this.addListener(listener, 1);
    }

    @Override
    public void removeActivateListener(ActivateListener listener) {
        this.removeListener(listener, 1, 2);
    }

    @Override
    public void addDeactivateListener(DeactivateListener listener) {
        this.addListener(listener, 3);
    }

    @Override
    public void removeDeactivateListener(DeactivateListener listener) {
        this.removeListener(listener, 3, 4);
    }

    @Override
    public void addStopListener(StopListener listener) {
        this.addListener(listener, 5);
    }

    @Override
    public void removeStopListener(StopListener listener) {
        this.removeListener(listener, 5, 6);
    }

    @Override
    public void addAccessPointListener(AccessPointListener listener, int accessPointType, int address) {
        this.addAccessPointListener(listener, accessPointType, address, -1, -1);
    }

    @Override
    public void addAccessPointListener(AccessPointListener listener, int accessPointType, int minAddress, int maxAddress) {
        this.addAccessPointListener(listener, accessPointType, minAddress, maxAddress, -1);
    }

    @Override
    public void addAccessPointListener(AccessPointListener listener, int accessPointType, int minAddress, int maxAddress, int bank) {
        if (listener != null) {
            AccessPoint point = new AccessPoint(listener, accessPointType, minAddress, maxAddress, bank);
            this.sendListener(this.addListenerObject(listener, 9, point), 9, point);
        }
    }

    @Override
    public void removeAccessPointListener(AccessPointListener listener) {
        this.removeListener(listener, 9, 10);
    }

    @Override
    public void addControllersListener(ControllersListener listener) {
        this.addListener(listener, 11);
    }

    @Override
    public void removeControllersListener(ControllersListener listener) {
        this.removeListener(listener, 11, 12);
    }

    @Override
    public void addFrameListener(FrameListener listener) {
        this.addListener(listener, 13);
    }

    @Override
    public void removeFrameListener(FrameListener listener) {
        this.removeListener(listener, 13, 14);
    }

    @Override
    public void addScanlineListener(ScanlineListener listener, int scanline) {
        if (listener != null) {
            ScanlinePoint point = new ScanlinePoint(listener, scanline);
            this.sendListener(this.addListenerObject(listener, 15, point), 15, point);
        }
    }

    @Override
    public void removeScanlineListener(ScanlineListener listener) {
        this.removeListener(listener, 15, 16);
    }

    @Override
    public void addScanlineCycleListener(ScanlineCycleListener listener, int scanline, int scanlineCycle) {
        if (listener != null) {
            ScanlineCyclePoint point = new ScanlineCyclePoint(listener, scanline, scanlineCycle);
            this.sendListener(this.addListenerObject(listener, 17, point), 17, point);
        }
    }

    @Override
    public void removeScanlineCycleListener(ScanlineCycleListener listener) {
        this.removeListener(listener, 17, 18);
    }

    @Override
    public void addSpriteZeroListener(SpriteZeroListener listener) {
        this.addListener(listener, 19);
    }

    @Override
    public void removeSpriteZeroListener(SpriteZeroListener listener) {
        this.removeListener(listener, 19, 20);
    }

    @Override
    public void addStatusListener(StatusListener listener) {
        this.addListener(listener, 21);
    }

    @Override
    public void removeStatusListener(StatusListener listener) {
        this.removeListener(listener, 21, 22);
    }

    @Override
    public void getPixels(int[] pixels) {
        try {
            this.stream.writeByte(119);
            this.stream.flush();
            this.stream.readIntArray(pixels);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

