/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.CPU;
import nintaco.util.BitUtil;

public class DeltaModulationChannel
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[][] RATES = new int[][]{{214, 190, 170, 160, 143, 127, 113, 107, 95, 80, 71, 64, 53, 42, 36, 27}, {199, 177, 158, 149, 138, 118, 105, 99, 88, 74, 66, 59, 49, 39, 33, 25}};
    private boolean irqEnabled;
    private boolean loop;
    private CPU cpu;
    private int timer;
    private int timerReload;
    private int outputLevel;
    private int sampleAddress;
    private int sampleLength;
    private int sampleBuffer;
    private int shiftRegister;
    private int bitsRemaining = 8;
    private boolean silence = true;
    private int currentAddress;
    private int bytesRemaining;
    private boolean sampleBufferFilled;
    private boolean requestedSample;
    private int[] rates;
    private float smoothDelta;
    private float smoothLevel;
    private int smoothSteps;

    public void setCPU(CPU cpu) {
        this.cpu = cpu;
    }

    public void setPAL(boolean pal) {
        this.rates = RATES[pal ? 1 : 0];
        this.timer = 1;
        this.timerReload = this.rates[0];
    }

    public int getBytesRemaining() {
        return this.bytesRemaining;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            if (this.bytesRemaining == 0) {
                this.currentAddress = this.sampleAddress;
                this.bytesRemaining = this.sampleLength;
            }
        } else {
            this.bytesRemaining = 0;
        }
        this.cpu.setDmcIrq(false);
    }

    public void writeFlagsAndFrequency(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 7);
        if (!this.irqEnabled) {
            this.cpu.setDmcIrq(false);
        }
        this.loop = BitUtil.getBitBool(value, 6);
        this.timerReload = this.rates[value & 0xF];
    }

    public void writeDirectLoad(int value) {
        this.smoothLevel = this.outputLevel;
        this.outputLevel = value & 0x7F;
        this.smoothLevel -= (float)this.outputLevel;
        this.smoothSteps = 255;
        this.smoothDelta = -0.00390625f * this.smoothLevel;
        this.smoothLevel += this.smoothDelta;
    }

    public void writeSampleAddress(int value) {
        this.sampleAddress = 0xC000 | value << 6;
    }

    public void writeSampleLength(int value) {
        this.sampleLength = value << 4 | 1;
    }

    public void fillSampleBuffer(int value) {
        this.sampleBuffer = value;
        this.sampleBufferFilled = true;
        if (++this.currentAddress > 65535) {
            this.currentAddress = 32768;
        }
        if (this.bytesRemaining == 0) {
            if (this.loop) {
                this.currentAddress = this.sampleAddress;
                this.bytesRemaining = this.sampleLength;
            } else if (this.irqEnabled) {
                this.cpu.setDmcIrq(true);
            }
        }
        this.requestedSample = false;
    }

    public void update() {
        if (this.smoothSteps > 0) {
            --this.smoothSteps;
            this.smoothLevel += this.smoothDelta;
        } else {
            this.smoothLevel = 0.0f;
        }
        if (--this.timer == 0) {
            this.timer = this.timerReload;
            if (!this.silence) {
                if ((this.shiftRegister & 1) == 1) {
                    if (this.outputLevel <= 125) {
                        this.outputLevel += 2;
                    }
                } else if (this.outputLevel >= 2) {
                    this.outputLevel -= 2;
                }
                this.shiftRegister >>= 1;
            }
            if (--this.bitsRemaining == 0) {
                this.bitsRemaining = 8;
                if (this.sampleBufferFilled) {
                    this.silence = false;
                    this.sampleBufferFilled = false;
                    this.shiftRegister = this.sampleBuffer;
                } else {
                    this.silence = true;
                }
            }
        }
        if (!this.requestedSample && !this.sampleBufferFilled && this.bytesRemaining > 0) {
            this.requestedSample = true;
            this.cpu.dmcRead(this.currentAddress);
            --this.bytesRemaining;
        }
    }

    public int getOutputLevel() {
        return this.outputLevel;
    }

    public float getSmoothLevel() {
        return this.smoothLevel;
    }
}

