/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.apu.APU;
import nintaco.apu.EnvelopeGenerator;
import nintaco.util.BitUtil;

public class NoiseGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[][] PERIODS = new int[][]{{2, 4, 8, 16, 32, 48, 64, 80, 101, 127, 190, 254, 381, 508, 1017, 2034}, {2, 4, 7, 15, 30, 44, 59, 74, 94, 118, 177, 236, 354, 472, 945, 1889}};
    private int shiftRegister = 1;
    private int lengthCounter;
    private int timerPeriod;
    private int timer;
    private boolean lengthCounterEnabled;
    private boolean mode;
    private boolean enabled;
    private int[] periods;
    private final EnvelopeGenerator envelopeGenerator = new EnvelopeGenerator();

    public void setPAL(boolean pal) {
        this.periods = PERIODS[pal ? 1 : 0];
    }

    public void writeEnvelope(int value) {
        this.envelopeGenerator.write(value);
        this.lengthCounterEnabled = !BitUtil.getBitBool(value, 5);
    }

    public void writeModeAndPeriod(int value) {
        this.mode = BitUtil.getBitBool(value, 7);
        this.timerPeriod = this.periods[value & 0xF];
    }

    public void writeLengthCounter(int value) {
        if (this.enabled) {
            this.lengthCounter = APU.lengths[value >> 3];
        }
        this.envelopeGenerator.setStart(true);
    }

    public void updateEnvelopeGenerator() {
        this.envelopeGenerator.update();
    }

    public void updateLengthCounter() {
        if (this.lengthCounterEnabled && this.lengthCounter > 0) {
            --this.lengthCounter;
        }
    }

    public void update() {
        if (this.timer == 0) {
            this.timer = this.timerPeriod;
            this.shiftRegister = this.shiftRegister >> 1 | (this.shiftRegister & 1 ^ this.shiftRegister >> (this.mode ? 6 : 1) & 1) << 14;
        } else {
            --this.timer;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.lengthCounter = 0;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getLengthCounter() {
        return this.lengthCounter;
    }

    public int getValue() {
        if (this.lengthCounter == 0 || (this.shiftRegister & 1) == 1) {
            return 0;
        }
        return this.envelopeGenerator.getVolume();
    }
}

