/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.apu.APU;
import nintaco.apu.EnvelopeGenerator;
import nintaco.apu.SweepGenerator;
import nintaco.util.BitUtil;

public class PulseGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final boolean[][] waveforms = new boolean[][]{{false, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false}, {false, true, true, true, true, false, false, false}, {true, false, false, true, true, true, true, true}};
    private final boolean pulseGenerator1;
    private int duty;
    private int timer;
    private int targetPeriod;
    private int currentPeriod;
    private int waveformIndex;
    private int lengthCounter;
    private boolean lengthCounterEnabled;
    private boolean enabled;
    private final EnvelopeGenerator envelopeGenerator = new EnvelopeGenerator();
    private final SweepGenerator sweepGenerator = new SweepGenerator();

    public PulseGenerator(boolean pulseGenerator1) {
        this.pulseGenerator1 = pulseGenerator1;
        this.sweepGenerator.setPulseGenerator(this);
    }

    private void updateTargetPeriod() {
        int delta = this.currentPeriod >> this.sweepGenerator.getShiftCount();
        this.targetPeriod = this.sweepGenerator.isNegate() ? (this.pulseGenerator1 ? this.currentPeriod + ~delta : this.currentPeriod - delta) : this.currentPeriod + delta;
    }

    public void adjustPulsePeriod() {
        this.updateTargetPeriod();
        if (this.sweepGenerator.getShiftCount() != 0 && this.targetPeriod <= 2047 && this.currentPeriod >= 8) {
            this.currentPeriod = this.targetPeriod & 0x7FF;
        }
    }

    public void writeEnvelope(int value) {
        this.envelopeGenerator.write(value);
        this.lengthCounterEnabled = !BitUtil.getBitBool(value, 5);
        this.duty = value >> 6 & 3;
    }

    public void writeSweep(int value) {
        this.sweepGenerator.write(value);
    }

    public void writeTimerReloadLow(int value) {
        this.currentPeriod = this.currentPeriod & 0x700 | value;
        this.updateTargetPeriod();
    }

    public void writeTimerReloadHigh(int value) {
        if (this.enabled) {
            this.lengthCounter = APU.lengths[value >> 3];
        }
        this.currentPeriod = this.currentPeriod & 0xFF | (value & 7) << 8;
        this.waveformIndex = 0;
        this.envelopeGenerator.setStart(true);
        this.updateTargetPeriod();
    }

    public void updateEnvelopeGenerator() {
        this.envelopeGenerator.update();
    }

    public void updateLengthCounterAndSweepGenerator() {
        if (this.lengthCounterEnabled && this.lengthCounter > 0) {
            --this.lengthCounter;
        }
        this.sweepGenerator.update();
    }

    public void update() {
        if (this.timer == 0) {
            this.timer = this.currentPeriod;
            this.waveformIndex = this.waveformIndex - 1 & 7;
        } else {
            --this.timer;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.lengthCounter = 0;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getLengthCounter() {
        return this.lengthCounter;
    }

    public int getValue() {
        if (this.targetPeriod > 2047 || this.currentPeriod < 8 || this.lengthCounter == 0) {
            return 0;
        }
        return waveforms[this.duty][this.waveformIndex] ? this.envelopeGenerator.getVolume() : 0;
    }
}

