/*
 * Decompiled with CFR 0.152.
 */
package nintaco.cheats;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import nintaco.App;
import nintaco.cheats.Cheat;
import nintaco.cheats.CheatsDB;
import nintaco.cheats.CheatsDBEntry;
import nintaco.cheats.GameGenie;
import nintaco.files.CartFile;
import nintaco.files.FileUtil;
import nintaco.input.InputUtil;
import nintaco.input.other.SetCheats;
import nintaco.preferences.AppPrefs;
import nintaco.util.CollectionsUtil;
import nintaco.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GameCheats {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^(.*)(\\p{XDigit}{4}:)(.*)$");
    private static String fileName;
    private static List<Cheat> cheatsList;

    private GameCheats() {
    }

    private static String getText(Element element, String tagName) {
        String text;
        Node node;
        Element e;
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList != null && nodeList.getLength() > 0 && (e = (Element)nodeList.item(0)) != null && (node = e.getFirstChild()) != null && (text = node.getNodeValue()) != null) {
            return text.trim();
        }
        return null;
    }

    private static Integer getInt(Element element, String tagName) {
        return GameCheats.getInt(GameCheats.getText(element, tagName));
    }

    private static Integer getInt(String text) {
        if (text == null || text.length() < 4) {
            return null;
        }
        try {
            return Integer.parseInt(text.substring(2), 16);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Cheat getCheat(Element element) {
        Integer address = GameCheats.getInt(element, "address");
        Integer dataValue = GameCheats.getInt(element, "value");
        if (address == null || dataValue == null || address < 0 || address > 65535 || dataValue < 0 || dataValue > 255) {
            return null;
        }
        Integer compareValue = GameCheats.getInt(element, "compare");
        if (compareValue != null && (compareValue < 0 || compareValue > 255)) {
            return null;
        }
        if (compareValue == null) {
            compareValue = -1;
        }
        String description = GameCheats.getText(element, "description");
        boolean enabled = true;
        String enabledStr = element.getAttribute("enabled");
        if (!StringUtil.isBlank(enabledStr)) {
            if ("0".equals(enabledStr = enabledStr.trim())) {
                enabled = false;
            } else if (!"1".equals(enabledStr)) {
                return null;
            }
        }
        Cheat cheat = new Cheat(address, dataValue, compareValue);
        cheat.setEnabled(enabled);
        if (description != null) {
            cheat.setDescription(description);
        }
        return cheat;
    }

    public static List<Cheat> loadXML(File file) throws Throwable {
        NodeList cs;
        ArrayList<Cheat> cheats = new ArrayList<Cheat>();
        if (!file.exists()) {
            return cheats;
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        Element root = doc.getDocumentElement();
        if (root != null && (cs = root.getElementsByTagName("cheat")) != null) {
            for (int i = 0; i < cs.getLength(); ++i) {
                Cheat cheat = GameCheats.getCheat((Element)cs.item(i));
                if (cheat == null) continue;
                cheats.add(cheat);
            }
        }
        return cheats;
    }

    private static String escapeString(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void saveXML(File file, List<Cheat> cheats) throws Throwable {
        GameCheats.saveXML(file, cheats, false, 0);
    }

    public static void saveXML(File file, List<Cheat> cheats, boolean isNesFile, int nesFileCRC) throws Throwable {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<cheats version=\"1.0\">");
            for (Cheat cheat : cheats) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("    <cheat enabled=\"%d\"", cheat.isEnabled() ? 1 : 0));
                if (isNesFile) {
                    sb.append(String.format(" game=\"0x%08X\"", nesFileCRC));
                }
                sb.append('>');
                out.println(sb);
                out.format("        <address>0x%04X</address>%n", cheat.getAddress());
                out.format("        <value>0x%02X</value>%n", cheat.getDataValue());
                if (cheat.hasCompareValue()) {
                    out.format("        <compare>0x%02X</compare>%n", cheat.getCompareValue());
                }
                if (!StringUtil.isBlank(cheat.getDescription())) {
                    out.format("        <description>%s</description>%n", GameCheats.escapeString(cheat.getDescription()));
                }
                out.println("    </cheat>");
            }
            out.println("</cheats>");
        }
    }

    public static List<Cheat> loadCHT(File file) throws Throwable {
        ArrayList<Cheat> cheats = new ArrayList<Cheat>();
        if (!file.exists()) {
            return cheats;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String input = null;
            while ((input = br.readLine()) != null) {
                int i;
                if (StringUtil.isBlank(input)) continue;
                Cheat cheat = new Cheat();
                Matcher matcher = ADDRESS_PATTERN.matcher(input = input.trim());
                if (!matcher.find()) continue;
                String prefix = matcher.group(1);
                int sIndex = -1;
                int cIndex = -1;
                int colonIndex = -1;
                int length = Math.min(3, prefix.length());
                block21: for (i = 0; i < length; ++i) {
                    switch (prefix.charAt(i)) {
                        case 'S': 
                        case 's': {
                            if (sIndex >= 0) continue block21;
                            sIndex = i;
                            continue block21;
                        }
                        case 'C': 
                        case 'c': {
                            if (cIndex >= 0) continue block21;
                            cIndex = i;
                            continue block21;
                        }
                        case ':': {
                            if (colonIndex >= 0) continue block21;
                            colonIndex = i;
                        }
                    }
                }
                if (cIndex >= 0 && sIndex > cIndex || colonIndex >= 0 && sIndex > colonIndex || colonIndex >= 0 && cIndex > colonIndex) continue;
                cheat.setEnabled(colonIndex < 0);
                i = Math.max(Math.max(sIndex, cIndex), colonIndex) + 1;
                try {
                    cheat.setAddress(Integer.parseInt(input.substring(i, i + 4), 16));
                    if (input.charAt(i + 4) != ':') {
                    }
                }
                catch (Throwable t) {}
                continue;
                i += 5;
                try {
                    cheat.setDataValue(Integer.parseInt(input.substring(i, i + 2), 16));
                    if (input.charAt(i + 2) != ':') {
                    }
                }
                catch (Throwable t) {}
                continue;
                i += 3;
                if (cIndex >= 0) {
                    try {
                        cheat.setCompareValue(Integer.parseInt(input.substring(i, i + 2), 16));
                        if (input.charAt(i + 2) != ':') {
                        }
                    }
                    catch (Throwable t) {}
                    continue;
                    i += 3;
                }
                if (i < input.length()) {
                    cheat.setDescription(input.substring(i));
                }
                cheats.add(cheat);
            }
        }
        return cheats;
    }

    public static void saveCHT(File file, List<Cheat> cheats) throws Throwable {
        if (CollectionsUtil.isBlank(cheats)) {
            file.delete();
        } else {
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
                for (Cheat cheat : cheats) {
                    StringBuilder sb = new StringBuilder();
                    sb.append('S');
                    if (cheat.hasCompareValue()) {
                        sb.append('C');
                    }
                    if (!cheat.isEnabled()) {
                        sb.append(':');
                    }
                    sb.append(String.format("%04x:%02x:", cheat.getAddress(), cheat.getDataValue()));
                    if (cheat.hasCompareValue()) {
                        sb.append(String.format("%02x:", cheat.getCompareValue()));
                    }
                    if (cheat.getDescription() != null) {
                        sb.append(cheat.getDescription());
                    }
                    out.println(sb);
                }
            }
        }
    }

    public static void addCheat(Cheat cheat, boolean overwrite) {
        GameCheats.addCheat(cheat, overwrite, GameCheats.getCheats());
    }

    public static void addCheat(Cheat cheat, boolean overwrite, List<Cheat> cheats) {
        if (overwrite) {
            for (Cheat c : cheats) {
                if (!c.effectivelyEquals(cheat)) continue;
                c.setDescription(cheat.getDescription());
                c.setEnabled(cheat.isEnabled());
                return;
            }
        }
        cheats.add(cheat);
    }

    public static boolean removeCheat(Cheat cheat) {
        return GameCheats.removeCheat(cheat, GameCheats.getCheats());
    }

    public static boolean removeCheat(Cheat cheat, List<Cheat> cheats) {
        boolean cheatRemoved = false;
        Iterator<Cheat> i = cheats.iterator();
        while (i.hasNext()) {
            Cheat c = i.next();
            if (!c.effectivelyEquals(cheat)) continue;
            i.remove();
            cheatRemoved = true;
        }
        return cheatRemoved;
    }

    public static synchronized List<Cheat> getCopy() {
        ArrayList<Cheat> cheats = new ArrayList<Cheat>();
        if (cheatsList != null) {
            for (Cheat cheat : cheatsList) {
                cheats.add(new Cheat(cheat));
            }
        }
        return cheats;
    }

    public static synchronized List<Cheat> getCheats() {
        return cheatsList;
    }

    public static synchronized void setCheats(List<Cheat> cheatsList) {
        GameCheats.cheatsList = cheatsList;
    }

    public static synchronized void updateMachine() {
        if (App.getMachine() != null) {
            InputUtil.addOtherInput(new SetCheats(GameCheats.getEnabledCheats()));
        }
    }

    public static synchronized Cheat[] getEnabledCheats() {
        if (cheatsList == null) {
            return null;
        }
        int size = 0;
        for (Cheat cheat : cheatsList) {
            if (!cheat.isEnabled()) continue;
            ++size;
        }
        Cheat[] cheats = null;
        if (size > 0) {
            cheats = new Cheat[size];
            int i = 0;
            for (Cheat cheat : cheatsList) {
                if (!cheat.isEnabled()) continue;
                cheats[i++] = new Cheat(cheat);
            }
        }
        return cheats;
    }

    public static synchronized void load(String entryFileName) {
        fileName = FileUtil.createCheatFile(entryFileName);
        List<Object> cheats = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                cheats = GameCheats.loadCHT(file);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cheats == null) {
            cheats = new ArrayList();
        }
        GameCheats.setCheats(cheats);
        GameCheats.updateMachine();
    }

    public static void save() {
        String file = fileName;
        if (StringUtil.isBlank(file)) {
            return;
        }
        List<Cheat> cheats = cheatsList;
        if (cheats == null) {
            return;
        }
        new Thread(() -> {
            Class<GameCheats> clazz = GameCheats.class;
            synchronized (GameCheats.class) {
                FileUtil.mkdir(AppPrefs.getInstance().getPaths().getCheatsDir());
                try {
                    GameCheats.saveCHT(new File(file), cheats);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
        }).run();
    }

    public static List<Cheat> queryCheatsDB() {
        CheatsDBEntry[] entries;
        CartFile cartFile = App.getCartFile();
        if (cartFile != null && (entries = CheatsDB.getCheats(cartFile.getFileCRC())) != null) {
            ArrayList<Cheat> cheats = new ArrayList<Cheat>();
            for (CheatsDBEntry entry : entries) {
                String[][] gameGenieCodes = entry.getGameGenieCodes();
                for (int j = 0; j < gameGenieCodes.length; ++j) {
                    String[] codes = gameGenieCodes[j];
                    for (int k = 0; k < codes.length; ++k) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(entry.getDescription());
                        if (j > 0) {
                            sb.append(String.format(" [a%d]", j));
                        }
                        if (codes.length > 1) {
                            sb.append(String.format(" [%d of %d]", k + 1, codes.length));
                        }
                        Cheat cheat = GameGenie.convert(codes[k]);
                        cheat.setEnabled(false);
                        cheat.setDescription(sb.toString());
                        cheats.add(cheat);
                    }
                }
            }
            return cheats;
        }
        return null;
    }
}

