/*
 * Decompiled with CFR 0.152.
 */
package nintaco.disassembler;

import java.io.Serializable;

public class AddressLabel
implements Comparable<AddressLabel>,
Serializable {
    private static final long serialVersionUID = 0L;
    private int bank;
    private int address;
    private String label;
    private String comment;
    private boolean code;
    private boolean bookmark;

    public static int createKey(int bank, int address) {
        return bank << 16 | address;
    }

    public AddressLabel(AddressLabel addressLabel) {
        this(addressLabel.bank, addressLabel.address, addressLabel.label, addressLabel.comment, addressLabel.code, addressLabel.bookmark);
    }

    public AddressLabel(int bank, int address, String label, String comment, boolean code, boolean bookmark) {
        this.setBank(bank);
        this.address = address;
        this.label = label;
        this.comment = comment;
        this.code = code;
        this.bookmark = bookmark;
    }

    public int getKey() {
        return AddressLabel.createKey(this.bank, this.address);
    }

    public int getBank() {
        return this.bank;
    }

    public final void setBank(int bank) {
        this.bank = bank >= 0 ? bank : -1;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isCode() {
        return this.code;
    }

    public void setCode(boolean code) {
        this.code = code;
    }

    public boolean isBookmark() {
        return this.bookmark;
    }

    public void setBookmark(boolean bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public int compareTo(AddressLabel addressLabel) {
        return Integer.compare(this.getKey(), addressLabel.getKey());
    }

    public boolean equals(Object obj) {
        AddressLabel addressLabel = (AddressLabel)obj;
        return this.getKey() == addressLabel.getKey();
    }

    public int hashCode() {
        return this.getKey();
    }

    public String toString() {
        return this.label;
    }
}

